/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.retryer;

import com.google.common.base.Preconditions;
import io.grpc.Deadline;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.internal.retryer.GrpcAsyncRetryer;
import io.temporal.internal.retryer.GrpcSyncRetryer;
import io.temporal.serviceclient.RpcRetryOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class GrpcRetryer {
    private final Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities;

    public GrpcRetryer(Supplier<GetSystemInfoResponse.Capabilities> serverCapabilities) {
        this.serverCapabilities = serverCapabilities;
    }

    public <T extends Throwable> void retry(RetryableProc<T> r, GrpcRetryerOptions options) throws T {
        this.retryWithResult(() -> {
            r.apply();
            return null;
        }, options);
    }

    public <R, T extends Throwable> R retryWithResult(RetryableFunc<R, T> r, GrpcRetryerOptions options) throws T {
        return new GrpcSyncRetryer().retry(r, options, this.serverCapabilities.get());
    }

    public <R> CompletableFuture<R> retryWithResultAsync(ScheduledExecutorService executor, Supplier<CompletableFuture<R>> function, GrpcRetryerOptions options) {
        return new GrpcAsyncRetryer<R>(executor, function, options, this.serverCapabilities.get()).retry();
    }

    public static class GrpcRetryerOptions {
        @Nonnull
        private final RpcRetryOptions options;
        @Nullable
        private final Deadline deadline;

        public GrpcRetryerOptions(@Nonnull RpcRetryOptions options, @Nullable Deadline deadline) {
            this.options = options;
            this.deadline = deadline;
        }

        @Nonnull
        public RpcRetryOptions getOptions() {
            return this.options;
        }

        @Nullable
        public Deadline getDeadline() {
            return this.deadline;
        }

        public void validate() {
            this.options.validate(false);
            Preconditions.checkState((this.options.getMaximumInterval() != null || this.options.getMaximumAttempts() > 0 || this.deadline != null ? 1 : 0) != 0, (Object)"configuration of the retries has to be finite");
        }
    }

    public static interface RetryableFunc<R, E extends Throwable> {
        public R apply() throws E;
    }

    public static interface RetryableProc<E extends Throwable> {
        public void apply() throws E;
    }
}

