/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.protobuf.GeneratedMessageV3;
import io.grpc.Status;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.serviceclient.rpcretry.DefaultStubServiceOperationRpcRetryOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RpcRetryOptions {
    private static final RpcRetryOptions DEFAULT_INSTANCE = RpcRetryOptions.newBuilder().build();
    private final Duration initialInterval;
    private final Duration congestionInitialInterval;
    private final double backoffCoefficient;
    private final Duration expiration;
    private final int maximumAttempts;
    private final Duration maximumInterval;
    private final double maximumJitterCoefficient;
    @Nonnull
    private final List<DoNotRetryItem> doNotRetry;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(RpcRetryOptions options) {
        return new Builder(options);
    }

    public static RpcRetryOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private RpcRetryOptions(Duration initialInterval, Duration congestionInitialInterval, double backoffCoefficient, Duration expiration, int maximumAttempts, Duration maximumInterval, double maximumJitterCoefficient, @Nonnull List<DoNotRetryItem> doNotRetry) {
        this.initialInterval = initialInterval;
        this.congestionInitialInterval = congestionInitialInterval;
        this.backoffCoefficient = backoffCoefficient;
        this.expiration = expiration;
        this.maximumAttempts = maximumAttempts;
        this.maximumInterval = maximumInterval;
        this.maximumJitterCoefficient = maximumJitterCoefficient;
        this.doNotRetry = Collections.unmodifiableList(doNotRetry);
    }

    public Duration getInitialInterval() {
        return this.initialInterval;
    }

    public Duration getCongestionInitialInterval() {
        return this.congestionInitialInterval;
    }

    public double getBackoffCoefficient() {
        return this.backoffCoefficient;
    }

    public Duration getExpiration() {
        return this.expiration;
    }

    public int getMaximumAttempts() {
        return this.maximumAttempts;
    }

    public Duration getMaximumInterval() {
        return this.maximumInterval;
    }

    public double getMaximumJitterCoefficient() {
        return this.maximumJitterCoefficient;
    }

    public void validate() {
        this.validate(true);
    }

    public void validate(boolean hasToBeFinite) {
        if (this.initialInterval == null) {
            throw new IllegalStateException("required property initialInterval not set");
        }
        if (this.congestionInitialInterval == null) {
            throw new IllegalStateException("required property congestionInitialInterval not set");
        }
        if (this.maximumAttempts < 0) {
            throw new IllegalArgumentException("negative maximum attempts");
        }
        if (hasToBeFinite && this.expiration == null && this.maximumAttempts == 0) {
            throw new IllegalArgumentException("both MaximumAttempts and Expiration on retry policy are not set, at least one of them must be set");
        }
        if (this.maximumInterval != null && this.maximumInterval.compareTo(this.initialInterval) < 0) {
            throw new IllegalStateException("maximumInterval(" + this.maximumInterval + ") cannot be smaller than initialInterval(" + this.initialInterval);
        }
        if (this.backoffCoefficient != 0.0 && this.backoffCoefficient < 1.0) {
            throw new IllegalArgumentException("coefficient less than 1");
        }
        if (!Double.isFinite(this.maximumJitterCoefficient) || this.maximumJitterCoefficient < 0.0 || this.maximumJitterCoefficient >= 1.0) {
            throw new IllegalArgumentException("maximumJitterCoefficient has to be >= 0 and < 1.0: " + this.maximumJitterCoefficient);
        }
    }

    @Nonnull
    public List<DoNotRetryItem> getDoNotRetry() {
        return this.doNotRetry;
    }

    public String toString() {
        return "RetryOptions{initialInterval=" + this.initialInterval + "congestionInitialInterval=" + this.congestionInitialInterval + ", backoffCoefficient=" + this.backoffCoefficient + ", expiration=" + this.expiration + ", maximumAttempts=" + this.maximumAttempts + ", maximumInterval=" + this.maximumInterval + ", maximumJitterCoefficient=" + this.maximumJitterCoefficient + ", doNotRetry=" + this.doNotRetry + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RpcRetryOptions that = (RpcRetryOptions)o;
        return Double.compare(that.backoffCoefficient, this.backoffCoefficient) == 0 && this.maximumAttempts == that.maximumAttempts && Objects.equals(this.initialInterval, that.initialInterval) && Objects.equals(this.congestionInitialInterval, that.congestionInitialInterval) && Objects.equals(this.expiration, that.expiration) && Objects.equals(this.maximumInterval, that.maximumInterval) && Objects.equals(this.maximumJitterCoefficient, that.maximumJitterCoefficient) && Objects.equals(this.doNotRetry, that.doNotRetry);
    }

    public int hashCode() {
        return Objects.hash(this.initialInterval, this.congestionInitialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.maximumJitterCoefficient, this.doNotRetry);
    }

    public static final class Builder {
        private Duration initialInterval;
        private Duration congestionInitialInterval;
        private Duration expiration;
        private double backoffCoefficient;
        private int maximumAttempts;
        private Duration maximumInterval;
        private double maximumJitterCoefficient = -1.0;
        private List<DoNotRetryItem> doNotRetry = new ArrayList<DoNotRetryItem>();

        private Builder() {
        }

        private Builder(RpcRetryOptions options) {
            if (options == null) {
                return;
            }
            this.backoffCoefficient = options.getBackoffCoefficient();
            this.maximumAttempts = options.getMaximumAttempts();
            this.expiration = options.getExpiration();
            this.initialInterval = options.getInitialInterval();
            this.congestionInitialInterval = options.getCongestionInitialInterval();
            this.maximumInterval = options.getMaximumInterval();
            this.maximumJitterCoefficient = options.getMaximumJitterCoefficient();
            this.doNotRetry = options.getDoNotRetry();
        }

        public Builder setInitialInterval(Duration initialInterval) {
            if (initialInterval != null) {
                if (initialInterval.isNegative() || initialInterval.isZero()) {
                    throw new IllegalArgumentException("Invalid interval: " + initialInterval);
                }
                this.initialInterval = initialInterval;
            } else {
                this.initialInterval = null;
            }
            return this;
        }

        public Builder setCongestionInitialInterval(Duration congestionInitialInterval) {
            if (this.initialInterval != null) {
                if (congestionInitialInterval.isNegative() || congestionInitialInterval.isZero()) {
                    throw new IllegalArgumentException("Invalid interval: " + congestionInitialInterval);
                }
                this.congestionInitialInterval = congestionInitialInterval;
            } else {
                this.congestionInitialInterval = null;
            }
            return this;
        }

        public Builder setExpiration(Duration expiration) {
            if (expiration != null) {
                if (expiration.isNegative() || expiration.isZero()) {
                    throw new IllegalArgumentException("Invalid interval: " + expiration);
                }
                this.expiration = expiration;
            } else {
                this.expiration = null;
            }
            return this;
        }

        public Builder setBackoffCoefficient(double backoffCoefficient) {
            if (backoffCoefficient != 0.0) {
                if (!Double.isFinite(backoffCoefficient) || backoffCoefficient < 1.0) {
                    throw new IllegalArgumentException("coefficient has to be >= 1.0: " + backoffCoefficient);
                }
                this.backoffCoefficient = backoffCoefficient;
            } else {
                this.backoffCoefficient = 0.0;
            }
            return this;
        }

        public Builder setMaximumAttempts(int maximumAttempts) {
            if (maximumAttempts < 0) {
                throw new IllegalArgumentException("Invalid maximumAttempts: " + maximumAttempts);
            }
            this.maximumAttempts = maximumAttempts;
            return this;
        }

        public Builder setMaximumInterval(Duration maximumInterval) {
            if (maximumInterval != null) {
                if (maximumInterval.isNegative() || maximumInterval.isZero()) {
                    throw new IllegalArgumentException("Invalid interval: " + maximumInterval);
                }
                this.maximumInterval = maximumInterval;
            } else {
                this.maximumInterval = null;
            }
            return this;
        }

        public Builder setMaximumJitterCoefficient(double maximumJitterCoefficient) {
            if (maximumJitterCoefficient != -1.0) {
                if (!Double.isFinite(maximumJitterCoefficient) || maximumJitterCoefficient < 0.0 || maximumJitterCoefficient >= 1.0) {
                    throw new IllegalArgumentException("maximumJitterCoefficient has to be >= 0 and < 1.0: " + maximumJitterCoefficient);
                }
                this.maximumJitterCoefficient = maximumJitterCoefficient;
            } else {
                this.maximumJitterCoefficient = -1.0;
            }
            return this;
        }

        public Builder addDoNotRetry(Status.Code code, @Nullable Class<? extends GeneratedMessageV3> detailsClass) {
            this.doNotRetry.add(new DoNotRetryItem(code, detailsClass));
            return this;
        }

        public Builder addDoNotRetry(DoNotRetryItem doNotRetryItem) {
            this.doNotRetry.add(doNotRetryItem);
            return this;
        }

        public Builder setRetryOptions(RpcRetryOptions o) {
            if (o == null) {
                return this;
            }
            this.setInitialInterval(OptionsUtils.merge(this.initialInterval, o.getInitialInterval(), Duration.class));
            this.setCongestionInitialInterval(OptionsUtils.merge(this.congestionInitialInterval, o.getInitialInterval(), Duration.class));
            this.setExpiration(OptionsUtils.merge(this.expiration, o.getExpiration(), Duration.class));
            this.setMaximumInterval(OptionsUtils.merge(this.maximumInterval, o.getMaximumInterval(), Duration.class));
            this.setBackoffCoefficient(OptionsUtils.merge(this.backoffCoefficient, o.getBackoffCoefficient(), Double.TYPE));
            this.setMaximumAttempts(OptionsUtils.merge(this.maximumAttempts, o.getMaximumAttempts(), Integer.TYPE));
            if (o.getMaximumJitterCoefficient() != -1.0) {
                this.setMaximumJitterCoefficient(o.getMaximumJitterCoefficient());
            }
            this.doNotRetry = this.merge(this.doNotRetry, o.getDoNotRetry());
            this.validateBuildWithDefaults();
            return this;
        }

        private List<DoNotRetryItem> merge(List<DoNotRetryItem> o1, List<DoNotRetryItem> o2) {
            if (o2 != null) {
                return new ArrayList<DoNotRetryItem>(o2);
            }
            if (o1.size() > 0) {
                return new ArrayList<DoNotRetryItem>(o1);
            }
            return null;
        }

        public RpcRetryOptions build() {
            return new RpcRetryOptions(this.initialInterval, this.congestionInitialInterval, this.backoffCoefficient, this.expiration, this.maximumAttempts, this.maximumInterval, this.maximumJitterCoefficient, this.doNotRetry);
        }

        public RpcRetryOptions buildWithDefaultsFrom(RpcRetryOptions rpcRetryOptions) {
            return RpcRetryOptions.newBuilder().setRetryOptions(rpcRetryOptions).validateBuildWithDefaults();
        }

        public RpcRetryOptions validateBuildWithDefaults() {
            Duration maxInterval;
            double backoff = this.backoffCoefficient;
            if (backoff == 0.0) {
                backoff = 2.0;
            }
            if (this.initialInterval == null || this.initialInterval.isZero() || this.initialInterval.isNegative()) {
                this.initialInterval = DefaultStubServiceOperationRpcRetryOptions.INITIAL_INTERVAL;
            }
            if (this.congestionInitialInterval == null || this.congestionInitialInterval.isZero() || this.congestionInitialInterval.isNegative()) {
                this.congestionInitialInterval = DefaultStubServiceOperationRpcRetryOptions.CONGESTION_INITIAL_INTERVAL;
            }
            if (this.expiration == null || this.expiration.isZero() || this.expiration.isNegative()) {
                this.expiration = DefaultStubServiceOperationRpcRetryOptions.EXPIRATION_INTERVAL;
            }
            if ((maxInterval = this.maximumInterval) == null || maxInterval.isZero() || maxInterval.isNegative()) {
                maxInterval = this.maximumAttempts == 0 ? DefaultStubServiceOperationRpcRetryOptions.MAXIMUM_INTERVAL : null;
            }
            if (this.maximumJitterCoefficient == -1.0) {
                this.maximumJitterCoefficient = 0.1;
            }
            RpcRetryOptions result = new RpcRetryOptions(this.initialInterval, this.congestionInitialInterval, backoff, this.expiration, this.maximumAttempts, maxInterval, this.maximumJitterCoefficient, (List)MoreObjects.firstNonNull(this.doNotRetry, Collections.emptyList()));
            result.validate();
            return result;
        }
    }

    public static class DoNotRetryItem {
        private final Status.Code code;
        private final Class<? extends GeneratedMessageV3> detailsClass;

        public DoNotRetryItem(@Nonnull Status.Code code, @Nullable Class<? extends GeneratedMessageV3> detailsClass) {
            this.code = (Status.Code)Preconditions.checkNotNull((Object)code, (Object)"code");
            this.detailsClass = detailsClass;
        }

        public Status.Code getCode() {
            return this.code;
        }

        public Class<? extends GeneratedMessageV3> getDetailsClass() {
            return this.detailsClass;
        }
    }
}

