/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.temporal.api.workflowservice.v1.GetSystemInfoRequest;
import io.temporal.api.workflowservice.v1.GetSystemInfoResponse;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public class SystemInfoInterceptor
implements ClientInterceptor {
    private final CompletableFuture<GetSystemInfoResponse.Capabilities> serverCapabilitiesFuture;

    public SystemInfoInterceptor(CompletableFuture<GetSystemInfoResponse.Capabilities> serverCapabilitiesFuture) {
        this.serverCapabilitiesFuture = serverCapabilitiesFuture;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(final MethodDescriptor<ReqT, RespT> method, final CallOptions callOptions, final Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                if (!SystemInfoInterceptor.this.serverCapabilitiesFuture.isDone()) {
                    if (method == WorkflowServiceGrpc.getGetSystemInfoMethod()) {
                        responseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>((ClientCall.Listener)responseListener){

                            public void onMessage(RespT message) {
                                if (message instanceof GetSystemInfoResponse) {
                                    GetSystemInfoResponse response = (GetSystemInfoResponse)message;
                                    SystemInfoInterceptor.this.serverCapabilitiesFuture.complete(response.getCapabilities());
                                }
                                super.onMessage(message);
                            }

                            public void onClose(Status status, Metadata trailers) {
                                if (Status.UNIMPLEMENTED.getCode().equals((Object)status.getCode())) {
                                    SystemInfoInterceptor.this.serverCapabilitiesFuture.complete(GetSystemInfoResponse.Capabilities.getDefaultInstance());
                                }
                                super.onClose(status, trailers);
                            }
                        };
                    } else {
                        SystemInfoInterceptor.this.serverCapabilitiesFuture.complete(SystemInfoInterceptor.getServerCapabilitiesOrThrow(next, callOptions.getDeadline()));
                    }
                }
                super.start(responseListener, headers);
            }
        };
    }

    public static GetSystemInfoResponse.Capabilities getServerCapabilitiesOrThrow(Channel channel, @Nullable Deadline deadline) {
        try {
            return ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)WorkflowServiceGrpc.newBlockingStub(channel).withDeadline(deadline)).getSystemInfo(GetSystemInfoRequest.newBuilder().build()).getCapabilities();
        }
        catch (StatusRuntimeException ex) {
            if (Status.Code.UNIMPLEMENTED.equals((Object)ex.getStatus().getCode())) {
                return GetSystemInfoResponse.Capabilities.getDefaultInstance();
            }
            throw ex;
        }
    }
}

