/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.serviceclient;

import com.google.common.base.MoreObjects;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.temporal.authorization.AuthorizationGrpcMetadataProvider;
import io.temporal.authorization.AuthorizationTokenSupplier;
import io.temporal.serviceclient.GrpcMetadataProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ServiceStubsOptions {
    public static final String DEFAULT_LOCAL_DOCKER_TARGET = "127.0.0.1:7233";
    public static final Duration DEFAULT_RPC_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_GRPC_RECONNECT_FREQUENCY = Duration.ofMinutes(1L);
    protected final ManagedChannel channel;
    protected final String target;
    @Nullable
    protected final Consumer<ManagedChannelBuilder<?>> channelInitializer;
    protected final boolean enableHttps;
    protected final SslContext sslContext;
    protected final Duration healthCheckAttemptTimeout;
    protected final Duration healthCheckTimeout;
    protected final boolean enableKeepAlive;
    protected final Duration keepAliveTime;
    protected final Duration keepAliveTimeout;
    protected final boolean keepAlivePermitWithoutStream;
    protected final Duration rpcTimeout;
    protected final Duration connectionBackoffResetFrequency;
    protected final Duration grpcReconnectFrequency;
    protected final Metadata headers;
    protected final Collection<GrpcMetadataProvider> grpcMetadataProviders;
    protected final Collection<ClientInterceptor> grpcClientInterceptors;
    protected final Scope metricsScope;

    ServiceStubsOptions(ServiceStubsOptions that) {
        this.channel = that.channel;
        this.target = that.target;
        this.channelInitializer = that.channelInitializer;
        this.enableHttps = that.enableHttps;
        this.sslContext = that.sslContext;
        this.healthCheckAttemptTimeout = that.healthCheckAttemptTimeout;
        this.healthCheckTimeout = that.healthCheckTimeout;
        this.enableKeepAlive = that.enableKeepAlive;
        this.keepAliveTime = that.keepAliveTime;
        this.keepAliveTimeout = that.keepAliveTimeout;
        this.keepAlivePermitWithoutStream = that.keepAlivePermitWithoutStream;
        this.rpcTimeout = that.rpcTimeout;
        this.connectionBackoffResetFrequency = that.connectionBackoffResetFrequency;
        this.grpcReconnectFrequency = that.grpcReconnectFrequency;
        this.headers = that.headers;
        this.grpcMetadataProviders = that.grpcMetadataProviders;
        this.grpcClientInterceptors = that.grpcClientInterceptors;
        this.metricsScope = that.metricsScope;
    }

    ServiceStubsOptions(ManagedChannel channel, String target, @Nullable Consumer<ManagedChannelBuilder<?>> channelInitializer, boolean enableHttps, SslContext sslContext, Duration healthCheckAttemptTimeout, Duration healthCheckTimeout, boolean enableKeepAlive, Duration keepAliveTime, Duration keepAliveTimeout, boolean keepAlivePermitWithoutStream, Duration rpcTimeout, Duration connectionBackoffResetFrequency, Duration grpcReconnectFrequency, Metadata headers, Collection<GrpcMetadataProvider> grpcMetadataProviders, Collection<ClientInterceptor> grpcClientInterceptors, Scope metricsScope) {
        this.channel = channel;
        this.target = target;
        this.channelInitializer = channelInitializer;
        this.enableHttps = enableHttps;
        this.sslContext = sslContext;
        this.healthCheckAttemptTimeout = healthCheckAttemptTimeout;
        this.healthCheckTimeout = healthCheckTimeout;
        this.enableKeepAlive = enableKeepAlive;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveTimeout = keepAliveTimeout;
        this.keepAlivePermitWithoutStream = keepAlivePermitWithoutStream;
        this.rpcTimeout = rpcTimeout;
        this.connectionBackoffResetFrequency = connectionBackoffResetFrequency;
        this.grpcReconnectFrequency = grpcReconnectFrequency;
        this.headers = headers;
        this.grpcMetadataProviders = grpcMetadataProviders;
        this.grpcClientInterceptors = grpcClientInterceptors;
        this.metricsScope = metricsScope;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public String getTarget() {
        return this.target;
    }

    @Nullable
    public Consumer<ManagedChannelBuilder<?>> getChannelInitializer() {
        return this.channelInitializer;
    }

    public boolean getEnableHttps() {
        return this.enableHttps;
    }

    public SslContext getSslContext() {
        return this.sslContext;
    }

    public Duration getHealthCheckAttemptTimeout() {
        return this.healthCheckAttemptTimeout;
    }

    public Duration getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    public boolean getEnableKeepAlive() {
        return this.enableKeepAlive;
    }

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public Duration getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public boolean getKeepAlivePermitWithoutStream() {
        return this.keepAlivePermitWithoutStream;
    }

    public Duration getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Duration getConnectionBackoffResetFrequency() {
        return this.connectionBackoffResetFrequency;
    }

    public Duration getGrpcReconnectFrequency() {
        return this.grpcReconnectFrequency;
    }

    public Metadata getHeaders() {
        return this.headers;
    }

    public Collection<GrpcMetadataProvider> getGrpcMetadataProviders() {
        return this.grpcMetadataProviders;
    }

    public Collection<ClientInterceptor> getGrpcClientInterceptors() {
        return this.grpcClientInterceptors;
    }

    @Nonnull
    public Scope getMetricsScope() {
        return this.metricsScope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceStubsOptions that = (ServiceStubsOptions)o;
        return this.enableHttps == that.enableHttps && this.enableKeepAlive == that.enableKeepAlive && this.keepAlivePermitWithoutStream == that.keepAlivePermitWithoutStream && Objects.equals(this.channel, that.channel) && Objects.equals(this.target, that.target) && Objects.equals(this.channelInitializer, that.channelInitializer) && Objects.equals(this.sslContext, that.sslContext) && Objects.equals(this.healthCheckAttemptTimeout, that.healthCheckAttemptTimeout) && Objects.equals(this.healthCheckTimeout, that.healthCheckTimeout) && Objects.equals(this.keepAliveTime, that.keepAliveTime) && Objects.equals(this.keepAliveTimeout, that.keepAliveTimeout) && Objects.equals(this.rpcTimeout, that.rpcTimeout) && Objects.equals(this.connectionBackoffResetFrequency, that.connectionBackoffResetFrequency) && Objects.equals(this.grpcReconnectFrequency, that.grpcReconnectFrequency) && Objects.equals(this.headers, that.headers) && Objects.equals(this.grpcMetadataProviders, that.grpcMetadataProviders) && Objects.equals(this.grpcClientInterceptors, that.grpcClientInterceptors) && Objects.equals(this.metricsScope, that.metricsScope);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.target, this.channelInitializer, this.enableHttps, this.sslContext, this.healthCheckAttemptTimeout, this.healthCheckTimeout, this.enableKeepAlive, this.keepAliveTime, this.keepAliveTimeout, this.keepAlivePermitWithoutStream, this.rpcTimeout, this.connectionBackoffResetFrequency, this.grpcReconnectFrequency, this.headers, this.grpcMetadataProviders, this.grpcClientInterceptors, this.metricsScope);
    }

    public String toString() {
        return "ServiceStubsOptions{channel=" + this.channel + ", target='" + this.target + '\'' + ", channelInitializer=" + this.channelInitializer + ", enableHttps=" + this.enableHttps + ", sslContext=" + this.sslContext + ", healthCheckAttemptTimeout=" + this.healthCheckAttemptTimeout + ", healthCheckTimeout=" + this.healthCheckTimeout + ", enableKeepAlive=" + this.enableKeepAlive + ", keepAliveTime=" + this.keepAliveTime + ", keepAliveTimeout=" + this.keepAliveTimeout + ", keepAlivePermitWithoutStream=" + this.keepAlivePermitWithoutStream + ", rpcTimeout=" + this.rpcTimeout + ", connectionBackoffResetFrequency=" + this.connectionBackoffResetFrequency + ", grpcReconnectFrequency=" + this.grpcReconnectFrequency + ", headers=" + this.headers + ", grpcMetadataProviders=" + this.grpcMetadataProviders + ", grpcClientInterceptors=" + this.grpcClientInterceptors + ", metricsScope=" + this.metricsScope + '}';
    }

    public static class Builder<T extends Builder<T>> {
        private ManagedChannel channel;
        private SslContext sslContext;
        private boolean enableHttps;
        private String target;
        private Consumer<ManagedChannelBuilder<?>> channelInitializer;
        private Duration healthCheckAttemptTimeout;
        private Duration healthCheckTimeout;
        private boolean enableKeepAlive = true;
        private Duration keepAliveTime = Duration.ofSeconds(30L);
        private Duration keepAliveTimeout = Duration.ofSeconds(15L);
        private boolean keepAlivePermitWithoutStream = true;
        private Duration rpcTimeout = DEFAULT_RPC_TIMEOUT;
        private Duration connectionBackoffResetFrequency = DEFAULT_CONNECTION_BACKOFF_RESET_FREQUENCY;
        private Duration grpcReconnectFrequency = DEFAULT_GRPC_RECONNECT_FREQUENCY;
        private Metadata headers;
        private Collection<GrpcMetadataProvider> grpcMetadataProviders;
        private Collection<ClientInterceptor> grpcClientInterceptors;
        private Scope metricsScope;

        protected Builder() {
        }

        protected Builder(ServiceStubsOptions options) {
            this.channel = options.channel;
            this.target = options.target;
            this.channelInitializer = options.channelInitializer;
            this.enableHttps = options.enableHttps;
            this.sslContext = options.sslContext;
            this.healthCheckAttemptTimeout = options.healthCheckAttemptTimeout;
            this.healthCheckTimeout = options.healthCheckTimeout;
            this.enableKeepAlive = options.enableKeepAlive;
            this.keepAliveTime = options.keepAliveTime;
            this.keepAliveTimeout = options.keepAliveTimeout;
            this.keepAlivePermitWithoutStream = options.keepAlivePermitWithoutStream;
            this.rpcTimeout = options.rpcTimeout;
            this.connectionBackoffResetFrequency = options.connectionBackoffResetFrequency;
            this.grpcReconnectFrequency = options.grpcReconnectFrequency;
            this.headers = options.headers;
            this.grpcMetadataProviders = options.grpcMetadataProviders;
            this.grpcClientInterceptors = options.grpcClientInterceptors;
            this.metricsScope = options.metricsScope;
        }

        public T setTarget(String target) {
            this.target = target;
            return this.self();
        }

        public T setChannelInitializer(Consumer<ManagedChannelBuilder<?>> channelInitializer) {
            this.channelInitializer = channelInitializer;
            return this.self();
        }

        public T setChannel(ManagedChannel channel) {
            this.channel = channel;
            return this.self();
        }

        public T setSslContext(SslContext sslContext) {
            this.sslContext = sslContext;
            return this.self();
        }

        public T setEnableHttps(boolean enableHttps) {
            this.enableHttps = enableHttps;
            return this.self();
        }

        public T setConnectionBackoffResetFrequency(Duration connectionBackoffResetFrequency) {
            this.connectionBackoffResetFrequency = connectionBackoffResetFrequency;
            return this.self();
        }

        public T setGrpcReconnectFrequency(Duration grpcReconnectFrequency) {
            this.grpcReconnectFrequency = grpcReconnectFrequency;
            return this.self();
        }

        public T setHeaders(Metadata headers) {
            this.headers = headers;
            return this.self();
        }

        public T addGrpcMetadataProvider(GrpcMetadataProvider grpcMetadataProvider) {
            if (this.grpcMetadataProviders == null) {
                this.grpcMetadataProviders = new ArrayList<GrpcMetadataProvider>();
            }
            this.grpcMetadataProviders.add(grpcMetadataProvider);
            return this.self();
        }

        public T addApiKey(AuthorizationTokenSupplier apiKey) {
            this.addGrpcMetadataProvider(new AuthorizationGrpcMetadataProvider(() -> "Bearer " + apiKey.supply()));
            return this.self();
        }

        public T setGrpcMetadataProviders(Collection<GrpcMetadataProvider> grpcMetadataProviders) {
            this.grpcMetadataProviders = grpcMetadataProviders;
            return this.self();
        }

        public T addGrpcClientInterceptor(ClientInterceptor grpcClientInterceptor) {
            if (this.grpcClientInterceptors == null) {
                this.grpcClientInterceptors = new ArrayList<ClientInterceptor>();
            }
            this.grpcClientInterceptors.add(grpcClientInterceptor);
            return this.self();
        }

        public T setGrpcClientInterceptors(Collection<ClientInterceptor> grpcClientInterceptors) {
            this.grpcClientInterceptors = grpcClientInterceptors;
            return this.self();
        }

        public T setMetricsScope(Scope metricsScope) {
            this.metricsScope = metricsScope;
            return this.self();
        }

        @Deprecated
        public T setHealthCheckAttemptTimeout(Duration healthCheckAttemptTimeout) {
            this.healthCheckAttemptTimeout = healthCheckAttemptTimeout;
            return this.self();
        }

        @Deprecated
        public T setHealthCheckTimeout(Duration healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this.self();
        }

        public T setEnableKeepAlive(boolean enableKeepAlive) {
            this.enableKeepAlive = enableKeepAlive;
            return this.self();
        }

        public T setKeepAliveTime(Duration keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
            return this.self();
        }

        public T setKeepAliveTimeout(Duration keepAliveTimeout) {
            this.keepAliveTimeout = keepAliveTimeout;
            return this.self();
        }

        public T setKeepAlivePermitWithoutStream(boolean keepAlivePermitWithoutStream) {
            this.keepAlivePermitWithoutStream = keepAlivePermitWithoutStream;
            return this.self();
        }

        public T setRpcTimeout(Duration timeout) {
            this.rpcTimeout = Objects.requireNonNull(timeout);
            return this.self();
        }

        private T self() {
            return (T)this;
        }

        public ServiceStubsOptions build() {
            return new ServiceStubsOptions(this.channel, this.target, this.channelInitializer, this.enableHttps, this.sslContext, this.healthCheckAttemptTimeout, this.healthCheckTimeout, this.enableKeepAlive, this.keepAliveTime, this.keepAliveTimeout, this.keepAlivePermitWithoutStream, this.rpcTimeout, this.connectionBackoffResetFrequency, this.grpcReconnectFrequency, this.headers, this.grpcMetadataProviders, this.grpcClientInterceptors, this.metricsScope);
        }

        public ServiceStubsOptions validateAndBuildWithDefaults() {
            if (this.target != null && this.channel != null) {
                throw new IllegalStateException("Only one of the 'target' or 'channel' options can be set at a time");
            }
            if (this.channelInitializer != null && this.channel != null) {
                throw new IllegalStateException("Only one of the 'channelInitializer' or 'channel' options can be set at a time");
            }
            if (this.sslContext != null && this.channel != null) {
                throw new IllegalStateException("Only one of the 'sslContext' or 'channel' options can be set at a time");
            }
            if (this.enableHttps && this.channel != null) {
                throw new IllegalStateException("Only one of the 'enableHttps' or 'channel' options can be set at a time");
            }
            String target = this.target == null && this.channel == null ? ServiceStubsOptions.DEFAULT_LOCAL_DOCKER_TARGET : this.target;
            Metadata headers = this.headers != null ? this.headers : new Metadata();
            Collection grpcMetadataProviders = (Collection)MoreObjects.firstNonNull(this.grpcMetadataProviders, Collections.emptyList());
            Collection grpcClientInterceptors = (Collection)MoreObjects.firstNonNull(this.grpcClientInterceptors, Collections.emptyList());
            Scope metricsScope = this.metricsScope != null ? this.metricsScope : new NoopScope();
            Duration healthCheckAttemptTimeout = this.healthCheckAttemptTimeout != null ? this.healthCheckAttemptTimeout : Duration.ofSeconds(5L);
            Duration healthCheckTimeout = this.healthCheckTimeout != null ? this.healthCheckTimeout : Duration.ofSeconds(10L);
            return new ServiceStubsOptions(this.channel, target, this.channelInitializer, this.enableHttps, this.sslContext, healthCheckAttemptTimeout, healthCheckTimeout, this.enableKeepAlive, this.keepAliveTime, this.keepAliveTimeout, this.keepAlivePermitWithoutStream, this.rpcTimeout, this.connectionBackoffResetFrequency, this.grpcReconnectFrequency, headers, grpcMetadataProviders, grpcClientInterceptors, metricsScope);
        }
    }
}

