/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.api.workflow.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DurationOrBuilder;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.MemoOrBuilder;
import io.temporal.api.common.v1.Priority;
import io.temporal.api.common.v1.PriorityOrBuilder;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.SearchAttributesOrBuilder;
import io.temporal.api.common.v1.WorkerVersionStamp;
import io.temporal.api.common.v1.WorkerVersionStampOrBuilder;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowExecutionOrBuilder;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.common.v1.WorkflowTypeOrBuilder;
import io.temporal.api.enums.v1.WorkflowExecutionStatus;
import io.temporal.api.workflow.v1.MessageProto;
import io.temporal.api.workflow.v1.ResetPoints;
import io.temporal.api.workflow.v1.ResetPointsOrBuilder;
import io.temporal.api.workflow.v1.WorkflowExecutionInfoOrBuilder;
import io.temporal.api.workflow.v1.WorkflowExecutionVersioningInfo;
import io.temporal.api.workflow.v1.WorkflowExecutionVersioningInfoOrBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class WorkflowExecutionInfo
extends GeneratedMessageV3
implements WorkflowExecutionInfoOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int EXECUTION_FIELD_NUMBER = 1;
    private WorkflowExecution execution_;
    public static final int TYPE_FIELD_NUMBER = 2;
    private WorkflowType type_;
    public static final int START_TIME_FIELD_NUMBER = 3;
    private Timestamp startTime_;
    public static final int CLOSE_TIME_FIELD_NUMBER = 4;
    private Timestamp closeTime_;
    public static final int STATUS_FIELD_NUMBER = 5;
    private int status_ = 0;
    public static final int HISTORY_LENGTH_FIELD_NUMBER = 6;
    private long historyLength_ = 0L;
    public static final int PARENT_NAMESPACE_ID_FIELD_NUMBER = 7;
    private volatile Object parentNamespaceId_ = "";
    public static final int PARENT_EXECUTION_FIELD_NUMBER = 8;
    private WorkflowExecution parentExecution_;
    public static final int EXECUTION_TIME_FIELD_NUMBER = 9;
    private Timestamp executionTime_;
    public static final int MEMO_FIELD_NUMBER = 10;
    private Memo memo_;
    public static final int SEARCH_ATTRIBUTES_FIELD_NUMBER = 11;
    private SearchAttributes searchAttributes_;
    public static final int AUTO_RESET_POINTS_FIELD_NUMBER = 12;
    private ResetPoints autoResetPoints_;
    public static final int TASK_QUEUE_FIELD_NUMBER = 13;
    private volatile Object taskQueue_ = "";
    public static final int STATE_TRANSITION_COUNT_FIELD_NUMBER = 14;
    private long stateTransitionCount_ = 0L;
    public static final int HISTORY_SIZE_BYTES_FIELD_NUMBER = 15;
    private long historySizeBytes_ = 0L;
    public static final int MOST_RECENT_WORKER_VERSION_STAMP_FIELD_NUMBER = 16;
    private WorkerVersionStamp mostRecentWorkerVersionStamp_;
    public static final int EXECUTION_DURATION_FIELD_NUMBER = 17;
    private Duration executionDuration_;
    public static final int ROOT_EXECUTION_FIELD_NUMBER = 18;
    private WorkflowExecution rootExecution_;
    public static final int ASSIGNED_BUILD_ID_FIELD_NUMBER = 19;
    private volatile Object assignedBuildId_ = "";
    public static final int INHERITED_BUILD_ID_FIELD_NUMBER = 20;
    private volatile Object inheritedBuildId_ = "";
    public static final int FIRST_RUN_ID_FIELD_NUMBER = 21;
    private volatile Object firstRunId_ = "";
    public static final int VERSIONING_INFO_FIELD_NUMBER = 22;
    private WorkflowExecutionVersioningInfo versioningInfo_;
    public static final int WORKER_DEPLOYMENT_NAME_FIELD_NUMBER = 23;
    private volatile Object workerDeploymentName_ = "";
    public static final int PRIORITY_FIELD_NUMBER = 24;
    private Priority priority_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final WorkflowExecutionInfo DEFAULT_INSTANCE = new WorkflowExecutionInfo();
    private static final Parser<WorkflowExecutionInfo> PARSER = new AbstractParser<WorkflowExecutionInfo>(){

        public WorkflowExecutionInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = WorkflowExecutionInfo.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private WorkflowExecutionInfo(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private WorkflowExecutionInfo() {
        this.status_ = 0;
        this.parentNamespaceId_ = "";
        this.taskQueue_ = "";
        this.assignedBuildId_ = "";
        this.inheritedBuildId_ = "";
        this.firstRunId_ = "";
        this.workerDeploymentName_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new WorkflowExecutionInfo();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MessageProto.internal_static_temporal_api_workflow_v1_WorkflowExecutionInfo_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MessageProto.internal_static_temporal_api_workflow_v1_WorkflowExecutionInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(WorkflowExecutionInfo.class, Builder.class);
    }

    @Override
    public boolean hasExecution() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution_ == null ? WorkflowExecution.getDefaultInstance() : this.execution_;
    }

    @Override
    public WorkflowExecutionOrBuilder getExecutionOrBuilder() {
        return this.execution_ == null ? WorkflowExecution.getDefaultInstance() : this.execution_;
    }

    @Override
    public boolean hasType() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public WorkflowType getType() {
        return this.type_ == null ? WorkflowType.getDefaultInstance() : this.type_;
    }

    @Override
    public WorkflowTypeOrBuilder getTypeOrBuilder() {
        return this.type_ == null ? WorkflowType.getDefaultInstance() : this.type_;
    }

    @Override
    public boolean hasStartTime() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public Timestamp getStartTime() {
        return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
    }

    @Override
    public TimestampOrBuilder getStartTimeOrBuilder() {
        return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
    }

    @Override
    public boolean hasCloseTime() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Timestamp getCloseTime() {
        return this.closeTime_ == null ? Timestamp.getDefaultInstance() : this.closeTime_;
    }

    @Override
    public TimestampOrBuilder getCloseTimeOrBuilder() {
        return this.closeTime_ == null ? Timestamp.getDefaultInstance() : this.closeTime_;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public WorkflowExecutionStatus getStatus() {
        WorkflowExecutionStatus result = WorkflowExecutionStatus.forNumber(this.status_);
        return result == null ? WorkflowExecutionStatus.UNRECOGNIZED : result;
    }

    @Override
    public long getHistoryLength() {
        return this.historyLength_;
    }

    @Override
    public String getParentNamespaceId() {
        Object ref = this.parentNamespaceId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.parentNamespaceId_ = s;
        return s;
    }

    @Override
    public ByteString getParentNamespaceIdBytes() {
        Object ref = this.parentNamespaceId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.parentNamespaceId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasParentExecution() {
        return (this.bitField0_ & 0x10) != 0;
    }

    @Override
    public WorkflowExecution getParentExecution() {
        return this.parentExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.parentExecution_;
    }

    @Override
    public WorkflowExecutionOrBuilder getParentExecutionOrBuilder() {
        return this.parentExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.parentExecution_;
    }

    @Override
    public boolean hasExecutionTime() {
        return (this.bitField0_ & 0x20) != 0;
    }

    @Override
    public Timestamp getExecutionTime() {
        return this.executionTime_ == null ? Timestamp.getDefaultInstance() : this.executionTime_;
    }

    @Override
    public TimestampOrBuilder getExecutionTimeOrBuilder() {
        return this.executionTime_ == null ? Timestamp.getDefaultInstance() : this.executionTime_;
    }

    @Override
    public boolean hasMemo() {
        return (this.bitField0_ & 0x40) != 0;
    }

    @Override
    public Memo getMemo() {
        return this.memo_ == null ? Memo.getDefaultInstance() : this.memo_;
    }

    @Override
    public MemoOrBuilder getMemoOrBuilder() {
        return this.memo_ == null ? Memo.getDefaultInstance() : this.memo_;
    }

    @Override
    public boolean hasSearchAttributes() {
        return (this.bitField0_ & 0x80) != 0;
    }

    @Override
    public SearchAttributes getSearchAttributes() {
        return this.searchAttributes_ == null ? SearchAttributes.getDefaultInstance() : this.searchAttributes_;
    }

    @Override
    public SearchAttributesOrBuilder getSearchAttributesOrBuilder() {
        return this.searchAttributes_ == null ? SearchAttributes.getDefaultInstance() : this.searchAttributes_;
    }

    @Override
    public boolean hasAutoResetPoints() {
        return (this.bitField0_ & 0x100) != 0;
    }

    @Override
    public ResetPoints getAutoResetPoints() {
        return this.autoResetPoints_ == null ? ResetPoints.getDefaultInstance() : this.autoResetPoints_;
    }

    @Override
    public ResetPointsOrBuilder getAutoResetPointsOrBuilder() {
        return this.autoResetPoints_ == null ? ResetPoints.getDefaultInstance() : this.autoResetPoints_;
    }

    @Override
    public String getTaskQueue() {
        Object ref = this.taskQueue_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.taskQueue_ = s;
        return s;
    }

    @Override
    public ByteString getTaskQueueBytes() {
        Object ref = this.taskQueue_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.taskQueue_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public long getStateTransitionCount() {
        return this.stateTransitionCount_;
    }

    @Override
    public long getHistorySizeBytes() {
        return this.historySizeBytes_;
    }

    @Override
    public boolean hasMostRecentWorkerVersionStamp() {
        return (this.bitField0_ & 0x200) != 0;
    }

    @Override
    public WorkerVersionStamp getMostRecentWorkerVersionStamp() {
        return this.mostRecentWorkerVersionStamp_ == null ? WorkerVersionStamp.getDefaultInstance() : this.mostRecentWorkerVersionStamp_;
    }

    @Override
    public WorkerVersionStampOrBuilder getMostRecentWorkerVersionStampOrBuilder() {
        return this.mostRecentWorkerVersionStamp_ == null ? WorkerVersionStamp.getDefaultInstance() : this.mostRecentWorkerVersionStamp_;
    }

    @Override
    public boolean hasExecutionDuration() {
        return (this.bitField0_ & 0x400) != 0;
    }

    @Override
    public Duration getExecutionDuration() {
        return this.executionDuration_ == null ? Duration.getDefaultInstance() : this.executionDuration_;
    }

    @Override
    public DurationOrBuilder getExecutionDurationOrBuilder() {
        return this.executionDuration_ == null ? Duration.getDefaultInstance() : this.executionDuration_;
    }

    @Override
    public boolean hasRootExecution() {
        return (this.bitField0_ & 0x800) != 0;
    }

    @Override
    public WorkflowExecution getRootExecution() {
        return this.rootExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.rootExecution_;
    }

    @Override
    public WorkflowExecutionOrBuilder getRootExecutionOrBuilder() {
        return this.rootExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.rootExecution_;
    }

    @Override
    @Deprecated
    public String getAssignedBuildId() {
        Object ref = this.assignedBuildId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.assignedBuildId_ = s;
        return s;
    }

    @Override
    @Deprecated
    public ByteString getAssignedBuildIdBytes() {
        Object ref = this.assignedBuildId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.assignedBuildId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    @Deprecated
    public String getInheritedBuildId() {
        Object ref = this.inheritedBuildId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.inheritedBuildId_ = s;
        return s;
    }

    @Override
    @Deprecated
    public ByteString getInheritedBuildIdBytes() {
        Object ref = this.inheritedBuildId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.inheritedBuildId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getFirstRunId() {
        Object ref = this.firstRunId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.firstRunId_ = s;
        return s;
    }

    @Override
    public ByteString getFirstRunIdBytes() {
        Object ref = this.firstRunId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.firstRunId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasVersioningInfo() {
        return (this.bitField0_ & 0x1000) != 0;
    }

    @Override
    public WorkflowExecutionVersioningInfo getVersioningInfo() {
        return this.versioningInfo_ == null ? WorkflowExecutionVersioningInfo.getDefaultInstance() : this.versioningInfo_;
    }

    @Override
    public WorkflowExecutionVersioningInfoOrBuilder getVersioningInfoOrBuilder() {
        return this.versioningInfo_ == null ? WorkflowExecutionVersioningInfo.getDefaultInstance() : this.versioningInfo_;
    }

    @Override
    public String getWorkerDeploymentName() {
        Object ref = this.workerDeploymentName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.workerDeploymentName_ = s;
        return s;
    }

    @Override
    public ByteString getWorkerDeploymentNameBytes() {
        Object ref = this.workerDeploymentName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.workerDeploymentName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasPriority() {
        return (this.bitField0_ & 0x2000) != 0;
    }

    @Override
    public Priority getPriority() {
        return this.priority_ == null ? Priority.getDefaultInstance() : this.priority_;
    }

    @Override
    public PriorityOrBuilder getPriorityOrBuilder() {
        return this.priority_ == null ? Priority.getDefaultInstance() : this.priority_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(1, (MessageLite)this.getExecution());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(2, (MessageLite)this.getType());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(3, (MessageLite)this.getStartTime());
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(4, (MessageLite)this.getCloseTime());
        }
        if (this.status_ != WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.status_);
        }
        if (this.historyLength_ != 0L) {
            output.writeInt64(6, this.historyLength_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parentNamespaceId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.parentNamespaceId_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            output.writeMessage(8, (MessageLite)this.getParentExecution());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            output.writeMessage(9, (MessageLite)this.getExecutionTime());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            output.writeMessage(10, (MessageLite)this.getMemo());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            output.writeMessage(11, (MessageLite)this.getSearchAttributes());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            output.writeMessage(12, (MessageLite)this.getAutoResetPoints());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.taskQueue_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)13, (Object)this.taskQueue_);
        }
        if (this.stateTransitionCount_ != 0L) {
            output.writeInt64(14, this.stateTransitionCount_);
        }
        if (this.historySizeBytes_ != 0L) {
            output.writeInt64(15, this.historySizeBytes_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            output.writeMessage(16, (MessageLite)this.getMostRecentWorkerVersionStamp());
        }
        if ((this.bitField0_ & 0x400) != 0) {
            output.writeMessage(17, (MessageLite)this.getExecutionDuration());
        }
        if ((this.bitField0_ & 0x800) != 0) {
            output.writeMessage(18, (MessageLite)this.getRootExecution());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.assignedBuildId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)19, (Object)this.assignedBuildId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.inheritedBuildId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)20, (Object)this.inheritedBuildId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.firstRunId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)21, (Object)this.firstRunId_);
        }
        if ((this.bitField0_ & 0x1000) != 0) {
            output.writeMessage(22, (MessageLite)this.getVersioningInfo());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workerDeploymentName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)23, (Object)this.workerDeploymentName_);
        }
        if ((this.bitField0_ & 0x2000) != 0) {
            output.writeMessage(24, (MessageLite)this.getPriority());
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getExecution());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)2, (MessageLite)this.getType());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getStartTime());
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getCloseTime());
        }
        if (this.status_ != WorkflowExecutionStatus.WORKFLOW_EXECUTION_STATUS_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.status_);
        }
        if (this.historyLength_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)6, (long)this.historyLength_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.parentNamespaceId_)) {
            size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.parentNamespaceId_);
        }
        if ((this.bitField0_ & 0x10) != 0) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)this.getParentExecution());
        }
        if ((this.bitField0_ & 0x20) != 0) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)this.getExecutionTime());
        }
        if ((this.bitField0_ & 0x40) != 0) {
            size += CodedOutputStream.computeMessageSize((int)10, (MessageLite)this.getMemo());
        }
        if ((this.bitField0_ & 0x80) != 0) {
            size += CodedOutputStream.computeMessageSize((int)11, (MessageLite)this.getSearchAttributes());
        }
        if ((this.bitField0_ & 0x100) != 0) {
            size += CodedOutputStream.computeMessageSize((int)12, (MessageLite)this.getAutoResetPoints());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.taskQueue_)) {
            size += GeneratedMessageV3.computeStringSize((int)13, (Object)this.taskQueue_);
        }
        if (this.stateTransitionCount_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)14, (long)this.stateTransitionCount_);
        }
        if (this.historySizeBytes_ != 0L) {
            size += CodedOutputStream.computeInt64Size((int)15, (long)this.historySizeBytes_);
        }
        if ((this.bitField0_ & 0x200) != 0) {
            size += CodedOutputStream.computeMessageSize((int)16, (MessageLite)this.getMostRecentWorkerVersionStamp());
        }
        if ((this.bitField0_ & 0x400) != 0) {
            size += CodedOutputStream.computeMessageSize((int)17, (MessageLite)this.getExecutionDuration());
        }
        if ((this.bitField0_ & 0x800) != 0) {
            size += CodedOutputStream.computeMessageSize((int)18, (MessageLite)this.getRootExecution());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.assignedBuildId_)) {
            size += GeneratedMessageV3.computeStringSize((int)19, (Object)this.assignedBuildId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.inheritedBuildId_)) {
            size += GeneratedMessageV3.computeStringSize((int)20, (Object)this.inheritedBuildId_);
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.firstRunId_)) {
            size += GeneratedMessageV3.computeStringSize((int)21, (Object)this.firstRunId_);
        }
        if ((this.bitField0_ & 0x1000) != 0) {
            size += CodedOutputStream.computeMessageSize((int)22, (MessageLite)this.getVersioningInfo());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.workerDeploymentName_)) {
            size += GeneratedMessageV3.computeStringSize((int)23, (Object)this.workerDeploymentName_);
        }
        if ((this.bitField0_ & 0x2000) != 0) {
            size += CodedOutputStream.computeMessageSize((int)24, (MessageLite)this.getPriority());
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkflowExecutionInfo)) {
            return super.equals(obj);
        }
        WorkflowExecutionInfo other = (WorkflowExecutionInfo)obj;
        if (this.hasExecution() != other.hasExecution()) {
            return false;
        }
        if (this.hasExecution() && !this.getExecution().equals(other.getExecution())) {
            return false;
        }
        if (this.hasType() != other.hasType()) {
            return false;
        }
        if (this.hasType() && !this.getType().equals(other.getType())) {
            return false;
        }
        if (this.hasStartTime() != other.hasStartTime()) {
            return false;
        }
        if (this.hasStartTime() && !this.getStartTime().equals((Object)other.getStartTime())) {
            return false;
        }
        if (this.hasCloseTime() != other.hasCloseTime()) {
            return false;
        }
        if (this.hasCloseTime() && !this.getCloseTime().equals((Object)other.getCloseTime())) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (this.getHistoryLength() != other.getHistoryLength()) {
            return false;
        }
        if (!this.getParentNamespaceId().equals(other.getParentNamespaceId())) {
            return false;
        }
        if (this.hasParentExecution() != other.hasParentExecution()) {
            return false;
        }
        if (this.hasParentExecution() && !this.getParentExecution().equals(other.getParentExecution())) {
            return false;
        }
        if (this.hasExecutionTime() != other.hasExecutionTime()) {
            return false;
        }
        if (this.hasExecutionTime() && !this.getExecutionTime().equals((Object)other.getExecutionTime())) {
            return false;
        }
        if (this.hasMemo() != other.hasMemo()) {
            return false;
        }
        if (this.hasMemo() && !this.getMemo().equals(other.getMemo())) {
            return false;
        }
        if (this.hasSearchAttributes() != other.hasSearchAttributes()) {
            return false;
        }
        if (this.hasSearchAttributes() && !this.getSearchAttributes().equals(other.getSearchAttributes())) {
            return false;
        }
        if (this.hasAutoResetPoints() != other.hasAutoResetPoints()) {
            return false;
        }
        if (this.hasAutoResetPoints() && !this.getAutoResetPoints().equals(other.getAutoResetPoints())) {
            return false;
        }
        if (!this.getTaskQueue().equals(other.getTaskQueue())) {
            return false;
        }
        if (this.getStateTransitionCount() != other.getStateTransitionCount()) {
            return false;
        }
        if (this.getHistorySizeBytes() != other.getHistorySizeBytes()) {
            return false;
        }
        if (this.hasMostRecentWorkerVersionStamp() != other.hasMostRecentWorkerVersionStamp()) {
            return false;
        }
        if (this.hasMostRecentWorkerVersionStamp() && !this.getMostRecentWorkerVersionStamp().equals(other.getMostRecentWorkerVersionStamp())) {
            return false;
        }
        if (this.hasExecutionDuration() != other.hasExecutionDuration()) {
            return false;
        }
        if (this.hasExecutionDuration() && !this.getExecutionDuration().equals((Object)other.getExecutionDuration())) {
            return false;
        }
        if (this.hasRootExecution() != other.hasRootExecution()) {
            return false;
        }
        if (this.hasRootExecution() && !this.getRootExecution().equals(other.getRootExecution())) {
            return false;
        }
        if (!this.getAssignedBuildId().equals(other.getAssignedBuildId())) {
            return false;
        }
        if (!this.getInheritedBuildId().equals(other.getInheritedBuildId())) {
            return false;
        }
        if (!this.getFirstRunId().equals(other.getFirstRunId())) {
            return false;
        }
        if (this.hasVersioningInfo() != other.hasVersioningInfo()) {
            return false;
        }
        if (this.hasVersioningInfo() && !this.getVersioningInfo().equals(other.getVersioningInfo())) {
            return false;
        }
        if (!this.getWorkerDeploymentName().equals(other.getWorkerDeploymentName())) {
            return false;
        }
        if (this.hasPriority() != other.hasPriority()) {
            return false;
        }
        if (this.hasPriority() && !this.getPriority().equals(other.getPriority())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + WorkflowExecutionInfo.getDescriptor().hashCode();
        if (this.hasExecution()) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getExecution().hashCode();
        }
        if (this.hasType()) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getType().hashCode();
        }
        if (this.hasStartTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getStartTime().hashCode();
        }
        if (this.hasCloseTime()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getCloseTime().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.status_;
        hash = 37 * hash + 6;
        hash = 53 * hash + Internal.hashLong((long)this.getHistoryLength());
        hash = 37 * hash + 7;
        hash = 53 * hash + this.getParentNamespaceId().hashCode();
        if (this.hasParentExecution()) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getParentExecution().hashCode();
        }
        if (this.hasExecutionTime()) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getExecutionTime().hashCode();
        }
        if (this.hasMemo()) {
            hash = 37 * hash + 10;
            hash = 53 * hash + this.getMemo().hashCode();
        }
        if (this.hasSearchAttributes()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + this.getSearchAttributes().hashCode();
        }
        if (this.hasAutoResetPoints()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getAutoResetPoints().hashCode();
        }
        hash = 37 * hash + 13;
        hash = 53 * hash + this.getTaskQueue().hashCode();
        hash = 37 * hash + 14;
        hash = 53 * hash + Internal.hashLong((long)this.getStateTransitionCount());
        hash = 37 * hash + 15;
        hash = 53 * hash + Internal.hashLong((long)this.getHistorySizeBytes());
        if (this.hasMostRecentWorkerVersionStamp()) {
            hash = 37 * hash + 16;
            hash = 53 * hash + this.getMostRecentWorkerVersionStamp().hashCode();
        }
        if (this.hasExecutionDuration()) {
            hash = 37 * hash + 17;
            hash = 53 * hash + this.getExecutionDuration().hashCode();
        }
        if (this.hasRootExecution()) {
            hash = 37 * hash + 18;
            hash = 53 * hash + this.getRootExecution().hashCode();
        }
        hash = 37 * hash + 19;
        hash = 53 * hash + this.getAssignedBuildId().hashCode();
        hash = 37 * hash + 20;
        hash = 53 * hash + this.getInheritedBuildId().hashCode();
        hash = 37 * hash + 21;
        hash = 53 * hash + this.getFirstRunId().hashCode();
        if (this.hasVersioningInfo()) {
            hash = 37 * hash + 22;
            hash = 53 * hash + this.getVersioningInfo().hashCode();
        }
        hash = 37 * hash + 23;
        hash = 53 * hash + this.getWorkerDeploymentName().hashCode();
        if (this.hasPriority()) {
            hash = 37 * hash + 24;
            hash = 53 * hash + this.getPriority().hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static WorkflowExecutionInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (WorkflowExecutionInfo)PARSER.parseFrom(data);
    }

    public static WorkflowExecutionInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WorkflowExecutionInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WorkflowExecutionInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (WorkflowExecutionInfo)PARSER.parseFrom(data);
    }

    public static WorkflowExecutionInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WorkflowExecutionInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WorkflowExecutionInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (WorkflowExecutionInfo)PARSER.parseFrom(data);
    }

    public static WorkflowExecutionInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (WorkflowExecutionInfo)PARSER.parseFrom(data, extensionRegistry);
    }

    public static WorkflowExecutionInfo parseFrom(InputStream input) throws IOException {
        return (WorkflowExecutionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static WorkflowExecutionInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WorkflowExecutionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static WorkflowExecutionInfo parseDelimitedFrom(InputStream input) throws IOException {
        return (WorkflowExecutionInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static WorkflowExecutionInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WorkflowExecutionInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static WorkflowExecutionInfo parseFrom(CodedInputStream input) throws IOException {
        return (WorkflowExecutionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static WorkflowExecutionInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (WorkflowExecutionInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return WorkflowExecutionInfo.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(WorkflowExecutionInfo prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static WorkflowExecutionInfo getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<WorkflowExecutionInfo> parser() {
        return PARSER;
    }

    public Parser<WorkflowExecutionInfo> getParserForType() {
        return PARSER;
    }

    public WorkflowExecutionInfo getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements WorkflowExecutionInfoOrBuilder {
        private int bitField0_;
        private WorkflowExecution execution_;
        private SingleFieldBuilderV3<WorkflowExecution, WorkflowExecution.Builder, WorkflowExecutionOrBuilder> executionBuilder_;
        private WorkflowType type_;
        private SingleFieldBuilderV3<WorkflowType, WorkflowType.Builder, WorkflowTypeOrBuilder> typeBuilder_;
        private Timestamp startTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> startTimeBuilder_;
        private Timestamp closeTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> closeTimeBuilder_;
        private int status_ = 0;
        private long historyLength_;
        private Object parentNamespaceId_ = "";
        private WorkflowExecution parentExecution_;
        private SingleFieldBuilderV3<WorkflowExecution, WorkflowExecution.Builder, WorkflowExecutionOrBuilder> parentExecutionBuilder_;
        private Timestamp executionTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> executionTimeBuilder_;
        private Memo memo_;
        private SingleFieldBuilderV3<Memo, Memo.Builder, MemoOrBuilder> memoBuilder_;
        private SearchAttributes searchAttributes_;
        private SingleFieldBuilderV3<SearchAttributes, SearchAttributes.Builder, SearchAttributesOrBuilder> searchAttributesBuilder_;
        private ResetPoints autoResetPoints_;
        private SingleFieldBuilderV3<ResetPoints, ResetPoints.Builder, ResetPointsOrBuilder> autoResetPointsBuilder_;
        private Object taskQueue_ = "";
        private long stateTransitionCount_;
        private long historySizeBytes_;
        private WorkerVersionStamp mostRecentWorkerVersionStamp_;
        private SingleFieldBuilderV3<WorkerVersionStamp, WorkerVersionStamp.Builder, WorkerVersionStampOrBuilder> mostRecentWorkerVersionStampBuilder_;
        private Duration executionDuration_;
        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> executionDurationBuilder_;
        private WorkflowExecution rootExecution_;
        private SingleFieldBuilderV3<WorkflowExecution, WorkflowExecution.Builder, WorkflowExecutionOrBuilder> rootExecutionBuilder_;
        private Object assignedBuildId_ = "";
        private Object inheritedBuildId_ = "";
        private Object firstRunId_ = "";
        private WorkflowExecutionVersioningInfo versioningInfo_;
        private SingleFieldBuilderV3<WorkflowExecutionVersioningInfo, WorkflowExecutionVersioningInfo.Builder, WorkflowExecutionVersioningInfoOrBuilder> versioningInfoBuilder_;
        private Object workerDeploymentName_ = "";
        private Priority priority_;
        private SingleFieldBuilderV3<Priority, Priority.Builder, PriorityOrBuilder> priorityBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return MessageProto.internal_static_temporal_api_workflow_v1_WorkflowExecutionInfo_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MessageProto.internal_static_temporal_api_workflow_v1_WorkflowExecutionInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(WorkflowExecutionInfo.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getExecutionFieldBuilder();
                this.getTypeFieldBuilder();
                this.getStartTimeFieldBuilder();
                this.getCloseTimeFieldBuilder();
                this.getParentExecutionFieldBuilder();
                this.getExecutionTimeFieldBuilder();
                this.getMemoFieldBuilder();
                this.getSearchAttributesFieldBuilder();
                this.getAutoResetPointsFieldBuilder();
                this.getMostRecentWorkerVersionStampFieldBuilder();
                this.getExecutionDurationFieldBuilder();
                this.getRootExecutionFieldBuilder();
                this.getVersioningInfoFieldBuilder();
                this.getPriorityFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.execution_ = null;
            if (this.executionBuilder_ != null) {
                this.executionBuilder_.dispose();
                this.executionBuilder_ = null;
            }
            this.type_ = null;
            if (this.typeBuilder_ != null) {
                this.typeBuilder_.dispose();
                this.typeBuilder_ = null;
            }
            this.startTime_ = null;
            if (this.startTimeBuilder_ != null) {
                this.startTimeBuilder_.dispose();
                this.startTimeBuilder_ = null;
            }
            this.closeTime_ = null;
            if (this.closeTimeBuilder_ != null) {
                this.closeTimeBuilder_.dispose();
                this.closeTimeBuilder_ = null;
            }
            this.status_ = 0;
            this.historyLength_ = 0L;
            this.parentNamespaceId_ = "";
            this.parentExecution_ = null;
            if (this.parentExecutionBuilder_ != null) {
                this.parentExecutionBuilder_.dispose();
                this.parentExecutionBuilder_ = null;
            }
            this.executionTime_ = null;
            if (this.executionTimeBuilder_ != null) {
                this.executionTimeBuilder_.dispose();
                this.executionTimeBuilder_ = null;
            }
            this.memo_ = null;
            if (this.memoBuilder_ != null) {
                this.memoBuilder_.dispose();
                this.memoBuilder_ = null;
            }
            this.searchAttributes_ = null;
            if (this.searchAttributesBuilder_ != null) {
                this.searchAttributesBuilder_.dispose();
                this.searchAttributesBuilder_ = null;
            }
            this.autoResetPoints_ = null;
            if (this.autoResetPointsBuilder_ != null) {
                this.autoResetPointsBuilder_.dispose();
                this.autoResetPointsBuilder_ = null;
            }
            this.taskQueue_ = "";
            this.stateTransitionCount_ = 0L;
            this.historySizeBytes_ = 0L;
            this.mostRecentWorkerVersionStamp_ = null;
            if (this.mostRecentWorkerVersionStampBuilder_ != null) {
                this.mostRecentWorkerVersionStampBuilder_.dispose();
                this.mostRecentWorkerVersionStampBuilder_ = null;
            }
            this.executionDuration_ = null;
            if (this.executionDurationBuilder_ != null) {
                this.executionDurationBuilder_.dispose();
                this.executionDurationBuilder_ = null;
            }
            this.rootExecution_ = null;
            if (this.rootExecutionBuilder_ != null) {
                this.rootExecutionBuilder_.dispose();
                this.rootExecutionBuilder_ = null;
            }
            this.assignedBuildId_ = "";
            this.inheritedBuildId_ = "";
            this.firstRunId_ = "";
            this.versioningInfo_ = null;
            if (this.versioningInfoBuilder_ != null) {
                this.versioningInfoBuilder_.dispose();
                this.versioningInfoBuilder_ = null;
            }
            this.workerDeploymentName_ = "";
            this.priority_ = null;
            if (this.priorityBuilder_ != null) {
                this.priorityBuilder_.dispose();
                this.priorityBuilder_ = null;
            }
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MessageProto.internal_static_temporal_api_workflow_v1_WorkflowExecutionInfo_descriptor;
        }

        public WorkflowExecutionInfo getDefaultInstanceForType() {
            return WorkflowExecutionInfo.getDefaultInstance();
        }

        public WorkflowExecutionInfo build() {
            WorkflowExecutionInfo result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public WorkflowExecutionInfo buildPartial() {
            WorkflowExecutionInfo result = new WorkflowExecutionInfo(this);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartial0(WorkflowExecutionInfo result) {
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 1) != 0) {
                result.execution_ = this.executionBuilder_ == null ? this.execution_ : (WorkflowExecution)this.executionBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.type_ = this.typeBuilder_ == null ? this.type_ : (WorkflowType)this.typeBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.startTime_ = this.startTimeBuilder_ == null ? this.startTime_ : (Timestamp)this.startTimeBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.closeTime_ = this.closeTimeBuilder_ == null ? this.closeTime_ : (Timestamp)this.closeTimeBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.status_ = this.status_;
            }
            if ((from_bitField0_ & 0x20) != 0) {
                result.historyLength_ = this.historyLength_;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.parentNamespaceId_ = this.parentNamespaceId_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.parentExecution_ = this.parentExecutionBuilder_ == null ? this.parentExecution_ : (WorkflowExecution)this.parentExecutionBuilder_.build();
                to_bitField0_ |= 0x10;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.executionTime_ = this.executionTimeBuilder_ == null ? this.executionTime_ : (Timestamp)this.executionTimeBuilder_.build();
                to_bitField0_ |= 0x20;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.memo_ = this.memoBuilder_ == null ? this.memo_ : (Memo)this.memoBuilder_.build();
                to_bitField0_ |= 0x40;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.searchAttributes_ = this.searchAttributesBuilder_ == null ? this.searchAttributes_ : (SearchAttributes)this.searchAttributesBuilder_.build();
                to_bitField0_ |= 0x80;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.autoResetPoints_ = this.autoResetPointsBuilder_ == null ? this.autoResetPoints_ : (ResetPoints)this.autoResetPointsBuilder_.build();
                to_bitField0_ |= 0x100;
            }
            if ((from_bitField0_ & 0x1000) != 0) {
                result.taskQueue_ = this.taskQueue_;
            }
            if ((from_bitField0_ & 0x2000) != 0) {
                result.stateTransitionCount_ = this.stateTransitionCount_;
            }
            if ((from_bitField0_ & 0x4000) != 0) {
                result.historySizeBytes_ = this.historySizeBytes_;
            }
            if ((from_bitField0_ & 0x8000) != 0) {
                result.mostRecentWorkerVersionStamp_ = this.mostRecentWorkerVersionStampBuilder_ == null ? this.mostRecentWorkerVersionStamp_ : (WorkerVersionStamp)this.mostRecentWorkerVersionStampBuilder_.build();
                to_bitField0_ |= 0x200;
            }
            if ((from_bitField0_ & 0x10000) != 0) {
                result.executionDuration_ = this.executionDurationBuilder_ == null ? this.executionDuration_ : (Duration)this.executionDurationBuilder_.build();
                to_bitField0_ |= 0x400;
            }
            if ((from_bitField0_ & 0x20000) != 0) {
                result.rootExecution_ = this.rootExecutionBuilder_ == null ? this.rootExecution_ : (WorkflowExecution)this.rootExecutionBuilder_.build();
                to_bitField0_ |= 0x800;
            }
            if ((from_bitField0_ & 0x40000) != 0) {
                result.assignedBuildId_ = this.assignedBuildId_;
            }
            if ((from_bitField0_ & 0x80000) != 0) {
                result.inheritedBuildId_ = this.inheritedBuildId_;
            }
            if ((from_bitField0_ & 0x100000) != 0) {
                result.firstRunId_ = this.firstRunId_;
            }
            if ((from_bitField0_ & 0x200000) != 0) {
                result.versioningInfo_ = this.versioningInfoBuilder_ == null ? this.versioningInfo_ : (WorkflowExecutionVersioningInfo)this.versioningInfoBuilder_.build();
                to_bitField0_ |= 0x1000;
            }
            if ((from_bitField0_ & 0x400000) != 0) {
                result.workerDeploymentName_ = this.workerDeploymentName_;
            }
            if ((from_bitField0_ & 0x800000) != 0) {
                result.priority_ = this.priorityBuilder_ == null ? this.priority_ : (Priority)this.priorityBuilder_.build();
                to_bitField0_ |= 0x2000;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof WorkflowExecutionInfo) {
                return this.mergeFrom((WorkflowExecutionInfo)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(WorkflowExecutionInfo other) {
            if (other == WorkflowExecutionInfo.getDefaultInstance()) {
                return this;
            }
            if (other.hasExecution()) {
                this.mergeExecution(other.getExecution());
            }
            if (other.hasType()) {
                this.mergeType(other.getType());
            }
            if (other.hasStartTime()) {
                this.mergeStartTime(other.getStartTime());
            }
            if (other.hasCloseTime()) {
                this.mergeCloseTime(other.getCloseTime());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            if (other.getHistoryLength() != 0L) {
                this.setHistoryLength(other.getHistoryLength());
            }
            if (!other.getParentNamespaceId().isEmpty()) {
                this.parentNamespaceId_ = other.parentNamespaceId_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasParentExecution()) {
                this.mergeParentExecution(other.getParentExecution());
            }
            if (other.hasExecutionTime()) {
                this.mergeExecutionTime(other.getExecutionTime());
            }
            if (other.hasMemo()) {
                this.mergeMemo(other.getMemo());
            }
            if (other.hasSearchAttributes()) {
                this.mergeSearchAttributes(other.getSearchAttributes());
            }
            if (other.hasAutoResetPoints()) {
                this.mergeAutoResetPoints(other.getAutoResetPoints());
            }
            if (!other.getTaskQueue().isEmpty()) {
                this.taskQueue_ = other.taskQueue_;
                this.bitField0_ |= 0x1000;
                this.onChanged();
            }
            if (other.getStateTransitionCount() != 0L) {
                this.setStateTransitionCount(other.getStateTransitionCount());
            }
            if (other.getHistorySizeBytes() != 0L) {
                this.setHistorySizeBytes(other.getHistorySizeBytes());
            }
            if (other.hasMostRecentWorkerVersionStamp()) {
                this.mergeMostRecentWorkerVersionStamp(other.getMostRecentWorkerVersionStamp());
            }
            if (other.hasExecutionDuration()) {
                this.mergeExecutionDuration(other.getExecutionDuration());
            }
            if (other.hasRootExecution()) {
                this.mergeRootExecution(other.getRootExecution());
            }
            if (!other.getAssignedBuildId().isEmpty()) {
                this.assignedBuildId_ = other.assignedBuildId_;
                this.bitField0_ |= 0x40000;
                this.onChanged();
            }
            if (!other.getInheritedBuildId().isEmpty()) {
                this.inheritedBuildId_ = other.inheritedBuildId_;
                this.bitField0_ |= 0x80000;
                this.onChanged();
            }
            if (!other.getFirstRunId().isEmpty()) {
                this.firstRunId_ = other.firstRunId_;
                this.bitField0_ |= 0x100000;
                this.onChanged();
            }
            if (other.hasVersioningInfo()) {
                this.mergeVersioningInfo(other.getVersioningInfo());
            }
            if (!other.getWorkerDeploymentName().isEmpty()) {
                this.workerDeploymentName_ = other.workerDeploymentName_;
                this.bitField0_ |= 0x400000;
                this.onChanged();
            }
            if (other.hasPriority()) {
                this.mergePriority(other.getPriority());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block32: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block32;
                        }
                        case 10: {
                            input.readMessage((MessageLite.Builder)this.getExecutionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 1;
                            continue block32;
                        }
                        case 18: {
                            input.readMessage((MessageLite.Builder)this.getTypeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 2;
                            continue block32;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block32;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getCloseTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block32;
                        }
                        case 40: {
                            this.status_ = input.readEnum();
                            this.bitField0_ |= 0x10;
                            continue block32;
                        }
                        case 48: {
                            this.historyLength_ = input.readInt64();
                            this.bitField0_ |= 0x20;
                            continue block32;
                        }
                        case 58: {
                            this.parentNamespaceId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block32;
                        }
                        case 66: {
                            input.readMessage((MessageLite.Builder)this.getParentExecutionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block32;
                        }
                        case 74: {
                            input.readMessage((MessageLite.Builder)this.getExecutionTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x100;
                            continue block32;
                        }
                        case 82: {
                            input.readMessage((MessageLite.Builder)this.getMemoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200;
                            continue block32;
                        }
                        case 90: {
                            input.readMessage((MessageLite.Builder)this.getSearchAttributesFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x400;
                            continue block32;
                        }
                        case 98: {
                            input.readMessage((MessageLite.Builder)this.getAutoResetPointsFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800;
                            continue block32;
                        }
                        case 106: {
                            this.taskQueue_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x1000;
                            continue block32;
                        }
                        case 112: {
                            this.stateTransitionCount_ = input.readInt64();
                            this.bitField0_ |= 0x2000;
                            continue block32;
                        }
                        case 120: {
                            this.historySizeBytes_ = input.readInt64();
                            this.bitField0_ |= 0x4000;
                            continue block32;
                        }
                        case 130: {
                            input.readMessage((MessageLite.Builder)this.getMostRecentWorkerVersionStampFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x8000;
                            continue block32;
                        }
                        case 138: {
                            input.readMessage((MessageLite.Builder)this.getExecutionDurationFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10000;
                            continue block32;
                        }
                        case 146: {
                            input.readMessage((MessageLite.Builder)this.getRootExecutionFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x20000;
                            continue block32;
                        }
                        case 154: {
                            this.assignedBuildId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40000;
                            continue block32;
                        }
                        case 162: {
                            this.inheritedBuildId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x80000;
                            continue block32;
                        }
                        case 170: {
                            this.firstRunId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100000;
                            continue block32;
                        }
                        case 178: {
                            input.readMessage((MessageLite.Builder)this.getVersioningInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x200000;
                            continue block32;
                        }
                        case 186: {
                            this.workerDeploymentName_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x400000;
                            continue block32;
                        }
                        case 194: {
                            input.readMessage((MessageLite.Builder)this.getPriorityFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x800000;
                            continue block32;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public boolean hasExecution() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public WorkflowExecution getExecution() {
            if (this.executionBuilder_ == null) {
                return this.execution_ == null ? WorkflowExecution.getDefaultInstance() : this.execution_;
            }
            return (WorkflowExecution)this.executionBuilder_.getMessage();
        }

        public Builder setExecution(WorkflowExecution value) {
            if (this.executionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.execution_ = value;
            } else {
                this.executionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder setExecution(WorkflowExecution.Builder builderForValue) {
            if (this.executionBuilder_ == null) {
                this.execution_ = builderForValue.build();
            } else {
                this.executionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder mergeExecution(WorkflowExecution value) {
            if (this.executionBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0 && this.execution_ != null && this.execution_ != WorkflowExecution.getDefaultInstance()) {
                    this.getExecutionBuilder().mergeFrom(value);
                } else {
                    this.execution_ = value;
                }
            } else {
                this.executionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.execution_ != null) {
                this.bitField0_ |= 1;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExecution() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.execution_ = null;
            if (this.executionBuilder_ != null) {
                this.executionBuilder_.dispose();
                this.executionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkflowExecution.Builder getExecutionBuilder() {
            this.bitField0_ |= 1;
            this.onChanged();
            return (WorkflowExecution.Builder)this.getExecutionFieldBuilder().getBuilder();
        }

        @Override
        public WorkflowExecutionOrBuilder getExecutionOrBuilder() {
            if (this.executionBuilder_ != null) {
                return (WorkflowExecutionOrBuilder)this.executionBuilder_.getMessageOrBuilder();
            }
            return this.execution_ == null ? WorkflowExecution.getDefaultInstance() : this.execution_;
        }

        private SingleFieldBuilderV3<WorkflowExecution, WorkflowExecution.Builder, WorkflowExecutionOrBuilder> getExecutionFieldBuilder() {
            if (this.executionBuilder_ == null) {
                this.executionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExecution(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.execution_ = null;
            }
            return this.executionBuilder_;
        }

        @Override
        public boolean hasType() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public WorkflowType getType() {
            if (this.typeBuilder_ == null) {
                return this.type_ == null ? WorkflowType.getDefaultInstance() : this.type_;
            }
            return (WorkflowType)this.typeBuilder_.getMessage();
        }

        public Builder setType(WorkflowType value) {
            if (this.typeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.type_ = value;
            } else {
                this.typeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder setType(WorkflowType.Builder builderForValue) {
            if (this.typeBuilder_ == null) {
                this.type_ = builderForValue.build();
            } else {
                this.typeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder mergeType(WorkflowType value) {
            if (this.typeBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0 && this.type_ != null && this.type_ != WorkflowType.getDefaultInstance()) {
                    this.getTypeBuilder().mergeFrom(value);
                } else {
                    this.type_ = value;
                }
            } else {
                this.typeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.type_ != null) {
                this.bitField0_ |= 2;
                this.onChanged();
            }
            return this;
        }

        public Builder clearType() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.type_ = null;
            if (this.typeBuilder_ != null) {
                this.typeBuilder_.dispose();
                this.typeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkflowType.Builder getTypeBuilder() {
            this.bitField0_ |= 2;
            this.onChanged();
            return (WorkflowType.Builder)this.getTypeFieldBuilder().getBuilder();
        }

        @Override
        public WorkflowTypeOrBuilder getTypeOrBuilder() {
            if (this.typeBuilder_ != null) {
                return (WorkflowTypeOrBuilder)this.typeBuilder_.getMessageOrBuilder();
            }
            return this.type_ == null ? WorkflowType.getDefaultInstance() : this.type_;
        }

        private SingleFieldBuilderV3<WorkflowType, WorkflowType.Builder, WorkflowTypeOrBuilder> getTypeFieldBuilder() {
            if (this.typeBuilder_ == null) {
                this.typeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getType(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.type_ = null;
            }
            return this.typeBuilder_;
        }

        @Override
        public boolean hasStartTime() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getStartTime() {
            if (this.startTimeBuilder_ == null) {
                return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
            }
            return (Timestamp)this.startTimeBuilder_.getMessage();
        }

        public Builder setStartTime(Timestamp value) {
            if (this.startTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.startTime_ = value;
            } else {
                this.startTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setStartTime(Timestamp.Builder builderForValue) {
            if (this.startTimeBuilder_ == null) {
                this.startTime_ = builderForValue.build();
            } else {
                this.startTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeStartTime(Timestamp value) {
            if (this.startTimeBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.startTime_ != null && this.startTime_ != Timestamp.getDefaultInstance()) {
                    this.getStartTimeBuilder().mergeFrom(value);
                } else {
                    this.startTime_ = value;
                }
            } else {
                this.startTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.startTime_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearStartTime() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.startTime_ = null;
            if (this.startTimeBuilder_ != null) {
                this.startTimeBuilder_.dispose();
                this.startTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getStartTimeBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Timestamp.Builder)this.getStartTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getStartTimeOrBuilder() {
            if (this.startTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.startTimeBuilder_.getMessageOrBuilder();
            }
            return this.startTime_ == null ? Timestamp.getDefaultInstance() : this.startTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getStartTimeFieldBuilder() {
            if (this.startTimeBuilder_ == null) {
                this.startTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getStartTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.startTime_ = null;
            }
            return this.startTimeBuilder_;
        }

        @Override
        public boolean hasCloseTime() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Timestamp getCloseTime() {
            if (this.closeTimeBuilder_ == null) {
                return this.closeTime_ == null ? Timestamp.getDefaultInstance() : this.closeTime_;
            }
            return (Timestamp)this.closeTimeBuilder_.getMessage();
        }

        public Builder setCloseTime(Timestamp value) {
            if (this.closeTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.closeTime_ = value;
            } else {
                this.closeTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setCloseTime(Timestamp.Builder builderForValue) {
            if (this.closeTimeBuilder_ == null) {
                this.closeTime_ = builderForValue.build();
            } else {
                this.closeTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeCloseTime(Timestamp value) {
            if (this.closeTimeBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.closeTime_ != null && this.closeTime_ != Timestamp.getDefaultInstance()) {
                    this.getCloseTimeBuilder().mergeFrom(value);
                } else {
                    this.closeTime_ = value;
                }
            } else {
                this.closeTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.closeTime_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCloseTime() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.closeTime_ = null;
            if (this.closeTimeBuilder_ != null) {
                this.closeTimeBuilder_.dispose();
                this.closeTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCloseTimeBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (Timestamp.Builder)this.getCloseTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCloseTimeOrBuilder() {
            if (this.closeTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.closeTimeBuilder_.getMessageOrBuilder();
            }
            return this.closeTime_ == null ? Timestamp.getDefaultInstance() : this.closeTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCloseTimeFieldBuilder() {
            if (this.closeTimeBuilder_ == null) {
                this.closeTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCloseTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.closeTime_ = null;
            }
            return this.closeTimeBuilder_;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        @Override
        public WorkflowExecutionStatus getStatus() {
            WorkflowExecutionStatus result = WorkflowExecutionStatus.forNumber(this.status_);
            return result == null ? WorkflowExecutionStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(WorkflowExecutionStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x10;
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public long getHistoryLength() {
            return this.historyLength_;
        }

        public Builder setHistoryLength(long value) {
            this.historyLength_ = value;
            this.bitField0_ |= 0x20;
            this.onChanged();
            return this;
        }

        public Builder clearHistoryLength() {
            this.bitField0_ &= 0xFFFFFFDF;
            this.historyLength_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public String getParentNamespaceId() {
            Object ref = this.parentNamespaceId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.parentNamespaceId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getParentNamespaceIdBytes() {
            Object ref = this.parentNamespaceId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.parentNamespaceId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setParentNamespaceId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.parentNamespaceId_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearParentNamespaceId() {
            this.parentNamespaceId_ = WorkflowExecutionInfo.getDefaultInstance().getParentNamespaceId();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setParentNamespaceIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowExecutionInfo.checkByteStringIsUtf8((ByteString)value);
            this.parentNamespaceId_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasParentExecution() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public WorkflowExecution getParentExecution() {
            if (this.parentExecutionBuilder_ == null) {
                return this.parentExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.parentExecution_;
            }
            return (WorkflowExecution)this.parentExecutionBuilder_.getMessage();
        }

        public Builder setParentExecution(WorkflowExecution value) {
            if (this.parentExecutionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.parentExecution_ = value;
            } else {
                this.parentExecutionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setParentExecution(WorkflowExecution.Builder builderForValue) {
            if (this.parentExecutionBuilder_ == null) {
                this.parentExecution_ = builderForValue.build();
            } else {
                this.parentExecutionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeParentExecution(WorkflowExecution value) {
            if (this.parentExecutionBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.parentExecution_ != null && this.parentExecution_ != WorkflowExecution.getDefaultInstance()) {
                    this.getParentExecutionBuilder().mergeFrom(value);
                } else {
                    this.parentExecution_ = value;
                }
            } else {
                this.parentExecutionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.parentExecution_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearParentExecution() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.parentExecution_ = null;
            if (this.parentExecutionBuilder_ != null) {
                this.parentExecutionBuilder_.dispose();
                this.parentExecutionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkflowExecution.Builder getParentExecutionBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (WorkflowExecution.Builder)this.getParentExecutionFieldBuilder().getBuilder();
        }

        @Override
        public WorkflowExecutionOrBuilder getParentExecutionOrBuilder() {
            if (this.parentExecutionBuilder_ != null) {
                return (WorkflowExecutionOrBuilder)this.parentExecutionBuilder_.getMessageOrBuilder();
            }
            return this.parentExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.parentExecution_;
        }

        private SingleFieldBuilderV3<WorkflowExecution, WorkflowExecution.Builder, WorkflowExecutionOrBuilder> getParentExecutionFieldBuilder() {
            if (this.parentExecutionBuilder_ == null) {
                this.parentExecutionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getParentExecution(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.parentExecution_ = null;
            }
            return this.parentExecutionBuilder_;
        }

        @Override
        public boolean hasExecutionTime() {
            return (this.bitField0_ & 0x100) != 0;
        }

        @Override
        public Timestamp getExecutionTime() {
            if (this.executionTimeBuilder_ == null) {
                return this.executionTime_ == null ? Timestamp.getDefaultInstance() : this.executionTime_;
            }
            return (Timestamp)this.executionTimeBuilder_.getMessage();
        }

        public Builder setExecutionTime(Timestamp value) {
            if (this.executionTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.executionTime_ = value;
            } else {
                this.executionTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder setExecutionTime(Timestamp.Builder builderForValue) {
            if (this.executionTimeBuilder_ == null) {
                this.executionTime_ = builderForValue.build();
            } else {
                this.executionTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder mergeExecutionTime(Timestamp value) {
            if (this.executionTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x100) != 0 && this.executionTime_ != null && this.executionTime_ != Timestamp.getDefaultInstance()) {
                    this.getExecutionTimeBuilder().mergeFrom(value);
                } else {
                    this.executionTime_ = value;
                }
            } else {
                this.executionTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.executionTime_ != null) {
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExecutionTime() {
            this.bitField0_ &= 0xFFFFFEFF;
            this.executionTime_ = null;
            if (this.executionTimeBuilder_ != null) {
                this.executionTimeBuilder_.dispose();
                this.executionTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getExecutionTimeBuilder() {
            this.bitField0_ |= 0x100;
            this.onChanged();
            return (Timestamp.Builder)this.getExecutionTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getExecutionTimeOrBuilder() {
            if (this.executionTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.executionTimeBuilder_.getMessageOrBuilder();
            }
            return this.executionTime_ == null ? Timestamp.getDefaultInstance() : this.executionTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getExecutionTimeFieldBuilder() {
            if (this.executionTimeBuilder_ == null) {
                this.executionTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExecutionTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.executionTime_ = null;
            }
            return this.executionTimeBuilder_;
        }

        @Override
        public boolean hasMemo() {
            return (this.bitField0_ & 0x200) != 0;
        }

        @Override
        public Memo getMemo() {
            if (this.memoBuilder_ == null) {
                return this.memo_ == null ? Memo.getDefaultInstance() : this.memo_;
            }
            return (Memo)this.memoBuilder_.getMessage();
        }

        public Builder setMemo(Memo value) {
            if (this.memoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.memo_ = value;
            } else {
                this.memoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder setMemo(Memo.Builder builderForValue) {
            if (this.memoBuilder_ == null) {
                this.memo_ = builderForValue.build();
            } else {
                this.memoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        public Builder mergeMemo(Memo value) {
            if (this.memoBuilder_ == null) {
                if ((this.bitField0_ & 0x200) != 0 && this.memo_ != null && this.memo_ != Memo.getDefaultInstance()) {
                    this.getMemoBuilder().mergeFrom(value);
                } else {
                    this.memo_ = value;
                }
            } else {
                this.memoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.memo_ != null) {
                this.bitField0_ |= 0x200;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMemo() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.memo_ = null;
            if (this.memoBuilder_ != null) {
                this.memoBuilder_.dispose();
                this.memoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Memo.Builder getMemoBuilder() {
            this.bitField0_ |= 0x200;
            this.onChanged();
            return (Memo.Builder)this.getMemoFieldBuilder().getBuilder();
        }

        @Override
        public MemoOrBuilder getMemoOrBuilder() {
            if (this.memoBuilder_ != null) {
                return (MemoOrBuilder)this.memoBuilder_.getMessageOrBuilder();
            }
            return this.memo_ == null ? Memo.getDefaultInstance() : this.memo_;
        }

        private SingleFieldBuilderV3<Memo, Memo.Builder, MemoOrBuilder> getMemoFieldBuilder() {
            if (this.memoBuilder_ == null) {
                this.memoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMemo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.memo_ = null;
            }
            return this.memoBuilder_;
        }

        @Override
        public boolean hasSearchAttributes() {
            return (this.bitField0_ & 0x400) != 0;
        }

        @Override
        public SearchAttributes getSearchAttributes() {
            if (this.searchAttributesBuilder_ == null) {
                return this.searchAttributes_ == null ? SearchAttributes.getDefaultInstance() : this.searchAttributes_;
            }
            return (SearchAttributes)this.searchAttributesBuilder_.getMessage();
        }

        public Builder setSearchAttributes(SearchAttributes value) {
            if (this.searchAttributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.searchAttributes_ = value;
            } else {
                this.searchAttributesBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder setSearchAttributes(SearchAttributes.Builder builderForValue) {
            if (this.searchAttributesBuilder_ == null) {
                this.searchAttributes_ = builderForValue.build();
            } else {
                this.searchAttributesBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder mergeSearchAttributes(SearchAttributes value) {
            if (this.searchAttributesBuilder_ == null) {
                if ((this.bitField0_ & 0x400) != 0 && this.searchAttributes_ != null && this.searchAttributes_ != SearchAttributes.getDefaultInstance()) {
                    this.getSearchAttributesBuilder().mergeFrom(value);
                } else {
                    this.searchAttributes_ = value;
                }
            } else {
                this.searchAttributesBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.searchAttributes_ != null) {
                this.bitField0_ |= 0x400;
                this.onChanged();
            }
            return this;
        }

        public Builder clearSearchAttributes() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.searchAttributes_ = null;
            if (this.searchAttributesBuilder_ != null) {
                this.searchAttributesBuilder_.dispose();
                this.searchAttributesBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public SearchAttributes.Builder getSearchAttributesBuilder() {
            this.bitField0_ |= 0x400;
            this.onChanged();
            return (SearchAttributes.Builder)this.getSearchAttributesFieldBuilder().getBuilder();
        }

        @Override
        public SearchAttributesOrBuilder getSearchAttributesOrBuilder() {
            if (this.searchAttributesBuilder_ != null) {
                return (SearchAttributesOrBuilder)this.searchAttributesBuilder_.getMessageOrBuilder();
            }
            return this.searchAttributes_ == null ? SearchAttributes.getDefaultInstance() : this.searchAttributes_;
        }

        private SingleFieldBuilderV3<SearchAttributes, SearchAttributes.Builder, SearchAttributesOrBuilder> getSearchAttributesFieldBuilder() {
            if (this.searchAttributesBuilder_ == null) {
                this.searchAttributesBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getSearchAttributes(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.searchAttributes_ = null;
            }
            return this.searchAttributesBuilder_;
        }

        @Override
        public boolean hasAutoResetPoints() {
            return (this.bitField0_ & 0x800) != 0;
        }

        @Override
        public ResetPoints getAutoResetPoints() {
            if (this.autoResetPointsBuilder_ == null) {
                return this.autoResetPoints_ == null ? ResetPoints.getDefaultInstance() : this.autoResetPoints_;
            }
            return (ResetPoints)this.autoResetPointsBuilder_.getMessage();
        }

        public Builder setAutoResetPoints(ResetPoints value) {
            if (this.autoResetPointsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.autoResetPoints_ = value;
            } else {
                this.autoResetPointsBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder setAutoResetPoints(ResetPoints.Builder builderForValue) {
            if (this.autoResetPointsBuilder_ == null) {
                this.autoResetPoints_ = builderForValue.build();
            } else {
                this.autoResetPointsBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder mergeAutoResetPoints(ResetPoints value) {
            if (this.autoResetPointsBuilder_ == null) {
                if ((this.bitField0_ & 0x800) != 0 && this.autoResetPoints_ != null && this.autoResetPoints_ != ResetPoints.getDefaultInstance()) {
                    this.getAutoResetPointsBuilder().mergeFrom(value);
                } else {
                    this.autoResetPoints_ = value;
                }
            } else {
                this.autoResetPointsBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.autoResetPoints_ != null) {
                this.bitField0_ |= 0x800;
                this.onChanged();
            }
            return this;
        }

        public Builder clearAutoResetPoints() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.autoResetPoints_ = null;
            if (this.autoResetPointsBuilder_ != null) {
                this.autoResetPointsBuilder_.dispose();
                this.autoResetPointsBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public ResetPoints.Builder getAutoResetPointsBuilder() {
            this.bitField0_ |= 0x800;
            this.onChanged();
            return (ResetPoints.Builder)this.getAutoResetPointsFieldBuilder().getBuilder();
        }

        @Override
        public ResetPointsOrBuilder getAutoResetPointsOrBuilder() {
            if (this.autoResetPointsBuilder_ != null) {
                return (ResetPointsOrBuilder)this.autoResetPointsBuilder_.getMessageOrBuilder();
            }
            return this.autoResetPoints_ == null ? ResetPoints.getDefaultInstance() : this.autoResetPoints_;
        }

        private SingleFieldBuilderV3<ResetPoints, ResetPoints.Builder, ResetPointsOrBuilder> getAutoResetPointsFieldBuilder() {
            if (this.autoResetPointsBuilder_ == null) {
                this.autoResetPointsBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getAutoResetPoints(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.autoResetPoints_ = null;
            }
            return this.autoResetPointsBuilder_;
        }

        @Override
        public String getTaskQueue() {
            Object ref = this.taskQueue_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.taskQueue_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getTaskQueueBytes() {
            Object ref = this.taskQueue_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.taskQueue_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setTaskQueue(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.taskQueue_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        public Builder clearTaskQueue() {
            this.taskQueue_ = WorkflowExecutionInfo.getDefaultInstance().getTaskQueue();
            this.bitField0_ &= 0xFFFFEFFF;
            this.onChanged();
            return this;
        }

        public Builder setTaskQueueBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowExecutionInfo.checkByteStringIsUtf8((ByteString)value);
            this.taskQueue_ = value;
            this.bitField0_ |= 0x1000;
            this.onChanged();
            return this;
        }

        @Override
        public long getStateTransitionCount() {
            return this.stateTransitionCount_;
        }

        public Builder setStateTransitionCount(long value) {
            this.stateTransitionCount_ = value;
            this.bitField0_ |= 0x2000;
            this.onChanged();
            return this;
        }

        public Builder clearStateTransitionCount() {
            this.bitField0_ &= 0xFFFFDFFF;
            this.stateTransitionCount_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public long getHistorySizeBytes() {
            return this.historySizeBytes_;
        }

        public Builder setHistorySizeBytes(long value) {
            this.historySizeBytes_ = value;
            this.bitField0_ |= 0x4000;
            this.onChanged();
            return this;
        }

        public Builder clearHistorySizeBytes() {
            this.bitField0_ &= 0xFFFFBFFF;
            this.historySizeBytes_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasMostRecentWorkerVersionStamp() {
            return (this.bitField0_ & 0x8000) != 0;
        }

        @Override
        public WorkerVersionStamp getMostRecentWorkerVersionStamp() {
            if (this.mostRecentWorkerVersionStampBuilder_ == null) {
                return this.mostRecentWorkerVersionStamp_ == null ? WorkerVersionStamp.getDefaultInstance() : this.mostRecentWorkerVersionStamp_;
            }
            return (WorkerVersionStamp)this.mostRecentWorkerVersionStampBuilder_.getMessage();
        }

        public Builder setMostRecentWorkerVersionStamp(WorkerVersionStamp value) {
            if (this.mostRecentWorkerVersionStampBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.mostRecentWorkerVersionStamp_ = value;
            } else {
                this.mostRecentWorkerVersionStampBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder setMostRecentWorkerVersionStamp(WorkerVersionStamp.Builder builderForValue) {
            if (this.mostRecentWorkerVersionStampBuilder_ == null) {
                this.mostRecentWorkerVersionStamp_ = builderForValue.build();
            } else {
                this.mostRecentWorkerVersionStampBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return this;
        }

        public Builder mergeMostRecentWorkerVersionStamp(WorkerVersionStamp value) {
            if (this.mostRecentWorkerVersionStampBuilder_ == null) {
                if ((this.bitField0_ & 0x8000) != 0 && this.mostRecentWorkerVersionStamp_ != null && this.mostRecentWorkerVersionStamp_ != WorkerVersionStamp.getDefaultInstance()) {
                    this.getMostRecentWorkerVersionStampBuilder().mergeFrom(value);
                } else {
                    this.mostRecentWorkerVersionStamp_ = value;
                }
            } else {
                this.mostRecentWorkerVersionStampBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.mostRecentWorkerVersionStamp_ != null) {
                this.bitField0_ |= 0x8000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearMostRecentWorkerVersionStamp() {
            this.bitField0_ &= 0xFFFF7FFF;
            this.mostRecentWorkerVersionStamp_ = null;
            if (this.mostRecentWorkerVersionStampBuilder_ != null) {
                this.mostRecentWorkerVersionStampBuilder_.dispose();
                this.mostRecentWorkerVersionStampBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkerVersionStamp.Builder getMostRecentWorkerVersionStampBuilder() {
            this.bitField0_ |= 0x8000;
            this.onChanged();
            return (WorkerVersionStamp.Builder)this.getMostRecentWorkerVersionStampFieldBuilder().getBuilder();
        }

        @Override
        public WorkerVersionStampOrBuilder getMostRecentWorkerVersionStampOrBuilder() {
            if (this.mostRecentWorkerVersionStampBuilder_ != null) {
                return (WorkerVersionStampOrBuilder)this.mostRecentWorkerVersionStampBuilder_.getMessageOrBuilder();
            }
            return this.mostRecentWorkerVersionStamp_ == null ? WorkerVersionStamp.getDefaultInstance() : this.mostRecentWorkerVersionStamp_;
        }

        private SingleFieldBuilderV3<WorkerVersionStamp, WorkerVersionStamp.Builder, WorkerVersionStampOrBuilder> getMostRecentWorkerVersionStampFieldBuilder() {
            if (this.mostRecentWorkerVersionStampBuilder_ == null) {
                this.mostRecentWorkerVersionStampBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getMostRecentWorkerVersionStamp(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.mostRecentWorkerVersionStamp_ = null;
            }
            return this.mostRecentWorkerVersionStampBuilder_;
        }

        @Override
        public boolean hasExecutionDuration() {
            return (this.bitField0_ & 0x10000) != 0;
        }

        @Override
        public Duration getExecutionDuration() {
            if (this.executionDurationBuilder_ == null) {
                return this.executionDuration_ == null ? Duration.getDefaultInstance() : this.executionDuration_;
            }
            return (Duration)this.executionDurationBuilder_.getMessage();
        }

        public Builder setExecutionDuration(Duration value) {
            if (this.executionDurationBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.executionDuration_ = value;
            } else {
                this.executionDurationBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder setExecutionDuration(Duration.Builder builderForValue) {
            if (this.executionDurationBuilder_ == null) {
                this.executionDuration_ = builderForValue.build();
            } else {
                this.executionDurationBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return this;
        }

        public Builder mergeExecutionDuration(Duration value) {
            if (this.executionDurationBuilder_ == null) {
                if ((this.bitField0_ & 0x10000) != 0 && this.executionDuration_ != null && this.executionDuration_ != Duration.getDefaultInstance()) {
                    this.getExecutionDurationBuilder().mergeFrom(value);
                } else {
                    this.executionDuration_ = value;
                }
            } else {
                this.executionDurationBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.executionDuration_ != null) {
                this.bitField0_ |= 0x10000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearExecutionDuration() {
            this.bitField0_ &= 0xFFFEFFFF;
            this.executionDuration_ = null;
            if (this.executionDurationBuilder_ != null) {
                this.executionDurationBuilder_.dispose();
                this.executionDurationBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Duration.Builder getExecutionDurationBuilder() {
            this.bitField0_ |= 0x10000;
            this.onChanged();
            return (Duration.Builder)this.getExecutionDurationFieldBuilder().getBuilder();
        }

        @Override
        public DurationOrBuilder getExecutionDurationOrBuilder() {
            if (this.executionDurationBuilder_ != null) {
                return (DurationOrBuilder)this.executionDurationBuilder_.getMessageOrBuilder();
            }
            return this.executionDuration_ == null ? Duration.getDefaultInstance() : this.executionDuration_;
        }

        private SingleFieldBuilderV3<Duration, Duration.Builder, DurationOrBuilder> getExecutionDurationFieldBuilder() {
            if (this.executionDurationBuilder_ == null) {
                this.executionDurationBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getExecutionDuration(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.executionDuration_ = null;
            }
            return this.executionDurationBuilder_;
        }

        @Override
        public boolean hasRootExecution() {
            return (this.bitField0_ & 0x20000) != 0;
        }

        @Override
        public WorkflowExecution getRootExecution() {
            if (this.rootExecutionBuilder_ == null) {
                return this.rootExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.rootExecution_;
            }
            return (WorkflowExecution)this.rootExecutionBuilder_.getMessage();
        }

        public Builder setRootExecution(WorkflowExecution value) {
            if (this.rootExecutionBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.rootExecution_ = value;
            } else {
                this.rootExecutionBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder setRootExecution(WorkflowExecution.Builder builderForValue) {
            if (this.rootExecutionBuilder_ == null) {
                this.rootExecution_ = builderForValue.build();
            } else {
                this.rootExecutionBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return this;
        }

        public Builder mergeRootExecution(WorkflowExecution value) {
            if (this.rootExecutionBuilder_ == null) {
                if ((this.bitField0_ & 0x20000) != 0 && this.rootExecution_ != null && this.rootExecution_ != WorkflowExecution.getDefaultInstance()) {
                    this.getRootExecutionBuilder().mergeFrom(value);
                } else {
                    this.rootExecution_ = value;
                }
            } else {
                this.rootExecutionBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.rootExecution_ != null) {
                this.bitField0_ |= 0x20000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRootExecution() {
            this.bitField0_ &= 0xFFFDFFFF;
            this.rootExecution_ = null;
            if (this.rootExecutionBuilder_ != null) {
                this.rootExecutionBuilder_.dispose();
                this.rootExecutionBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkflowExecution.Builder getRootExecutionBuilder() {
            this.bitField0_ |= 0x20000;
            this.onChanged();
            return (WorkflowExecution.Builder)this.getRootExecutionFieldBuilder().getBuilder();
        }

        @Override
        public WorkflowExecutionOrBuilder getRootExecutionOrBuilder() {
            if (this.rootExecutionBuilder_ != null) {
                return (WorkflowExecutionOrBuilder)this.rootExecutionBuilder_.getMessageOrBuilder();
            }
            return this.rootExecution_ == null ? WorkflowExecution.getDefaultInstance() : this.rootExecution_;
        }

        private SingleFieldBuilderV3<WorkflowExecution, WorkflowExecution.Builder, WorkflowExecutionOrBuilder> getRootExecutionFieldBuilder() {
            if (this.rootExecutionBuilder_ == null) {
                this.rootExecutionBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRootExecution(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.rootExecution_ = null;
            }
            return this.rootExecutionBuilder_;
        }

        @Override
        @Deprecated
        public String getAssignedBuildId() {
            Object ref = this.assignedBuildId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.assignedBuildId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        @Deprecated
        public ByteString getAssignedBuildIdBytes() {
            Object ref = this.assignedBuildId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.assignedBuildId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Deprecated
        public Builder setAssignedBuildId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.assignedBuildId_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearAssignedBuildId() {
            this.assignedBuildId_ = WorkflowExecutionInfo.getDefaultInstance().getAssignedBuildId();
            this.bitField0_ &= 0xFFFBFFFF;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder setAssignedBuildIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowExecutionInfo.checkByteStringIsUtf8((ByteString)value);
            this.assignedBuildId_ = value;
            this.bitField0_ |= 0x40000;
            this.onChanged();
            return this;
        }

        @Override
        @Deprecated
        public String getInheritedBuildId() {
            Object ref = this.inheritedBuildId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.inheritedBuildId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        @Deprecated
        public ByteString getInheritedBuildIdBytes() {
            Object ref = this.inheritedBuildId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.inheritedBuildId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Deprecated
        public Builder setInheritedBuildId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.inheritedBuildId_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder clearInheritedBuildId() {
            this.inheritedBuildId_ = WorkflowExecutionInfo.getDefaultInstance().getInheritedBuildId();
            this.bitField0_ &= 0xFFF7FFFF;
            this.onChanged();
            return this;
        }

        @Deprecated
        public Builder setInheritedBuildIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowExecutionInfo.checkByteStringIsUtf8((ByteString)value);
            this.inheritedBuildId_ = value;
            this.bitField0_ |= 0x80000;
            this.onChanged();
            return this;
        }

        @Override
        public String getFirstRunId() {
            Object ref = this.firstRunId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.firstRunId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getFirstRunIdBytes() {
            Object ref = this.firstRunId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.firstRunId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setFirstRunId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.firstRunId_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        public Builder clearFirstRunId() {
            this.firstRunId_ = WorkflowExecutionInfo.getDefaultInstance().getFirstRunId();
            this.bitField0_ &= 0xFFEFFFFF;
            this.onChanged();
            return this;
        }

        public Builder setFirstRunIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowExecutionInfo.checkByteStringIsUtf8((ByteString)value);
            this.firstRunId_ = value;
            this.bitField0_ |= 0x100000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasVersioningInfo() {
            return (this.bitField0_ & 0x200000) != 0;
        }

        @Override
        public WorkflowExecutionVersioningInfo getVersioningInfo() {
            if (this.versioningInfoBuilder_ == null) {
                return this.versioningInfo_ == null ? WorkflowExecutionVersioningInfo.getDefaultInstance() : this.versioningInfo_;
            }
            return (WorkflowExecutionVersioningInfo)this.versioningInfoBuilder_.getMessage();
        }

        public Builder setVersioningInfo(WorkflowExecutionVersioningInfo value) {
            if (this.versioningInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.versioningInfo_ = value;
            } else {
                this.versioningInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder setVersioningInfo(WorkflowExecutionVersioningInfo.Builder builderForValue) {
            if (this.versioningInfoBuilder_ == null) {
                this.versioningInfo_ = builderForValue.build();
            } else {
                this.versioningInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return this;
        }

        public Builder mergeVersioningInfo(WorkflowExecutionVersioningInfo value) {
            if (this.versioningInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x200000) != 0 && this.versioningInfo_ != null && this.versioningInfo_ != WorkflowExecutionVersioningInfo.getDefaultInstance()) {
                    this.getVersioningInfoBuilder().mergeFrom(value);
                } else {
                    this.versioningInfo_ = value;
                }
            } else {
                this.versioningInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.versioningInfo_ != null) {
                this.bitField0_ |= 0x200000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearVersioningInfo() {
            this.bitField0_ &= 0xFFDFFFFF;
            this.versioningInfo_ = null;
            if (this.versioningInfoBuilder_ != null) {
                this.versioningInfoBuilder_.dispose();
                this.versioningInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public WorkflowExecutionVersioningInfo.Builder getVersioningInfoBuilder() {
            this.bitField0_ |= 0x200000;
            this.onChanged();
            return (WorkflowExecutionVersioningInfo.Builder)this.getVersioningInfoFieldBuilder().getBuilder();
        }

        @Override
        public WorkflowExecutionVersioningInfoOrBuilder getVersioningInfoOrBuilder() {
            if (this.versioningInfoBuilder_ != null) {
                return (WorkflowExecutionVersioningInfoOrBuilder)this.versioningInfoBuilder_.getMessageOrBuilder();
            }
            return this.versioningInfo_ == null ? WorkflowExecutionVersioningInfo.getDefaultInstance() : this.versioningInfo_;
        }

        private SingleFieldBuilderV3<WorkflowExecutionVersioningInfo, WorkflowExecutionVersioningInfo.Builder, WorkflowExecutionVersioningInfoOrBuilder> getVersioningInfoFieldBuilder() {
            if (this.versioningInfoBuilder_ == null) {
                this.versioningInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getVersioningInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.versioningInfo_ = null;
            }
            return this.versioningInfoBuilder_;
        }

        @Override
        public String getWorkerDeploymentName() {
            Object ref = this.workerDeploymentName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.workerDeploymentName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getWorkerDeploymentNameBytes() {
            Object ref = this.workerDeploymentName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.workerDeploymentName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setWorkerDeploymentName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.workerDeploymentName_ = value;
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        public Builder clearWorkerDeploymentName() {
            this.workerDeploymentName_ = WorkflowExecutionInfo.getDefaultInstance().getWorkerDeploymentName();
            this.bitField0_ &= 0xFFBFFFFF;
            this.onChanged();
            return this;
        }

        public Builder setWorkerDeploymentNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            WorkflowExecutionInfo.checkByteStringIsUtf8((ByteString)value);
            this.workerDeploymentName_ = value;
            this.bitField0_ |= 0x400000;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPriority() {
            return (this.bitField0_ & 0x800000) != 0;
        }

        @Override
        public Priority getPriority() {
            if (this.priorityBuilder_ == null) {
                return this.priority_ == null ? Priority.getDefaultInstance() : this.priority_;
            }
            return (Priority)this.priorityBuilder_.getMessage();
        }

        public Builder setPriority(Priority value) {
            if (this.priorityBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.priority_ = value;
            } else {
                this.priorityBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder setPriority(Priority.Builder builderForValue) {
            if (this.priorityBuilder_ == null) {
                this.priority_ = builderForValue.build();
            } else {
                this.priorityBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return this;
        }

        public Builder mergePriority(Priority value) {
            if (this.priorityBuilder_ == null) {
                if ((this.bitField0_ & 0x800000) != 0 && this.priority_ != null && this.priority_ != Priority.getDefaultInstance()) {
                    this.getPriorityBuilder().mergeFrom(value);
                } else {
                    this.priority_ = value;
                }
            } else {
                this.priorityBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.priority_ != null) {
                this.bitField0_ |= 0x800000;
                this.onChanged();
            }
            return this;
        }

        public Builder clearPriority() {
            this.bitField0_ &= 0xFF7FFFFF;
            this.priority_ = null;
            if (this.priorityBuilder_ != null) {
                this.priorityBuilder_.dispose();
                this.priorityBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Priority.Builder getPriorityBuilder() {
            this.bitField0_ |= 0x800000;
            this.onChanged();
            return (Priority.Builder)this.getPriorityFieldBuilder().getBuilder();
        }

        @Override
        public PriorityOrBuilder getPriorityOrBuilder() {
            if (this.priorityBuilder_ != null) {
                return (PriorityOrBuilder)this.priorityBuilder_.getMessageOrBuilder();
            }
            return this.priority_ == null ? Priority.getDefaultInstance() : this.priority_;
        }

        private SingleFieldBuilderV3<Priority, Priority.Builder, PriorityOrBuilder> getPriorityFieldBuilder() {
            if (this.priorityBuilder_ == null) {
                this.priorityBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getPriority(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.priority_ = null;
            }
            return this.priorityBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

