// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: temporal/api/common/v1/message.proto

// Protobuf Java Version: 3.25.5
package io.temporal.api.common.v1;

/**
 * <pre>
 * Priority contains metadata that controls relative ordering of task processing
 * when tasks are backed up in a queue. Initially, Priority will be used in
 * matching (workflow and activity) task queues. Later it may be used in history
 * task queues and in rate limiting decisions.
 *
 * Priority is attached to workflows and activities. By default, activities
 * inherit Priority from the workflow that created them, but may override fields
 * when an activity is started or modified.
 *
 * Despite being named "Priority", this message also contains fields that
 * control "fairness" mechanisms.
 *
 * For all fields, the field not present or equal to zero/empty string means to
 * inherit the value from the calling workflow, or if there is no calling
 * workflow, then use the default value.
 *
 * For all fields other than fairness_key, the zero value isn't meaningful so
 * there's no confusion between inherit/default and a meaningful value. For
 * fairness_key, the empty string will be interpreted as "inherit". This means
 * that if a workflow has a non-empty fairness key, you can't override the
 * fairness key of its activity to the empty string.
 *
 * The overall semantics of Priority are:
 * 1. First, consider "priority": higher priority (lower number) goes first.
 * 2. Then, consider fairness: try to dispatch tasks for different fairness keys
 *    in proportion to their weight.
 *
 * Applications may use any subset of mechanisms that are useful to them and
 * leave the other fields to use default values.
 *
 * Not all queues in the system may support the "full" semantics of all priority
 * fields. (Currently only support in matching task queues is planned.)
 * </pre>
 *
 * Protobuf type {@code temporal.api.common.v1.Priority}
 */
@javax.annotation.Generated(value="protoc", comments="annotations:Priority.java.pb.meta")
public final class Priority extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:temporal.api.common.v1.Priority)
    PriorityOrBuilder {
private static final long serialVersionUID = 0L;
  // Use Priority.newBuilder() to construct.
  private Priority(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private Priority() {
    fairnessKey_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new Priority();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.temporal.api.common.v1.MessageProto.internal_static_temporal_api_common_v1_Priority_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.temporal.api.common.v1.MessageProto.internal_static_temporal_api_common_v1_Priority_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.temporal.api.common.v1.Priority.class, io.temporal.api.common.v1.Priority.Builder.class);
  }

  public static final int PRIORITY_KEY_FIELD_NUMBER = 1;
  private int priorityKey_ = 0;
  /**
   * <pre>
   * Priority key is a positive integer from 1 to n, where smaller integers
   * correspond to higher priorities (tasks run sooner). In general, tasks in
   * a queue should be processed in close to priority order, although small
   * deviations are possible.
   *
   * The maximum priority value (minimum priority) is determined by server
   * configuration, and defaults to 5.
   *
   * If priority is not present (or zero), then the effective priority will be
   * the default priority, which is calculated by (min+max)/2. With the
   * default max of 5, and min of 1, that comes out to 3.
   * </pre>
   *
   * <code>int32 priority_key = 1;</code>
   * @return The priorityKey.
   */
  @java.lang.Override
  public int getPriorityKey() {
    return priorityKey_;
  }

  public static final int FAIRNESS_KEY_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object fairnessKey_ = "";
  /**
   * <pre>
   * Fairness key is a short string that's used as a key for a fairness
   * balancing mechanism. It may correspond to a tenant id, or to a fixed
   * string like "high" or "low". The default is the empty string.
   *
   * The fairness mechanism attempts to dispatch tasks for a given key in
   * proportion to its weight. For example, using a thousand distinct tenant
   * ids, each with a weight of 1.0 (the default) will result in each tenant
   * getting a roughly equal share of task dispatch throughput.
   *
   * (Note: this does not imply equal share of worker capacity! Fairness
   * decisions are made based on queue statistics, not
   * current worker load.)
   *
   * As another example, using keys "high" and "low" with weight 9.0 and 1.0
   * respectively will prefer dispatching "high" tasks over "low" tasks at a
   * 9:1 ratio, while allowing either key to use all worker capacity if the
   * other is not present.
   *
   * All fairness mechanisms, including rate limits, are best-effort and
   * probabilistic. The results may not match what a "perfect" algorithm with
   * infinite resources would produce. The more unique keys are used, the less
   * accurate the results will be.
   *
   * Fairness keys are limited to 64 bytes.
   * </pre>
   *
   * <code>string fairness_key = 2;</code>
   * @return The fairnessKey.
   */
  @java.lang.Override
  public java.lang.String getFairnessKey() {
    java.lang.Object ref = fairnessKey_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      fairnessKey_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Fairness key is a short string that's used as a key for a fairness
   * balancing mechanism. It may correspond to a tenant id, or to a fixed
   * string like "high" or "low". The default is the empty string.
   *
   * The fairness mechanism attempts to dispatch tasks for a given key in
   * proportion to its weight. For example, using a thousand distinct tenant
   * ids, each with a weight of 1.0 (the default) will result in each tenant
   * getting a roughly equal share of task dispatch throughput.
   *
   * (Note: this does not imply equal share of worker capacity! Fairness
   * decisions are made based on queue statistics, not
   * current worker load.)
   *
   * As another example, using keys "high" and "low" with weight 9.0 and 1.0
   * respectively will prefer dispatching "high" tasks over "low" tasks at a
   * 9:1 ratio, while allowing either key to use all worker capacity if the
   * other is not present.
   *
   * All fairness mechanisms, including rate limits, are best-effort and
   * probabilistic. The results may not match what a "perfect" algorithm with
   * infinite resources would produce. The more unique keys are used, the less
   * accurate the results will be.
   *
   * Fairness keys are limited to 64 bytes.
   * </pre>
   *
   * <code>string fairness_key = 2;</code>
   * @return The bytes for fairnessKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getFairnessKeyBytes() {
    java.lang.Object ref = fairnessKey_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      fairnessKey_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FAIRNESS_WEIGHT_FIELD_NUMBER = 3;
  private float fairnessWeight_ = 0F;
  /**
   * <pre>
   * Fairness weight for a task can come from multiple sources for
   * flexibility. From highest to lowest precedence:
   * 1. Weights for a small set of keys can be overridden in task queue
   *    configuration with an API.
   * 2. It can be attached to the workflow/activity in this field.
   * 3. The default weight of 1.0 will be used.
   *
   * Weight values are clamped to the range [0.001, 1000].
   * </pre>
   *
   * <code>float fairness_weight = 3;</code>
   * @return The fairnessWeight.
   */
  @java.lang.Override
  public float getFairnessWeight() {
    return fairnessWeight_;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (priorityKey_ != 0) {
      output.writeInt32(1, priorityKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fairnessKey_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, fairnessKey_);
    }
    if (java.lang.Float.floatToRawIntBits(fairnessWeight_) != 0) {
      output.writeFloat(3, fairnessWeight_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (priorityKey_ != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt32Size(1, priorityKey_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(fairnessKey_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, fairnessKey_);
    }
    if (java.lang.Float.floatToRawIntBits(fairnessWeight_) != 0) {
      size += com.google.protobuf.CodedOutputStream
        .computeFloatSize(3, fairnessWeight_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.temporal.api.common.v1.Priority)) {
      return super.equals(obj);
    }
    io.temporal.api.common.v1.Priority other = (io.temporal.api.common.v1.Priority) obj;

    if (getPriorityKey()
        != other.getPriorityKey()) return false;
    if (!getFairnessKey()
        .equals(other.getFairnessKey())) return false;
    if (java.lang.Float.floatToIntBits(getFairnessWeight())
        != java.lang.Float.floatToIntBits(
            other.getFairnessWeight())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PRIORITY_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getPriorityKey();
    hash = (37 * hash) + FAIRNESS_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getFairnessKey().hashCode();
    hash = (37 * hash) + FAIRNESS_WEIGHT_FIELD_NUMBER;
    hash = (53 * hash) + java.lang.Float.floatToIntBits(
        getFairnessWeight());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.temporal.api.common.v1.Priority parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.temporal.api.common.v1.Priority parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.temporal.api.common.v1.Priority parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static io.temporal.api.common.v1.Priority parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.temporal.api.common.v1.Priority prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Priority contains metadata that controls relative ordering of task processing
   * when tasks are backed up in a queue. Initially, Priority will be used in
   * matching (workflow and activity) task queues. Later it may be used in history
   * task queues and in rate limiting decisions.
   *
   * Priority is attached to workflows and activities. By default, activities
   * inherit Priority from the workflow that created them, but may override fields
   * when an activity is started or modified.
   *
   * Despite being named "Priority", this message also contains fields that
   * control "fairness" mechanisms.
   *
   * For all fields, the field not present or equal to zero/empty string means to
   * inherit the value from the calling workflow, or if there is no calling
   * workflow, then use the default value.
   *
   * For all fields other than fairness_key, the zero value isn't meaningful so
   * there's no confusion between inherit/default and a meaningful value. For
   * fairness_key, the empty string will be interpreted as "inherit". This means
   * that if a workflow has a non-empty fairness key, you can't override the
   * fairness key of its activity to the empty string.
   *
   * The overall semantics of Priority are:
   * 1. First, consider "priority": higher priority (lower number) goes first.
   * 2. Then, consider fairness: try to dispatch tasks for different fairness keys
   *    in proportion to their weight.
   *
   * Applications may use any subset of mechanisms that are useful to them and
   * leave the other fields to use default values.
   *
   * Not all queues in the system may support the "full" semantics of all priority
   * fields. (Currently only support in matching task queues is planned.)
   * </pre>
   *
   * Protobuf type {@code temporal.api.common.v1.Priority}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:temporal.api.common.v1.Priority)
      io.temporal.api.common.v1.PriorityOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.temporal.api.common.v1.MessageProto.internal_static_temporal_api_common_v1_Priority_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.temporal.api.common.v1.MessageProto.internal_static_temporal_api_common_v1_Priority_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.temporal.api.common.v1.Priority.class, io.temporal.api.common.v1.Priority.Builder.class);
    }

    // Construct using io.temporal.api.common.v1.Priority.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      priorityKey_ = 0;
      fairnessKey_ = "";
      fairnessWeight_ = 0F;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.temporal.api.common.v1.MessageProto.internal_static_temporal_api_common_v1_Priority_descriptor;
    }

    @java.lang.Override
    public io.temporal.api.common.v1.Priority getDefaultInstanceForType() {
      return io.temporal.api.common.v1.Priority.getDefaultInstance();
    }

    @java.lang.Override
    public io.temporal.api.common.v1.Priority build() {
      io.temporal.api.common.v1.Priority result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.temporal.api.common.v1.Priority buildPartial() {
      io.temporal.api.common.v1.Priority result = new io.temporal.api.common.v1.Priority(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(io.temporal.api.common.v1.Priority result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.priorityKey_ = priorityKey_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.fairnessKey_ = fairnessKey_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.fairnessWeight_ = fairnessWeight_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.temporal.api.common.v1.Priority) {
        return mergeFrom((io.temporal.api.common.v1.Priority)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.temporal.api.common.v1.Priority other) {
      if (other == io.temporal.api.common.v1.Priority.getDefaultInstance()) return this;
      if (other.getPriorityKey() != 0) {
        setPriorityKey(other.getPriorityKey());
      }
      if (!other.getFairnessKey().isEmpty()) {
        fairnessKey_ = other.fairnessKey_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getFairnessWeight() != 0F) {
        setFairnessWeight(other.getFairnessWeight());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8: {
              priorityKey_ = input.readInt32();
              bitField0_ |= 0x00000001;
              break;
            } // case 8
            case 18: {
              fairnessKey_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 29: {
              fairnessWeight_ = input.readFloat();
              bitField0_ |= 0x00000004;
              break;
            } // case 29
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private int priorityKey_ ;
    /**
     * <pre>
     * Priority key is a positive integer from 1 to n, where smaller integers
     * correspond to higher priorities (tasks run sooner). In general, tasks in
     * a queue should be processed in close to priority order, although small
     * deviations are possible.
     *
     * The maximum priority value (minimum priority) is determined by server
     * configuration, and defaults to 5.
     *
     * If priority is not present (or zero), then the effective priority will be
     * the default priority, which is calculated by (min+max)/2. With the
     * default max of 5, and min of 1, that comes out to 3.
     * </pre>
     *
     * <code>int32 priority_key = 1;</code>
     * @return The priorityKey.
     */
    @java.lang.Override
    public int getPriorityKey() {
      return priorityKey_;
    }
    /**
     * <pre>
     * Priority key is a positive integer from 1 to n, where smaller integers
     * correspond to higher priorities (tasks run sooner). In general, tasks in
     * a queue should be processed in close to priority order, although small
     * deviations are possible.
     *
     * The maximum priority value (minimum priority) is determined by server
     * configuration, and defaults to 5.
     *
     * If priority is not present (or zero), then the effective priority will be
     * the default priority, which is calculated by (min+max)/2. With the
     * default max of 5, and min of 1, that comes out to 3.
     * </pre>
     *
     * <code>int32 priority_key = 1;</code>
     * @param value The priorityKey to set.
     * @return This builder for chaining.
     */
    public Builder setPriorityKey(int value) {

      priorityKey_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Priority key is a positive integer from 1 to n, where smaller integers
     * correspond to higher priorities (tasks run sooner). In general, tasks in
     * a queue should be processed in close to priority order, although small
     * deviations are possible.
     *
     * The maximum priority value (minimum priority) is determined by server
     * configuration, and defaults to 5.
     *
     * If priority is not present (or zero), then the effective priority will be
     * the default priority, which is calculated by (min+max)/2. With the
     * default max of 5, and min of 1, that comes out to 3.
     * </pre>
     *
     * <code>int32 priority_key = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearPriorityKey() {
      bitField0_ = (bitField0_ & ~0x00000001);
      priorityKey_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object fairnessKey_ = "";
    /**
     * <pre>
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     *
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     *
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     *
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     *
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     *
     * Fairness keys are limited to 64 bytes.
     * </pre>
     *
     * <code>string fairness_key = 2;</code>
     * @return The fairnessKey.
     */
    public java.lang.String getFairnessKey() {
      java.lang.Object ref = fairnessKey_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        fairnessKey_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     *
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     *
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     *
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     *
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     *
     * Fairness keys are limited to 64 bytes.
     * </pre>
     *
     * <code>string fairness_key = 2;</code>
     * @return The bytes for fairnessKey.
     */
    public com.google.protobuf.ByteString
        getFairnessKeyBytes() {
      java.lang.Object ref = fairnessKey_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        fairnessKey_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     *
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     *
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     *
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     *
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     *
     * Fairness keys are limited to 64 bytes.
     * </pre>
     *
     * <code>string fairness_key = 2;</code>
     * @param value The fairnessKey to set.
     * @return This builder for chaining.
     */
    public Builder setFairnessKey(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      fairnessKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     *
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     *
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     *
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     *
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     *
     * Fairness keys are limited to 64 bytes.
     * </pre>
     *
     * <code>string fairness_key = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearFairnessKey() {
      fairnessKey_ = getDefaultInstance().getFairnessKey();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fairness key is a short string that's used as a key for a fairness
     * balancing mechanism. It may correspond to a tenant id, or to a fixed
     * string like "high" or "low". The default is the empty string.
     *
     * The fairness mechanism attempts to dispatch tasks for a given key in
     * proportion to its weight. For example, using a thousand distinct tenant
     * ids, each with a weight of 1.0 (the default) will result in each tenant
     * getting a roughly equal share of task dispatch throughput.
     *
     * (Note: this does not imply equal share of worker capacity! Fairness
     * decisions are made based on queue statistics, not
     * current worker load.)
     *
     * As another example, using keys "high" and "low" with weight 9.0 and 1.0
     * respectively will prefer dispatching "high" tasks over "low" tasks at a
     * 9:1 ratio, while allowing either key to use all worker capacity if the
     * other is not present.
     *
     * All fairness mechanisms, including rate limits, are best-effort and
     * probabilistic. The results may not match what a "perfect" algorithm with
     * infinite resources would produce. The more unique keys are used, the less
     * accurate the results will be.
     *
     * Fairness keys are limited to 64 bytes.
     * </pre>
     *
     * <code>string fairness_key = 2;</code>
     * @param value The bytes for fairnessKey to set.
     * @return This builder for chaining.
     */
    public Builder setFairnessKeyBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      fairnessKey_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private float fairnessWeight_ ;
    /**
     * <pre>
     * Fairness weight for a task can come from multiple sources for
     * flexibility. From highest to lowest precedence:
     * 1. Weights for a small set of keys can be overridden in task queue
     *    configuration with an API.
     * 2. It can be attached to the workflow/activity in this field.
     * 3. The default weight of 1.0 will be used.
     *
     * Weight values are clamped to the range [0.001, 1000].
     * </pre>
     *
     * <code>float fairness_weight = 3;</code>
     * @return The fairnessWeight.
     */
    @java.lang.Override
    public float getFairnessWeight() {
      return fairnessWeight_;
    }
    /**
     * <pre>
     * Fairness weight for a task can come from multiple sources for
     * flexibility. From highest to lowest precedence:
     * 1. Weights for a small set of keys can be overridden in task queue
     *    configuration with an API.
     * 2. It can be attached to the workflow/activity in this field.
     * 3. The default weight of 1.0 will be used.
     *
     * Weight values are clamped to the range [0.001, 1000].
     * </pre>
     *
     * <code>float fairness_weight = 3;</code>
     * @param value The fairnessWeight to set.
     * @return This builder for chaining.
     */
    public Builder setFairnessWeight(float value) {

      fairnessWeight_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fairness weight for a task can come from multiple sources for
     * flexibility. From highest to lowest precedence:
     * 1. Weights for a small set of keys can be overridden in task queue
     *    configuration with an API.
     * 2. It can be attached to the workflow/activity in this field.
     * 3. The default weight of 1.0 will be used.
     *
     * Weight values are clamped to the range [0.001, 1000].
     * </pre>
     *
     * <code>float fairness_weight = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearFairnessWeight() {
      bitField0_ = (bitField0_ & ~0x00000004);
      fairnessWeight_ = 0F;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:temporal.api.common.v1.Priority)
  }

  // @@protoc_insertion_point(class_scope:temporal.api.common.v1.Priority)
  private static final io.temporal.api.common.v1.Priority DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.temporal.api.common.v1.Priority();
  }

  public static io.temporal.api.common.v1.Priority getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Priority>
      PARSER = new com.google.protobuf.AbstractParser<Priority>() {
    @java.lang.Override
    public Priority parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Priority> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Priority> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.temporal.api.common.v1.Priority getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

