/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.testservice;

import io.grpc.BindableService;
import io.temporal.internal.testservice.SelfAdvancingTimerImpl;
import io.temporal.internal.testservice.TestOperatorService;
import io.temporal.internal.testservice.TestService;
import io.temporal.internal.testservice.TestVisibilityStore;
import io.temporal.internal.testservice.TestVisibilityStoreImpl;
import io.temporal.internal.testservice.TestWorkflowService;
import io.temporal.internal.testservice.TestWorkflowStore;
import io.temporal.internal.testservice.TestWorkflowStoreImpl;
import java.io.Closeable;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TestServicesStarter
implements Closeable {
    private final SelfAdvancingTimerImpl selfAdvancingTimer;
    private final TestVisibilityStore visibilityStore = new TestVisibilityStoreImpl();
    private final TestWorkflowStore workflowStore;
    private final TestOperatorService operatorService;
    private final TestWorkflowService workflowService;
    private final TestService testService;
    private final List<BindableService> services;

    public TestServicesStarter(boolean lockTimeSkipping, long initialTimeMillis) {
        this.selfAdvancingTimer = new SelfAdvancingTimerImpl(initialTimeMillis, Clock.systemDefaultZone());
        this.workflowStore = new TestWorkflowStoreImpl(this.selfAdvancingTimer);
        this.operatorService = new TestOperatorService(this.visibilityStore);
        this.testService = new TestService(this.workflowStore, this.selfAdvancingTimer, lockTimeSkipping);
        this.workflowService = new TestWorkflowService(this.workflowStore, this.visibilityStore, this.selfAdvancingTimer);
        this.services = Arrays.asList(this.operatorService, this.testService, this.workflowService);
    }

    @Override
    public void close() {
        this.workflowService.close();
        this.operatorService.close();
        this.testService.close();
        this.visibilityStore.close();
    }

    public TestOperatorService getOperatorService() {
        return this.operatorService;
    }

    public TestWorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public TestService getTestService() {
        return this.testService;
    }

    public List<BindableService> getServices() {
        return Collections.unmodifiableList(this.services);
    }
}

