/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.common.collect.ObjectArrays;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.common.WorkflowExecutionUtils;
import io.temporal.testing.TestWorkflowEnvironment;
import io.temporal.worker.Worker;
import java.io.File;

public final class WorkflowReplayer {
    public static void replayWorkflowExecutionFromResource(String resourceName, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionUtils.readHistoryFromResource((String)resourceName);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(File historyFile, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionUtils.readHistory((File)historyFile);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(String jsonSerializedHistory, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionHistory history = WorkflowExecutionHistory.fromJson((String)jsonSerializedHistory);
        WorkflowReplayer.replayWorkflowExecution(history, workflowClass, moreWorkflowClasses);
    }

    public static void replayWorkflowExecution(WorkflowExecutionHistory history, Class<?> workflowClass, Class<?> ... moreWorkflowClasses) throws Exception {
        WorkflowExecutionStartedEventAttributes attr = ((HistoryEvent)history.getEvents().get(0)).getWorkflowExecutionStartedEventAttributes();
        TaskQueue taskQueue = attr.getTaskQueue();
        TestWorkflowEnvironment testEnv = TestWorkflowEnvironment.newInstance();
        Worker worker = testEnv.newWorker(taskQueue.getName());
        worker.registerWorkflowImplementationTypes((Class[])ObjectArrays.concat((Object[])moreWorkflowClasses, workflowClass));
        worker.replayWorkflowExecution(history);
    }
}

