/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing.internal;

import com.google.protobuf.ByteString;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.taskqueue.v1.StickyExecutionAttributes;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueRequest;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondWorkflowTaskFailedRequest;
import io.temporal.api.workflowservice.v1.SignalWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.StartWorkflowExecutionRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.time.Duration;
import java.util.ArrayList;
import java.util.UUID;

public class TestServiceUtils {
    private TestServiceUtils() {
    }

    public static void startWorkflowExecution(String namespace, String taskqueueName, String workflowType, WorkflowServiceStubs service) throws Exception {
        TestServiceUtils.startWorkflowExecution(namespace, taskqueueName, workflowType, Duration.ofSeconds(100L), Duration.ofSeconds(100L), service);
    }

    public static void startWorkflowExecution(String namespace, String taskqueueName, String workflowType, Duration workflowRunTimeout, Duration workflowTaskTimeout, WorkflowServiceStubs service) throws Exception {
        StartWorkflowExecutionRequest.Builder request = StartWorkflowExecutionRequest.newBuilder();
        request.setRequestId(UUID.randomUUID().toString());
        request.setNamespace(namespace);
        request.setWorkflowId(UUID.randomUUID().toString());
        request.setTaskQueue(InternalUtils.createNormalTaskQueue((String)taskqueueName));
        request.setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration((Duration)workflowRunTimeout));
        request.setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration((Duration)workflowTaskTimeout));
        request.setWorkflowType(WorkflowType.newBuilder().setName(workflowType));
        ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).startWorkflowExecution(request.build());
    }

    public static void respondWorkflowTaskCompletedWithSticky(ByteString taskToken, TaskQueue stickyTaskQueue, WorkflowServiceStubs service) throws Exception {
        TestServiceUtils.respondWorkflowTaskCompletedWithSticky(taskToken, stickyTaskQueue, Duration.ofSeconds(100L), service);
    }

    public static void respondWorkflowTaskCompletedWithSticky(ByteString taskToken, TaskQueue stickyTaskQueue, Duration startToCloseTimeout, WorkflowServiceStubs service) throws Exception {
        RespondWorkflowTaskCompletedRequest.Builder request = RespondWorkflowTaskCompletedRequest.newBuilder();
        StickyExecutionAttributes.Builder attributes = StickyExecutionAttributes.newBuilder();
        attributes.setWorkerTaskQueue(stickyTaskQueue);
        attributes.setScheduleToStartTimeout(ProtobufTimeUtils.toProtoDuration((Duration)startToCloseTimeout));
        request.setStickyAttributes(attributes);
        request.setTaskToken(taskToken);
        request.addAllCommands(new ArrayList());
        ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).respondWorkflowTaskCompleted(request.build());
    }

    public static void respondWorkflowTaskFailedWithSticky(ByteString taskToken, WorkflowServiceStubs service) throws Exception {
        RespondWorkflowTaskFailedRequest request = RespondWorkflowTaskFailedRequest.newBuilder().setTaskToken(taskToken).build();
        ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).respondWorkflowTaskFailed(request);
    }

    public static PollWorkflowTaskQueueResponse pollWorkflowTaskQueue(String namespace, TaskQueue taskqueue, WorkflowServiceStubs service) throws Exception {
        PollWorkflowTaskQueueRequest request = PollWorkflowTaskQueueRequest.newBuilder().setNamespace(namespace).setTaskQueue(taskqueue).build();
        return ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).pollWorkflowTaskQueue(request);
    }

    public static void signalWorkflow(WorkflowExecution workflowExecution, String namespace, WorkflowServiceStubs service) throws Exception {
        SignalWorkflowExecutionRequest signalRequest = SignalWorkflowExecutionRequest.newBuilder().setNamespace(namespace).setSignalName("my-signal").setWorkflowExecution(workflowExecution).build();
        ((WorkflowServiceGrpc.WorkflowServiceBlockingStub)service.blockingStub()).signalWorkflowExecution(signalRequest);
    }
}

