/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.IndexedValueType;
import io.temporal.api.nexus.v1.Endpoint;
import io.temporal.client.WorkflowClient;
import io.temporal.common.WorkflowExecutionHistory;
import io.temporal.serviceclient.OperatorServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.testing.TestWorkflowEnvironmentInternal;
import io.temporal.worker.Worker;
import io.temporal.worker.WorkerFactory;
import io.temporal.worker.WorkerOptions;
import java.io.Closeable;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public interface TestWorkflowEnvironment
extends Closeable {
    public static TestWorkflowEnvironment newInstance() {
        return new TestWorkflowEnvironmentInternal(TestEnvironmentOptions.getDefaultInstance());
    }

    public static TestWorkflowEnvironment newInstance(TestEnvironmentOptions options) {
        return new TestWorkflowEnvironmentInternal(options);
    }

    public Worker newWorker(String var1);

    public Worker newWorker(String var1, WorkerOptions var2);

    public WorkflowClient getWorkflowClient();

    public long currentTimeMillis();

    public void sleep(Duration var1);

    public void registerDelayedCallback(Duration var1, Runnable var2);

    public boolean registerSearchAttribute(String var1, IndexedValueType var2);

    public Endpoint createNexusEndpoint(String var1, String var2);

    public void deleteNexusEndpoint(Endpoint var1);

    @Deprecated
    public WorkflowServiceStubs getWorkflowService();

    public WorkflowServiceStubs getWorkflowServiceStubs();

    public OperatorServiceStubs getOperatorServiceStubs();

    public String getNamespace();

    public String getDiagnostics();

    @Deprecated
    public WorkflowExecutionHistory getWorkflowExecutionHistory(@Nonnull WorkflowExecution var1);

    @Override
    public void close();

    public WorkerFactory getWorkerFactory();

    public void start();

    public boolean isStarted();

    public boolean isShutdown();

    public boolean isTerminated();

    @Deprecated
    public void shutdownTestService();

    public void shutdown();

    public void shutdownNow();

    public void awaitTermination(long var1, TimeUnit var3);
}

