/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.testing;

import com.google.protobuf.ByteString;
import com.uber.m3.tally.NoopScope;
import com.uber.m3.tally.Scope;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.enums.v1.RetryState;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponseOrBuilder;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatRequest;
import io.temporal.api.workflowservice.v1.RecordActivityTaskHeartbeatResponse;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCanceledRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskCompletedRequest;
import io.temporal.api.workflowservice.v1.RespondActivityTaskFailedRequest;
import io.temporal.api.workflowservice.v1.WorkflowServiceGrpc;
import io.temporal.client.WorkflowClient;
import io.temporal.client.WorkflowClientOptions;
import io.temporal.common.SearchAttributeUpdate;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.EncodedValues;
import io.temporal.common.converter.Values;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.ActivityFailure;
import io.temporal.failure.CanceledFailure;
import io.temporal.internal.activity.ActivityExecutionContextFactory;
import io.temporal.internal.activity.ActivityExecutionContextFactoryImpl;
import io.temporal.internal.activity.ActivityTaskHandlerImpl;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.sync.ActivityInvocationHandler;
import io.temporal.internal.sync.ActivityInvocationHandlerBase;
import io.temporal.internal.sync.DeterministicRunnerWrapper;
import io.temporal.internal.sync.LocalActivityInvocationHandler;
import io.temporal.internal.testservice.InProcessGRPCServer;
import io.temporal.internal.worker.ActivityTask;
import io.temporal.internal.worker.ActivityTaskHandler;
import io.temporal.serviceclient.ServiceStubsOptions;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.serviceclient.WorkflowServiceStubsOptions;
import io.temporal.testing.ActivityRequestedAsyncCompletion;
import io.temporal.testing.TestActivityEnvironment;
import io.temporal.testing.TestEnvironmentOptions;
import io.temporal.worker.WorkerOptions;
import io.temporal.workflow.Functions;
import io.temporal.workflow.MutableSideEffectOptions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.SideEffectOptions;
import io.temporal.workflow.TimerOptions;
import io.temporal.workflow.Workflow;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestActivityEnvironmentInternal
implements TestActivityEnvironment {
    private static final Logger log = LoggerFactory.getLogger(TestActivityEnvironmentInternal.class);
    private final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(20);
    private final ExecutorService activityWorkerExecutor = Executors.newSingleThreadExecutor(r -> new Thread(r, "test-service-activity-worker"));
    private final ExecutorService deterministicRunnerExecutor = new ThreadPoolExecutor(1, 1000, 1L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), r -> new Thread(r, "test-service-deterministic-runner"));
    private final AtomicBoolean cancellationRequested = new AtomicBoolean();
    private final AtomicInteger idSequencer = new AtomicInteger();
    private final InProcessGRPCServer mockServer;
    private final ActivityTaskHandlerImpl activityTaskHandler;
    private final TestEnvironmentOptions testEnvironmentOptions;
    private final WorkflowServiceStubs workflowServiceStubs;
    private final AtomicReference<Object> heartbeatDetails = new AtomicReference();
    private ClassConsumerPair<Object> activityHeartbeatListener;

    public TestActivityEnvironmentInternal(@Nullable TestEnvironmentOptions options) {
        this.mockServer = new InProcessGRPCServer(Collections.singletonList(new HeartbeatInterceptingService()));
        this.testEnvironmentOptions = options != null ? TestEnvironmentOptions.newBuilder(options).validateAndBuildWithDefaults() : TestEnvironmentOptions.newBuilder().validateAndBuildWithDefaults();
        WorkflowServiceStubsOptions.Builder serviceStubsOptionsBuilder = ((WorkflowServiceStubsOptions.Builder)((WorkflowServiceStubsOptions.Builder)WorkflowServiceStubsOptions.newBuilder((ServiceStubsOptions)this.testEnvironmentOptions.getWorkflowServiceStubsOptions()).setTarget(null)).setChannel(this.mockServer.getChannel())).setRpcQueryTimeout(Duration.ofSeconds(60L));
        Scope metricsScope = this.testEnvironmentOptions.getMetricsScope();
        if (metricsScope != null && !NoopScope.class.equals(metricsScope.getClass())) {
            serviceStubsOptionsBuilder.setMetricsScope(metricsScope);
        }
        this.workflowServiceStubs = WorkflowServiceStubs.newServiceStubs((WorkflowServiceStubsOptions)serviceStubsOptionsBuilder.build());
        ActivityExecutionContextFactoryImpl activityExecutionContextFactory = new ActivityExecutionContextFactoryImpl(WorkflowClient.newInstance((WorkflowServiceStubs)this.workflowServiceStubs, (WorkflowClientOptions)this.testEnvironmentOptions.getWorkflowClientOptions()), this.testEnvironmentOptions.getWorkflowClientOptions().getIdentity(), this.testEnvironmentOptions.getWorkflowClientOptions().getNamespace(), WorkerOptions.getDefaultInstance().getMaxHeartbeatThrottleInterval(), WorkerOptions.getDefaultInstance().getDefaultHeartbeatThrottleInterval(), this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter(), this.heartbeatExecutor);
        this.activityTaskHandler = new ActivityTaskHandlerImpl(this.testEnvironmentOptions.getWorkflowClientOptions().getNamespace(), "test-activity-env-task-queue", this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter(), (ActivityExecutionContextFactory)activityExecutionContextFactory, this.testEnvironmentOptions.getWorkerFactoryOptions().getWorkerInterceptors(), this.testEnvironmentOptions.getWorkflowClientOptions().getContextPropagators());
    }

    @Override
    public void registerActivitiesImplementations(Object ... activityImplementations) {
        this.activityTaskHandler.registerActivityImplementations(activityImplementations);
    }

    @Override
    public <T> T newActivityStub(Class<T> activityInterface) {
        ActivityOptions options = ActivityOptions.newBuilder().setScheduleToCloseTimeout(Duration.ofDays(1L)).setHeartbeatTimeout(Duration.ofSeconds(1L)).build();
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, (ActivityOptions)options, null, (WorkflowOutboundCallsInterceptor)new TestActivityExecutor(), (Functions.Proc & Serializable)() -> {});
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler, this.deterministicRunnerExecutor::submit);
        return (T)ActivityInvocationHandlerBase.newProxy(activityInterface, (InvocationHandler)invocationHandler);
    }

    @Override
    public <T> T newActivityStub(Class<T> activityInterface, ActivityOptions options) {
        InvocationHandler invocationHandler = ActivityInvocationHandler.newInstance(activityInterface, (ActivityOptions)options, null, (WorkflowOutboundCallsInterceptor)new TestActivityExecutor(), (Functions.Proc & Serializable)() -> {});
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler, this.deterministicRunnerExecutor::submit);
        return (T)ActivityInvocationHandlerBase.newProxy(activityInterface, (InvocationHandler)invocationHandler);
    }

    @Override
    public <T> T newLocalActivityStub(Class<T> activityInterface, LocalActivityOptions options, Map<String, LocalActivityOptions> activityMethodOptions) {
        InvocationHandler invocationHandler = LocalActivityInvocationHandler.newInstance(activityInterface, (LocalActivityOptions)options, activityMethodOptions, (WorkflowOutboundCallsInterceptor)new TestActivityExecutor(), (Functions.Proc & Serializable)() -> {});
        invocationHandler = new DeterministicRunnerWrapper(invocationHandler, this.deterministicRunnerExecutor::submit);
        return (T)ActivityInvocationHandlerBase.newProxy(activityInterface, (InvocationHandler)invocationHandler);
    }

    @Override
    public void requestCancelActivity() {
        this.cancellationRequested.set(true);
    }

    @Override
    public <T> void setActivityHeartbeatListener(Class<T> detailsClass, Functions.Proc1<T> listener) {
        this.setActivityHeartbeatListener(detailsClass, detailsClass, listener);
    }

    @Override
    public <T> void setActivityHeartbeatListener(Class<T> detailsClass, Type detailsType, Functions.Proc1<T> listener) {
        this.activityHeartbeatListener = new ClassConsumerPair<T>(detailsClass, detailsType, listener);
    }

    @Override
    public <T> void setHeartbeatDetails(T details) {
        this.heartbeatDetails.set(details);
    }

    @Override
    public void close() {
        this.heartbeatExecutor.shutdownNow();
        this.activityWorkerExecutor.shutdownNow();
        this.deterministicRunnerExecutor.shutdownNow();
        this.workflowServiceStubs.shutdown();
        this.mockServer.shutdown();
        this.mockServer.awaitTermination(5L, TimeUnit.SECONDS);
    }

    private static class ClassConsumerPair<T> {
        final Functions.Proc1<T> consumer;
        final Class<T> valueClass;
        final Type valueType;

        ClassConsumerPair(Class<T> valueClass, Type valueType, Functions.Proc1<T> consumer) {
            this.valueClass = Objects.requireNonNull(valueClass);
            this.valueType = Objects.requireNonNull(valueType);
            this.consumer = Objects.requireNonNull(consumer);
        }
    }

    private class TestActivityExecutor
    implements WorkflowOutboundCallsInterceptor {
        private TestActivityExecutor() {
        }

        public <T> WorkflowOutboundCallsInterceptor.ActivityOutput<T> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<T> i) {
            Optional payloads = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().toPayloads(i.getArgs());
            Optional heartbeatPayload = Optional.ofNullable(TestActivityEnvironmentInternal.this.heartbeatDetails.getAndSet(null)).flatMap(obj -> TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().toPayloads(new Object[]{obj}));
            ActivityOptions options = i.getOptions();
            PollActivityTaskQueueResponse.Builder taskBuilder = PollActivityTaskQueueResponse.newBuilder().setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getScheduleToCloseTimeout())).setHeartbeatTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getHeartbeatTimeout())).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getStartToCloseTimeout())).setScheduledTime(ProtobufTimeUtils.getCurrentProtoTime()).setStartedTime(ProtobufTimeUtils.getCurrentProtoTime()).setTaskToken(ByteString.copyFrom((byte[])"test-task-token".getBytes(StandardCharsets.UTF_8))).setActivityId(String.valueOf(TestActivityEnvironmentInternal.this.idSequencer.incrementAndGet())).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId("test-workflow-id").setRunId(UUID.randomUUID().toString()).build()).setActivityType(ActivityType.newBuilder().setName(i.getActivityName()).build());
            payloads.ifPresent(arg_0 -> ((PollActivityTaskQueueResponse.Builder)taskBuilder).setInput(arg_0));
            heartbeatPayload.ifPresent(arg_0 -> ((PollActivityTaskQueueResponse.Builder)taskBuilder).setHeartbeatDetails(arg_0));
            PollActivityTaskQueueResponse task = taskBuilder.build();
            return new WorkflowOutboundCallsInterceptor.ActivityOutput(task.getActivityId(), Workflow.newPromise(this.getReply(task, this.executeActivity(task, false), i.getResultClass(), i.getResultType())));
        }

        public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> i) {
            Optional payloads = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().toPayloads(i.getArgs());
            LocalActivityOptions options = i.getOptions();
            PollActivityTaskQueueResponse.Builder taskBuilder = PollActivityTaskQueueResponse.newBuilder().setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getScheduleToCloseTimeout())).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration((Duration)options.getStartToCloseTimeout())).setScheduledTime(ProtobufTimeUtils.getCurrentProtoTime()).setStartedTime(ProtobufTimeUtils.getCurrentProtoTime()).setTaskToken(ByteString.copyFrom((byte[])"test-task-token".getBytes(StandardCharsets.UTF_8))).setActivityId(String.valueOf(TestActivityEnvironmentInternal.this.idSequencer.incrementAndGet())).setWorkflowExecution(WorkflowExecution.newBuilder().setWorkflowId("test-workflow-id").setRunId(UUID.randomUUID().toString()).build()).setActivityType(ActivityType.newBuilder().setName(i.getActivityName()).build());
            payloads.ifPresent(arg_0 -> ((PollActivityTaskQueueResponse.Builder)taskBuilder).setInput(arg_0));
            PollActivityTaskQueueResponse task = taskBuilder.build();
            return new WorkflowOutboundCallsInterceptor.LocalActivityOutput(Workflow.newPromise(this.getReply(task, this.executeActivity(task, true), i.getResultClass(), i.getResultType())));
        }

        private ActivityTaskHandler.Result executeActivity(PollActivityTaskQueueResponse activityTask, boolean localActivity) {
            Future<ActivityTaskHandler.Result> activityFuture = TestActivityEnvironmentInternal.this.activityWorkerExecutor.submit(() -> TestActivityEnvironmentInternal.this.activityTaskHandler.handle(new ActivityTask((PollActivityTaskQueueResponseOrBuilder)activityTask, null, (Functions.Proc & Serializable)() -> {}), TestActivityEnvironmentInternal.this.testEnvironmentOptions.getMetricsScope(), localActivity));
            try {
                return activityFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                log.error("Exception during processing of activity task");
                throw new RuntimeException(e);
            }
        }

        public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput<R> executeNexusOperation(WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R> input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Random newRandom() {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalWorkflow(WorkflowOutboundCallsInterceptor.SignalExternalInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public WorkflowOutboundCallsInterceptor.CancelWorkflowOutput cancelWorkflow(WorkflowOutboundCallsInterceptor.CancelWorkflowInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void sleep(Duration duration) {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void await(String reason, Supplier<Boolean> unblockCondition) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Promise<Void> newTimer(Duration duration) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Promise<Void> newTimer(Duration duration, TimerOptions options) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func, SideEffectOptions options) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
            throw new UnsupportedOperationException("not implemented");
        }

        public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func, MutableSideEffectOptions options) {
            throw new UnsupportedOperationException("not implemented");
        }

        public int getVersion(String changeId, int minSupported, int maxSupported) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void continueAsNew(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerQuery(WorkflowOutboundCallsInterceptor.RegisterQueryInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerSignalHandlers(WorkflowOutboundCallsInterceptor.RegisterSignalHandlersInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerDynamicSignalHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicSignalHandlerInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerDynamicQueryHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicQueryHandlerInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public UUID randomUUID() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void upsertSearchAttributes(Map<String, ?> searchAttributes) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void upsertTypedSearchAttributes(SearchAttributeUpdate<?> ... searchAttributeUpdates) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void upsertMemo(Map<String, Object> memo) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Scope getMetricsScope() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object newChildThread(Runnable runnable, boolean detached, String name) {
            throw new UnsupportedOperationException("not implemented");
        }

        public long currentTimeMillis() {
            throw new UnsupportedOperationException("not implemented");
        }

        private <T> T getReply(PollActivityTaskQueueResponse task, ActivityTaskHandler.Result response, Class<T> resultClass, Type resultType) {
            DataConverter dataConverter = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter();
            if (response.getTaskCompleted() != null) {
                RespondActivityTaskCompletedRequest taskCompleted = response.getTaskCompleted();
                Optional result = taskCompleted.hasResult() ? Optional.of(taskCompleted.getResult()) : Optional.empty();
                return (T)dataConverter.fromPayloads(0, result, resultClass, resultType);
            }
            if (response.getTaskFailed() != null) {
                RespondActivityTaskFailedRequest taskFailed = response.getTaskFailed().getTaskFailedRequest();
                RuntimeException cause = dataConverter.failureToException(taskFailed.getFailure());
                throw new ActivityFailure(taskFailed.getFailure().getMessage(), 0L, 0L, task.getActivityType().getName(), task.getActivityId(), RetryState.RETRY_STATE_NON_RETRYABLE_FAILURE, "TestActivityEnvironment", (Throwable)cause);
            }
            if (response.getTaskCanceled() != null) {
                RespondActivityTaskCanceledRequest taskCanceled = response.getTaskCanceled();
                throw new CanceledFailure("canceled", (Values)new EncodedValues(taskCanceled.hasDetails() ? Optional.of(taskCanceled.getDetails()) : Optional.empty(), dataConverter), null);
            }
            throw new ActivityRequestedAsyncCompletion(task.getActivityId(), response.isManualCompletion());
        }

        public void registerUpdateHandlers(WorkflowOutboundCallsInterceptor.RegisterUpdateHandlersInput input) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void registerDynamicUpdateHandler(WorkflowOutboundCallsInterceptor.RegisterDynamicUpdateHandlerInput input) {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private class HeartbeatInterceptingService
    extends WorkflowServiceGrpc.WorkflowServiceImplBase {
        private HeartbeatInterceptingService() {
        }

        public void recordActivityTaskHeartbeat(RecordActivityTaskHeartbeatRequest request, StreamObserver<RecordActivityTaskHeartbeatResponse> responseObserver) {
            try {
                if (TestActivityEnvironmentInternal.this.activityHeartbeatListener != null) {
                    Optional requestDetails = request.hasDetails() ? Optional.of(request.getDetails()) : Optional.empty();
                    Object details = TestActivityEnvironmentInternal.this.testEnvironmentOptions.getWorkflowClientOptions().getDataConverter().fromPayloads(0, requestDetails, ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbeatListener.valueClass, ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbeatListener.valueType);
                    ((TestActivityEnvironmentInternal)TestActivityEnvironmentInternal.this).activityHeartbeatListener.consumer.apply(details);
                }
                responseObserver.onNext((Object)RecordActivityTaskHeartbeatResponse.newBuilder().setCancelRequested(TestActivityEnvironmentInternal.this.cancellationRequested.get()).build());
                responseObserver.onCompleted();
            }
            catch (StatusRuntimeException e) {
                responseObserver.onError((Throwable)e);
            }
        }
    }
}

