/*
 * Decompiled with CFR 0.152.
 */
package io.tus.java.client;

import io.tus.java.client.TusInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class TusUpload {
    private long size;
    private InputStream input;
    private TusInputStream tusInputStream;
    private String fingerprint;
    private Map<String, String> metadata;

    public TusUpload() {
    }

    public TusUpload(@NotNull File file) throws FileNotFoundException {
        this.size = file.length();
        this.setInputStream(new FileInputStream(file));
        this.fingerprint = String.format("%s-%d", file.getAbsolutePath(), this.size);
        this.metadata = new HashMap<String, String>();
        this.metadata.put("filename", file.getName());
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(String fingerprint) {
        this.fingerprint = fingerprint;
    }

    public InputStream getInputStream() {
        return this.input;
    }

    TusInputStream getTusInputStream() {
        return this.tusInputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.input = inputStream;
        this.tusInputStream = new TusInputStream(inputStream);
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getEncodedMetadata() {
        if (this.metadata == null || this.metadata.size() == 0) {
            return "";
        }
        String encoded = "";
        boolean firstElement = true;
        for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
            if (!firstElement) {
                encoded = encoded + ",";
            }
            encoded = encoded + entry.getKey() + " " + TusUpload.base64Encode(entry.getValue().getBytes());
            firstElement = false;
        }
        return encoded;
    }

    static String base64Encode(byte[] in) {
        StringBuilder out = new StringBuilder(in.length * 4 / 3);
        String codes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
        for (int i = 0; i < in.length; i += 3) {
            int b = (in[i] & 0xFC) >> 2;
            out.append(codes.charAt(b));
            b = (in[i] & 3) << 4;
            if (i + 1 < in.length) {
                out.append(codes.charAt(b |= (in[i + 1] & 0xF0) >> 4));
                b = (in[i + 1] & 0xF) << 2;
                if (i + 2 < in.length) {
                    out.append(codes.charAt(b |= (in[i + 2] & 0xC0) >> 6));
                    b = in[i + 2] & 0x3F;
                    out.append(codes.charAt(b));
                    continue;
                }
                out.append(codes.charAt(b));
                out.append('=');
                continue;
            }
            out.append(codes.charAt(b));
            out.append("==");
        }
        return out.toString();
    }
}

