/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.protocol.http;

import io.undertow.UndertowMessages;
import io.undertow.UndertowOptions;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.protocol.http.ParseState;
import io.undertow.util.Headers;
import io.undertow.util.HttpString;
import io.undertow.util.Methods;
import io.undertow.util.Protocols;
import io.undertow.util.URLUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.xnio.OptionMap;

public abstract class HttpRequestParser {
    private static final byte[] HTTP;
    public static final int HTTP_LENGTH;
    private final int maxParameters;
    private final int maxHeaders;
    private final boolean allowEncodedSlash;
    private final boolean decode;
    private final String charset;
    private static final int START = 0;
    private static final int FIRST_COLON = 1;
    private static final int FIRST_SLASH = 2;
    private static final int SECOND_SLASH = 3;
    private static final int IN_PATH = 4;
    private static final int HOST_DONE = 5;
    private static final int NORMAL = 0;
    private static final int WHITESPACE = 1;
    private static final int BEGIN_LINE_END = 2;
    private static final int LINE_END = 3;
    private static final int AWAIT_DATA_END = 4;

    public HttpRequestParser(OptionMap options) {
        this.maxParameters = options.get(UndertowOptions.MAX_PARAMETERS, 1000);
        this.maxHeaders = options.get(UndertowOptions.MAX_HEADERS, 200);
        this.allowEncodedSlash = options.get(UndertowOptions.ALLOW_ENCODED_SLASH, false);
        this.decode = options.get(UndertowOptions.DECODE_URL, true);
        this.charset = (String)options.get(UndertowOptions.URL_CHARSET, (Object)StandardCharsets.UTF_8.name());
    }

    public static final HttpRequestParser instance(OptionMap options) {
        try {
            Class<?> cls = Class.forName(HttpRequestParser.class.getName() + "$$generated", false, HttpRequestParser.class.getClassLoader());
            Constructor<?> ctor = cls.getConstructor(OptionMap.class);
            return (HttpRequestParser)ctor.newInstance(options);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handle(ByteBuffer buffer, ParseState currentState, HttpServerExchange builder) throws BadRequestException {
        if (currentState.state == 0) {
            int position = buffer.position();
            if (buffer.remaining() > 3 && buffer.get(position) == 71 && buffer.get(position + 1) == 69 && buffer.get(position + 2) == 84 && buffer.get(position + 3) == 32) {
                buffer.position(position + 4);
                builder.setRequestMethod(Methods.GET);
                currentState.state = 1;
            } else {
                this.handleHttpVerb(buffer, currentState, builder);
            }
            this.handlePath(buffer, currentState, builder);
            boolean failed = false;
            if (buffer.remaining() > HTTP_LENGTH + 3) {
                int pos = buffer.position();
                for (int i = 0; i < HTTP_LENGTH; ++i) {
                    if (HTTP[i] == buffer.get(pos + i)) continue;
                    failed = true;
                    break;
                }
                if (!failed) {
                    byte b = buffer.get(pos + HTTP_LENGTH);
                    byte b2 = buffer.get(pos + HTTP_LENGTH + 1);
                    byte b3 = buffer.get(pos + HTTP_LENGTH + 2);
                    if (b2 == 13 && b3 == 10) {
                        if (b == 49) {
                            builder.setProtocol(Protocols.HTTP_1_1);
                            buffer.position(pos + HTTP_LENGTH + 3);
                            currentState.state = 6;
                        } else if (b == 48) {
                            builder.setProtocol(Protocols.HTTP_1_0);
                            buffer.position(pos + HTTP_LENGTH + 3);
                            currentState.state = 6;
                        } else {
                            failed = true;
                        }
                    } else {
                        failed = true;
                    }
                }
            } else {
                failed = true;
            }
            if (failed) {
                this.handleHttpVersion(buffer, currentState, builder);
                this.handleAfterVersion(buffer, currentState);
            }
            while (currentState.state != 8 && buffer.hasRemaining()) {
                this.handleHeader(buffer, currentState, builder);
                if (currentState.state != 7) continue;
                this.handleHeaderValue(buffer, currentState, builder);
            }
            return;
        }
        this.handleStateful(buffer, currentState, builder);
    }

    private void handleStateful(ByteBuffer buffer, ParseState currentState, HttpServerExchange builder) throws BadRequestException {
        if (currentState.state == 1) {
            this.handlePath(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 3) {
            this.handleQueryParameters(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 2) {
            this.handlePathParameters(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 4) {
            this.handleHttpVersion(buffer, currentState, builder);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        if (currentState.state == 5) {
            this.handleAfterVersion(buffer, currentState);
            if (!buffer.hasRemaining()) {
                return;
            }
        }
        while (currentState.state != 8) {
            if (currentState.state == 6) {
                this.handleHeader(buffer, currentState, builder);
                if (!buffer.hasRemaining()) {
                    return;
                }
            }
            if (currentState.state != 7) continue;
            this.handleHeaderValue(buffer, currentState, builder);
            if (buffer.hasRemaining()) continue;
            return;
        }
    }

    abstract void handleHttpVerb(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    abstract void handleHttpVersion(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    abstract void handleHeader(ByteBuffer var1, ParseState var2, HttpServerExchange var3);

    final void handlePath(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        int parseState = state.parseState;
        int canonicalPathStart = state.pos;
        boolean urlDecodeRequired = state.urlDecodeRequired;
        while (buffer.hasRemaining()) {
            char next = (char)(buffer.get() & 0xFF);
            if (next == ' ' || next == '\t') {
                if (stringBuilder.length() == 0) continue;
                String path = stringBuilder.toString();
                if (parseState == 3) {
                    exchange.setRequestPath("/");
                    exchange.setRelativePath("/");
                    exchange.setRequestURI(path);
                } else if (parseState < 5) {
                    String decodedPath = this.decode(path, urlDecodeRequired, state, this.allowEncodedSlash);
                    exchange.setRequestPath(decodedPath);
                    exchange.setRelativePath(decodedPath);
                    exchange.setRequestURI(path);
                } else {
                    this.handleFullUrl(state, exchange, canonicalPathStart, urlDecodeRequired, path);
                }
                exchange.setQueryString("");
                state.state = 4;
                state.stringBuilder.setLength(0);
                state.parseState = 0;
                state.pos = 0;
                state.urlDecodeRequired = false;
                return;
            }
            if (next == '\r' || next == '\n') {
                throw UndertowMessages.MESSAGES.failedToParsePath();
            }
            if (next == '?' && (parseState == 0 || parseState == 5 || parseState == 4)) {
                this.beginQueryParameters(buffer, state, exchange, stringBuilder, parseState, canonicalPathStart, urlDecodeRequired);
                return;
            }
            if (next == ';' && (parseState == 0 || parseState == 5 || parseState == 4)) {
                this.beginPathParameters(state, exchange, stringBuilder, parseState, canonicalPathStart, urlDecodeRequired);
                this.handlePathParameters(buffer, state, exchange);
                return;
            }
            if (this.decode && (next == '%' || next > '\u007f')) {
                urlDecodeRequired = true;
            } else if (next == ':' && parseState == 0) {
                parseState = 1;
            } else if (next == '/' && parseState == 1) {
                parseState = 2;
            } else if (next == '/' && parseState == 2) {
                parseState = 3;
            } else if (next == '/' && parseState == 3) {
                parseState = 5;
                canonicalPathStart = stringBuilder.length();
            } else if (parseState == 1 || parseState == 2) {
                parseState = 4;
            } else if (next == '/' && parseState != 5) {
                parseState = 4;
            }
            stringBuilder.append(next);
        }
        state.parseState = parseState;
        state.pos = canonicalPathStart;
        state.urlDecodeRequired = urlDecodeRequired;
    }

    private void beginPathParameters(ParseState state, HttpServerExchange exchange, StringBuilder stringBuilder, int parseState, int canonicalPathStart, boolean urlDecodeRequired) {
        String path = stringBuilder.toString();
        if (parseState == 3) {
            exchange.setRequestPath("/");
            exchange.setRelativePath("/");
            exchange.setRequestURI(path);
        } else if (parseState < 5) {
            String decodedPath = this.decode(path, urlDecodeRequired, state, this.allowEncodedSlash);
            exchange.setRequestPath(decodedPath);
            exchange.setRelativePath(decodedPath);
            exchange.setRequestURI(path);
        } else {
            String thePath = path.substring(canonicalPathStart);
            exchange.setRequestPath(thePath);
            exchange.setRelativePath(thePath);
            exchange.setRequestURI(path, true);
        }
        state.state = 2;
        state.stringBuilder.setLength(0);
        state.parseState = 0;
        state.pos = 0;
        state.urlDecodeRequired = false;
    }

    private void beginQueryParameters(ByteBuffer buffer, ParseState state, HttpServerExchange exchange, StringBuilder stringBuilder, int parseState, int canonicalPathStart, boolean urlDecodeRequired) {
        String path = stringBuilder.toString();
        if (parseState == 3) {
            exchange.setRequestPath("/");
            exchange.setRelativePath("/");
            exchange.setRequestURI(path);
        } else if (parseState < 5) {
            String decodedPath = this.decode(path, urlDecodeRequired, state, this.allowEncodedSlash);
            exchange.setRequestPath(decodedPath);
            exchange.setRelativePath(decodedPath);
            exchange.setRequestURI(path, false);
        } else {
            this.handleFullUrl(state, exchange, canonicalPathStart, urlDecodeRequired, path);
        }
        state.state = 3;
        state.stringBuilder.setLength(0);
        state.parseState = 0;
        state.pos = 0;
        state.urlDecodeRequired = false;
        this.handleQueryParameters(buffer, state, exchange);
    }

    private void handleFullUrl(ParseState state, HttpServerExchange exchange, int canonicalPathStart, boolean urlDecodeRequired, String path) {
        String thePath = this.decode(path.substring(canonicalPathStart), urlDecodeRequired, state, this.allowEncodedSlash);
        exchange.setRequestPath(thePath);
        exchange.setRelativePath(thePath);
        exchange.setRequestURI(path, true);
    }

    final void handleQueryParameters(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        int queryParamPos = state.pos;
        int mapCount = state.mapCount;
        boolean urlDecodeRequired = state.urlDecodeRequired;
        String nextQueryParam = state.nextQueryParam;
        while (buffer.hasRemaining()) {
            char next = (char)(buffer.get() & 0xFF);
            if (next == ' ' || next == '\t') {
                String queryString = stringBuilder.toString();
                exchange.setQueryString(queryString);
                if (nextQueryParam == null) {
                    if (queryParamPos != stringBuilder.length()) {
                        exchange.addQueryParam(this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true), "");
                    }
                } else {
                    exchange.addQueryParam(nextQueryParam, this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true));
                }
                state.state = 4;
                state.stringBuilder.setLength(0);
                state.pos = 0;
                state.nextQueryParam = null;
                state.urlDecodeRequired = false;
                state.mapCount = 0;
                return;
            }
            if (next == '\r' || next == '\n') {
                throw UndertowMessages.MESSAGES.failedToParsePath();
            }
            if (this.decode && (next == '+' || next == '%' || next > '\u007f')) {
                urlDecodeRequired = true;
            } else if (next == '=' && nextQueryParam == null) {
                nextQueryParam = this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true);
                urlDecodeRequired = false;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&' && nextQueryParam == null) {
                if (mapCount++ > this.maxParameters) {
                    throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                }
                if (queryParamPos != stringBuilder.length()) {
                    exchange.addQueryParam(this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true), "");
                }
                urlDecodeRequired = false;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&') {
                if (mapCount++ > this.maxParameters) {
                    throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                }
                exchange.addQueryParam(nextQueryParam, this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true));
                urlDecodeRequired = false;
                queryParamPos = stringBuilder.length() + 1;
                nextQueryParam = null;
            }
            stringBuilder.append(next);
        }
        state.pos = queryParamPos;
        state.nextQueryParam = nextQueryParam;
        state.urlDecodeRequired = urlDecodeRequired;
        state.mapCount = 0;
    }

    private String decode(String value, boolean urlDecodeRequired, ParseState state, boolean allowEncodedSlash) {
        if (urlDecodeRequired) {
            return URLUtils.decode(value, this.charset, allowEncodedSlash, state.decodeBuffer);
        }
        return value;
    }

    final void handlePathParameters(ByteBuffer buffer, ParseState state, HttpServerExchange exchange) {
        StringBuilder stringBuilder = state.stringBuilder;
        int queryParamPos = state.pos;
        int mapCount = state.mapCount;
        boolean urlDecodeRequired = state.urlDecodeRequired;
        String nextQueryParam = state.nextQueryParam;
        while (buffer.hasRemaining()) {
            char next = (char)(buffer.get() & 0xFF);
            if (next == ' ' || next == '\t' || next == '?') {
                if (nextQueryParam == null) {
                    if (queryParamPos != stringBuilder.length()) {
                        exchange.addPathParam(this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true), "");
                    }
                } else {
                    exchange.addPathParam(nextQueryParam, this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true));
                }
                exchange.setRequestURI(exchange.getRequestURI() + ';' + stringBuilder.toString(), state.parseState > 5);
                state.stringBuilder.setLength(0);
                state.pos = 0;
                state.nextQueryParam = null;
                state.mapCount = 0;
                state.urlDecodeRequired = false;
                if (next == '?') {
                    state.state = 3;
                    this.handleQueryParameters(buffer, state, exchange);
                } else {
                    state.state = 4;
                }
                return;
            }
            if (next == '\r' || next == '\n') {
                throw UndertowMessages.MESSAGES.failedToParsePath();
            }
            if (this.decode && (next == '+' || next == '%' || next > '\u007f')) {
                urlDecodeRequired = true;
            }
            if (next == '=' && nextQueryParam == null) {
                nextQueryParam = this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true);
                urlDecodeRequired = false;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&' && nextQueryParam == null) {
                if (mapCount++ > this.maxParameters) {
                    throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                }
                exchange.addPathParam(this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true), "");
                urlDecodeRequired = false;
                queryParamPos = stringBuilder.length() + 1;
            } else if (next == '&') {
                if (mapCount++ > this.maxParameters) {
                    throw UndertowMessages.MESSAGES.tooManyQueryParameters(this.maxParameters);
                }
                exchange.addPathParam(nextQueryParam, this.decode(stringBuilder.substring(queryParamPos), urlDecodeRequired, state, true));
                urlDecodeRequired = false;
                queryParamPos = stringBuilder.length() + 1;
                nextQueryParam = null;
            }
            stringBuilder.append(next);
        }
        state.pos = queryParamPos;
        state.nextQueryParam = nextQueryParam;
        state.mapCount = 0;
        state.urlDecodeRequired = urlDecodeRequired;
    }

    final void handleHeaderValue(ByteBuffer buffer, ParseState state, HttpServerExchange builder) throws BadRequestException {
        String existing;
        HttpString headerName = state.nextHeader;
        StringBuilder stringBuilder = state.stringBuilder;
        HashMap<HttpString, String> headerValuesCache = state.headerValuesCache;
        if (stringBuilder.length() == 0 && (existing = headerValuesCache.get(headerName)) != null && this.handleCachedHeader(existing, buffer, state, builder)) {
            return;
        }
        this.handleHeaderValueCacheMiss(buffer, state, builder, headerName, headerValuesCache, stringBuilder);
    }

    private void handleHeaderValueCacheMiss(ByteBuffer buffer, ParseState state, HttpServerExchange builder, HttpString headerName, HashMap<HttpString, String> headerValuesCache, StringBuilder stringBuilder) throws BadRequestException {
        byte next;
        int parseState = state.parseState;
        while (buffer.hasRemaining() && parseState == 0) {
            next = buffer.get();
            if (next == 13) {
                parseState = 2;
                continue;
            }
            if (next == 10) {
                parseState = 3;
                continue;
            }
            if (next == 32 || next == 9) {
                parseState = 1;
                continue;
            }
            stringBuilder.append((char)(next & 0xFF));
        }
        while (buffer.hasRemaining()) {
            next = buffer.get();
            switch (parseState) {
                case 0: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) {
                        parseState = 1;
                        break;
                    }
                    stringBuilder.append((char)(next & 0xFF));
                    break;
                }
                case 1: {
                    if (next == 13) {
                        parseState = 2;
                        break;
                    }
                    if (next == 10) {
                        parseState = 3;
                        break;
                    }
                    if (next == 32 || next == 9) break;
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(' ');
                    }
                    stringBuilder.append((char)(next & 0xFF));
                    parseState = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (next == 10 && parseState == 2) {
                        parseState = 3;
                        break;
                    }
                    if (next == 9 || next == 32) {
                        parseState = 1;
                        break;
                    }
                    String headerValue = stringBuilder.toString();
                    if (state.mapCount++ > this.maxHeaders) {
                        throw new BadRequestException(UndertowMessages.MESSAGES.tooManyHeaders(this.maxHeaders));
                    }
                    builder.getRequestHeaders().add(headerName, headerValue);
                    if (headerValuesCache.size() < this.maxHeaders) {
                        headerValuesCache.put(headerName, headerValue);
                    }
                    state.nextHeader = null;
                    state.leftOver = next;
                    state.stringBuilder.setLength(0);
                    if (next == 13) {
                        parseState = 4;
                        break;
                    }
                    if (next == 10) {
                        state.state = 8;
                        return;
                    }
                    state.state = 6;
                    state.parseState = 0;
                    return;
                }
                case 4: {
                    state.state = 8;
                    return;
                }
            }
        }
        state.parseState = parseState;
    }

    protected boolean handleCachedHeader(String existing, ByteBuffer buffer, ParseState state, HttpServerExchange builder) throws BadRequestException {
        int i;
        int pos;
        for (pos = buffer.position(); pos < buffer.limit() && buffer.get(pos) == 32; ++pos) {
        }
        if (existing.length() + 3 + pos > buffer.limit()) {
            return false;
        }
        for (i = 0; i < existing.length(); ++i) {
            byte b = buffer.get(pos + i);
            if (b == existing.charAt(i)) continue;
            return false;
        }
        if (buffer.get(pos + i++) != 13) {
            return false;
        }
        if (buffer.get(pos + i++) != 10) {
            return false;
        }
        byte next = buffer.get(pos + i);
        if (next == 9 || next == 32) {
            return false;
        }
        buffer.position(pos + i);
        if (state.mapCount++ > this.maxHeaders) {
            throw new BadRequestException(UndertowMessages.MESSAGES.tooManyHeaders(this.maxHeaders));
        }
        builder.getRequestHeaders().add(state.nextHeader, existing);
        state.nextHeader = null;
        state.state = 6;
        state.parseState = 0;
        return true;
    }

    protected void handleAfterVersion(ByteBuffer buffer, ParseState state) {
        boolean newLine;
        boolean bl = newLine = state.leftOver == 10;
        while (buffer.hasRemaining()) {
            byte next = buffer.get();
            if (newLine) {
                if (next == 10) {
                    state.state = 8;
                    return;
                }
                state.state = 6;
                state.leftOver = next;
                return;
            }
            if (next == 10) {
                newLine = true;
                continue;
            }
            if (next != 13 && next != 32 && next != 9) {
                state.state = 6;
                state.leftOver = next;
                return;
            }
            throw UndertowMessages.MESSAGES.badRequest();
        }
        if (newLine) {
            state.leftOver = (byte)10;
        }
    }

    protected static Map<String, HttpString> httpStrings() {
        Class[] classs;
        HashMap<String, HttpString> results = new HashMap<String, HttpString>();
        for (Class c : classs = new Class[]{Headers.class, Methods.class, Protocols.class}) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.getType().equals(HttpString.class)) continue;
                HttpString result = null;
                try {
                    result = (HttpString)field.get(null);
                    results.put(result.toString(), result);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return results;
    }

    static {
        try {
            HTTP = "HTTP/1.".getBytes("ASCII");
            HTTP_LENGTH = HTTP.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static class BadRequestException
    extends Exception {
        public BadRequestException(String msg) {
            super(msg);
        }
    }
}

