/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.proxy;

import io.undertow.UndertowLogger;
import io.undertow.client.ClientConnection;
import io.undertow.client.UndertowClient;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.proxy.ConnectionPoolErrorHandler;
import io.undertow.server.handlers.proxy.ConnectionPoolManager;
import io.undertow.server.handlers.proxy.ExclusivityChecker;
import io.undertow.server.handlers.proxy.ProxyCallback;
import io.undertow.server.handlers.proxy.ProxyClient;
import io.undertow.server.handlers.proxy.ProxyConnection;
import io.undertow.server.handlers.proxy.ProxyConnectionPool;
import io.undertow.server.handlers.proxy.RouteIteratorFactory;
import io.undertow.server.handlers.proxy.RouteParsingStrategy;
import io.undertow.util.AttachmentKey;
import io.undertow.util.AttachmentList;
import io.undertow.util.CopyOnWriteMap;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.ssl.XnioSsl;

public class LoadBalancingProxyClient
implements ProxyClient {
    private final AttachmentKey<ExclusiveConnectionHolder> exclusiveConnectionKey = AttachmentKey.create(ExclusiveConnectionHolder.class);
    private static final AttachmentKey<AttachmentList<Host>> ATTEMPTED_HOSTS = AttachmentKey.createList(Host.class);
    private volatile int problemServerRetry = 10;
    private final Set<String> sessionCookieNames = new CopyOnWriteArraySet<String>();
    private volatile int connectionsPerThread = 10;
    private volatile int maxQueueSize = 0;
    private volatile int softMaxConnectionsPerThread = 5;
    private volatile int ttl = -1;
    private volatile Host[] hosts = new Host[0];
    private final HostSelector hostSelector;
    private final UndertowClient client;
    private final Map<String, Host> routes = new CopyOnWriteMap<String, Host>();
    private RouteIteratorFactory routeIteratorFactory = new RouteIteratorFactory(RouteParsingStrategy.SINGLE, RouteIteratorFactory.ParsingCompatibility.MOD_JK);
    private final ExclusivityChecker exclusivityChecker;
    private static final ProxyClient.ProxyTarget PROXY_TARGET = new ProxyClient.ProxyTarget(){};

    @Override
    public List<ProxyClient.ProxyTarget> getAllTargets() {
        ArrayList<ProxyClient.ProxyTarget> arr = new ArrayList<ProxyClient.ProxyTarget>();
        for (Host host : this.hosts) {
            ProxyClient.HostProxyTarget proxyTarget = new ProxyClient.HostProxyTarget(){
                Host host;

                @Override
                public void setHost(Host host) {
                    this.host = host;
                }

                public String toString() {
                    return this.host.getUri().toString();
                }
            };
            proxyTarget.setHost(host);
            arr.add(proxyTarget);
        }
        return arr;
    }

    public LoadBalancingProxyClient() {
        this(UndertowClient.getInstance());
    }

    public LoadBalancingProxyClient(UndertowClient client) {
        this(client, null, null);
    }

    public LoadBalancingProxyClient(ExclusivityChecker client) {
        this(UndertowClient.getInstance(), client, null);
    }

    public LoadBalancingProxyClient(UndertowClient client, ExclusivityChecker exclusivityChecker) {
        this(client, exclusivityChecker, null);
    }

    public LoadBalancingProxyClient(UndertowClient client, ExclusivityChecker exclusivityChecker, HostSelector hostSelector) {
        this.client = client;
        this.exclusivityChecker = exclusivityChecker;
        this.sessionCookieNames.add("JSESSIONID");
        this.hostSelector = hostSelector == null ? new RoundRobinHostSelector() : hostSelector;
    }

    public LoadBalancingProxyClient addSessionCookieName(String sessionCookieName) {
        this.sessionCookieNames.add(sessionCookieName);
        return this;
    }

    public LoadBalancingProxyClient removeSessionCookieName(String sessionCookieName) {
        this.sessionCookieNames.remove(sessionCookieName);
        return this;
    }

    public LoadBalancingProxyClient setProblemServerRetry(int problemServerRetry) {
        this.problemServerRetry = problemServerRetry;
        return this;
    }

    public int getProblemServerRetry() {
        return this.problemServerRetry;
    }

    public int getConnectionsPerThread() {
        return this.connectionsPerThread;
    }

    public LoadBalancingProxyClient setConnectionsPerThread(int connectionsPerThread) {
        this.connectionsPerThread = connectionsPerThread;
        return this;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public LoadBalancingProxyClient setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public LoadBalancingProxyClient setTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public LoadBalancingProxyClient setSoftMaxConnectionsPerThread(int softMaxConnectionsPerThread) {
        this.softMaxConnectionsPerThread = softMaxConnectionsPerThread;
        return this;
    }

    public LoadBalancingProxyClient setRouteParsingStrategy(RouteParsingStrategy routeParsingStrategy) {
        this.routeIteratorFactory = new RouteIteratorFactory(routeParsingStrategy, RouteIteratorFactory.ParsingCompatibility.MOD_JK, null);
        return this;
    }

    public LoadBalancingProxyClient setRankedRoutingDelimiter(String rankedRoutingDelimiter) {
        this.routeIteratorFactory = new RouteIteratorFactory(RouteParsingStrategy.RANKED, RouteIteratorFactory.ParsingCompatibility.MOD_JK, rankedRoutingDelimiter);
        return this;
    }

    public synchronized LoadBalancingProxyClient addHost(URI host) {
        return this.addHost(host, null, null);
    }

    public synchronized LoadBalancingProxyClient addHost(URI host, XnioSsl ssl) {
        return this.addHost(host, null, ssl);
    }

    public synchronized LoadBalancingProxyClient addHost(URI host, String jvmRoute) {
        return this.addHost(host, jvmRoute, null);
    }

    public synchronized LoadBalancingProxyClient addHost(URI host, String jvmRoute, XnioSsl ssl) {
        Host h = new Host(jvmRoute, null, host, ssl, OptionMap.EMPTY);
        Host[] existing = this.hosts;
        Host[] newHosts = new Host[existing.length + 1];
        System.arraycopy(existing, 0, newHosts, 0, existing.length);
        newHosts[existing.length] = h;
        this.hosts = newHosts;
        if (jvmRoute != null) {
            this.routes.put(jvmRoute, h);
        }
        return this;
    }

    public synchronized LoadBalancingProxyClient addHost(URI host, String jvmRoute, XnioSsl ssl, OptionMap options) {
        return this.addHost(null, host, jvmRoute, ssl, options);
    }

    public synchronized LoadBalancingProxyClient addHost(InetSocketAddress bindAddress, URI host, String jvmRoute, XnioSsl ssl, OptionMap options) {
        Host h = new Host(jvmRoute, bindAddress, host, ssl, options);
        Host[] existing = this.hosts;
        Host[] newHosts = new Host[existing.length + 1];
        System.arraycopy(existing, 0, newHosts, 0, existing.length);
        newHosts[existing.length] = h;
        this.hosts = newHosts;
        if (jvmRoute != null) {
            this.routes.put(jvmRoute, h);
        }
        return this;
    }

    public synchronized LoadBalancingProxyClient removeHost(URI uri) {
        int found = -1;
        Host[] existing = this.hosts;
        Host removedHost = null;
        for (int i = 0; i < existing.length; ++i) {
            if (!existing[i].uri.equals(uri)) continue;
            found = i;
            removedHost = existing[i];
            break;
        }
        if (found == -1) {
            return this;
        }
        Host[] newHosts = new Host[existing.length - 1];
        System.arraycopy(existing, 0, newHosts, 0, found);
        System.arraycopy(existing, found + 1, newHosts, found, existing.length - found - 1);
        this.hosts = newHosts;
        removedHost.connectionPool.close();
        if (removedHost.jvmRoute != null) {
            this.routes.remove(removedHost.jvmRoute);
        }
        return this;
    }

    @Override
    public ProxyClient.ProxyTarget findTarget(HttpServerExchange exchange) {
        return PROXY_TARGET;
    }

    @Override
    public void getConnection(ProxyClient.ProxyTarget target, HttpServerExchange exchange, final ProxyCallback<ProxyConnection> callback, long timeout, TimeUnit timeUnit) {
        final ExclusiveConnectionHolder holder = exchange.getConnection().getAttachment(this.exclusiveConnectionKey);
        if (holder != null && holder.connection.getConnection().isOpen()) {
            callback.completed(exchange, holder.connection);
            return;
        }
        final Host host = this.selectHost(exchange);
        if (host == null) {
            callback.couldNotResolveBackend(exchange);
        } else {
            exchange.addToAttachmentList(ATTEMPTED_HOSTS, host);
            if (holder != null || this.exclusivityChecker != null && this.exclusivityChecker.isExclusivityRequired(exchange)) {
                host.connectionPool.connect(target, exchange, new ProxyCallback<ProxyConnection>(){

                    @Override
                    public void completed(HttpServerExchange exchange, ProxyConnection result) {
                        if (holder != null) {
                            holder.connection = result;
                        } else {
                            final ExclusiveConnectionHolder newHolder = new ExclusiveConnectionHolder();
                            newHolder.connection = result;
                            ServerConnection connection = exchange.getConnection();
                            connection.putAttachment(LoadBalancingProxyClient.this.exclusiveConnectionKey, newHolder);
                            connection.addCloseListener(new ServerConnection.CloseListener(){

                                @Override
                                public void closed(ServerConnection connection) {
                                    ClientConnection clientConnection = newHolder.connection.getConnection();
                                    if (clientConnection.isOpen()) {
                                        IoUtils.safeClose((Closeable)clientConnection);
                                    }
                                }
                            });
                        }
                        callback.completed(exchange, result);
                    }

                    @Override
                    public void queuedRequestFailed(HttpServerExchange exchange) {
                        callback.queuedRequestFailed(exchange);
                    }

                    @Override
                    public void failed(HttpServerExchange exchange) {
                        UndertowLogger.PROXY_REQUEST_LOGGER.proxyFailedToConnectToBackend(exchange.getRequestURI(), host.uri);
                        callback.failed(exchange);
                    }

                    @Override
                    public void couldNotResolveBackend(HttpServerExchange exchange) {
                        callback.couldNotResolveBackend(exchange);
                    }
                }, timeout, timeUnit, true);
            } else {
                host.connectionPool.connect(target, exchange, callback, timeout, timeUnit, false);
            }
        }
    }

    protected Host selectHost(HttpServerExchange exchange) {
        int host;
        AttachmentList<Host> attempted = exchange.getAttachment(ATTEMPTED_HOSTS);
        Host[] hosts = this.hosts;
        if (hosts.length == 0) {
            return null;
        }
        Iterator<CharSequence> parsedRoutes = this.parseRoutes(exchange);
        while (parsedRoutes.hasNext()) {
            Host host2 = this.routes.get(parsedRoutes.next().toString());
            if (host2 == null || attempted != null && attempted.contains(host2)) continue;
            return host2;
        }
        int startHost = host = this.hostSelector.selectHost(hosts);
        Host full = null;
        Host problem = null;
        do {
            Host selected = hosts[host];
            if (attempted != null && attempted.contains(selected)) continue;
            ProxyConnectionPool.AvailabilityType available = selected.connectionPool.available();
            if (available == ProxyConnectionPool.AvailabilityType.AVAILABLE) {
                return selected;
            }
            if (available == ProxyConnectionPool.AvailabilityType.FULL && full == null) {
                full = selected;
                continue;
            }
            if (available != ProxyConnectionPool.AvailabilityType.PROBLEM && available != ProxyConnectionPool.AvailabilityType.FULL_QUEUE || problem != null) continue;
            problem = selected;
        } while ((host = (host + 1) % hosts.length) != startHost);
        if (full != null) {
            return full;
        }
        if (problem != null) {
            return problem;
        }
        return null;
    }

    protected Iterator<CharSequence> parseRoutes(HttpServerExchange exchange) {
        for (String cookieName : this.sessionCookieNames) {
            for (Cookie cookie : exchange.requestCookies()) {
                if (!cookieName.equals(cookie.getName())) continue;
                return this.routeIteratorFactory.iterator(cookie.getValue());
            }
        }
        return this.routeIteratorFactory.iterator(null);
    }

    public void closeCurrentConnections() {
        for (Host host : this.hosts) {
            host.closeCurrentConnections();
        }
    }

    public final class Host
    extends ConnectionPoolErrorHandler.SimpleConnectionPoolErrorHandler
    implements ConnectionPoolManager {
        final ProxyConnectionPool connectionPool;
        final String jvmRoute;
        final URI uri;
        final XnioSsl ssl;

        private Host(String jvmRoute, InetSocketAddress bindAddress, URI uri, XnioSsl ssl, OptionMap options) {
            this.connectionPool = new ProxyConnectionPool(this, bindAddress, uri, ssl, LoadBalancingProxyClient.this.client, options);
            this.jvmRoute = jvmRoute;
            this.uri = uri;
            this.ssl = ssl;
        }

        @Override
        public int getProblemServerRetry() {
            return LoadBalancingProxyClient.this.problemServerRetry;
        }

        @Override
        public int getMaxConnections() {
            return LoadBalancingProxyClient.this.connectionsPerThread;
        }

        @Override
        public int getMaxCachedConnections() {
            return LoadBalancingProxyClient.this.connectionsPerThread;
        }

        @Override
        public int getSMaxConnections() {
            return LoadBalancingProxyClient.this.softMaxConnectionsPerThread;
        }

        @Override
        public long getTtl() {
            return LoadBalancingProxyClient.this.ttl;
        }

        @Override
        public int getMaxQueueSize() {
            return LoadBalancingProxyClient.this.maxQueueSize;
        }

        public URI getUri() {
            return this.uri;
        }

        void closeCurrentConnections() {
            this.connectionPool.closeCurrentConnections();
        }
    }

    public static interface HostSelector {
        public int selectHost(Host[] var1);
    }

    private static class ExclusiveConnectionHolder {
        private ProxyConnection connection;

        private ExclusiveConnectionHolder() {
        }
    }

    static class RoundRobinHostSelector
    implements HostSelector {
        private final AtomicInteger currentHost = new AtomicInteger(0);

        RoundRobinHostSelector() {
        }

        @Override
        public int selectHost(Host[] availableHosts) {
            return this.currentHost.incrementAndGet() % availableHosts.length;
        }
    }
}

