/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.servlet.core.ManagedServlet;
import java.util.concurrent.Executor;

public class ServletChain {
    private final HttpHandler handler;
    private final ManagedServlet managedServlet;
    private final String servletPath;
    private final Executor executor;
    private final boolean defaultServletMapping;

    public ServletChain(HttpHandler handler, ManagedServlet managedServlet, String servletPath, boolean defaultServletMapping) {
        this.handler = handler;
        this.managedServlet = managedServlet;
        this.servletPath = servletPath;
        this.defaultServletMapping = defaultServletMapping;
        this.executor = managedServlet.getServletInfo().getExecutor();
    }

    public ServletChain(ServletChain other) {
        this(other.getHandler(), other.getManagedServlet(), other.getServletPath(), other.isDefaultServletMapping());
    }

    public HttpHandler getHandler() {
        return this.handler;
    }

    public ManagedServlet getManagedServlet() {
        return this.managedServlet;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean isDefaultServletMapping() {
        return this.defaultServletMapping;
    }
}

