/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.servlet.core;

import io.undertow.server.handlers.form.FormEncodedDataDefinition;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultiPartParserDefinition;
import io.undertow.server.handlers.resource.ResourceChangeListener;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.UndertowServletMessages;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.LifecycleInterceptor;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.core.Lifecycle;
import io.undertow.servlet.core.LifecyleInterceptorInvocation;
import io.undertow.servlet.spec.ServletConfigImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class ManagedServlet
implements Lifecycle {
    private final ServletInfo servletInfo;
    private final ServletContextImpl servletContext;
    private volatile boolean started = false;
    private final InstanceStrategy instanceStrategy;
    private volatile boolean permanentlyUnavailable = false;
    private long maxMultipartRequestSize;
    private FormParserFactory formParserFactory;
    private MultipartConfigElement multipartConfig;
    private static final AtomicLongFieldUpdater<ManagedServlet> unavailableUntilUpdater = AtomicLongFieldUpdater.newUpdater(ManagedServlet.class, "unavailableUntil");
    private volatile long unavailableUntil = 0L;

    public ManagedServlet(ServletInfo servletInfo, ServletContextImpl servletContext) {
        this.servletInfo = servletInfo;
        this.servletContext = servletContext;
        this.instanceStrategy = new DefaultInstanceStrategy(servletInfo.getInstanceFactory(), servletInfo, servletContext);
        this.setupMultipart(servletContext);
    }

    public void setupMultipart(ServletContextImpl servletContext) {
        FormEncodedDataDefinition formDataParser = new FormEncodedDataDefinition().setDefaultEncoding(servletContext.getDeployment().getDefaultRequestCharset().name());
        MultipartConfigElement multipartConfig = this.servletInfo.getMultipartConfig();
        if (multipartConfig == null) {
            multipartConfig = servletContext.getDeployment().getDeploymentInfo().getDefaultMultipartConfig();
        }
        this.multipartConfig = multipartConfig;
        if (multipartConfig != null) {
            Path tempDir;
            MultipartConfigElement config = multipartConfig;
            this.maxMultipartRequestSize = config.getMaxRequestSize() != -1L ? config.getMaxRequestSize() : -1L;
            if (config.getLocation() == null || config.getLocation().isEmpty()) {
                tempDir = servletContext.getDeployment().getDeploymentInfo().getTempPath();
            } else {
                String location = config.getLocation();
                Path locFile = Paths.get(location, new String[0]);
                if (locFile.isAbsolute()) {
                    tempDir = locFile;
                } else {
                    DeploymentInfo deploymentInfo = servletContext.getDeployment().getDeploymentInfo();
                    tempDir = deploymentInfo.requireTempPath().resolve(location);
                }
            }
            MultiPartParserDefinition multiPartParserDefinition = new MultiPartParserDefinition(tempDir);
            if (config.getMaxFileSize() > 0L) {
                multiPartParserDefinition.setMaxIndividualFileSize(config.getMaxFileSize());
            }
            if (config.getFileSizeThreshold() > 0) {
                multiPartParserDefinition.setFileSizeThreshold((long)config.getFileSizeThreshold());
            }
            multiPartParserDefinition.setDefaultEncoding(servletContext.getDeployment().getDefaultRequestCharset().name());
            this.formParserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)formDataParser).addParser((FormParserFactory.ParserDefinition)multiPartParserDefinition).build();
        } else {
            this.formParserFactory = FormParserFactory.builder((boolean)false).addParser((FormParserFactory.ParserDefinition)formDataParser).build();
            this.maxMultipartRequestSize = -1L;
        }
    }

    @Override
    public synchronized void start() throws ServletException {
    }

    public void createServlet() throws ServletException {
        block4: {
            if (this.permanentlyUnavailable) {
                return;
            }
            try {
                if (!this.started && this.servletInfo.getLoadOnStartup() != null && this.servletInfo.getLoadOnStartup() >= 0) {
                    this.instanceStrategy.start();
                    this.started = true;
                }
            }
            catch (UnavailableException e) {
                if (!e.isPermanent()) break block4;
                this.permanentlyUnavailable = true;
                this.stop();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.started) {
            this.instanceStrategy.stop();
        }
        this.started = false;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    public boolean isPermanentlyUnavailable() {
        return this.permanentlyUnavailable;
    }

    public boolean isTemporarilyUnavailable() {
        long until = this.unavailableUntil;
        if (until != 0L) {
            if (System.currentTimeMillis() < until) {
                return true;
            }
            unavailableUntilUpdater.compareAndSet(this, until, 0L);
        }
        return false;
    }

    public void setPermanentlyUnavailable(boolean permanentlyUnavailable) {
        this.permanentlyUnavailable = permanentlyUnavailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceHandle<? extends Servlet> getServlet() throws ServletException {
        if (this.servletContext.getDeployment().getDeploymentState() != DeploymentManager.State.STARTED) {
            throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
        }
        if (!this.started) {
            ManagedServlet managedServlet = this;
            synchronized (managedServlet) {
                if (!this.started) {
                    this.instanceStrategy.start();
                    this.started = true;
                }
            }
        }
        return this.instanceStrategy.getServlet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceInit() throws ServletException {
        if (!this.started) {
            if (this.servletContext.getDeployment().getDeploymentState() != DeploymentManager.State.STARTED) {
                throw UndertowServletMessages.MESSAGES.deploymentStopped(this.servletContext.getDeployment().getDeploymentInfo().getDeploymentName());
            }
            ManagedServlet managedServlet = this;
            synchronized (managedServlet) {
                if (!this.started) {
                    try {
                        this.instanceStrategy.start();
                    }
                    catch (UnavailableException e) {
                        this.handleUnavailableException(e);
                    }
                    this.started = true;
                }
            }
        }
    }

    public void handleUnavailableException(UnavailableException e) {
        if (e.isPermanent()) {
            UndertowServletLogger.REQUEST_LOGGER.stoppingServletDueToPermanentUnavailability(this.getServletInfo().getName(), e);
            this.stop();
            this.setPermanentlyUnavailable(true);
        } else {
            long until = System.currentTimeMillis() + (long)(e.getUnavailableSeconds() * 1000);
            unavailableUntilUpdater.set(this, until);
            UndertowServletLogger.REQUEST_LOGGER.stoppingServletUntilDueToTemporaryUnavailability(this.getServletInfo().getName(), new Date(until), e);
        }
    }

    public ServletInfo getServletInfo() {
        return this.servletInfo;
    }

    public long getMaxRequestSize() {
        return this.maxMultipartRequestSize;
    }

    public FormParserFactory getFormParserFactory() {
        return this.formParserFactory;
    }

    public MultipartConfigElement getMultipartConfig() {
        return this.multipartConfig;
    }

    public String toString() {
        return "ManagedServlet{servletInfo=" + this.servletInfo + "}";
    }

    private static class DefaultInstanceStrategy
    implements InstanceStrategy {
        private final InstanceFactory<? extends Servlet> factory;
        private final ServletInfo servletInfo;
        private final ServletContextImpl servletContext;
        private volatile InstanceHandle<? extends Servlet> handle;
        private volatile Servlet instance;
        private ResourceChangeListener changeListener;
        private final InstanceHandle<Servlet> instanceHandle = new InstanceHandle<Servlet>(){

            @Override
            public Servlet getInstance() {
                return instance;
            }

            @Override
            public void release() {
            }
        };

        DefaultInstanceStrategy(InstanceFactory<? extends Servlet> factory, ServletInfo servletInfo, ServletContextImpl servletContext) {
            this.factory = factory;
            this.servletInfo = servletInfo;
            this.servletContext = servletContext;
        }

        @Override
        public synchronized void start() throws ServletException {
            try {
                this.handle = this.factory.createInstance();
            }
            catch (Exception e) {
                throw UndertowServletMessages.MESSAGES.couldNotInstantiateComponent(this.servletInfo.getName(), e);
            }
            this.instance = this.handle.getInstance();
            new LifecyleInterceptorInvocation(this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors(), this.servletInfo, this.instance, new ServletConfigImpl(this.servletInfo, this.servletContext)).proceed();
            ResourceManager resourceManager = this.servletContext.getDeployment().getDeploymentInfo().getResourceManager();
            if (this.instance instanceof ResourceChangeListener && resourceManager.isResourceChangeListenerSupported()) {
                this.changeListener = (ResourceChangeListener)this.instance;
                resourceManager.registerResourceChangeListener(this.changeListener);
            }
        }

        @Override
        public synchronized void stop() {
            if (this.handle != null) {
                ResourceManager resourceManager = this.servletContext.getDeployment().getDeploymentInfo().getResourceManager();
                if (this.changeListener != null) {
                    resourceManager.removeResourceChangeListener(this.changeListener);
                }
                this.invokeDestroy();
                this.handle.release();
            }
        }

        private void invokeDestroy() {
            List<LifecycleInterceptor> interceptors = this.servletContext.getDeployment().getDeploymentInfo().getLifecycleInterceptors();
            try {
                new LifecyleInterceptorInvocation(interceptors, this.servletInfo, this.instance).proceed();
            }
            catch (Exception e) {
                UndertowServletLogger.ROOT_LOGGER.failedToDestroy(this.servletInfo, e);
            }
        }

        @Override
        public InstanceHandle<? extends Servlet> getServlet() {
            return this.instanceHandle;
        }
    }

    static interface InstanceStrategy {
        public void start() throws ServletException;

        public void stop();

        public InstanceHandle<? extends Servlet> getServlet() throws ServletException;
    }
}

