/*
 * Decompiled with CFR 0.152.
 */
package io.vavr.test;

import io.vavr.collection.List;
import io.vavr.collection.Stream;
import io.vavr.test.Gen;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Arbitrary<T> {
    public Gen<T> apply(int var1);

    default public Arbitrary<T> distinct() {
        return this.distinctBy(Function.identity());
    }

    default public Arbitrary<T> distinctBy(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator, "comparator is null");
        TreeSet<? super T> seen = new TreeSet<T>(comparator);
        return this.filter(seen::add);
    }

    default public <U> Arbitrary<T> distinctBy(Function<? super T, ? extends U> keyExtractor) {
        Objects.requireNonNull(keyExtractor, "keyExtractor is null");
        HashSet seen = new HashSet();
        return this.filter(t -> seen.add(keyExtractor.apply(t)));
    }

    default public Arbitrary<T> filter(Predicate<? super T> predicate) {
        return size -> this.apply(size).filter(predicate);
    }

    default public <U> Arbitrary<U> flatMap(Function<? super T, ? extends Arbitrary<? extends U>> mapper) {
        return size -> {
            Gen gen = this.apply(size);
            return random -> ((Arbitrary)mapper.apply((Object)gen.apply(random))).apply(size).apply(random);
        };
    }

    default public Arbitrary<T> intersperse(Arbitrary<T> other) {
        Objects.requireNonNull(other, "other is null");
        return size -> this.apply(size).intersperse(other.apply(size));
    }

    default public <U> Arbitrary<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return n -> {
            Gen generator = this.apply(n);
            return random -> mapper.apply((Object)generator.apply(random));
        };
    }

    default public Arbitrary<T> peek(Consumer<? super T> action) {
        return size -> this.apply(size).peek(action);
    }

    default public <U> U transform(Function<? super Arbitrary<T>, ? extends U> f) {
        Objects.requireNonNull(f, "f is null");
        return f.apply(this);
    }

    @SafeVarargs
    public static <U> Arbitrary<U> of(U ... values) {
        return Arbitrary.ofAll(Gen.choose(values));
    }

    public static <U> Arbitrary<U> ofAll(Gen<U> generator) {
        return size -> generator;
    }

    public static Arbitrary<Integer> integer() {
        return size -> Gen.choose(-size, size);
    }

    public static Arbitrary<LocalDateTime> localDateTime() {
        return Arbitrary.localDateTime(ChronoUnit.DAYS);
    }

    public static Arbitrary<LocalDateTime> localDateTime(ChronoUnit unit) {
        return Arbitrary.localDateTime(LocalDateTime.now(), unit);
    }

    public static Arbitrary<LocalDateTime> localDateTime(LocalDateTime median, ChronoUnit unit) {
        Objects.requireNonNull(median, "median is null");
        Objects.requireNonNull(unit, "unit is null");
        return size -> {
            if (size == 0) {
                return Gen.of(median);
            }
            LocalDateTime start = median.minus(size, unit);
            LocalDateTime end = median.plus(size, unit);
            long duration = Duration.between(start, end).toMillis();
            Gen<Long> from = Gen.choose(0L, duration);
            return random -> start.plus((Long)from.apply(random), ChronoUnit.MILLIS);
        };
    }

    public static Arbitrary<String> string(Gen<Character> gen) {
        return size -> random -> Gen.choose(0, size).map(i -> {
            char[] chars = new char[i.intValue()];
            for (int j = 0; j < i; ++j) {
                chars[j] = ((Character)gen.apply(random)).charValue();
            }
            return new String(chars);
        }).apply(random);
    }

    public static <T> Arbitrary<List<T>> list(Arbitrary<T> arbitraryT) {
        return size -> {
            Gen genT = arbitraryT.apply(size);
            return random -> List.fill((int)Gen.choose(0, size).apply(random), () -> genT.apply(random));
        };
    }

    public static <T> Arbitrary<Stream<T>> stream(Arbitrary<T> arbitraryT) {
        return size -> {
            Gen genT = arbitraryT.apply(size);
            return random -> Stream.continually(() -> genT.apply(random)).take(Gen.choose(0, size).apply(random).intValue());
        };
    }
}

