/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.audit;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.audit.Marker;
import io.vertx.ext.auth.audit.impl.SecurityAuditLogger;
import io.vertx.ext.auth.audit.impl.SecurityAuditNOOP;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.auth.authorization.Authorization;

@VertxGen
public interface SecurityAudit {
    public static final SecurityAudit NOOP = new SecurityAuditNOOP();

    public static SecurityAudit create() {
        if (SecurityAuditLogger.isEnabled()) {
            return new SecurityAuditLogger();
        }
        return NOOP;
    }

    @Fluent
    public SecurityAudit source(SocketAddress var1);

    @Fluent
    public SecurityAudit destination(SocketAddress var1);

    public SecurityAudit resource(HttpVersion var1, HttpMethod var2, String var3);

    @Fluent
    public SecurityAudit resource(String var1);

    @Fluent
    public SecurityAudit credentials(Credentials var1);

    @Fluent
    public SecurityAudit user(User var1);

    @Fluent
    public SecurityAudit authorization(Authorization var1);

    @Fluent
    public SecurityAudit status(int var1);

    public void audit(Marker var1, boolean var2);

    @GenIgnore(value={"permitted-type"})
    default public <T> Handler<AsyncResult<T>> auditHandlerFor(Marker marker) {
        return event -> this.audit(marker, event.succeeded());
    }
}

