/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.oauth2;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.JWTOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.oauth2.OAuth2FlowType;
import io.vertx.ext.auth.oauth2.OAuth2OptionsConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DataObject
@JsonGen(publicConverter=false)
public class OAuth2Options {
    private static final Logger LOG = LoggerFactory.getLogger(OAuth2Options.class);
    private static final OAuth2FlowType FLOW = OAuth2FlowType.AUTH_CODE;
    private static final String AUTHORIZATION_PATH = "/oauth/authorize";
    private static final String TOKEN_PATH = "/oauth/token";
    private static final String REVOCATION_PATH = "/oauth/revoke";
    private static final JWTOptions JWT_OPTIONS = new JWTOptions();
    private static final String SCOPE_SEPARATOR = " ";
    private static final boolean VALIDATE_ISSUER = true;
    private static final long JWK_DEFAULT_AGE = -1L;
    private OAuth2FlowType flow;
    private List<String> supportedGrantTypes;
    private String authorizationPath;
    private String tokenPath;
    private String revocationPath;
    private String scopeSeparator;
    private boolean validateIssuer;
    private String logoutPath;
    private String userInfoPath;
    private JsonObject userInfoParams;
    private String introspectionPath;
    private String jwkPath;
    private long jwkMaxAge;
    private String tenant;
    private String site;
    private String clientId;
    private String clientSecret;
    private String clientAssertionType;
    private String clientAssertion;
    private String userAgent;
    private JsonObject headers;
    private List<PubSecKeyOptions> pubSecKeys;
    private JWTOptions jwtOptions;
    private JsonObject extraParams;
    private HttpClientOptions httpClientOptions = new HttpClientOptions();
    private static final Pattern TENANT_PATTER = Pattern.compile("\\{(tenant|realm)}");

    public String getSite() {
        return this.site;
    }

    public OAuth2Options() {
        this.init();
    }

    public OAuth2Options(OAuth2Options other) {
        this.tenant = other.getTenant();
        this.clientId = other.getClientId();
        this.clientSecret = other.getClientSecret();
        this.clientAssertionType = other.getClientAssertionType();
        this.clientAssertion = other.getClientAssertion();
        this.validateIssuer = other.isValidateIssuer();
        this.flow = other.getFlow();
        this.authorizationPath = other.getAuthorizationPath();
        this.tokenPath = other.getTokenPath();
        this.revocationPath = other.getRevocationPath();
        this.userInfoPath = other.getUserInfoPath();
        this.introspectionPath = other.getIntrospectionPath();
        this.scopeSeparator = other.getScopeSeparator();
        this.site = other.getSite();
        this.pubSecKeys = other.getPubSecKeys();
        this.jwtOptions = other.getJWTOptions();
        this.logoutPath = other.getLogoutPath();
        JsonObject obj = other.getExtraParameters();
        this.extraParams = obj != null ? obj.copy() : null;
        JsonObject obj2 = other.getUserInfoParameters();
        this.userInfoParams = obj2 != null ? obj2.copy() : null;
        JsonObject obj3 = other.getHeaders();
        this.headers = obj3 != null ? obj3.copy() : null;
        this.jwkPath = other.getJwkPath();
        this.jwkMaxAge = other.getJwkMaxAgeInSeconds();
        this.httpClientOptions = other.getHttpClientOptions();
        this.userAgent = other.getUserAgent();
        this.supportedGrantTypes = other.getSupportedGrantTypes();
        this.replaceVariables(false);
    }

    private void init() {
        this.flow = FLOW;
        this.validateIssuer = true;
        this.authorizationPath = AUTHORIZATION_PATH;
        this.tokenPath = TOKEN_PATH;
        this.revocationPath = REVOCATION_PATH;
        this.scopeSeparator = SCOPE_SEPARATOR;
        this.jwtOptions = JWT_OPTIONS;
        this.jwkMaxAge = -1L;
    }

    public OAuth2Options(JsonObject json) {
        this.init();
        OAuth2OptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
        this.replaceVariables(false);
    }

    public String getAuthorizationPath() {
        return this.authorizationPath;
    }

    public OAuth2Options setAuthorizationPath(String authorizationPath) {
        this.authorizationPath = authorizationPath;
        return this;
    }

    public String getTokenPath() {
        return this.tokenPath;
    }

    public OAuth2Options setTokenPath(String tokenPath) {
        this.tokenPath = tokenPath;
        return this;
    }

    public String getRevocationPath() {
        return this.revocationPath;
    }

    public OAuth2Options setRevocationPath(String revocationPath) {
        this.revocationPath = revocationPath;
        return this;
    }

    public OAuth2Options setSite(String site) {
        this.site = site;
        return this;
    }

    @Deprecated
    public String getClientID() {
        return this.getClientId();
    }

    @Deprecated
    public OAuth2Options setClientID(String clientID) {
        return this.setClientId(clientID);
    }

    public String getClientId() {
        return this.clientId;
    }

    public OAuth2Options setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public OAuth2Options setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getClientAssertionType() {
        return this.clientAssertionType;
    }

    public OAuth2Options setClientAssertionType(String clientAssertionType) {
        this.clientAssertionType = clientAssertionType;
        return this;
    }

    public String getClientAssertion() {
        return this.clientAssertion;
    }

    public OAuth2Options setClientAssertion(String clientAssertion) {
        this.clientAssertion = clientAssertion;
        return this;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public OAuth2Options setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public JsonObject getHeaders() {
        return this.headers;
    }

    public OAuth2Options setHeaders(JsonObject headers) {
        this.headers = headers;
        return this;
    }

    public List<PubSecKeyOptions> getPubSecKeys() {
        return this.pubSecKeys;
    }

    public OAuth2Options setPubSecKeys(List<PubSecKeyOptions> pubSecKeys) {
        this.pubSecKeys = pubSecKeys;
        return this;
    }

    public OAuth2Options addPubSecKey(PubSecKeyOptions pubSecKey) {
        if (this.pubSecKeys == null) {
            this.pubSecKeys = new ArrayList<PubSecKeyOptions>();
        }
        this.pubSecKeys.add(pubSecKey);
        return this;
    }

    public String getLogoutPath() {
        return this.logoutPath;
    }

    public OAuth2Options setLogoutPath(String logoutPath) {
        this.logoutPath = logoutPath;
        return this;
    }

    public String getUserInfoPath() {
        return this.userInfoPath;
    }

    public OAuth2Options setUserInfoPath(String userInfoPath) {
        this.userInfoPath = userInfoPath;
        return this;
    }

    public String getScopeSeparator() {
        return this.scopeSeparator;
    }

    public OAuth2Options setScopeSeparator(String scopeSeparator) {
        this.scopeSeparator = scopeSeparator;
        return this;
    }

    public JsonObject getExtraParameters() {
        return this.extraParams;
    }

    public OAuth2Options setExtraParameters(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    public String getIntrospectionPath() {
        return this.introspectionPath;
    }

    public OAuth2Options setIntrospectionPath(String introspectionPath) {
        this.introspectionPath = introspectionPath;
        return this;
    }

    public JsonObject getUserInfoParameters() {
        return this.userInfoParams;
    }

    public OAuth2Options setUserInfoParameters(JsonObject userInfoParams) {
        this.userInfoParams = userInfoParams;
        return this;
    }

    public String getJwkPath() {
        return this.jwkPath;
    }

    public OAuth2Options setJwkPath(String jwkPath) {
        this.jwkPath = jwkPath;
        return this;
    }

    public JWTOptions getJWTOptions() {
        return this.jwtOptions;
    }

    public OAuth2Options setJWTOptions(JWTOptions jwtOptions) {
        this.jwtOptions = jwtOptions;
        return this;
    }

    @Deprecated
    public OAuth2FlowType getFlow() {
        return this.flow;
    }

    @Deprecated
    public OAuth2Options setFlow(OAuth2FlowType flow) {
        this.flow = flow;
        return this;
    }

    public boolean isValidateIssuer() {
        return this.validateIssuer;
    }

    public OAuth2Options setValidateIssuer(boolean validateIssuer) {
        this.validateIssuer = validateIssuer;
        return this;
    }

    public String getTenant() {
        return this.tenant;
    }

    public OAuth2Options setTenant(String tenant) {
        this.tenant = tenant;
        return this;
    }

    @Deprecated
    public boolean isRotateJWKs() {
        return this.jwkMaxAge != -1L;
    }

    @Deprecated
    public OAuth2Options setRotateJWKs(boolean rotateJWKs) {
        return this;
    }

    public List<String> getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    public OAuth2Options setSupportedGrantTypes(List<String> supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
        return this;
    }

    public OAuth2Options addSupportedGrantType(String supportedGrantType) {
        if (this.supportedGrantTypes == null) {
            this.supportedGrantTypes = new ArrayList<String>();
        }
        this.supportedGrantTypes.add(supportedGrantType);
        return this;
    }

    public void replaceVariables(boolean strict) {
        if (this.site != null && this.site.endsWith("/")) {
            this.site = this.site.substring(0, this.site.length() - 1);
        }
        this.site = this.replaceVariables(this.site);
        this.authorizationPath = this.replaceVariables(this.authorizationPath);
        this.tokenPath = this.replaceVariables(this.tokenPath);
        this.revocationPath = this.replaceVariables(this.revocationPath);
        this.logoutPath = this.replaceVariables(this.logoutPath);
        this.userInfoPath = this.replaceVariables(this.userInfoPath);
        this.introspectionPath = this.replaceVariables(this.introspectionPath);
        this.jwkPath = this.replaceVariables(this.jwkPath);
        if (this.extraParams != null) {
            for (Map.Entry kv : this.extraParams) {
                Object v = kv.getValue();
                if (!(v instanceof String)) continue;
                try {
                    kv.setValue(this.replaceVariables((String)v));
                }
                catch (IllegalStateException e) {
                    if (!strict) continue;
                    throw e;
                }
            }
        }
    }

    private String replaceVariables(String path) {
        Matcher matcher;
        if (path != null && (matcher = TENANT_PATTER.matcher(path)).find()) {
            if (this.tenant == null) {
                throw new IllegalStateException("Configuration with placeholders require that \"tenant\" is prior set");
            }
            return matcher.replaceAll(this.tenant);
        }
        return path;
    }

    public void validate() throws IllegalStateException {
        if (this.flow == null) {
            throw new IllegalStateException("Missing OAuth2 flow [e.g.: AUTH_CODE]");
        }
        switch (this.flow) {
            case AUTH_CODE: 
            case AUTH_JWT: 
            case AAD_OBO: {
                if (this.clientAssertion == null && this.clientAssertionType == null) {
                    if (this.clientId != null) break;
                    throw new IllegalStateException("Configuration missing. You need to specify [clientId]");
                }
                if (this.clientAssertion != null && this.clientAssertionType != null) break;
                throw new IllegalStateException("Configuration missing. You need to specify [clientAssertion] AND [clientAssertionType]");
            }
            case PASSWORD: {
                if (this.clientAssertion == null && this.clientAssertionType == null) {
                    if (this.clientId != null) break;
                    LOG.debug((Object)"If you are using Client Oauth2 Resource Owner flow. You need to specify [clientId]");
                    break;
                }
                if (this.clientAssertion != null && this.clientAssertionType != null) break;
                throw new IllegalStateException("Configuration missing. You need to specify [clientAssertion] AND [clientAssertionType]");
            }
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        OAuth2OptionsConverter.toJson(this, json);
        return json;
    }

    public String toString() {
        return this.toJson().encode();
    }

    public HttpClientOptions getHttpClientOptions() {
        return this.httpClientOptions;
    }

    public OAuth2Options setHttpClientOptions(HttpClientOptions httpClientOptions) {
        this.httpClientOptions = httpClientOptions;
        return this;
    }

    public long getJwkMaxAgeInSeconds() {
        return this.jwkMaxAge;
    }

    public void setJwkMaxAgeInSeconds(long jwkMaxAgeInSeconds) {
        this.jwkMaxAge = jwkMaxAgeInSeconds;
    }
}

