/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth.webauthn.impl.metadata;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.LocalMap;
import io.vertx.ext.auth.impl.CertificateHelper;
import io.vertx.ext.auth.impl.jose.JWS;
import io.vertx.ext.auth.webauthn.PublicKeyCredential;
import io.vertx.ext.auth.webauthn.WebAuthnOptions;
import io.vertx.ext.auth.webauthn.impl.attestation.AttestationException;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataEntry;
import io.vertx.ext.auth.webauthn.impl.metadata.MetaDataException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MetaData {
    private static final JsonArray EMTPY = new JsonArray(Collections.emptyList());
    public static final int ALG_SIGN_SECP256R1_ECDSA_SHA256_RAW = 1;
    public static final int ALG_SIGN_SECP256R1_ECDSA_SHA256_DER = 2;
    public static final int ALG_SIGN_RSASSA_PSS_SHA256_RAW = 3;
    public static final int ALG_SIGN_RSASSA_PSS_SHA256_DER = 4;
    public static final int ALG_SIGN_SECP256K1_ECDSA_SHA256_RAW = 5;
    public static final int ALG_SIGN_SECP256K1_ECDSA_SHA256_DER = 6;
    public static final int ALG_SIGN_RSASSA_PSS_SHA384_RAW = 10;
    public static final int ALG_SIGN_RSASSA_PSS_SHA512_RAW = 11;
    public static final int ALG_SIGN_RSASSA_PKCSV15_SHA256_RAW = 12;
    public static final int ALG_SIGN_RSASSA_PKCSV15_SHA384_RAW = 13;
    public static final int ALG_SIGN_RSASSA_PKCSV15_SHA512_RAW = 14;
    public static final int ALG_SIGN_RSASSA_PKCSV15_SHA1_RAW = 15;
    public static final int ALG_SIGN_SECP384R1_ECDSA_SHA384_RAW = 16;
    public static final int ALG_SIGN_SECP521R1_ECDSA_SHA512_RAW = 17;
    public static final int ALG_SIGN_ED25519_EDDSA_SHA256_RAW = 18;
    public static final int ATTESTATION_BASIC_FULL = 15879;
    public static final int ATTESTATION_BASIC_SURROGATE = 15880;
    public static final int ATTESTATION_ECDAA = 15881;
    public static final int ATTESTATION_ATTCA = 15882;
    public static final int ATTESTATION_ANONCA = 15884;
    public static final int ATTESTATION_NONE = 15883;
    private final LocalMap<String, MetaDataEntry> store;
    private final WebAuthnOptions options;

    public MetaData(Vertx vertx, WebAuthnOptions options) {
        this.store = vertx.sharedData().getLocalMap(MetaData.class.getName());
        this.options = options;
    }

    public MetaData clear() {
        this.store.clear();
        return this;
    }

    public int size() {
        return this.store.size();
    }

    public @Nullable PublicKeyCredential toJOSEAlg(Integer fido2AlgSign) {
        if (fido2AlgSign == null) {
            return null;
        }
        switch (fido2AlgSign) {
            case 1: 
            case 2: {
                return PublicKeyCredential.ES256;
            }
            case 3: 
            case 4: {
                return PublicKeyCredential.PS256;
            }
            case 5: 
            case 6: {
                return PublicKeyCredential.ES256K;
            }
            case 10: {
                return PublicKeyCredential.PS384;
            }
            case 11: {
                return PublicKeyCredential.PS512;
            }
            case 12: {
                return PublicKeyCredential.RS256;
            }
            case 13: {
                return PublicKeyCredential.RS384;
            }
            case 14: {
                return PublicKeyCredential.RS512;
            }
            case 15: {
                return PublicKeyCredential.RS1;
            }
            case 16: {
                return PublicKeyCredential.ES384;
            }
            case 17: {
                return PublicKeyCredential.ES512;
            }
            case 18: {
                return PublicKeyCredential.EdDSA;
            }
        }
        return null;
    }

    public static @Nullable PublicKeyCredential toJOSEAlg(String fido2AlgSign) {
        if (fido2AlgSign == null) {
            return null;
        }
        switch (fido2AlgSign) {
            case "secp256r1_ecdsa_sha256_raw": 
            case "secp256r1_ecdsa_sha256_der": {
                return PublicKeyCredential.ES256;
            }
            case "rsassa_pss_sha256_raw": 
            case "rsassa_pss_sha256_der": {
                return PublicKeyCredential.PS256;
            }
            case "secp256k1_ecdsa_sha256_raw": 
            case "secp256k1_ecdsa_sha256_der": {
                return PublicKeyCredential.ES256K;
            }
            case "rsassa_pss_sha384_raw": {
                return PublicKeyCredential.PS384;
            }
            case "rsassa_pss_sha512_raw": {
                return PublicKeyCredential.PS512;
            }
            case "rsassa_pkcsv15_sha256_raw": {
                return PublicKeyCredential.RS256;
            }
            case "rsassa_pkcsv15_sha384_raw": {
                return PublicKeyCredential.RS384;
            }
            case "rsassa_pkcsv15_sha512_raw": {
                return PublicKeyCredential.RS512;
            }
            case "rsassa_pkcsv15_sha1_raw": {
                return PublicKeyCredential.RS1;
            }
            case "secp384r1_ecdsa_sha384_raw": {
                return PublicKeyCredential.ES384;
            }
            case "secp521r1_ecdsa_sha512_raw": {
                return PublicKeyCredential.ES512;
            }
            case "ed25519_eddsa_sha256_raw": {
                return PublicKeyCredential.EdDSA;
            }
        }
        return null;
    }

    public JsonObject verifyMetadata(String aaguid, PublicKeyCredential alg, List<X509Certificate> x5c) throws MetaDataException, AttestationException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateException {
        return this.verifyMetadata(aaguid, alg, x5c, null, true);
    }

    public JsonObject verifyMetadata(String aaguid, PublicKeyCredential alg, List<X509Certificate> x5c, boolean includesRoot) throws MetaDataException, AttestationException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateException {
        return this.verifyMetadata(aaguid, alg, x5c, null, includesRoot);
    }

    public JsonObject verifyMetadata(String aaguid, PublicKeyCredential alg, List<X509Certificate> x5c, X509Certificate rootCert) throws MetaDataException, AttestationException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateException {
        return this.verifyMetadata(aaguid, alg, x5c, rootCert, true);
    }

    public @Nullable JsonObject verifyMetadata(String aaguid, PublicKeyCredential alg, List<X509Certificate> x5c, X509Certificate rootCert, boolean includesRoot) throws MetaDataException, AttestationException, NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException, SignatureException, CertificateException {
        MetaDataEntry entry = (MetaDataEntry)this.store.get((Object)aaguid);
        if (entry != null) {
            entry.checkValid();
            switch (entry.version()) {
                case 2: {
                    if (alg == this.toJOSEAlg(entry.statement().getInteger("authenticationAlgorithm"))) break;
                    throw new AttestationException("Attestation alg did not match metadata auth alg");
                }
                case 3: {
                    boolean found = false;
                    for (Object el : entry.statement().getJsonArray("authenticationAlgorithms", EMTPY)) {
                        if (alg != MetaData.toJOSEAlg((String)el)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                    throw new AttestationException("Attestation alg did not match metadata auth alg");
                }
                default: {
                    throw new AttestationException("Unsupported metadata version: " + entry.version());
                }
            }
            if (x5c != null) {
                x5c = new ArrayList<X509Certificate>(x5c);
                JsonArray attestationRootCertificates = entry.statement().getJsonArray("attestationRootCertificates");
                if (attestationRootCertificates == null || attestationRootCertificates.size() == 0) {
                    if (rootCert != null) {
                        x5c.add(rootCert);
                    }
                    CertificateHelper.checkValidity(x5c, (boolean)includesRoot, this.options.getRootCrls());
                } else {
                    boolean chainValid = false;
                    for (int i = 0; i < attestationRootCertificates.size(); ++i) {
                        try {
                            x5c.add(JWS.parseX5c((String)attestationRootCertificates.getString(i)));
                            CertificateHelper.checkValidity(x5c, this.options.getRootCrls());
                            chainValid = true;
                            break;
                        }
                        catch (CertificateException e) {
                            x5c.remove(x5c.size() - 1);
                            continue;
                        }
                    }
                    if (!chainValid) {
                        throw new AttestationException("Certificate Chain not valid for metadata");
                    }
                }
            }
            return entry.statement();
        }
        if (x5c != null) {
            x5c = new ArrayList<X509Certificate>(x5c);
            if (rootCert != null) {
                x5c.add(rootCert);
            }
            CertificateHelper.checkValidity(x5c, (boolean)includesRoot, this.options.getRootCrls());
        }
        return null;
    }

    public MetaData loadMetadata(MetaDataEntry entry) {
        JsonObject json = entry.statement();
        String aaguid = json.getString("aaguid");
        if ("fido2".equals(json.getString("protocolFamily"))) {
            if (aaguid == null) {
                throw new IllegalArgumentException("Statement doesn't contain {aaguid}");
            }
            this.store.put((Object)aaguid, (Object)entry);
        }
        return this;
    }

    public static boolean statementAttestationTypesContains(JsonObject statement, int type) throws MetaDataException {
        if (!statement.containsKey("attestationTypes")) {
            return true;
        }
        JsonArray attestationTypes = statement.getJsonArray("attestationTypes");
        switch (statement.getInteger("schema", Integer.valueOf(2))) {
            case 2: {
                return attestationTypes.contains((Object)type);
            }
            case 3: {
                String stype;
                switch (type) {
                    case 15879: {
                        stype = "basic_full";
                        break;
                    }
                    case 15880: {
                        stype = "basic_surrogate";
                        break;
                    }
                    case 15881: {
                        stype = "ecdaa";
                        break;
                    }
                    case 15882: {
                        stype = "attca";
                        break;
                    }
                    case 15884: {
                        stype = "anonca";
                        break;
                    }
                    case 15883: {
                        stype = "none";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid type: " + type);
                    }
                }
                return attestationTypes.contains((Object)stype);
            }
        }
        throw new MetaDataException("Unsupported metadata version");
    }
}

