/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.config.impl.spi;

import io.vertx.config.impl.spi.HttpConfigStore;
import io.vertx.config.spi.ConfigStore;
import io.vertx.config.spi.ConfigStoreFactory;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import java.util.Objects;

public class HttpConfigStoreFactory
implements ConfigStoreFactory {
    @Override
    public String name() {
        return "http";
    }

    @Override
    public ConfigStore create(Vertx vertx, JsonObject configuration) {
        HttpClient client = vertx.createHttpClient(new HttpClientOptions(configuration));
        String host = configuration.getString("host");
        int port = configuration.getInteger("port", Integer.valueOf(80));
        String path = configuration.getString("path", "/");
        Objects.requireNonNull(host);
        return new HttpConfigStore(host, port, path, client);
    }
}

