/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.Http1xConnectionBase;
import io.vertx.core.http.impl.HttpChunkContentCompressor;
import io.vertx.core.http.impl.HttpHandlers;
import io.vertx.core.http.impl.HttpServerRequestImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.ServerWebSocketImpl;
import io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.Metrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;

public class Http1xServerConnection
extends Http1xConnectionBase
implements HttpConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xServerConnection.class);
    private final String serverOrigin;
    private final SSLHelper sslHelper;
    private boolean requestFailed;
    private long bytesRead;
    private long bytesWritten;
    private ServerWebSocketImpl ws;
    private boolean closeFrameSent;
    private HttpServerRequestImpl requestInProgress;
    private HttpServerRequestImpl responseInProgress;
    private boolean channelPaused;
    final Handler<HttpServerRequest> requestHandler;
    final HttpServerMetrics metrics;
    final boolean handle100ContinueAutomatically;
    final HttpServerOptions options;

    public Http1xServerConnection(VertxInternal vertx, SSLHelper sslHelper, HttpServerOptions options, ChannelHandlerContext channel, ContextInternal context, String serverOrigin, HttpHandlers handlers, HttpServerMetrics metrics) {
        super(vertx, channel, context);
        this.requestHandler = Http1xServerConnection.requestHandler(handlers);
        this.serverOrigin = serverOrigin;
        this.options = options;
        this.sslHelper = sslHelper;
        this.metrics = metrics;
        this.handle100ContinueAutomatically = options.isHandle100ContinueAutomatically();
        this.exceptionHandler((Handler)handlers.exceptionHandler);
    }

    @Override
    public HttpServerMetrics metrics() {
        return this.metrics;
    }

    @Override
    public synchronized void handleMessage(Object msg) {
        if (msg instanceof HttpRequest) {
            HttpServerRequestImpl req;
            DefaultHttpRequest request = (DefaultHttpRequest)msg;
            if (request.decoderResult() != DecoderResult.SUCCESS) {
                this.handleError((HttpObject)request);
                return;
            }
            this.requestInProgress = req = new HttpServerRequestImpl(this, (HttpRequest)request);
            if (this.responseInProgress == null) {
                this.responseInProgress = this.requestInProgress;
                req.handleBegin();
            } else {
                req.pause();
                this.responseInProgress.appendRequest(req);
            }
        } else if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            this.handleEnd();
        } else if (msg instanceof HttpContent) {
            this.handleContent(msg);
        } else {
            this.handleOther(msg);
        }
    }

    private void handleContent(Object msg) {
        HttpContent content = (HttpContent)msg;
        if (content.decoderResult() != DecoderResult.SUCCESS) {
            this.handleError((HttpObject)content);
            return;
        }
        Buffer buffer = Buffer.buffer(VertxHandler.safeBuffer(content.content(), this.chctx.alloc()));
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesRead(buffer);
        }
        this.requestInProgress.handleContent(buffer);
        if (content instanceof LastHttpContent) {
            this.handleEnd();
        }
    }

    private void handleEnd() {
        if (Metrics.METRICS_ENABLED) {
            this.reportRequestComplete();
        }
        HttpServerRequestImpl request = this.requestInProgress;
        this.requestInProgress = null;
        request.handleEnd();
    }

    synchronized void responseComplete() {
        if (Metrics.METRICS_ENABLED) {
            this.reportResponseComplete();
        }
        HttpServerRequestImpl request = this.responseInProgress;
        this.responseInProgress = null;
        HttpServerRequestImpl next = request.nextRequest();
        if (next != null) {
            this.handleNext(next);
        }
    }

    private void handleNext(HttpServerRequestImpl request) {
        this.responseInProgress = request;
        this.getContext().runOnContext(v -> this.responseInProgress.handlePipelined());
    }

    private void handleOther(Object msg) {
        CloseWebSocketFrame closeFrame;
        WebSocketFrameInternal frame;
        if (msg instanceof WebSocketFrame) {
            frame = this.decodeFrame((WebSocketFrame)msg);
            switch (frame.type()) {
                case PING: {
                    this.chctx.writeAndFlush((Object)new PongWebSocketFrame(frame.getBinaryData()));
                    return;
                }
                case CLOSE: {
                    if (this.closeFrameSent) break;
                    closeFrame = new CloseWebSocketFrame((int)frame.closeStatusCode(), frame.closeReason());
                    this.chctx.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    this.closeFrameSent = true;
                }
            }
            if (this.ws != null) {
                this.ws.handleFrame(frame);
            }
        }
        if (msg instanceof PingWebSocketFrame) {
            frame = (PingWebSocketFrame)msg;
            frame.content().retain();
            this.chctx.writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
            return;
        }
        if (msg instanceof CloseWebSocketFrame && !this.closeFrameSent) {
            frame = (CloseWebSocketFrame)msg;
            closeFrame = new CloseWebSocketFrame(frame.statusCode(), frame.reasonText());
            this.chctx.writeAndFlush((Object)closeFrame).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            this.closeFrameSent = true;
        }
    }

    @Override
    public void doPause() {
        if (!this.channelPaused) {
            this.channelPaused = true;
            super.doPause();
        }
    }

    @Override
    public void doResume() {
        if (this.channelPaused) {
            this.channelPaused = false;
            super.doResume();
        }
    }

    private void reportBytesRead(Buffer buffer) {
        if (this.metrics != null) {
            this.bytesRead += (long)buffer.length();
        }
    }

    private void reportBytesWritten(Object msg) {
        if (this.metrics != null) {
            long bytes = this.getBytes(msg);
            if (bytes == -1L) {
                log.warn("Metrics could not be updated to include bytes written because of unknown object " + msg.getClass() + " being written.");
            } else {
                this.bytesWritten += bytes;
            }
        }
    }

    private void reportRequestComplete() {
        if (this.metrics != null) {
            this.reportBytesRead(this.bytesRead);
            this.bytesRead = 0L;
        }
    }

    private void reportResponseComplete() {
        if (this.metrics != null) {
            this.reportBytesWritten(this.bytesWritten);
            if (this.requestFailed) {
                this.metrics.requestReset(this.responseInProgress.metric());
                this.requestFailed = false;
            } else {
                this.metrics.responseEnd(this.responseInProgress.metric(), this.responseInProgress.response());
            }
            this.bytesWritten = 0L;
        }
    }

    String getServerOrigin() {
        return this.serverOrigin;
    }

    Vertx vertx() {
        return this.vertx;
    }

    @Override
    public void writeToChannel(Object msg, ChannelPromise promise) {
        if (Metrics.METRICS_ENABLED) {
            this.reportBytesWritten(msg);
        }
        super.writeToChannel(msg, promise);
    }

    ServerWebSocketImpl createWebSocket(HttpServerRequestImpl request) {
        if (this.ws != null) {
            return this.ws;
        }
        if (!(request.nettyRequest() instanceof FullHttpRequest)) {
            throw new IllegalStateException();
        }
        WebSocketServerHandshaker handshaker = this.createHandshaker(request);
        if (handshaker == null) {
            return null;
        }
        this.ws = new ServerWebSocketImpl(this, handshaker.version() != WebSocketVersion.V00, request, handshaker, this.options.getMaxWebsocketFrameSize(), this.options.getMaxWebsocketMessageSize());
        if (Metrics.METRICS_ENABLED && this.metrics != null) {
            this.ws.setMetric(this.metrics.connected(this.metric(), request.metric(), this.ws));
        }
        return this.ws;
    }

    private WebSocketServerHandshaker createHandshaker(HttpServerRequestImpl request) {
        String wsURL;
        Channel ch = this.channel();
        String connectionHeader = request.getHeader(HttpHeaders.CONNECTION);
        if (connectionHeader == null || !connectionHeader.toLowerCase().contains("upgrade")) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("\"Connection\" header must be \"Upgrade\".");
            return null;
        }
        if (request.method() != HttpMethod.GET) {
            request.response().setStatusCode(HttpResponseStatus.METHOD_NOT_ALLOWED.code()).end();
            return null;
        }
        try {
            wsURL = HttpUtils.getWebSocketLocation(request, this.isSsl());
        }
        catch (Exception e) {
            request.response().setStatusCode(HttpResponseStatus.BAD_REQUEST.code()).end("Invalid request URI");
            return null;
        }
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(wsURL, this.options.getWebsocketSubProtocols(), this.options.getPerMessageWebsocketCompressionSupported() || this.options.getPerFrameWebsocketCompressionSupported(), this.options.getMaxWebsocketFrameSize(), this.options.isAcceptUnmaskedFrames());
        WebSocketServerHandshaker shake = factory.newHandshaker(request.nettyRequest());
        if (shake == null) {
            request.response().putHeader((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION, (CharSequence)WebSocketVersion.V13.toHttpHeaderValue()).setStatusCode(HttpResponseStatus.UPGRADE_REQUIRED.code()).end();
        }
        return shake;
    }

    NetSocket createNetSocket() {
        final HashMap<Channel, 1> connectionMap = new HashMap<Channel, 1>(1);
        NetSocketImpl socket = new NetSocketImpl(this.vertx, this.chctx, this.context, this.sslHelper, this.metrics){

            @Override
            protected void handleClosed() {
                if (Http1xServerConnection.this.metrics != null) {
                    Http1xServerConnection.this.metrics.responseEnd(Http1xServerConnection.this.responseInProgress.metric(), Http1xServerConnection.this.responseInProgress.response());
                }
                connectionMap.remove(this.chctx.channel());
                super.handleClosed();
            }

            @Override
            public synchronized void handleMessage(Object msg) {
                if (msg instanceof HttpContent) {
                    ReferenceCountUtil.release((Object)msg);
                    return;
                }
                super.handleMessage(msg);
            }
        };
        socket.metric(this.metric());
        connectionMap.put(this.chctx.channel(), socket);
        this.endReadAndFlush();
        ChannelPipeline pipeline = this.chctx.pipeline();
        ChannelHandler compressor = pipeline.get(HttpChunkContentCompressor.class);
        if (compressor != null) {
            pipeline.remove(compressor);
        }
        pipeline.remove("httpDecoder");
        if (pipeline.get("chunkedWriter") != null) {
            pipeline.remove("chunkedWriter");
        }
        this.chctx.pipeline().replace("handler", "handler", VertxHandler.create(socket));
        this.chctx.pipeline().remove("httpEncoder");
        return socket;
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.responseInProgress != null) {
                this.responseInProgress.response().handleDrained();
            } else if (this.ws != null) {
                this.ws.handleDrained();
            }
        }
    }

    @Override
    public void close() {
        if (this.ws == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.chctx.writeAndFlush((Object)new CloseWebSocketFrame(true, 0, 1000, null)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    @Override
    public void closeWithPayload(ByteBuf byteBuf) {
        if (this.ws == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.chctx.writeAndFlush((Object)new CloseWebSocketFrame(true, 0, byteBuf)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    void write100Continue() {
        this.chctx.writeAndFlush((Object)new DefaultFullHttpResponse(io.netty.handler.codec.http.HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleClosed() {
        HttpServerRequestImpl responseInProgress;
        HttpServerRequestImpl requestInProgress;
        ServerWebSocketImpl ws;
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = this.ws;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null && ws != null) {
                this.metrics.disconnected(ws.getMetric());
                ws.setMetric(null);
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(CLOSED_EXCEPTION);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(CLOSED_EXCEPTION);
        }
        if (ws != null) {
            ws.handleClosed();
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleException(Throwable t) {
        HttpServerRequestImpl responseInProgress;
        HttpServerRequestImpl requestInProgress;
        ServerWebSocketImpl ws;
        super.handleException(t);
        Http1xServerConnection http1xServerConnection = this;
        synchronized (http1xServerConnection) {
            ws = this.ws;
            requestInProgress = this.requestInProgress;
            responseInProgress = this.responseInProgress;
            if (Metrics.METRICS_ENABLED && this.metrics != null) {
                this.requestFailed = true;
            }
        }
        if (requestInProgress != null) {
            requestInProgress.handleException(t);
        }
        if (responseInProgress != null && responseInProgress != requestInProgress) {
            responseInProgress.handleException(t);
        }
        if (ws != null) {
            ws.handleException(t);
        }
    }

    @Override
    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        super.addFuture(completionHandler, future);
    }

    @Override
    protected boolean supportsFileRegion() {
        return super.supportsFileRegion() && this.chctx.pipeline().get(HttpChunkContentCompressor.class) == null;
    }

    @Override
    protected ChannelFuture sendFile(RandomAccessFile file, long offset, long length) throws IOException {
        return super.sendFile(file, offset, length);
    }

    private void handleError(HttpObject obj) {
        DecoderResult result = obj.decoderResult();
        Throwable cause = result.cause();
        if (cause instanceof TooLongFrameException) {
            String causeMsg = cause.getMessage();
            io.netty.handler.codec.http.HttpVersion version = obj instanceof HttpRequest ? ((HttpRequest)obj).protocolVersion() : (this.requestInProgress != null ? (this.requestInProgress.version() == HttpVersion.HTTP_1_0 ? io.netty.handler.codec.http.HttpVersion.HTTP_1_0 : io.netty.handler.codec.http.HttpVersion.HTTP_1_1) : io.netty.handler.codec.http.HttpVersion.HTTP_1_1);
            HttpResponseStatus status = causeMsg.startsWith("An HTTP line is larger than") ? HttpResponseStatus.REQUEST_URI_TOO_LONG : HttpResponseStatus.BAD_REQUEST;
            DefaultFullHttpResponse resp = new DefaultFullHttpResponse(version, status);
            ChannelPromise fut = this.chctx.newPromise();
            this.writeToChannel(resp, fut);
            fut.addListener(res -> this.fail(result.cause()));
        } else {
            this.fail(result.cause());
        }
    }

    private long getBytes(Object obj) {
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Buffer) {
            return ((Buffer)obj).length();
        }
        if (obj instanceof ByteBuf) {
            return ((ByteBuf)obj).readableBytes();
        }
        if (obj instanceof HttpContent) {
            return ((HttpContent)obj).content().readableBytes();
        }
        if (obj instanceof WebSocketFrame) {
            return ((WebSocketFrame)obj).content().readableBytes();
        }
        if (obj instanceof FileRegion) {
            return ((FileRegion)obj).count();
        }
        if (obj instanceof ChunkedFile) {
            ChunkedFile file = (ChunkedFile)obj;
            return file.endOffset() - file.startOffset();
        }
        return -1L;
    }

    private static Handler<HttpServerRequest> requestHandler(HttpHandlers handler) {
        if (handler.connectionHandler != null) {
            class Adapter
            implements Handler<HttpServerRequest> {
                private boolean isFirst = true;
                final /* synthetic */ HttpHandlers val$handler;

                Adapter(HttpHandlers httpHandlers) {
                    this.val$handler = httpHandlers;
                }

                @Override
                public void handle(HttpServerRequest request) {
                    if (this.isFirst) {
                        this.isFirst = false;
                        this.val$handler.connectionHandler.handle(request.connection());
                    }
                    this.val$handler.requestHandler.handle(request);
                }
            }
            return new Adapter(handler);
        }
        return handler.requestHandler;
    }
}

