/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.HttpChannelConnector;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.pool.Pool;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.LongSupplier;

class ConnectionManager {
    private static final LongSupplier CLOCK = System::currentTimeMillis;
    private final int maxWaitQueueSize;
    private final HttpClientMetrics metrics;
    private final HttpClientImpl client;
    private final Map<Channel, HttpClientConnection> connectionMap = new ConcurrentHashMap<Channel, HttpClientConnection>();
    private final Map<EndpointKey, Endpoint> endpointMap = new ConcurrentHashMap<EndpointKey, Endpoint>();
    private final HttpVersion version;
    private final long maxSize;
    private long timerID;

    ConnectionManager(HttpClientImpl client, HttpClientMetrics metrics, HttpVersion version, long maxSize, int maxWaitQueueSize) {
        this.client = client;
        this.maxWaitQueueSize = maxWaitQueueSize;
        this.metrics = metrics;
        this.maxSize = maxSize;
        this.version = version;
    }

    synchronized void start() {
        long period = this.client.getOptions().getPoolCleanerPeriod();
        this.timerID = period > 0L ? this.client.getVertx().setTimer(period, id -> this.checkExpired(period)) : -1L;
    }

    private synchronized void checkExpired(long period) {
        this.endpointMap.values().forEach(e -> ((Endpoint)e).pool.closeIdle());
        this.timerID = this.client.getVertx().setTimer(period, id -> this.checkExpired(period));
    }

    void getConnection(ContextInternal ctx, SocketAddress peerAddress, boolean ssl, SocketAddress server, Handler<AsyncResult<HttpClientConnection>> handler) {
        Object metric;
        Endpoint endpoint;
        EndpointKey key = new EndpointKey(ssl, server, peerAddress);
        do {
            endpoint = this.endpointMap.computeIfAbsent(key, targetAddress -> {
                int port;
                String host;
                int maxPoolSize = Math.max(this.client.getOptions().getMaxPoolSize(), this.client.getOptions().getHttp2MaxPoolSize());
                if (server.path() == null) {
                    host = server.host();
                    port = server.port();
                } else {
                    host = server.path();
                    port = 0;
                }
                Object metric = this.metrics != null ? this.metrics.createEndpoint(host, port, maxPoolSize) : null;
                HttpChannelConnector connector = new HttpChannelConnector(this.client, metric, this.version, ssl, peerAddress, server);
                Pool<HttpClientConnection> pool = new Pool<HttpClientConnection>(ctx, connector, CLOCK, this.maxWaitQueueSize, connector.weight(), this.maxSize, v -> {
                    if (this.metrics != null) {
                        this.metrics.closeEndpoint(host, port, metric);
                    }
                    this.endpointMap.remove(key);
                }, conn -> this.connectionMap.put(conn.channel(), (HttpClientConnection)conn), conn -> this.connectionMap.remove(conn.channel(), conn), false);
                return new Endpoint(pool, metric);
            });
            metric = this.metrics != null ? this.metrics.enqueueRequest(endpoint.metric) : null;
        } while (!endpoint.pool.getConnection(ar -> {
            if (ar.succeeded()) {
                HttpClientConnection conn = (HttpClientConnection)ar.result();
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(endpoint.metric, metric);
                }
                handler.handle(Future.succeededFuture(conn));
            } else {
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(endpoint.metric, metric);
                }
                handler.handle(Future.failedFuture(ar.cause()));
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (this.timerID >= 0L) {
                this.client.getVertx().cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        this.endpointMap.clear();
        for (HttpClientConnection conn : this.connectionMap.values()) {
            conn.close();
        }
    }

    class Endpoint {
        private final Pool<HttpClientConnection> pool;
        private final Object metric;

        public Endpoint(Pool<HttpClientConnection> pool, Object metric) {
            this.pool = pool;
            this.metric = metric;
        }
    }

    private static final class EndpointKey {
        private final boolean ssl;
        private final SocketAddress server;
        private final SocketAddress peerAddress;

        EndpointKey(boolean ssl, SocketAddress server, SocketAddress peerAddress) {
            if (server == null) {
                throw new NullPointerException("No null host");
            }
            if (peerAddress == null) {
                throw new NullPointerException("No null peer address");
            }
            this.ssl = ssl;
            this.peerAddress = peerAddress;
            this.server = server;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointKey that = (EndpointKey)o;
            return this.ssl == that.ssl && this.server.equals(that.server) && this.peerAddress.equals(that.peerAddress);
        }

        public int hashCode() {
            int result = this.ssl ? 1 : 0;
            result = 31 * result + this.peerAddress.hashCode();
            result = 31 * result + this.server.hashCode();
            return result;
        }
    }
}

