/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http;

import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.Cookie;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.StreamPriority;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.Set;

@VertxGen
public interface HttpServerResponse
extends WriteStream<Buffer> {
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> var1);

    public HttpServerResponse setWriteQueueMaxSize(int var1);

    public HttpServerResponse drainHandler(Handler<Void> var1);

    public int getStatusCode();

    @Fluent
    public HttpServerResponse setStatusCode(int var1);

    public String getStatusMessage();

    @Fluent
    public HttpServerResponse setStatusMessage(String var1);

    @Fluent
    public HttpServerResponse setChunked(boolean var1);

    public boolean isChunked();

    @CacheReturn
    public MultiMap headers();

    @Fluent
    public HttpServerResponse putHeader(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putHeader(CharSequence var1, Iterable<CharSequence> var2);

    @CacheReturn
    public MultiMap trailers();

    @Fluent
    public HttpServerResponse putTrailer(String var1, String var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(CharSequence var1, CharSequence var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(String var1, Iterable<String> var2);

    @GenIgnore(value={"permitted-type"})
    @Fluent
    public HttpServerResponse putTrailer(CharSequence var1, Iterable<CharSequence> var2);

    @Fluent
    public HttpServerResponse closeHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpServerResponse endHandler(@Nullable Handler<Void> var1);

    public Future<Void> writeHead();

    public Future<Void> write(String var1, String var2);

    @Override
    public Future<Void> write(String var1);

    public Future<Void> writeContinue();

    public Future<Void> writeEarlyHints(MultiMap var1);

    @Override
    public Future<Void> end(String var1);

    public Future<Void> end(String var1, String var2);

    @Override
    public Future<Void> end(Buffer var1);

    @Override
    public Future<Void> end();

    default public Future<Void> send() {
        return this.end();
    }

    default public Future<Void> send(String body) {
        return this.end(body);
    }

    default public Future<Void> send(Buffer body) {
        return this.end(body);
    }

    default public Future<Void> send(ReadStream<Buffer> body) {
        MultiMap headers = this.headers();
        if (headers == null || !headers.contains(HttpHeaders.CONTENT_LENGTH)) {
            this.setChunked(true);
        }
        return body.pipeTo(this);
    }

    default public Future<Void> sendFile(String filename) {
        return this.sendFile(filename, 0L);
    }

    default public Future<Void> sendFile(String filename, long offset) {
        return this.sendFile(filename, offset, Long.MAX_VALUE);
    }

    public Future<Void> sendFile(String var1, long var2, long var4);

    @GenIgnore(value={"permitted-type"})
    default public Future<Void> sendFile(FileChannel channel) {
        return this.sendFile(channel, 0L);
    }

    @GenIgnore(value={"permitted-type"})
    default public Future<Void> sendFile(FileChannel channel, long offset) {
        return this.sendFile(channel, offset, Long.MAX_VALUE);
    }

    @GenIgnore(value={"permitted-type"})
    public Future<Void> sendFile(FileChannel var1, long var2, long var4);

    @GenIgnore(value={"permitted-type"})
    default public Future<Void> sendFile(RandomAccessFile file) {
        return this.sendFile(file, 0L);
    }

    @GenIgnore(value={"permitted-type"})
    default public Future<Void> sendFile(RandomAccessFile file, long offset) {
        return this.sendFile(file, offset, Long.MAX_VALUE);
    }

    @GenIgnore(value={"permitted-type"})
    public Future<Void> sendFile(RandomAccessFile var1, long var2, long var4);

    public boolean ended();

    public boolean closed();

    public boolean headWritten();

    @Fluent
    public HttpServerResponse headersEndHandler(@Nullable Handler<Void> var1);

    @Fluent
    public HttpServerResponse bodyEndHandler(@Nullable Handler<Void> var1);

    public long bytesWritten();

    public int streamId();

    default public Future<HttpServerResponse> push(HttpMethod method, HostAndPort authority, String path) {
        return this.push(method, authority, path, null);
    }

    default public Future<HttpServerResponse> push(HttpMethod method, String path, MultiMap headers) {
        return this.push(method, null, path, headers);
    }

    default public Future<HttpServerResponse> push(HttpMethod method, String path) {
        return this.push(method, null, path);
    }

    public Future<HttpServerResponse> push(HttpMethod var1, HostAndPort var2, String var3, MultiMap var4);

    default public Future<Void> reset() {
        return this.reset(0L);
    }

    public Future<Void> reset(long var1);

    public Future<Void> writeCustomFrame(int var1, int var2, Buffer var3);

    default public Future<Void> writeCustomFrame(HttpFrame frame) {
        return this.writeCustomFrame(frame.type(), frame.flags(), frame.payload());
    }

    @Fluent
    default public HttpServerResponse setStreamPriority(StreamPriority streamPriority) {
        return this;
    }

    @Fluent
    public HttpServerResponse addCookie(Cookie var1);

    default public @Nullable Cookie removeCookie(String name) {
        return this.removeCookie(name, true);
    }

    public @Nullable Cookie removeCookie(String var1, boolean var2);

    default public Set<Cookie> removeCookies(String name) {
        return this.removeCookies(name, true);
    }

    public Set<Cookie> removeCookies(String var1, boolean var2);

    default public @Nullable Cookie removeCookie(String name, String domain, String path) {
        return this.removeCookie(name, domain, path, true);
    }

    public @Nullable Cookie removeCookie(String var1, String var2, String var3, boolean var4);
}

