/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.Completable;
import io.vertx.core.Future;
import io.vertx.core.http.HttpClientConnection;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnectOptions;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.http.HttpClientInternal;
import io.vertx.core.internal.net.NetClientInternal;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.core.spi.metrics.Metrics;
import java.lang.ref.Cleaner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;

public class CleanableHttpClient
implements HttpClientInternal {
    public final HttpClientInternal delegate;
    private final Cleaner.Cleanable cleanable;
    private final Action action;

    public CleanableHttpClient(HttpClientInternal delegate, Cleaner cleaner, BiFunction<Long, TimeUnit, Future<Void>> dispose) {
        this.action = new Action(dispose);
        this.delegate = delegate;
        this.cleanable = cleaner.register(this, this.action);
    }

    @Override
    public Future<HttpClientRequest> request(RequestOptions options) {
        return this.delegate.request(options);
    }

    @Override
    public Future<Boolean> updateSSLOptions(ClientSSLOptions options, boolean force) {
        return this.delegate.updateSSLOptions(options, force);
    }

    @Override
    public Future<Void> shutdown(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException();
        }
        if (unit == null) {
            throw new IllegalArgumentException();
        }
        this.action.timeout = timeout;
        this.action.timeUnit = unit;
        this.cleanable.clean();
        return this.action.closeFuture;
    }

    @Override
    public VertxInternal vertx() {
        return this.delegate.vertx();
    }

    @Override
    public HttpClientOptions options() {
        return this.delegate.options();
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.delegate.isMetricsEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        return this.delegate.redirectHandler();
    }

    @Override
    public NetClientInternal netClient() {
        return this.delegate.netClient();
    }

    @Override
    public Future<Void> closeFuture() {
        return this.delegate.closeFuture();
    }

    @Override
    public void close(Completable<Void> completion) {
        this.delegate.close(completion);
    }

    @Override
    public Future<HttpClientConnection> connect(HttpConnectOptions options) {
        return this.delegate.connect(options);
    }

    static class Action
    implements Runnable {
        private final BiFunction<Long, TimeUnit, Future<Void>> dispose;
        private long timeout = 30L;
        private TimeUnit timeUnit = TimeUnit.SECONDS;
        private Future<Void> closeFuture;

        private Action(BiFunction<Long, TimeUnit, Future<Void>> dispose) {
            this.dispose = dispose;
        }

        @Override
        public void run() {
            this.closeFuture = this.dispose.apply(this.timeout, this.timeUnit);
        }
    }
}

