/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TCPSSLOptions;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TCPSSLOptionsConverter {
    static void fromJson(Iterable<Map.Entry<String, Object>> json, TCPSSLOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "tcpNoDelay": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpNoDelay((Boolean)member.getValue());
                    break;
                }
                case "tcpKeepAlive": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpKeepAlive((Boolean)member.getValue());
                    break;
                }
                case "soLinger": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSoLinger(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "readIdleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setReadIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "writeIdleTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setWriteIdleTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "idleTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setIdleTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                    break;
                }
                case "ssl": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setSsl((Boolean)member.getValue());
                    break;
                }
                case "enabledCipherSuites": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addEnabledCipherSuite((String)item);
                        }
                    });
                    break;
                }
                case "crlPaths": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCrlPath((String)item);
                        }
                    });
                    break;
                }
                case "crlValues": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            obj.addCrlValue(Buffer.fromJson((String)item));
                        }
                    });
                    break;
                }
                case "useAlpn": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setUseAlpn((Boolean)member.getValue());
                    break;
                }
                case "enabledSecureTransportProtocols": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    LinkedHashSet<String> list = new LinkedHashSet<String>();
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof String) {
                            list.add((String)item);
                        }
                    });
                    obj.setEnabledSecureTransportProtocols(list);
                    break;
                }
                case "tcpFastOpen": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpFastOpen((Boolean)member.getValue());
                    break;
                }
                case "tcpCork": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpCork((Boolean)member.getValue());
                    break;
                }
                case "tcpQuickAck": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setTcpQuickAck((Boolean)member.getValue());
                    break;
                }
                case "tcpUserTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setTcpUserTimeout(((Number)member.getValue()).intValue());
                    break;
                }
                case "sslHandshakeTimeout": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSslHandshakeTimeout(((Number)member.getValue()).longValue());
                    break;
                }
                case "sslHandshakeTimeoutUnit": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setSslHandshakeTimeoutUnit(TimeUnit.valueOf((String)member.getValue()));
                }
            }
        }
    }

    static void toJson(TCPSSLOptions obj, JsonObject json) {
        TCPSSLOptionsConverter.toJson(obj, json.getMap());
    }

    static void toJson(TCPSSLOptions obj, Map<String, Object> json) {
        JsonArray array;
        json.put("tcpNoDelay", obj.isTcpNoDelay());
        json.put("tcpKeepAlive", obj.isTcpKeepAlive());
        json.put("soLinger", obj.getSoLinger());
        json.put("idleTimeout", obj.getIdleTimeout());
        json.put("readIdleTimeout", obj.getReadIdleTimeout());
        json.put("writeIdleTimeout", obj.getWriteIdleTimeout());
        if (obj.getIdleTimeoutUnit() != null) {
            json.put("idleTimeoutUnit", obj.getIdleTimeoutUnit().name());
        }
        json.put("ssl", obj.isSsl());
        if (obj.getEnabledCipherSuites() != null) {
            array = new JsonArray();
            obj.getEnabledCipherSuites().forEach(item -> array.add(item));
            json.put("enabledCipherSuites", array);
        }
        if (obj.getCrlPaths() != null) {
            array = new JsonArray();
            obj.getCrlPaths().forEach(item -> array.add(item));
            json.put("crlPaths", array);
        }
        if (obj.getCrlValues() != null) {
            array = new JsonArray();
            obj.getCrlValues().forEach(item -> array.add(item.toJson()));
            json.put("crlValues", array);
        }
        json.put("useAlpn", obj.isUseAlpn());
        if (obj.getEnabledSecureTransportProtocols() != null) {
            array = new JsonArray();
            obj.getEnabledSecureTransportProtocols().forEach(item -> array.add(item));
            json.put("enabledSecureTransportProtocols", array);
        }
        json.put("tcpFastOpen", obj.isTcpFastOpen());
        json.put("tcpCork", obj.isTcpCork());
        json.put("tcpQuickAck", obj.isTcpQuickAck());
        json.put("tcpUserTimeout", obj.getTcpUserTimeout());
        json.put("sslHandshakeTimeout", obj.getSslHandshakeTimeout());
        if (obj.getSslHandshakeTimeoutUnit() != null) {
            json.put("sslHandshakeTimeoutUnit", obj.getSslHandshakeTimeoutUnit().name());
        }
    }
}

