/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.VertxException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.internal.net.SslHandshakeCompletionHandler;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.DelegatingChannelPromise;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;

public abstract class ConnectionBase {
    private static final long METRICS_REPORTED_BYTES_LOW_MASK = 4095L;
    private static final long METRICS_REPORTED_BYTES_HIGH_MASK = -4096L;
    public static final VertxException CLOSED_EXCEPTION = NetSocketInternal.CLOSED_EXCEPTION;
    public static final AttributeKey<SocketAddress> REMOTE_ADDRESS_OVERRIDE = AttributeKey.valueOf((String)"RemoteAddressOverride");
    public static final AttributeKey<SocketAddress> LOCAL_ADDRESS_OVERRIDE = AttributeKey.valueOf((String)"LocalAddressOverride");
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    protected final VertxInternal vertx;
    protected final ChannelHandlerContext chctx;
    protected final Channel channel;
    protected final ContextInternal context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Object metric;
    private SocketAddress remoteAddress;
    private SocketAddress realRemoteAddress;
    private SocketAddress localAddress;
    private SocketAddress realLocalAddress;
    private Future<Void> closeFuture;
    private long remainingBytesRead;
    private long remainingBytesWritten;
    private ChannelPromise closeInitiated;
    private boolean closeFinished;

    protected ConnectionBase(ContextInternal context, ChannelHandlerContext chctx) {
        PromiseInternal<Void> f = context.promise();
        chctx.channel().closeFuture().addListener(f);
        this.vertx = context.owner();
        this.chctx = chctx;
        this.channel = chctx.channel();
        this.context = context;
        this.closeFuture = f;
    }

    public Future<Void> closeFuture() {
        return this.closeFuture;
    }

    public void fail(Throwable error) {
        this.chctx.pipeline().fireExceptionCaught(error);
    }

    protected final ChannelPromise wrap(FutureListener<Void> handler) {
        ChannelPromise promise = this.chctx.newPromise();
        promise.addListener(handler);
        return promise;
    }

    public final Future<Void> close() {
        return this.close((Object)null);
    }

    public final Future<Void> close(Object reason) {
        return this.close(reason, 0L, TimeUnit.SECONDS);
    }

    public final Future<Void> close(Object reason, long timeout, TimeUnit unit) {
        EventExecutor exec = this.chctx.executor();
        CloseChannelPromise promise = new CloseChannelPromise(this.channel, reason, timeout, unit);
        if (exec.inEventLoop()) {
            this.close(promise);
        } else {
            exec.execute(() -> this.close(promise));
        }
        PromiseInternal p = this.context.promise();
        promise.addListener((GenericFutureListener)p);
        return p.future();
    }

    private void close(CloseChannelPromise promise) {
        this.channel.close((ChannelPromise)promise);
    }

    final void handleClose(ChannelPromise promise) {
        if (this.closeInitiated != null) {
            Object closeReason;
            long timeout;
            if (promise instanceof CloseChannelPromise) {
                timeout = ((CloseChannelPromise)promise).timeout;
                closeReason = ((CloseChannelPromise)promise).reason;
            } else {
                timeout = 0L;
                closeReason = null;
            }
            if (timeout == 0L && !this.closeFinished) {
                this.closeFinished = true;
                this.closeInitiated = promise;
                this.handleClose(closeReason, promise);
            } else {
                this.channel.closeFuture().addListener(future -> {
                    if (future.isSuccess()) {
                        promise.setSuccess();
                    } else {
                        promise.setFailure(future.cause());
                    }
                });
            }
        } else {
            this.closeInitiated = promise;
            if (promise instanceof CloseChannelPromise) {
                CloseChannelPromise closeChannelPromise = (CloseChannelPromise)promise;
                this.handleClose(closeChannelPromise.reason, closeChannelPromise.timeout, closeChannelPromise.unit, promise);
            } else {
                this.handleClose(null, 0L, TimeUnit.SECONDS, promise);
            }
        }
    }

    void handleClose(Object reason, long timeout, TimeUnit unit, ChannelPromise promise) {
        if (this.closeFinished) {
            return;
        }
        this.closeFinished = true;
        this.handleClose(reason, promise);
    }

    protected void handleClose(Object reason, ChannelPromise promise) {
        this.chctx.close(promise);
    }

    public synchronized ConnectionBase closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    public synchronized ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public final Channel channel() {
        return this.channel;
    }

    public final ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    public final ContextInternal context() {
        return this.context;
    }

    public final synchronized void metric(Object metric) {
        this.metric = metric;
    }

    public final synchronized Object metric() {
        return this.metric;
    }

    public NetworkMetrics metrics() {
        return null;
    }

    protected void handleException(Throwable t) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            metrics.exceptionOccurred(this.metric, this.remoteAddress(), t);
        }
        this.context.execute(t, err -> {
            Handler<Throwable> handler;
            ConnectionBase connectionBase = this;
            synchronized (connectionBase) {
                handler = this.exceptionHandler;
            }
            if (handler != null) {
                this.context.dispatch(err, handler);
            } else if (log.isDebugEnabled()) {
                log.error((Object)t.getMessage(), t);
            } else {
                log.error((Object)t.getMessage());
            }
        });
    }

    protected void handleClosed() {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            this.flushBytesRead();
            this.flushBytesWritten();
            if (metrics instanceof TCPMetrics) {
                ((TCPMetrics)metrics).disconnected(this.metric(), this.remoteAddress());
            }
        }
        this.context.execute(() -> {
            Handler<Void> handler;
            ConnectionBase connectionBase = this;
            synchronized (connectionBase) {
                handler = this.closeHandler;
            }
            if (handler != null) {
                this.context.dispatch(handler);
            }
        });
    }

    public final void reportBytesRead(Object msg) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            this.doReportBytesRead(msg, metrics);
        }
    }

    private void doReportBytesRead(Object msg, NetworkMetrics metrics) {
        long bytes = this.remainingBytesRead;
        long numberOfBytes = this.sizeof(msg);
        long val = (bytes += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
        if (val > 0L) {
            bytes &= 0xFFFL;
            metrics.bytesRead(this.metric(), this.remoteAddress(), val);
        }
        this.remainingBytesRead = bytes;
    }

    protected long sizeof(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        return 0L;
    }

    public final void reportBytesRead(long numberOfBytes) {
        if (numberOfBytes < 0L) {
            throw new IllegalArgumentException();
        }
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            long bytes = this.remainingBytesRead;
            long val = (bytes += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
            if (val > 0L) {
                bytes &= 0xFFFL;
                metrics.bytesRead(this.metric(), this.remoteAddress(), val);
            }
            this.remainingBytesRead = bytes;
        }
    }

    public final void reportsBytesWritten(Object msg) {
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            long numberOfBytes = this.sizeof(msg);
            long bytes = this.remainingBytesWritten;
            long val = (bytes += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
            if (val > 0L) {
                bytes &= 0xFFFL;
                metrics.bytesWritten(this.metric, this.remoteAddress(), val);
            }
            this.remainingBytesWritten = bytes;
        }
    }

    public final void reportBytesWritten(long numberOfBytes) {
        if (numberOfBytes < 0L) {
            throw new IllegalArgumentException();
        }
        NetworkMetrics metrics = this.metrics();
        if (metrics != null) {
            long bytes = this.remainingBytesWritten;
            long val = (bytes += numberOfBytes) & 0xFFFFFFFFFFFFF000L;
            if (val > 0L) {
                bytes &= 0xFFFL;
                metrics.bytesWritten(this.metric, this.remoteAddress(), val);
            }
            this.remainingBytesWritten = bytes;
        }
    }

    public void flushBytesRead() {
        long val;
        NetworkMetrics metrics = this.metrics();
        if (metrics != null && (val = this.remainingBytesRead) > 0L) {
            this.remainingBytesRead = 0L;
            metrics.bytesRead(this.metric(), this.remoteAddress(), val);
        }
    }

    public void flushBytesWritten() {
        long val;
        NetworkMetrics metrics = this.metrics();
        if (metrics != null && (val = this.remainingBytesWritten) > 0L) {
            this.remainingBytesWritten = 0L;
            metrics.bytesWritten(this.metric(), this.remoteAddress(), val);
        }
    }

    public boolean isSsl() {
        return this.chctx.pipeline().get(SslHandler.class) != null;
    }

    public boolean isTrafficShaped() {
        return this.chctx.pipeline().get(AbstractTrafficShapingHandler.class) != null;
    }

    public SSLSession sslSession() {
        ChannelHandlerContext sslHandlerContext = this.chctx.pipeline().context(SslHandler.class);
        if (sslHandlerContext != null) {
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession();
        }
        return null;
    }

    public List<Certificate> peerCertificates() throws SSLPeerUnverifiedException {
        SSLSession session = this.sslSession();
        if (session != null) {
            return Arrays.asList(session.getPeerCertificates());
        }
        return null;
    }

    public String indicatedServerName() {
        if (this.channel.hasAttr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR)) {
            return (String)this.channel.attr(SslHandshakeCompletionHandler.SERVER_NAME_ATTR).get();
        }
        return null;
    }

    public ChannelPromise newChannelPromise() {
        return this.chctx.newPromise();
    }

    public ChannelPromise newChannelPromise(Promise<Void> promise) {
        return new DelegatingChannelPromise(promise, this.channel);
    }

    public String remoteName() {
        java.net.SocketAddress addr = this.channel.remoteAddress();
        if (addr instanceof InetSocketAddress) {
            return ((InetSocketAddress)addr).getHostString();
        }
        return null;
    }

    private SocketAddress channelRemoteAddress() {
        java.net.SocketAddress addr = this.channel.remoteAddress();
        return addr != null ? this.vertx.transport().convert(addr) : null;
    }

    private SocketAddress socketAdressOverride(AttributeKey<SocketAddress> key) {
        return this.channel.hasAttr(key) ? (SocketAddress)this.channel.attr(key).getAndSet(null) : null;
    }

    public SocketAddress remoteAddress() {
        SocketAddress address = this.remoteAddress;
        if (address == null) {
            address = this.socketAdressOverride(REMOTE_ADDRESS_OVERRIDE);
            if (address == null && (address = this.channelRemoteAddress()) != null && address.isDomainSocket() && address.path().isEmpty()) {
                address = this.channelLocalAddress();
            }
            if (address != null) {
                this.remoteAddress = address;
            }
        }
        return address;
    }

    public SocketAddress remoteAddress(boolean real) {
        if (real) {
            SocketAddress address = this.realRemoteAddress;
            if (address == null) {
                address = this.channelRemoteAddress();
            }
            if (address != null) {
                this.realRemoteAddress = address;
            }
            return address;
        }
        return this.remoteAddress();
    }

    private SocketAddress channelLocalAddress() {
        java.net.SocketAddress addr = this.channel.localAddress();
        return addr != null ? this.vertx.transport().convert(addr) : null;
    }

    public SocketAddress localAddress() {
        SocketAddress address = this.localAddress;
        if (address == null) {
            address = this.socketAdressOverride(LOCAL_ADDRESS_OVERRIDE);
            if (address == null && (address = this.channelLocalAddress()) != null && address.isDomainSocket() && address.path().isEmpty()) {
                address = this.channelRemoteAddress();
            }
            if (address != null) {
                this.localAddress = address;
            }
        }
        return address;
    }

    public SocketAddress localAddress(boolean real) {
        if (real) {
            SocketAddress address = this.realLocalAddress;
            if (address == null) {
                address = this.channelLocalAddress();
            }
            if (address != null) {
                this.realLocalAddress = address;
            }
            return address;
        }
        return this.localAddress();
    }

    static class CloseChannelPromise
    extends DefaultChannelPromise {
        final Object reason;
        final long timeout;
        final TimeUnit unit;

        public CloseChannelPromise(Channel channel, Object reason, long timeout, TimeUnit unit) {
            super(channel);
            this.reason = reason;
            this.timeout = timeout;
            this.unit = unit;
        }
    }
}

