/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyFailure;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.Matcher;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class EventBusMetricsImpl
extends AbstractMetrics
implements EventBusMetrics<HandlerMetric> {
    private final HandlerMetric ignoredHandler = new HandlerMetric(null, false, true);
    private final HandlerMetric noMatchHandler = new HandlerMetric(null, true, false);
    private final ConcurrentMap<String, HandlerCounter> handlerTimers = new ConcurrentHashMap<String, HandlerCounter>();
    private final Matcher handlerMatcher;
    private final Counter handlerCount = this.counter("handlers");
    private final Counter pending = this.counter("messages", "pending");
    private final Counter pendingLocal = this.counter("messages", "pending-local");
    private final Counter pendingRemote = this.counter("messages", "pending-remote");
    private final Counter discarded = this.counter("messages", "discarded");
    private final Counter discardedLocal = this.counter("messages", "discarded-local");
    private final Counter discardedRemote = this.counter("messages", "discarded-remote");
    private final Meter bytesRead;
    private final Meter bytesWritten;
    private final ThroughputMeter receivedMessages = this.throughputMeter("messages", "received");
    private final ThroughputMeter receivedLocalMessages = this.throughputMeter("messages", "received-local");
    private final ThroughputMeter receivedRemoteMessages = this.throughputMeter("messages", "received-remote");
    private final ThroughputMeter sentMessages;
    private final ThroughputMeter sentLocalMessages;
    private final ThroughputMeter sentRemoteMessages;
    private final ThroughputMeter publishedMessages;
    private final ThroughputMeter publishedLocalMessages;
    private final ThroughputMeter publishedRemoteMessages;
    private final ThroughputMeter deliveredMessages = this.throughputMeter("messages", "delivered");
    private final ThroughputMeter deliveredLocalMessages = this.throughputMeter("messages", "delivered-local");
    private final ThroughputMeter deliveredRemoteMessages = this.throughputMeter("messages", "delivered-remote");
    private final Meter replyFailures;

    EventBusMetricsImpl(AbstractMetrics metrics, String baseName, DropwizardMetricsOptions options) {
        super(metrics.registry(), baseName);
        this.sentMessages = this.throughputMeter("messages", "sent");
        this.sentLocalMessages = this.throughputMeter("messages", "sent-local");
        this.sentRemoteMessages = this.throughputMeter("messages", "sent-remote");
        this.publishedMessages = this.throughputMeter("messages", "published");
        this.publishedLocalMessages = this.throughputMeter("messages", "published-local");
        this.publishedRemoteMessages = this.throughputMeter("messages", "published-remote");
        this.replyFailures = this.meter("messages", "reply-failures");
        this.bytesRead = this.meter("messages", "bytes-read");
        this.bytesWritten = this.meter("messages", "bytes-written");
        this.handlerMatcher = options.getMonitoredEventBusHandlers() == null ? null : new Matcher(options.getMonitoredEventBusHandlers());
    }

    private static boolean isInternal(String address) {
        return address.startsWith("__vertx.");
    }

    public void messageWritten(String address, int size) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            this.bytesWritten.mark((long)size);
        }
    }

    public void messageRead(String address, int size) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            this.bytesRead.mark((long)size);
        }
    }

    public void close() {
    }

    public HandlerMetric handlerRegistered(String address, String repliedAddress) {
        String match;
        if (EventBusMetricsImpl.isInternal(address)) {
            return this.ignoredHandler;
        }
        this.handlerCount.inc();
        if (this.handlerMatcher != null && (match = this.handlerMatcher.matches(address)) != null) {
            return new HandlerMetric(match, false, false);
        }
        return this.noMatchHandler;
    }

    public void handlerUnregistered(HandlerMetric handler) {
        if (handler.ignored) {
            return;
        }
        this.handlerCount.dec();
        if (!handler.noMatch) {
            handler.remove();
        }
    }

    public void scheduleMessage(HandlerMetric handler, boolean local) {
        if (handler.ignored) {
            return;
        }
        this.pending.inc();
        if (local) {
            this.pendingLocal.inc();
            if (!handler.noMatch) {
                ++handler.pendingLocalCount;
            }
        } else {
            this.pendingRemote.inc();
            if (!handler.noMatch) {
                ++handler.pendingRemoteCount;
            }
        }
    }

    public void discardMessage(HandlerMetric handler, boolean local, Message<?> msg) {
        if (handler.ignored) {
            return;
        }
        this.pending.dec();
        this.discarded.inc();
        if (local) {
            this.discardedLocal.inc();
            this.pendingLocal.dec();
            if (!handler.noMatch) {
                --handler.pendingLocalCount;
            }
        } else {
            this.discardedRemote.inc();
            this.pendingRemote.dec();
            if (!handler.noMatch) {
                --handler.pendingRemoteCount;
            }
        }
    }

    public void messageDelivered(HandlerMetric handler, boolean local) {
        if (handler.ignored) {
            return;
        }
        this.pending.dec();
        if (local) {
            this.pendingLocal.dec();
        } else {
            this.pendingRemote.dec();
        }
        if (!handler.noMatch) {
            if (local) {
                --handler.pendingLocalCount;
            } else {
                --handler.pendingRemoteCount;
            }
            handler.counter.inc();
        }
    }

    public void messageSent(String address, boolean publish, boolean local, boolean remote) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            if (publish) {
                this.publishedMessages.mark();
                if (local) {
                    this.publishedLocalMessages.mark();
                } else {
                    this.publishedRemoteMessages.mark();
                }
            } else {
                this.sentMessages.mark();
                if (local) {
                    this.sentLocalMessages.mark();
                } else {
                    this.sentRemoteMessages.mark();
                }
            }
        }
    }

    public void messageReceived(String address, boolean publish, boolean local, int handlers) {
        if (!EventBusMetricsImpl.isInternal(address)) {
            this.receivedMessages.mark();
            if (local) {
                this.receivedLocalMessages.mark();
            } else {
                this.receivedRemoteMessages.mark();
            }
            if (handlers > 0) {
                this.deliveredMessages.mark();
                if (local) {
                    this.deliveredLocalMessages.mark();
                } else {
                    this.deliveredRemoteMessages.mark();
                }
            }
        }
    }

    public void replyFailure(String address, ReplyFailure failure) {
        this.replyFailures.mark();
        this.meter("messages", "reply-failures", failure.name()).mark();
    }

    static class HandlerCounter {
        final int refCount;
        final Counter counter;

        public HandlerCounter(int refCount, Counter counter) {
            this.refCount = refCount;
            this.counter = counter;
        }

        public HandlerCounter() {
            this(1, new Counter());
        }

        HandlerCounter inc() {
            return new HandlerCounter(this.refCount + 1, this.counter);
        }

        HandlerCounter dec() {
            return new HandlerCounter(this.refCount - 1, this.counter);
        }

        public boolean equals(Object obj) {
            HandlerCounter that = (HandlerCounter)obj;
            return this.refCount == that.refCount;
        }
    }

    public class HandlerMetric {
        final String address;
        final Counter counter;
        final String name;
        final boolean noMatch;
        final boolean ignored;
        long pendingLocalCount;
        long pendingRemoteCount;

        public HandlerMetric(String address, boolean noMatch, boolean ignored) {
            block3: {
                HandlerCounter created;
                this.address = address;
                this.noMatch = noMatch;
                this.ignored = ignored;
                if (noMatch || ignored) {
                    this.counter = null;
                    this.name = null;
                    return;
                }
                this.name = EventBusMetricsImpl.this.nameOf("handlers", address);
                while (true) {
                    HandlerCounter existing;
                    if ((existing = (HandlerCounter)EventBusMetricsImpl.this.handlerTimers.get(address)) != null) {
                        HandlerCounter next = existing.inc();
                        if (!EventBusMetricsImpl.this.handlerTimers.replace(address, existing, next)) continue;
                        this.counter = next.counter;
                        break block3;
                    }
                    created = new HandlerCounter();
                    if (EventBusMetricsImpl.this.handlerTimers.putIfAbsent(address, created) == null) break;
                }
                EventBusMetricsImpl.this.registry.register(this.name, (Metric)created.counter);
                this.counter = created.counter;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void remove() {
            if (this.noMatch || this.ignored) return;
            while (true) {
                HandlerCounter existing = (HandlerCounter)EventBusMetricsImpl.this.handlerTimers.get(this.address);
                HandlerCounter next = existing.dec();
                if (next.refCount == 0) {
                    if (!EventBusMetricsImpl.this.handlerTimers.remove(this.address, existing)) continue;
                    EventBusMetricsImpl.this.registry.remove(this.name);
                    return;
                }
                if (EventBusMetricsImpl.this.handlerTimers.replace(this.address, existing, next)) return;
            }
        }
    }
}

