/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.httpproxy.Body;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.impl.ParseUtils;
import java.time.Instant;

class Resource {
    final String absoluteUri;
    final int statusCode;
    final String statusMessage;
    final MultiMap headers;
    final long timestamp;
    final long maxAge;
    final Instant lastModified;
    final String etag;
    final Buffer content = Buffer.buffer();

    Resource(String absoluteUri, int statusCode, String statusMessage, MultiMap headers, long timestamp, long maxAge) {
        String lastModifiedHeader = headers.get(HttpHeaders.LAST_MODIFIED);
        this.absoluteUri = absoluteUri;
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
        this.headers = headers;
        this.timestamp = timestamp;
        this.maxAge = maxAge;
        this.lastModified = lastModifiedHeader != null ? ParseUtils.parseHeaderDate(lastModifiedHeader) : null;
        this.etag = headers.get(HttpHeaders.ETAG);
    }

    void init(ProxyResponse proxyResponse) {
        proxyResponse.setStatusCode(200);
        proxyResponse.setStatusMessage(this.statusMessage);
        proxyResponse.headers().addAll(this.headers);
        proxyResponse.setBody(Body.body(this.content));
    }
}

