/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.parsetools.RecordParser;
import java.util.regex.Pattern;

class MultilineParser
implements Handler<Buffer> {
    private static final Pattern STATUS_LINE_CONTINUE = Pattern.compile("^\\d{3}-.*");
    private static final Logger log = LoggerFactory.getLogger(MultilineParser.class);
    private boolean initialized = false;
    private Buffer result;
    private RecordParser rp;

    public MultilineParser(final Handler<Buffer> output) {
        Handler<Buffer> mlp = new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                if (!MultilineParser.this.initialized) {
                    MultilineParser.this.initialized = true;
                    String line = buffer.toString();
                    if (line.endsWith("\r")) {
                        log.debug((Object)"setting crlf line mode");
                        MultilineParser.this.rp.delimitedMode("\r\n");
                        this.appendOrHandle(Buffer.buffer((String)line.substring(0, line.length() - 1)));
                    } else {
                        this.appendOrHandle(buffer);
                    }
                } else {
                    this.appendOrHandle(buffer);
                }
            }

            private void appendOrHandle(Buffer buffer) {
                if (MultilineParser.this.result == null) {
                    MultilineParser.this.result = buffer;
                } else {
                    MultilineParser.this.result.appendString("\n");
                    MultilineParser.this.result.appendBuffer(buffer);
                }
                if (this.isFinalLine(buffer)) {
                    output.handle((Object)MultilineParser.this.result);
                    MultilineParser.this.result = null;
                }
            }

            private boolean isFinalLine(Buffer buffer) {
                String line = buffer.toString();
                return !STATUS_LINE_CONTINUE.matcher(line).matches();
            }
        };
        this.rp = RecordParser.newDelimited((String)"\n", (Handler)mlp);
    }

    public void handle(Buffer event) {
        this.rp.handle(event);
    }
}

