/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.mailencoder;

import io.vertx.core.MultiMap;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.ext.mail.MailAttachment;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.mailencoder.AttachmentPart;
import io.vertx.ext.mail.mailencoder.EncodedPart;
import io.vertx.ext.mail.mailencoder.MultiPart;
import io.vertx.ext.mail.mailencoder.TextPart;
import io.vertx.ext.mail.mailencoder.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MailEncoder {
    private final MailMessage message;
    private final String hostname;
    private String messageID;

    public MailEncoder(MailMessage message, String hostname) {
        this.message = message;
        this.hostname = hostname;
    }

    public String encode() {
        EncodedPart completeMessage;
        String text = this.message.getText();
        String html = this.message.getHtml();
        EncodedPart mainPart = text != null && html != null ? new MultiPart(Arrays.asList(new TextPart(text, "plain"), this.htmlPart()), "alternative") : (text != null ? new TextPart(text, "plain") : (html != null ? this.htmlPart() : null));
        List<MailAttachment> attachments = this.message.getAttachment();
        if (attachments != null) {
            ArrayList<EncodedPart> parts = new ArrayList<EncodedPart>();
            if (mainPart != null) {
                parts.add(mainPart);
            }
            for (MailAttachment a : attachments) {
                parts.add(new AttachmentPart(a));
            }
            completeMessage = new MultiPart(parts, "mixed");
        } else {
            completeMessage = mainPart;
        }
        if (completeMessage == null) {
            completeMessage = new TextPart("", "plain");
        }
        completeMessage.headers = this.createHeaders(completeMessage.headers);
        return completeMessage.asString();
    }

    private EncodedPart htmlPart() {
        EncodedPart mainPart;
        if (this.message.getInlineAttachment() != null) {
            ArrayList<EncodedPart> parts = new ArrayList<EncodedPart>();
            parts.add(new TextPart(this.message.getHtml(), "html"));
            for (MailAttachment a : this.message.getInlineAttachment()) {
                parts.add(new AttachmentPart(a));
            }
            mainPart = new MultiPart(parts, "related");
        } else {
            mainPart = new TextPart(this.message.getHtml(), "html");
        }
        return mainPart;
    }

    private MultiMap createHeaders(MultiMap additionalHeaders) {
        MultiMap headersToSet;
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        if (!this.message.isFixedHeaders()) {
            headers.set("MIME-Version", "1.0");
            headers.set("Message-ID", Utils.generateMessageID(this.hostname));
            headers.set("Date", Utils.generateDate());
            if (this.message.getSubject() != null) {
                headers.set("Subject", Utils.encodeHeader(this.message.getSubject(), 9));
            }
            if (this.message.getFrom() != null) {
                headers.set("From", Utils.encodeHeaderEmail(this.message.getFrom(), 6));
            }
            if (this.message.getTo() != null) {
                headers.set("To", Utils.encodeEmailList(this.message.getTo(), 4));
            }
            if (this.message.getCc() != null) {
                headers.set("Cc", Utils.encodeEmailList(this.message.getCc(), 4));
            }
            headers.addAll(additionalHeaders);
        }
        if ((headersToSet = this.message.getHeaders()) != null) {
            for (String key : headersToSet.names()) {
                headers.remove(key);
            }
            headers.addAll(headersToSet);
        }
        this.messageID = headers.get("Message-ID");
        return headers;
    }

    public String getMessageID() {
        return this.messageID;
    }
}

