/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.mssqlclient.MSSQLConnectOptionsConverter;
import io.vertx.mssqlclient.impl.MSSQLConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@DataObject
@JsonGen(publicConverter=false)
public class MSSQLConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 1433;
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_DATABASE = "";
    public static final String DEFAULT_APP_NAME = "vertx-mssql-client";
    public static final String DEFAULT_CLIENT_INTERFACE_NAME = "Vert.x";
    public static final Map<String, String> DEFAULT_PROPERTIES;
    public static final int MIN_PACKET_SIZE = 512;
    public static final int MAX_PACKET_SIZE = Short.MAX_VALUE;
    public static final int DEFAULT_PACKET_SIZE = 4096;
    private int packetSize;

    public static MSSQLConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof MSSQLConnectOptions) {
            return (MSSQLConnectOptions)options;
        }
        return new MSSQLConnectOptions(options);
    }

    public static MSSQLConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = MSSQLConnectionUriParser.parse(connectionUri);
        return new MSSQLConnectOptions(parsedConfiguration);
    }

    public MSSQLConnectOptions() {
    }

    public MSSQLConnectOptions(JsonObject json) {
        super(json);
        MSSQLConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public MSSQLConnectOptions(SqlConnectOptions other) {
        super(other);
        if (other instanceof MSSQLConnectOptions) {
            MSSQLConnectOptions opts = (MSSQLConnectOptions)other;
            this.copyFields(opts);
        }
    }

    public MSSQLConnectOptions(MSSQLConnectOptions other) {
        super((SqlConnectOptions)other);
        this.copyFields(other);
    }

    private void copyFields(MSSQLConnectOptions other) {
        this.packetSize = other.packetSize;
    }

    public MSSQLConnectOptions setHost(String host) {
        return (MSSQLConnectOptions)super.setHost(host);
    }

    public MSSQLConnectOptions setPort(int port) {
        return (MSSQLConnectOptions)super.setPort(port);
    }

    public MSSQLConnectOptions setUser(String user) {
        return (MSSQLConnectOptions)super.setUser(user);
    }

    public MSSQLConnectOptions setPassword(String password) {
        return (MSSQLConnectOptions)super.setPassword(password);
    }

    public MSSQLConnectOptions setDatabase(String database) {
        return (MSSQLConnectOptions)super.setDatabase(database);
    }

    public MSSQLConnectOptions setProperties(Map<String, String> properties) {
        return (MSSQLConnectOptions)super.setProperties(properties);
    }

    public MSSQLConnectOptions addProperty(String key, String value) {
        return (MSSQLConnectOptions)super.addProperty(key, value);
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public MSSQLConnectOptions setPacketSize(int packetSize) {
        if (packetSize < 512 || packetSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Packet size: " + packetSize);
        }
        this.packetSize = packetSize;
        return this;
    }

    public MSSQLConnectOptions setSendBufferSize(int sendBufferSize) {
        return (MSSQLConnectOptions)super.setSendBufferSize(sendBufferSize);
    }

    public MSSQLConnectOptions setReceiveBufferSize(int receiveBufferSize) {
        return (MSSQLConnectOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public MSSQLConnectOptions setReuseAddress(boolean reuseAddress) {
        return (MSSQLConnectOptions)super.setReuseAddress(reuseAddress);
    }

    public MSSQLConnectOptions setReusePort(boolean reusePort) {
        return (MSSQLConnectOptions)super.setReusePort(reusePort);
    }

    public MSSQLConnectOptions setTrafficClass(int trafficClass) {
        return (MSSQLConnectOptions)super.setTrafficClass(trafficClass);
    }

    public MSSQLConnectOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (MSSQLConnectOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public MSSQLConnectOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (MSSQLConnectOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public MSSQLConnectOptions setSoLinger(int soLinger) {
        return (MSSQLConnectOptions)super.setSoLinger(soLinger);
    }

    public MSSQLConnectOptions setIdleTimeout(int idleTimeout) {
        return (MSSQLConnectOptions)super.setIdleTimeout(idleTimeout);
    }

    public MSSQLConnectOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return (MSSQLConnectOptions)super.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    public MSSQLConnectOptions setKeyCertOptions(KeyCertOptions options) {
        return (MSSQLConnectOptions)super.setKeyCertOptions(options);
    }

    public MSSQLConnectOptions setKeyStoreOptions(JksOptions options) {
        return (MSSQLConnectOptions)super.setKeyStoreOptions(options);
    }

    public MSSQLConnectOptions setPfxKeyCertOptions(PfxOptions options) {
        return (MSSQLConnectOptions)super.setPfxKeyCertOptions(options);
    }

    public MSSQLConnectOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (MSSQLConnectOptions)super.setPemKeyCertOptions(options);
    }

    public MSSQLConnectOptions setTrustOptions(TrustOptions options) {
        return (MSSQLConnectOptions)super.setTrustOptions(options);
    }

    public MSSQLConnectOptions setTrustStoreOptions(JksOptions options) {
        return (MSSQLConnectOptions)super.setTrustStoreOptions(options);
    }

    public MSSQLConnectOptions setPemTrustOptions(PemTrustOptions options) {
        return (MSSQLConnectOptions)super.setPemTrustOptions(options);
    }

    public MSSQLConnectOptions setPfxTrustOptions(PfxOptions options) {
        return (MSSQLConnectOptions)super.setPfxTrustOptions(options);
    }

    public MSSQLConnectOptions addEnabledCipherSuite(String suite) {
        return (MSSQLConnectOptions)super.addEnabledCipherSuite(suite);
    }

    public MSSQLConnectOptions addEnabledSecureTransportProtocol(String protocol) {
        return (MSSQLConnectOptions)super.addEnabledSecureTransportProtocol(protocol);
    }

    public MSSQLConnectOptions removeEnabledSecureTransportProtocol(String protocol) {
        return (MSSQLConnectOptions)super.removeEnabledSecureTransportProtocol(protocol);
    }

    public MSSQLConnectOptions setUseAlpn(boolean useAlpn) {
        return (MSSQLConnectOptions)super.setUseAlpn(useAlpn);
    }

    public MSSQLConnectOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (MSSQLConnectOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    public MSSQLConnectOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (MSSQLConnectOptions)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    public MSSQLConnectOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (MSSQLConnectOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    public MSSQLConnectOptions setTcpCork(boolean tcpCork) {
        return (MSSQLConnectOptions)super.setTcpCork(tcpCork);
    }

    public MSSQLConnectOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (MSSQLConnectOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    public MSSQLConnectOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (MSSQLConnectOptions)super.setOpenSslEngineOptions(sslEngineOptions);
    }

    public MSSQLConnectOptions addCrlPath(String crlPath) throws NullPointerException {
        return (MSSQLConnectOptions)super.addCrlPath(crlPath);
    }

    public MSSQLConnectOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (MSSQLConnectOptions)super.addCrlValue(crlValue);
    }

    public MSSQLConnectOptions setTrustAll(boolean trustAll) {
        return (MSSQLConnectOptions)super.setTrustAll(trustAll);
    }

    public MSSQLConnectOptions setConnectTimeout(int connectTimeout) {
        return (MSSQLConnectOptions)super.setConnectTimeout(connectTimeout);
    }

    public MSSQLConnectOptions setMetricsName(String metricsName) {
        return (MSSQLConnectOptions)super.setMetricsName(metricsName);
    }

    public MSSQLConnectOptions setReconnectAttempts(int attempts) {
        return (MSSQLConnectOptions)super.setReconnectAttempts(attempts);
    }

    public MSSQLConnectOptions setReconnectInterval(long interval) {
        return (MSSQLConnectOptions)super.setReconnectInterval(interval);
    }

    public MSSQLConnectOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        return (MSSQLConnectOptions)super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
    }

    public MSSQLConnectOptions setLogActivity(boolean logEnabled) {
        return (MSSQLConnectOptions)super.setLogActivity(logEnabled);
    }

    public MSSQLConnectOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (MSSQLConnectOptions)super.setProxyOptions(proxyOptions);
    }

    public MSSQLConnectOptions setLocalAddress(String localAddress) {
        return (MSSQLConnectOptions)super.setLocalAddress(localAddress);
    }

    public MSSQLConnectOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (MSSQLConnectOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    public MSSQLConnectOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return (MSSQLConnectOptions)super.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    public MSSQLConnectOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return (MSSQLConnectOptions)super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    public MSSQLConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        return (MSSQLConnectOptions)super.setTracingPolicy(tracingPolicy);
    }

    public MSSQLConnectOptions setSsl(boolean ssl) {
        return (MSSQLConnectOptions)super.setSsl(ssl);
    }

    public MSSQLConnectOptions setNonProxyHosts(List<String> nonProxyHosts) {
        return (MSSQLConnectOptions)super.setNonProxyHosts(nonProxyHosts);
    }

    protected void init() {
        this.setHost(DEFAULT_HOST);
        this.setPort(1433);
        this.setUser(DEFAULT_USER);
        this.setPassword("");
        this.setDatabase("");
        this.setProperties(new HashMap<String, String>(DEFAULT_PROPERTIES));
        this.packetSize = 4096;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        MSSQLConnectOptionsConverter.toJson(this, json);
        return json;
    }

    public MSSQLConnectOptions merge(JsonObject other) {
        JsonObject json = this.toJson();
        json.mergeIn(other);
        return new MSSQLConnectOptions(json);
    }

    static {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("appName", DEFAULT_APP_NAME);
        defaultProperties.put("clientInterfaceName", DEFAULT_CLIENT_INTERFACE_NAME);
        DEFAULT_PROPERTIES = defaultProperties;
    }
}

