/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.vertx.mssqlclient.impl.codec.TdsPacket;

public class TdsMessage
extends DefaultByteBufHolder {
    private final short type;

    private TdsMessage(short type, ByteBuf data) {
        super(data);
        this.type = type;
    }

    public static TdsMessage createForDecoding(ByteBufAllocator alloc, TdsPacket tdsPacket) {
        Object data = tdsPacket.status() == 1 ? tdsPacket.content() : alloc.compositeDirectBuffer().addComponent(true, tdsPacket.content());
        return new TdsMessage(tdsPacket.type(), (ByteBuf)data);
    }

    public int type() {
        return this.type;
    }

    public void aggregate(TdsPacket tdsPacket) {
        if (this.type != tdsPacket.type()) {
            throw new IllegalArgumentException("Message type [" + this.type + "] does not match packet type [" + tdsPacket.type() + "]");
        }
        CompositeByteBuf content = (CompositeByteBuf)this.content();
        content.addComponent(true, tdsPacket.content());
    }
}

