/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.InitDbCommand;
import java.nio.charset.StandardCharsets;

class InitDbCommandCodec
extends CommandCodec<Void, InitDbCommand> {
    InitDbCommandCodec(InitDbCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendInitDbCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        this.handleOkPacketOrErrorPacketPayload(payload);
    }

    private void sendInitDbCommand() {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(2);
        packet.writeCharSequence((CharSequence)((InitDbCommand)this.cmd).schemaName(), StandardCharsets.UTF_8);
        int lenOfPayload = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, lenOfPayload);
        this.sendPacket(packet, lenOfPayload);
    }
}

