/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.datatype;

import io.netty.util.collection.ShortObjectHashMap;
import io.netty.util.collection.ShortObjectMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.mysqlclient.data.spatial.Geometry;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

public enum DataType {
    U_INT8(1, Short.class, JDBCType.SMALLINT),
    U_INT16(2, Integer.class, JDBCType.INTEGER),
    U_INT24(9, Integer.class, JDBCType.INTEGER),
    U_INT32(3, Long.class, JDBCType.BIGINT),
    U_INT64(8, BigInteger.class, JDBCType.NUMERIC),
    INT8(1, Byte.class, JDBCType.TINYINT),
    INT16(2, Short.class, JDBCType.SMALLINT),
    INT24(9, Integer.class, JDBCType.INTEGER),
    INT32(3, Integer.class, JDBCType.INTEGER),
    INT64(8, Long.class, JDBCType.BIGINT),
    BIT(16, Long.class, JDBCType.BIT),
    DOUBLE(5, Double.class, JDBCType.DOUBLE),
    FLOAT(4, Float.class, JDBCType.FLOAT),
    NUMERIC(246, Numeric.class, JDBCType.DECIMAL),
    STRING(254, String.class, JDBCType.CHAR),
    VARSTRING(253, String.class, JDBCType.VARCHAR),
    TINY_TEXT(249, String.class, JDBCType.CLOB),
    TEXT(252, String.class, JDBCType.CLOB),
    MEDIUM_TEXT(250, String.class, JDBCType.CLOB),
    LONG_TEXT(251, String.class, JDBCType.CLOB),
    BINARY(254, Buffer.class, JDBCType.BINARY),
    VARBINARY(253, Buffer.class, JDBCType.VARBINARY),
    TINY_BLOB(249, Buffer.class, JDBCType.BLOB),
    BLOB(252, Buffer.class, JDBCType.BLOB),
    MEDIUM_BLOB(250, Buffer.class, JDBCType.BLOB),
    LONG_BLOB(251, Buffer.class, JDBCType.BLOB),
    DATE(10, LocalDate.class, JDBCType.DATE),
    TIME(11, Duration.class, JDBCType.TIME),
    DATETIME(12, LocalDateTime.class, JDBCType.TIMESTAMP),
    YEAR(13, Short.class, JDBCType.SMALLINT),
    TIMESTAMP(7, LocalDateTime.class, JDBCType.TIMESTAMP),
    JSON(245, Object.class, JDBCType.OTHER),
    GEOMETRY(255, Geometry.class, JDBCType.OTHER),
    NULL(6, Object.class, JDBCType.OTHER),
    UNBIND(-1, Object.class, JDBCType.OTHER);

    private static final Logger LOGGER;
    private final short columnType;
    private final Class<?> javaType;
    private final JDBCType jdbcType;
    private static final ShortObjectMap<List<DataType>> COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING;
    private static final ShortObjectMap<List<DataType>> COLUMN_TYPE_TO_STRING_TYPE_MAPPING;
    private static final ShortObjectMap<DataType> COLUMN_TYPE_TO_DATA_TYPE_MAPPING;

    private DataType(short columnType, Class<?> javaType, JDBCType jdbcType) {
        this.columnType = columnType;
        this.javaType = javaType;
        this.jdbcType = jdbcType;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public JDBCType getJdbcType() {
        return this.jdbcType;
    }

    public static DataType parseDataType(short type, int characterSet, int flags) {
        if (COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.containsKey(type)) {
            return DataType.isUnsignedNumeric(flags) ? (DataType)((Object)((List)COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.get(type)).get(0)) : (DataType)((Object)((List)COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.get(type)).get(1));
        }
        if (COLUMN_TYPE_TO_STRING_TYPE_MAPPING.containsKey(type)) {
            return DataType.isText(characterSet) ? (DataType)((Object)((List)COLUMN_TYPE_TO_STRING_TYPE_MAPPING.get(type)).get(0)) : (DataType)((Object)((List)COLUMN_TYPE_TO_STRING_TYPE_MAPPING.get(type)).get(1));
        }
        DataType dataType = (DataType)((Object)COLUMN_TYPE_TO_DATA_TYPE_MAPPING.get(type));
        if (dataType == null) {
            LOGGER.warn((Object)String.format("MySQL data type Id =[%d] not handled - using string type instead", type));
            return STRING;
        }
        return dataType;
    }

    private static boolean isText(int collationId) {
        return collationId != MySQLCollation.binary.collationId();
    }

    private static boolean isUnsignedNumeric(int columnDefinitionFlags) {
        return (columnDefinitionFlags & 0x20) != 0;
    }

    static {
        LOGGER = LoggerFactory.getLogger(DataType.class);
        COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING = new ShortObjectHashMap(5, 1.0f);
        COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.put((short)1, Arrays.asList(U_INT8, INT8));
        COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.put((short)2, Arrays.asList(U_INT16, INT16));
        COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.put((short)9, Arrays.asList(U_INT24, INT24));
        COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.put((short)3, Arrays.asList(U_INT32, INT32));
        COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.put((short)8, Arrays.asList(U_INT64, INT64));
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING = new ShortObjectHashMap(6, 1.0f);
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING.put((short)254, Arrays.asList(STRING, BINARY));
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING.put((short)253, Arrays.asList(VARSTRING, VARBINARY));
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING.put((short)249, Arrays.asList(TINY_TEXT, TINY_BLOB));
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING.put((short)252, Arrays.asList(TEXT, BLOB));
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING.put((short)250, Arrays.asList(MEDIUM_TEXT, MEDIUM_BLOB));
        COLUMN_TYPE_TO_STRING_TYPE_MAPPING.put((short)251, Arrays.asList(LONG_TEXT, LONG_BLOB));
        COLUMN_TYPE_TO_DATA_TYPE_MAPPING = new ShortObjectHashMap(13, 1.0f);
        for (DataType dataType : DataType.values()) {
            if (COLUMN_TYPE_TO_INTEGER_TYPE_MAPPING.containsKey(dataType.columnType) || COLUMN_TYPE_TO_STRING_TYPE_MAPPING.containsKey(dataType.columnType)) continue;
            COLUMN_TYPE_TO_DATA_TYPE_MAPPING.put(dataType.columnType, (Object)dataType);
        }
    }
}

