/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.impl.MySQLConnectionFactory;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.mysqlclient.impl.MySQLConnectionUriParser;
import io.vertx.mysqlclient.impl.MySQLPoolImpl;
import io.vertx.mysqlclient.impl.MySQLPoolOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolImpl;
import io.vertx.sqlclient.impl.SingletonSupplier;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

public class MySQLDriver
implements Driver {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.mysqlclient";
    public static final MySQLDriver INSTANCE = new MySQLDriver();

    public Pool newPool(Vertx vertx, Supplier<? extends Future<? extends SqlConnectOptions>> databases, PoolOptions options, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedClient(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, databases, options, (CloseFuture)cf)) : this.newPoolImpl(vx, databases, options, closeFuture);
        return new MySQLPoolImpl(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> databases, PoolOptions options, CloseFuture closeFuture) {
        boolean pipelinedPool = options instanceof MySQLPoolOptions && ((MySQLPoolOptions)options).isPipelined();
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, pipelinedPool, options, null, null, closeFuture);
        ConnectionFactory factory = this.createConnectionFactory((Vertx)vertx, databases);
        pool.connectionProvider(context -> factory.connect(context, (Future)databases.get()));
        pool.init();
        closeFuture.add((Closeable)factory);
        return pool;
    }

    public MySQLConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = MySQLConnectionUriParser.parse(uri, false);
        return conf == null ? null : new MySQLConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MySQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new MySQLConnectionFactory((VertxInternal)vertx, SingletonSupplier.wrap((Object)database));
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, Supplier<? extends Future<? extends SqlConnectOptions>> database) {
        return new MySQLConnectionFactory((VertxInternal)vertx, database);
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn) {
        return new MySQLConnectionImpl(context, factory, conn);
    }
}

