/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.commands.OracleCommand;
import io.vertx.oracleclient.impl.commands.OraclePreparedStatement;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;

public class OraclePrepareStatementCommand
extends OracleCommand<io.vertx.sqlclient.impl.PreparedStatement> {
    private final OraclePrepareOptions options;
    private final String sql;

    public OraclePrepareStatementCommand(OracleConnection oracleConnection, ContextInternal connectionContext, PrepareStatementCommand cmd) {
        super(oracleConnection, connectionContext);
        this.options = OraclePrepareOptions.createFrom(cmd.options());
        this.sql = cmd.sql();
    }

    @Override
    protected Future<io.vertx.sqlclient.impl.PreparedStatement> execute() {
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = this.options == null || this.options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = this.options != null && this.options.getAutoGeneratedKeysIndexes() != null;
        if (autoGeneratedKeys && !autoGeneratedIndexes) {
            return this.prepareReturningKey();
        }
        if (autoGeneratedIndexes) {
            return this.prepareWithAutoGeneratedIndexes();
        }
        return this.prepare();
    }

    private Future<io.vertx.sqlclient.impl.PreparedStatement> prepareWithAutoGeneratedIndexes() {
        return this.executeBlocking(() -> {
            JsonArray indexes = this.options.getAutoGeneratedKeysIndexes();
            if (indexes.getValue(0) instanceof Number) {
                int[] keys = new int[indexes.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = indexes.getInteger(i);
                }
                try (PreparedStatement statement = this.oracleConnection.prepareStatement(this.sql, keys);){
                    OraclePreparedStatement oraclePreparedStatement = new OraclePreparedStatement(this.sql, statement);
                    return oraclePreparedStatement;
                }
            }
            if (indexes.getValue(0) instanceof String) {
                String[] keys = new String[indexes.size()];
                for (int i = 0; i < keys.length; ++i) {
                    keys[i] = indexes.getString(i);
                }
                try (PreparedStatement statement = this.oracleConnection.prepareStatement(this.sql, keys);){
                    OraclePreparedStatement oraclePreparedStatement = new OraclePreparedStatement(this.sql, statement);
                    return oraclePreparedStatement;
                }
            }
            throw new SQLException("Invalid type of index, only [int, String] allowed");
        });
    }

    private Future<io.vertx.sqlclient.impl.PreparedStatement> prepareReturningKey() {
        return this.executeBlocking(() -> {
            try (PreparedStatement statement = this.oracleConnection.prepareStatement(this.sql, 1);){
                OraclePreparedStatement oraclePreparedStatement = new OraclePreparedStatement(this.sql, statement);
                return oraclePreparedStatement;
            }
        });
    }

    private Future<io.vertx.sqlclient.impl.PreparedStatement> prepare() {
        return this.executeBlocking(() -> {
            try (PreparedStatement statement = this.oracleConnection.prepareStatement(this.sql);){
                OraclePreparedStatement oraclePreparedStatement = new OraclePreparedStatement(this.sql, statement);
                return oraclePreparedStatement;
            }
        });
    }
}

