/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.impl.commands.OracleCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import oracle.jdbc.OracleConnection;

public class OracleTransactionCommand<R>
extends OracleCommand<R> {
    private final TxCommand<R> op;

    private OracleTransactionCommand(OracleConnection oracleConnection, ContextInternal connectionContext, TxCommand<R> op) {
        super(oracleConnection, connectionContext);
        this.op = op;
    }

    public static <U> OracleTransactionCommand<U> create(OracleConnection oracleConnection, ContextInternal connectionContext, TxCommand<U> cmd) {
        return new OracleTransactionCommand<U>(oracleConnection, connectionContext, cmd);
    }

    @Override
    protected Future<R> execute() {
        Future<Void> result = this.op.kind == TxCommand.Kind.BEGIN ? this.begin() : (this.op.kind == TxCommand.Kind.COMMIT ? this.commit() : this.rollback());
        return result.map(this.op.result);
    }

    private Future<Void> begin() {
        return this.executeBlocking(() -> {
            int isolation = this.oracleConnection.getTransactionIsolation();
            this.oracleConnection.setAutoCommit(false);
            this.oracleConnection.setTransactionIsolation(isolation);
        });
    }

    private Future<Void> commit() {
        return this.executeBlocking(() -> this.oracleConnection.getAutoCommit()).compose(autoCommit -> autoCommit != false ? Future.succeededFuture() : this.first(this.oracleConnection.commitAsyncOracle())).eventually(v -> this.executeBlocking(() -> this.oracleConnection.setAutoCommit(true)));
    }

    private Future<Void> rollback() {
        return this.executeBlocking(() -> this.oracleConnection.getAutoCommit()).compose(autoCommit -> autoCommit != false ? Future.succeededFuture() : this.first(this.oracleConnection.rollbackAsyncOracle())).eventually(v -> this.executeBlocking(() -> this.oracleConnection.setAutoCommit(true)));
    }
}

