/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.DataFormat;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.JDBCType;

class PgColumnDesc
implements ColumnDescriptor {
    public static final PgColumnDesc[] EMPTY_COLUMNS = new PgColumnDesc[0];
    final String name;
    final int relationId;
    final DataType dataType;
    final DataFormat dataFormat;
    final short relationAttributeNo;
    final short length;
    final int typeModifier;

    PgColumnDesc(String name, int relationId, short relationAttributeNo, DataType dataType, short length, int typeModifier, DataFormat dataFormat) {
        this.name = name;
        this.dataType = dataType;
        this.dataFormat = dataFormat;
        this.length = length;
        this.relationId = relationId;
        this.relationAttributeNo = relationAttributeNo;
        this.typeModifier = typeModifier;
    }

    boolean supportsBinary() {
        return this.dataType.supportsBinary;
    }

    boolean hasTextFormat() {
        return this.dataFormat == DataFormat.TEXT;
    }

    PgColumnDesc toBinaryDataFormat() {
        return new PgColumnDesc(this.name, this.relationId, this.relationAttributeNo, this.dataType, this.length, this.typeModifier, DataFormat.BINARY);
    }

    public String name() {
        return this.name;
    }

    public boolean isArray() {
        return this.dataType.array;
    }

    public String typeName() {
        return this.dataType.toString();
    }

    public JDBCType jdbcType() {
        return this.dataType.jdbcType;
    }
}

