/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.redis;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.lang.rx.RxGen;
import io.vertx.lang.rx.TypeArg;
import io.vertx.reactivex.impl.AsyncResultCompletable;
import io.vertx.reactivex.impl.AsyncResultSingle;
import io.vertx.redis.op.AggregateOptions;
import io.vertx.redis.op.BitOperation;
import io.vertx.redis.op.FailoverOptions;
import io.vertx.redis.op.GeoMember;
import io.vertx.redis.op.GeoRadiusOptions;
import io.vertx.redis.op.GeoUnit;
import io.vertx.redis.op.InsertOptions;
import io.vertx.redis.op.KillFilter;
import io.vertx.redis.op.LimitOptions;
import io.vertx.redis.op.MigrateOptions;
import io.vertx.redis.op.ObjectCmd;
import io.vertx.redis.op.RangeLimitOptions;
import io.vertx.redis.op.RangeOptions;
import io.vertx.redis.op.ResetOptions;
import io.vertx.redis.op.ScanOptions;
import io.vertx.redis.op.SetOptions;
import io.vertx.redis.op.SlotCmd;
import io.vertx.redis.op.SortOptions;
import java.util.List;
import java.util.Map;

@RxGen(value=io.vertx.redis.RedisTransaction.class)
public class RedisTransaction {
    public static final TypeArg<RedisTransaction> __TYPE_ARG = new TypeArg(obj -> new RedisTransaction((io.vertx.redis.RedisTransaction)obj), RedisTransaction::getDelegate);
    private final io.vertx.redis.RedisTransaction delegate;

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisTransaction that = (RedisTransaction)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public RedisTransaction(io.vertx.redis.RedisTransaction delegate) {
        this.delegate = delegate;
    }

    public RedisTransaction(Object delegate) {
        this.delegate = (io.vertx.redis.RedisTransaction)delegate;
    }

    public io.vertx.redis.RedisTransaction getDelegate() {
        return this.delegate;
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Completable rxClose() {
        return AsyncResultCompletable.toCompletable(handler -> this.close((Handler<AsyncResult<Void>>)handler));
    }

    public RedisTransaction append(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.append(key, value, handler);
        return this;
    }

    public Single<String> rxAppend(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.append(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction auth(String password, Handler<AsyncResult<String>> handler) {
        this.delegate.auth(password, handler);
        return this;
    }

    public Single<String> rxAuth(String password) {
        return AsyncResultSingle.toSingle(handler -> this.auth(password, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bgrewriteaof(Handler<AsyncResult<String>> handler) {
        this.delegate.bgrewriteaof(handler);
        return this;
    }

    public Single<String> rxBgrewriteaof() {
        return AsyncResultSingle.toSingle(handler -> this.bgrewriteaof((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bgsave(Handler<AsyncResult<String>> handler) {
        this.delegate.bgsave(handler);
        return this;
    }

    public Single<String> rxBgsave() {
        return AsyncResultSingle.toSingle(handler -> this.bgsave((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bitcount(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.bitcount(key, handler);
        return this;
    }

    public Single<String> rxBitcount(String key) {
        return AsyncResultSingle.toSingle(handler -> this.bitcount(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bitcountRange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.bitcountRange(key, start, end, handler);
        return this;
    }

    public Single<String> rxBitcountRange(String key, long start, long end) {
        return AsyncResultSingle.toSingle(handler -> this.bitcountRange(key, start, end, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bitop(BitOperation operation, String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.bitop(operation, destkey, keys, handler);
        return this;
    }

    public Single<String> rxBitop(BitOperation operation, String destkey, List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.bitop(operation, destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bitpos(String key, int bit, Handler<AsyncResult<String>> handler) {
        this.delegate.bitpos(key, bit, handler);
        return this;
    }

    public Single<String> rxBitpos(String key, int bit) {
        return AsyncResultSingle.toSingle(handler -> this.bitpos(key, bit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bitposFrom(String key, int bit, int start, Handler<AsyncResult<String>> handler) {
        this.delegate.bitposFrom(key, bit, start, handler);
        return this;
    }

    public Single<String> rxBitposFrom(String key, int bit, int start) {
        return AsyncResultSingle.toSingle(handler -> this.bitposFrom(key, bit, start, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction bitposRange(String key, int bit, int start, int stop, Handler<AsyncResult<String>> handler) {
        this.delegate.bitposRange(key, bit, start, stop, handler);
        return this;
    }

    public Single<String> rxBitposRange(String key, int bit, int start, int stop) {
        return AsyncResultSingle.toSingle(handler -> this.bitposRange(key, bit, start, stop, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction blpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.blpop(key, seconds, handler);
        return this;
    }

    public Single<String> rxBlpop(String key, int seconds) {
        return AsyncResultSingle.toSingle(handler -> this.blpop(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction blpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.blpopMany(keys, seconds, handler);
        return this;
    }

    public Single<String> rxBlpopMany(List<String> keys, int seconds) {
        return AsyncResultSingle.toSingle(handler -> this.blpopMany(keys, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction brpop(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpop(key, seconds, handler);
        return this;
    }

    public Single<String> rxBrpop(String key, int seconds) {
        return AsyncResultSingle.toSingle(handler -> this.brpop(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction brpopMany(List<String> keys, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpopMany(keys, seconds, handler);
        return this;
    }

    public Single<String> rxBrpopMany(List<String> keys, int seconds) {
        return AsyncResultSingle.toSingle(handler -> this.brpopMany(keys, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction brpoplpush(String key, String destkey, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.brpoplpush(key, destkey, seconds, handler);
        return this;
    }

    public Single<String> rxBrpoplpush(String key, String destkey, int seconds) {
        return AsyncResultSingle.toSingle(handler -> this.brpoplpush(key, destkey, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clientKill(KillFilter filter, Handler<AsyncResult<String>> handler) {
        this.delegate.clientKill(filter, handler);
        return this;
    }

    public Single<String> rxClientKill(KillFilter filter) {
        return AsyncResultSingle.toSingle(handler -> this.clientKill(filter, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clientList(Handler<AsyncResult<String>> handler) {
        this.delegate.clientList(handler);
        return this;
    }

    public Single<String> rxClientList() {
        return AsyncResultSingle.toSingle(handler -> this.clientList((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clientGetname(Handler<AsyncResult<String>> handler) {
        this.delegate.clientGetname(handler);
        return this;
    }

    public Single<String> rxClientGetname() {
        return AsyncResultSingle.toSingle(handler -> this.clientGetname((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clientPause(long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.clientPause(millis, handler);
        return this;
    }

    public Single<String> rxClientPause(long millis) {
        return AsyncResultSingle.toSingle(handler -> this.clientPause(millis, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clientSetname(String name, Handler<AsyncResult<String>> handler) {
        this.delegate.clientSetname(name, handler);
        return this;
    }

    public Single<String> rxClientSetname(String name) {
        return AsyncResultSingle.toSingle(handler -> this.clientSetname(name, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterAddslots(List<String> slots, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterAddslots(slots, handler);
        return this;
    }

    public Single<String> rxClusterAddslots(List<String> slots) {
        return AsyncResultSingle.toSingle(handler -> this.clusterAddslots(slots, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterCountFailureReports(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterCountFailureReports(nodeId, handler);
        return this;
    }

    public Single<String> rxClusterCountFailureReports(String nodeId) {
        return AsyncResultSingle.toSingle(handler -> this.clusterCountFailureReports(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterCountkeysinslot(long slot, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterCountkeysinslot(slot, handler);
        return this;
    }

    public Single<String> rxClusterCountkeysinslot(long slot) {
        return AsyncResultSingle.toSingle(handler -> this.clusterCountkeysinslot(slot, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterDelslots(long slot, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterDelslots(slot, handler);
        return this;
    }

    public Single<String> rxClusterDelslots(long slot) {
        return AsyncResultSingle.toSingle(handler -> this.clusterDelslots(slot, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterDelslotsMany(List<String> slots, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterDelslotsMany(slots, handler);
        return this;
    }

    public Single<String> rxClusterDelslotsMany(List<String> slots) {
        return AsyncResultSingle.toSingle(handler -> this.clusterDelslotsMany(slots, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterFailover(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterFailover(handler);
        return this;
    }

    public Single<String> rxClusterFailover() {
        return AsyncResultSingle.toSingle(handler -> this.clusterFailover((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterFailOverWithOptions(FailoverOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterFailOverWithOptions(options, handler);
        return this;
    }

    public Single<String> rxClusterFailOverWithOptions(FailoverOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.clusterFailOverWithOptions(options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterForget(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterForget(nodeId, handler);
        return this;
    }

    public Single<String> rxClusterForget(String nodeId) {
        return AsyncResultSingle.toSingle(handler -> this.clusterForget(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterGetkeysinslot(long slot, long count, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterGetkeysinslot(slot, count, handler);
        return this;
    }

    public Single<String> rxClusterGetkeysinslot(long slot, long count) {
        return AsyncResultSingle.toSingle(handler -> this.clusterGetkeysinslot(slot, count, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterInfo(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterInfo(handler);
        return this;
    }

    public Single<String> rxClusterInfo() {
        return AsyncResultSingle.toSingle(handler -> this.clusterInfo((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterKeyslot(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterKeyslot(key, handler);
        return this;
    }

    public Single<String> rxClusterKeyslot(String key) {
        return AsyncResultSingle.toSingle(handler -> this.clusterKeyslot(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterMeet(String ip, long port, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterMeet(ip, port, handler);
        return this;
    }

    public Single<String> rxClusterMeet(String ip, long port) {
        return AsyncResultSingle.toSingle(handler -> this.clusterMeet(ip, port, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterNodes(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterNodes(handler);
        return this;
    }

    public Single<String> rxClusterNodes() {
        return AsyncResultSingle.toSingle(handler -> this.clusterNodes((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterReplicate(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterReplicate(nodeId, handler);
        return this;
    }

    public Single<String> rxClusterReplicate(String nodeId) {
        return AsyncResultSingle.toSingle(handler -> this.clusterReplicate(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterReset(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterReset(handler);
        return this;
    }

    public Single<String> rxClusterReset() {
        return AsyncResultSingle.toSingle(handler -> this.clusterReset((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterResetWithOptions(ResetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterResetWithOptions(options, handler);
        return this;
    }

    public Single<String> rxClusterResetWithOptions(ResetOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.clusterResetWithOptions(options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterSaveconfig(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSaveconfig(handler);
        return this;
    }

    public Single<String> rxClusterSaveconfig() {
        return AsyncResultSingle.toSingle(handler -> this.clusterSaveconfig((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterSetConfigEpoch(long epoch, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetConfigEpoch(epoch, handler);
        return this;
    }

    public Single<String> rxClusterSetConfigEpoch(long epoch) {
        return AsyncResultSingle.toSingle(handler -> this.clusterSetConfigEpoch(epoch, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterSetslot(long slot, SlotCmd subcommand, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetslot(slot, subcommand, handler);
        return this;
    }

    public Single<String> rxClusterSetslot(long slot, SlotCmd subcommand) {
        return AsyncResultSingle.toSingle(handler -> this.clusterSetslot(slot, subcommand, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSetslotWithNode(slot, subcommand, nodeId, handler);
        return this;
    }

    public Single<String> rxClusterSetslotWithNode(long slot, SlotCmd subcommand, String nodeId) {
        return AsyncResultSingle.toSingle(handler -> this.clusterSetslotWithNode(slot, subcommand, nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterSlaves(String nodeId, Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSlaves(nodeId, handler);
        return this;
    }

    public Single<String> rxClusterSlaves(String nodeId) {
        return AsyncResultSingle.toSingle(handler -> this.clusterSlaves(nodeId, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction clusterSlots(Handler<AsyncResult<String>> handler) {
        this.delegate.clusterSlots(handler);
        return this;
    }

    public Single<String> rxClusterSlots() {
        return AsyncResultSingle.toSingle(handler -> this.clusterSlots((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction command(Handler<AsyncResult<String>> handler) {
        this.delegate.command(handler);
        return this;
    }

    public Single<String> rxCommand() {
        return AsyncResultSingle.toSingle(handler -> this.command((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction commandCount(Handler<AsyncResult<String>> handler) {
        this.delegate.commandCount(handler);
        return this;
    }

    public Single<String> rxCommandCount() {
        return AsyncResultSingle.toSingle(handler -> this.commandCount((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction commandGetkeys(Handler<AsyncResult<String>> handler) {
        this.delegate.commandGetkeys(handler);
        return this;
    }

    public Single<String> rxCommandGetkeys() {
        return AsyncResultSingle.toSingle(handler -> this.commandGetkeys((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction commandInfo(List<String> commands, Handler<AsyncResult<String>> handler) {
        this.delegate.commandInfo(commands, handler);
        return this;
    }

    public Single<String> rxCommandInfo(List<String> commands) {
        return AsyncResultSingle.toSingle(handler -> this.commandInfo(commands, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction configGet(String parameter, Handler<AsyncResult<String>> handler) {
        this.delegate.configGet(parameter, handler);
        return this;
    }

    public Single<String> rxConfigGet(String parameter) {
        return AsyncResultSingle.toSingle(handler -> this.configGet(parameter, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction configRewrite(Handler<AsyncResult<String>> handler) {
        this.delegate.configRewrite(handler);
        return this;
    }

    public Single<String> rxConfigRewrite() {
        return AsyncResultSingle.toSingle(handler -> this.configRewrite((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction configSet(String parameter, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.configSet(parameter, value, handler);
        return this;
    }

    public Single<String> rxConfigSet(String parameter, String value) {
        return AsyncResultSingle.toSingle(handler -> this.configSet(parameter, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction configResetstat(Handler<AsyncResult<String>> handler) {
        this.delegate.configResetstat(handler);
        return this;
    }

    public Single<String> rxConfigResetstat() {
        return AsyncResultSingle.toSingle(handler -> this.configResetstat((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction dbsize(Handler<AsyncResult<String>> handler) {
        this.delegate.dbsize(handler);
        return this;
    }

    public Single<String> rxDbsize() {
        return AsyncResultSingle.toSingle(handler -> this.dbsize((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction debugObject(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.debugObject(key, handler);
        return this;
    }

    public Single<String> rxDebugObject(String key) {
        return AsyncResultSingle.toSingle(handler -> this.debugObject(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction debugSegfault(Handler<AsyncResult<String>> handler) {
        this.delegate.debugSegfault(handler);
        return this;
    }

    public Single<String> rxDebugSegfault() {
        return AsyncResultSingle.toSingle(handler -> this.debugSegfault((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction decr(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.decr(key, handler);
        return this;
    }

    public Single<String> rxDecr(String key) {
        return AsyncResultSingle.toSingle(handler -> this.decr(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction decrby(String key, long decrement, Handler<AsyncResult<String>> handler) {
        this.delegate.decrby(key, decrement, handler);
        return this;
    }

    public Single<String> rxDecrby(String key, long decrement) {
        return AsyncResultSingle.toSingle(handler -> this.decrby(key, decrement, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction del(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.del(key, handler);
        return this;
    }

    public Single<String> rxDel(String key) {
        return AsyncResultSingle.toSingle(handler -> this.del(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction delMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.delMany(keys, handler);
        return this;
    }

    public Single<String> rxDelMany(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.delMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction discard(Handler<AsyncResult<String>> handler) {
        this.delegate.discard(handler);
        return this;
    }

    public Single<String> rxDiscard() {
        return AsyncResultSingle.toSingle(handler -> this.discard((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction dump(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.dump(key, handler);
        return this;
    }

    public Single<String> rxDump(String key) {
        return AsyncResultSingle.toSingle(handler -> this.dump(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction echo(String message, Handler<AsyncResult<String>> handler) {
        this.delegate.echo(message, handler);
        return this;
    }

    public Single<String> rxEcho(String message) {
        return AsyncResultSingle.toSingle(handler -> this.echo(message, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction eval(String script, List<String> keys, List<String> args, Handler<AsyncResult<String>> handler) {
        this.delegate.eval(script, keys, args, handler);
        return this;
    }

    public Single<String> rxEval(String script, List<String> keys, List<String> args) {
        return AsyncResultSingle.toSingle(handler -> this.eval(script, keys, args, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction evalsha(String sha1, List<String> keys, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.evalsha(sha1, keys, values, handler);
        return this;
    }

    public Single<String> rxEvalsha(String sha1, List<String> keys, List<String> values) {
        return AsyncResultSingle.toSingle(handler -> this.evalsha(sha1, keys, values, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction exec(Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.exec(handler);
        return this;
    }

    public Single<JsonArray> rxExec() {
        return AsyncResultSingle.toSingle(handler -> this.exec((Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisTransaction exists(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.exists(key, handler);
        return this;
    }

    public Single<String> rxExists(String key) {
        return AsyncResultSingle.toSingle(handler -> this.exists(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction existsMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.existsMany(keys, handler);
        return this;
    }

    public Single<String> rxExistsMany(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.existsMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction expire(String key, int seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.expire(key, seconds, handler);
        return this;
    }

    public Single<String> rxExpire(String key, int seconds) {
        return AsyncResultSingle.toSingle(handler -> this.expire(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction expireat(String key, long seconds, Handler<AsyncResult<String>> handler) {
        this.delegate.expireat(key, seconds, handler);
        return this;
    }

    public Single<String> rxExpireat(String key, long seconds) {
        return AsyncResultSingle.toSingle(handler -> this.expireat(key, seconds, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction flushall(Handler<AsyncResult<String>> handler) {
        this.delegate.flushall(handler);
        return this;
    }

    public Single<String> rxFlushall() {
        return AsyncResultSingle.toSingle(handler -> this.flushall((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction flushdb(Handler<AsyncResult<String>> handler) {
        this.delegate.flushdb(handler);
        return this;
    }

    public Single<String> rxFlushdb() {
        return AsyncResultSingle.toSingle(handler -> this.flushdb((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction get(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.get(key, handler);
        return this;
    }

    public Single<String> rxGet(String key) {
        return AsyncResultSingle.toSingle(handler -> this.get(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction getBinary(String key, final Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>> handler) {
        this.delegate.getBinary(key, (Handler)new Handler<AsyncResult<Buffer>>(){

            public void handle(AsyncResult<Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle((Object)Future.succeededFuture((Object)io.vertx.reactivex.core.buffer.Buffer.newInstance((Buffer)ar.result())));
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                }
            }
        });
        return this;
    }

    public Single<io.vertx.reactivex.core.buffer.Buffer> rxGetBinary(String key) {
        return AsyncResultSingle.toSingle(handler -> this.getBinary(key, (Handler<AsyncResult<io.vertx.reactivex.core.buffer.Buffer>>)handler));
    }

    public RedisTransaction getbit(String key, long offset, Handler<AsyncResult<String>> handler) {
        this.delegate.getbit(key, offset, handler);
        return this;
    }

    public Single<String> rxGetbit(String key, long offset) {
        return AsyncResultSingle.toSingle(handler -> this.getbit(key, offset, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction getrange(String key, long start, long end, Handler<AsyncResult<String>> handler) {
        this.delegate.getrange(key, start, end, handler);
        return this;
    }

    public Single<String> rxGetrange(String key, long start, long end) {
        return AsyncResultSingle.toSingle(handler -> this.getrange(key, start, end, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction getset(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.getset(key, value, handler);
        return this;
    }

    public Single<String> rxGetset(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.getset(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hdel(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hdel(key, field, handler);
        return this;
    }

    public Single<String> rxHdel(String key, String field) {
        return AsyncResultSingle.toSingle(handler -> this.hdel(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hdelMany(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
        this.delegate.hdelMany(key, fields, handler);
        return this;
    }

    public Single<String> rxHdelMany(String key, List<String> fields) {
        return AsyncResultSingle.toSingle(handler -> this.hdelMany(key, fields, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hexists(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hexists(key, field, handler);
        return this;
    }

    public Single<String> rxHexists(String key, String field) {
        return AsyncResultSingle.toSingle(handler -> this.hexists(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hget(String key, String field, Handler<AsyncResult<String>> handler) {
        this.delegate.hget(key, field, handler);
        return this;
    }

    public Single<String> rxHget(String key, String field) {
        return AsyncResultSingle.toSingle(handler -> this.hget(key, field, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hgetall(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hgetall(key, handler);
        return this;
    }

    public Single<String> rxHgetall(String key) {
        return AsyncResultSingle.toSingle(handler -> this.hgetall(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hincrby(String key, String field, long increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrby(key, field, increment, handler);
        return this;
    }

    public Single<String> rxHincrby(String key, String field, long increment) {
        return AsyncResultSingle.toSingle(handler -> this.hincrby(key, field, increment, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hincrbyfloat(String key, String field, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.hincrbyfloat(key, field, increment, handler);
        return this;
    }

    public Single<String> rxHincrbyfloat(String key, String field, double increment) {
        return AsyncResultSingle.toSingle(handler -> this.hincrbyfloat(key, field, increment, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hkeys(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hkeys(key, handler);
        return this;
    }

    public Single<String> rxHkeys(String key) {
        return AsyncResultSingle.toSingle(handler -> this.hkeys(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hlen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hlen(key, handler);
        return this;
    }

    public Single<String> rxHlen(String key) {
        return AsyncResultSingle.toSingle(handler -> this.hlen(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hmget(String key, List<String> fields, Handler<AsyncResult<String>> handler) {
        this.delegate.hmget(key, fields, handler);
        return this;
    }

    public Single<String> rxHmget(String key, List<String> fields) {
        return AsyncResultSingle.toSingle(handler -> this.hmget(key, fields, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hmset(String key, JsonObject values, Handler<AsyncResult<String>> handler) {
        this.delegate.hmset(key, values, handler);
        return this;
    }

    public Single<String> rxHmset(String key, JsonObject values) {
        return AsyncResultSingle.toSingle(handler -> this.hmset(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hset(String key, String field, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.hset(key, field, value, handler);
        return this;
    }

    public Single<String> rxHset(String key, String field, String value) {
        return AsyncResultSingle.toSingle(handler -> this.hset(key, field, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hsetnx(String key, String field, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.hsetnx(key, field, value, handler);
        return this;
    }

    public Single<String> rxHsetnx(String key, String field, String value) {
        return AsyncResultSingle.toSingle(handler -> this.hsetnx(key, field, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hvals(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.hvals(key, handler);
        return this;
    }

    public Single<String> rxHvals(String key) {
        return AsyncResultSingle.toSingle(handler -> this.hvals(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction incr(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.incr(key, handler);
        return this;
    }

    public Single<String> rxIncr(String key) {
        return AsyncResultSingle.toSingle(handler -> this.incr(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction incrby(String key, long increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrby(key, increment, handler);
        return this;
    }

    public Single<String> rxIncrby(String key, long increment) {
        return AsyncResultSingle.toSingle(handler -> this.incrby(key, increment, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction incrbyfloat(String key, double increment, Handler<AsyncResult<String>> handler) {
        this.delegate.incrbyfloat(key, increment, handler);
        return this;
    }

    public Single<String> rxIncrbyfloat(String key, double increment) {
        return AsyncResultSingle.toSingle(handler -> this.incrbyfloat(key, increment, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction info(Handler<AsyncResult<String>> handler) {
        this.delegate.info(handler);
        return this;
    }

    public Single<String> rxInfo() {
        return AsyncResultSingle.toSingle(handler -> this.info((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction infoSection(String section, Handler<AsyncResult<String>> handler) {
        this.delegate.infoSection(section, handler);
        return this;
    }

    public Single<String> rxInfoSection(String section) {
        return AsyncResultSingle.toSingle(handler -> this.infoSection(section, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction keys(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.keys(pattern, handler);
        return this;
    }

    public Single<String> rxKeys(String pattern) {
        return AsyncResultSingle.toSingle(handler -> this.keys(pattern, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lastsave(Handler<AsyncResult<String>> handler) {
        this.delegate.lastsave(handler);
        return this;
    }

    public Single<String> rxLastsave() {
        return AsyncResultSingle.toSingle(handler -> this.lastsave((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lindex(String key, int index, Handler<AsyncResult<String>> handler) {
        this.delegate.lindex(key, index, handler);
        return this;
    }

    public Single<String> rxLindex(String key, int index) {
        return AsyncResultSingle.toSingle(handler -> this.lindex(key, index, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction linsert(String key, InsertOptions option, String pivot, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.linsert(key, option, pivot, value, handler);
        return this;
    }

    public Single<String> rxLinsert(String key, InsertOptions option, String pivot, String value) {
        return AsyncResultSingle.toSingle(handler -> this.linsert(key, option, pivot, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction llen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.llen(key, handler);
        return this;
    }

    public Single<String> rxLlen(String key) {
        return AsyncResultSingle.toSingle(handler -> this.llen(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.lpop(key, handler);
        return this;
    }

    public Single<String> rxLpop(String key) {
        return AsyncResultSingle.toSingle(handler -> this.lpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.lpushMany(key, values, handler);
        return this;
    }

    public Single<String> rxLpushMany(String key, List<String> values) {
        return AsyncResultSingle.toSingle(handler -> this.lpushMany(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lpush(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lpush(key, value, handler);
        return this;
    }

    public Single<String> rxLpush(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.lpush(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lpushx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lpushx(key, value, handler);
        return this;
    }

    public Single<String> rxLpushx(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.lpushx(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lrange(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.lrange(key, from, to, handler);
        return this;
    }

    public Single<String> rxLrange(String key, long from, long to) {
        return AsyncResultSingle.toSingle(handler -> this.lrange(key, from, to, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lrem(String key, long count, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lrem(key, count, value, handler);
        return this;
    }

    public Single<String> rxLrem(String key, long count, String value) {
        return AsyncResultSingle.toSingle(handler -> this.lrem(key, count, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction lset(String key, long index, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.lset(key, index, value, handler);
        return this;
    }

    public Single<String> rxLset(String key, long index, String value) {
        return AsyncResultSingle.toSingle(handler -> this.lset(key, index, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction ltrim(String key, long from, long to, Handler<AsyncResult<String>> handler) {
        this.delegate.ltrim(key, from, to, handler);
        return this;
    }

    public Single<String> rxLtrim(String key, long from, long to) {
        return AsyncResultSingle.toSingle(handler -> this.ltrim(key, from, to, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction mget(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.mget(key, handler);
        return this;
    }

    public Single<String> rxMget(String key) {
        return AsyncResultSingle.toSingle(handler -> this.mget(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction mgetMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.mgetMany(keys, handler);
        return this;
    }

    public Single<String> rxMgetMany(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.mgetMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction migrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.migrate(host, port, key, destdb, timeout, options, handler);
        return this;
    }

    public Single<String> rxMigrate(String host, int port, String key, int destdb, long timeout, MigrateOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.migrate(host, port, key, destdb, timeout, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction monitor(Handler<AsyncResult<String>> handler) {
        this.delegate.monitor(handler);
        return this;
    }

    public Single<String> rxMonitor() {
        return AsyncResultSingle.toSingle(handler -> this.monitor((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction move(String key, int destdb, Handler<AsyncResult<String>> handler) {
        this.delegate.move(key, destdb, handler);
        return this;
    }

    public Single<String> rxMove(String key, int destdb) {
        return AsyncResultSingle.toSingle(handler -> this.move(key, destdb, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction mset(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.mset(keyvals, handler);
        return this;
    }

    public Single<String> rxMset(JsonObject keyvals) {
        return AsyncResultSingle.toSingle(handler -> this.mset(keyvals, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction msetnx(JsonObject keyvals, Handler<AsyncResult<String>> handler) {
        this.delegate.msetnx(keyvals, handler);
        return this;
    }

    public Single<String> rxMsetnx(JsonObject keyvals) {
        return AsyncResultSingle.toSingle(handler -> this.msetnx(keyvals, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction multi(Handler<AsyncResult<String>> handler) {
        this.delegate.multi(handler);
        return this;
    }

    public Single<String> rxMulti() {
        return AsyncResultSingle.toSingle(handler -> this.multi((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction object(String key, ObjectCmd cmd, Handler<AsyncResult<String>> handler) {
        this.delegate.object(key, cmd, handler);
        return this;
    }

    public Single<String> rxObject(String key, ObjectCmd cmd) {
        return AsyncResultSingle.toSingle(handler -> this.object(key, cmd, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction persist(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.persist(key, handler);
        return this;
    }

    public Single<String> rxPersist(String key) {
        return AsyncResultSingle.toSingle(handler -> this.persist(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pexpire(String key, long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.pexpire(key, millis, handler);
        return this;
    }

    public Single<String> rxPexpire(String key, long millis) {
        return AsyncResultSingle.toSingle(handler -> this.pexpire(key, millis, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pexpireat(String key, long millis, Handler<AsyncResult<String>> handler) {
        this.delegate.pexpireat(key, millis, handler);
        return this;
    }

    public Single<String> rxPexpireat(String key, long millis) {
        return AsyncResultSingle.toSingle(handler -> this.pexpireat(key, millis, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pfadd(String key, String element, Handler<AsyncResult<String>> handler) {
        this.delegate.pfadd(key, element, handler);
        return this;
    }

    public Single<String> rxPfadd(String key, String element) {
        return AsyncResultSingle.toSingle(handler -> this.pfadd(key, element, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pfaddMany(String key, List<String> elements, Handler<AsyncResult<String>> handler) {
        this.delegate.pfaddMany(key, elements, handler);
        return this;
    }

    public Single<String> rxPfaddMany(String key, List<String> elements) {
        return AsyncResultSingle.toSingle(handler -> this.pfaddMany(key, elements, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pfcount(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.pfcount(key, handler);
        return this;
    }

    public Single<String> rxPfcount(String key) {
        return AsyncResultSingle.toSingle(handler -> this.pfcount(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pfcountMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfcountMany(keys, handler);
        return this;
    }

    public Single<String> rxPfcountMany(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.pfcountMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pfmerge(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.pfmerge(destkey, keys, handler);
        return this;
    }

    public Single<String> rxPfmerge(String destkey, List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.pfmerge(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction ping(Handler<AsyncResult<String>> handler) {
        this.delegate.ping(handler);
        return this;
    }

    public Single<String> rxPing() {
        return AsyncResultSingle.toSingle(handler -> this.ping((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction psetex(String key, long millis, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.psetex(key, millis, value, handler);
        return this;
    }

    public Single<String> rxPsetex(String key, long millis, String value) {
        return AsyncResultSingle.toSingle(handler -> this.psetex(key, millis, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction psubscribe(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.psubscribe(pattern, handler);
        return this;
    }

    public Single<String> rxPsubscribe(String pattern) {
        return AsyncResultSingle.toSingle(handler -> this.psubscribe(pattern, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction psubscribeMany(List<String> patterns, Handler<AsyncResult<String>> handler) {
        this.delegate.psubscribeMany(patterns, handler);
        return this;
    }

    public Single<String> rxPsubscribeMany(List<String> patterns) {
        return AsyncResultSingle.toSingle(handler -> this.psubscribeMany(patterns, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pubsubChannels(String pattern, Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubChannels(pattern, handler);
        return this;
    }

    public Single<String> rxPubsubChannels(String pattern) {
        return AsyncResultSingle.toSingle(handler -> this.pubsubChannels(pattern, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pubsubNumsub(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubNumsub(channels, handler);
        return this;
    }

    public Single<String> rxPubsubNumsub(List<String> channels) {
        return AsyncResultSingle.toSingle(handler -> this.pubsubNumsub(channels, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pubsubNumpat(Handler<AsyncResult<String>> handler) {
        this.delegate.pubsubNumpat(handler);
        return this;
    }

    public Single<String> rxPubsubNumpat() {
        return AsyncResultSingle.toSingle(handler -> this.pubsubNumpat((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction pttl(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.pttl(key, handler);
        return this;
    }

    public Single<String> rxPttl(String key) {
        return AsyncResultSingle.toSingle(handler -> this.pttl(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction publish(String channel, String message, Handler<AsyncResult<String>> handler) {
        this.delegate.publish(channel, message, handler);
        return this;
    }

    public Single<String> rxPublish(String channel, String message) {
        return AsyncResultSingle.toSingle(handler -> this.publish(channel, message, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction punsubscribe(List<String> patterns, Handler<AsyncResult<String>> handler) {
        this.delegate.punsubscribe(patterns, handler);
        return this;
    }

    public Single<String> rxPunsubscribe(List<String> patterns) {
        return AsyncResultSingle.toSingle(handler -> this.punsubscribe(patterns, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction randomkey(Handler<AsyncResult<String>> handler) {
        this.delegate.randomkey(handler);
        return this;
    }

    public Single<String> rxRandomkey() {
        return AsyncResultSingle.toSingle(handler -> this.randomkey((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction rename(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rename(key, newkey, handler);
        return this;
    }

    public Single<String> rxRename(String key, String newkey) {
        return AsyncResultSingle.toSingle(handler -> this.rename(key, newkey, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction renamenx(String key, String newkey, Handler<AsyncResult<String>> handler) {
        this.delegate.renamenx(key, newkey, handler);
        return this;
    }

    public Single<String> rxRenamenx(String key, String newkey) {
        return AsyncResultSingle.toSingle(handler -> this.renamenx(key, newkey, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction restore(String key, long millis, String serialized, Handler<AsyncResult<String>> handler) {
        this.delegate.restore(key, millis, serialized, handler);
        return this;
    }

    public Single<String> rxRestore(String key, long millis, String serialized) {
        return AsyncResultSingle.toSingle(handler -> this.restore(key, millis, serialized, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction role(Handler<AsyncResult<String>> handler) {
        this.delegate.role(handler);
        return this;
    }

    public Single<String> rxRole() {
        return AsyncResultSingle.toSingle(handler -> this.role((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction rpop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.rpop(key, handler);
        return this;
    }

    public Single<String> rxRpop(String key) {
        return AsyncResultSingle.toSingle(handler -> this.rpop(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction rpoplpush(String key, String destkey, Handler<AsyncResult<String>> handler) {
        this.delegate.rpoplpush(key, destkey, handler);
        return this;
    }

    public Single<String> rxRpoplpush(String key, String destkey) {
        return AsyncResultSingle.toSingle(handler -> this.rpoplpush(key, destkey, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction rpushMany(String key, List<String> values, Handler<AsyncResult<String>> handler) {
        this.delegate.rpushMany(key, values, handler);
        return this;
    }

    public Single<String> rxRpushMany(String key, List<String> values) {
        return AsyncResultSingle.toSingle(handler -> this.rpushMany(key, values, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction rpush(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.rpush(key, value, handler);
        return this;
    }

    public Single<String> rxRpush(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.rpush(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction rpushx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.rpushx(key, value, handler);
        return this;
    }

    public Single<String> rxRpushx(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.rpushx(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sadd(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.sadd(key, member, handler);
        return this;
    }

    public Single<String> rxSadd(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.sadd(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction saddMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.saddMany(key, members, handler);
        return this;
    }

    public Single<String> rxSaddMany(String key, List<String> members) {
        return AsyncResultSingle.toSingle(handler -> this.saddMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction save(Handler<AsyncResult<String>> handler) {
        this.delegate.save(handler);
        return this;
    }

    public Single<String> rxSave() {
        return AsyncResultSingle.toSingle(handler -> this.save((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scard(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.scard(key, handler);
        return this;
    }

    public Single<String> rxScard(String key) {
        return AsyncResultSingle.toSingle(handler -> this.scard(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scriptExists(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptExists(script, handler);
        return this;
    }

    public Single<String> rxScriptExists(String script) {
        return AsyncResultSingle.toSingle(handler -> this.scriptExists(script, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scriptExistsMany(List<String> scripts, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptExistsMany(scripts, handler);
        return this;
    }

    public Single<String> rxScriptExistsMany(List<String> scripts) {
        return AsyncResultSingle.toSingle(handler -> this.scriptExistsMany(scripts, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scriptFlush(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptFlush(handler);
        return this;
    }

    public Single<String> rxScriptFlush() {
        return AsyncResultSingle.toSingle(handler -> this.scriptFlush((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scriptKill(Handler<AsyncResult<String>> handler) {
        this.delegate.scriptKill(handler);
        return this;
    }

    public Single<String> rxScriptKill() {
        return AsyncResultSingle.toSingle(handler -> this.scriptKill((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scriptLoad(String script, Handler<AsyncResult<String>> handler) {
        this.delegate.scriptLoad(script, handler);
        return this;
    }

    public Single<String> rxScriptLoad(String script) {
        return AsyncResultSingle.toSingle(handler -> this.scriptLoad(script, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sdiff(String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
        this.delegate.sdiff(key, cmpkeys, handler);
        return this;
    }

    public Single<String> rxSdiff(String key, List<String> cmpkeys) {
        return AsyncResultSingle.toSingle(handler -> this.sdiff(key, cmpkeys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sdiffstore(String destkey, String key, List<String> cmpkeys, Handler<AsyncResult<String>> handler) {
        this.delegate.sdiffstore(destkey, key, cmpkeys, handler);
        return this;
    }

    public Single<String> rxSdiffstore(String destkey, String key, List<String> cmpkeys) {
        return AsyncResultSingle.toSingle(handler -> this.sdiffstore(destkey, key, cmpkeys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction select(int dbindex, Handler<AsyncResult<String>> handler) {
        this.delegate.select(dbindex, handler);
        return this;
    }

    public Single<String> rxSelect(int dbindex) {
        return AsyncResultSingle.toSingle(handler -> this.select(dbindex, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction set(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.set(key, value, handler);
        return this;
    }

    public Single<String> rxSet(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.set(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setWithOptions(String key, String value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setWithOptions(key, value, options, handler);
        return this;
    }

    public Single<String> rxSetWithOptions(String key, String value, SetOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.setWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setBinary(String key, io.vertx.reactivex.core.buffer.Buffer value, Handler<AsyncResult<String>> handler) {
        this.delegate.setBinary(key, value.getDelegate(), handler);
        return this;
    }

    public Single<String> rxSetBinary(String key, io.vertx.reactivex.core.buffer.Buffer value) {
        return AsyncResultSingle.toSingle(handler -> this.setBinary(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setBinaryWithOptions(String key, io.vertx.reactivex.core.buffer.Buffer value, SetOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.setBinaryWithOptions(key, value.getDelegate(), options, handler);
        return this;
    }

    public Single<String> rxSetBinaryWithOptions(String key, io.vertx.reactivex.core.buffer.Buffer value, SetOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.setBinaryWithOptions(key, value, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setbit(String key, long offset, int bit, Handler<AsyncResult<String>> handler) {
        this.delegate.setbit(key, offset, bit, handler);
        return this;
    }

    public Single<String> rxSetbit(String key, long offset, int bit) {
        return AsyncResultSingle.toSingle(handler -> this.setbit(key, offset, bit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setex(String key, long seconds, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setex(key, seconds, value, handler);
        return this;
    }

    public Single<String> rxSetex(String key, long seconds, String value) {
        return AsyncResultSingle.toSingle(handler -> this.setex(key, seconds, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setnx(String key, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setnx(key, value, handler);
        return this;
    }

    public Single<String> rxSetnx(String key, String value) {
        return AsyncResultSingle.toSingle(handler -> this.setnx(key, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction setrange(String key, int offset, String value, Handler<AsyncResult<String>> handler) {
        this.delegate.setrange(key, offset, value, handler);
        return this;
    }

    public Single<String> rxSetrange(String key, int offset, String value) {
        return AsyncResultSingle.toSingle(handler -> this.setrange(key, offset, value, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sinter(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sinter(keys, handler);
        return this;
    }

    public Single<String> rxSinter(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.sinter(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sinterstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sinterstore(destkey, keys, handler);
        return this;
    }

    public Single<String> rxSinterstore(String destkey, List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.sinterstore(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sismember(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.sismember(key, member, handler);
        return this;
    }

    public Single<String> rxSismember(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.sismember(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction slaveof(String host, int port, Handler<AsyncResult<String>> handler) {
        this.delegate.slaveof(host, port, handler);
        return this;
    }

    public Single<String> rxSlaveof(String host, int port) {
        return AsyncResultSingle.toSingle(handler -> this.slaveof(host, port, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction slaveofNoone(Handler<AsyncResult<String>> handler) {
        this.delegate.slaveofNoone(handler);
        return this;
    }

    public Single<String> rxSlaveofNoone() {
        return AsyncResultSingle.toSingle(handler -> this.slaveofNoone((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction slowlogGet(int limit, Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogGet(limit, handler);
        return this;
    }

    public Single<String> rxSlowlogGet(int limit) {
        return AsyncResultSingle.toSingle(handler -> this.slowlogGet(limit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction slowlogLen(Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogLen(handler);
        return this;
    }

    public Single<String> rxSlowlogLen() {
        return AsyncResultSingle.toSingle(handler -> this.slowlogLen((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction slowlogReset(Handler<AsyncResult<String>> handler) {
        this.delegate.slowlogReset(handler);
        return this;
    }

    public Single<String> rxSlowlogReset() {
        return AsyncResultSingle.toSingle(handler -> this.slowlogReset((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction smembers(String key, Handler<AsyncResult<JsonArray>> handler) {
        this.delegate.smembers(key, handler);
        return this;
    }

    public Single<JsonArray> rxSmembers(String key) {
        return AsyncResultSingle.toSingle(handler -> this.smembers(key, (Handler<AsyncResult<JsonArray>>)handler));
    }

    public RedisTransaction smove(String key, String destkey, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.smove(key, destkey, member, handler);
        return this;
    }

    public Single<String> rxSmove(String key, String destkey, String member) {
        return AsyncResultSingle.toSingle(handler -> this.smove(key, destkey, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sort(String key, SortOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.sort(key, options, handler);
        return this;
    }

    public Single<String> rxSort(String key, SortOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.sort(key, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction spop(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.spop(key, handler);
        return this;
    }

    public Single<String> rxSpop(String key) {
        return AsyncResultSingle.toSingle(handler -> this.spop(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction spopMany(String key, int count, Handler<AsyncResult<String>> handler) {
        this.delegate.spopMany(key, count, handler);
        return this;
    }

    public Single<String> rxSpopMany(String key, int count) {
        return AsyncResultSingle.toSingle(handler -> this.spopMany(key, count, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction srandmember(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmember(key, handler);
        return this;
    }

    public Single<String> rxSrandmember(String key) {
        return AsyncResultSingle.toSingle(handler -> this.srandmember(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction srandmemberCount(String key, int count, Handler<AsyncResult<String>> handler) {
        this.delegate.srandmemberCount(key, count, handler);
        return this;
    }

    public Single<String> rxSrandmemberCount(String key, int count) {
        return AsyncResultSingle.toSingle(handler -> this.srandmemberCount(key, count, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction srem(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.srem(key, member, handler);
        return this;
    }

    public Single<String> rxSrem(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.srem(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.sremMany(key, members, handler);
        return this;
    }

    public Single<String> rxSremMany(String key, List<String> members) {
        return AsyncResultSingle.toSingle(handler -> this.sremMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction strlen(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.strlen(key, handler);
        return this;
    }

    public Single<String> rxStrlen(String key) {
        return AsyncResultSingle.toSingle(handler -> this.strlen(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction subscribe(String channel, Handler<AsyncResult<String>> handler) {
        this.delegate.subscribe(channel, handler);
        return this;
    }

    public Single<String> rxSubscribe(String channel) {
        return AsyncResultSingle.toSingle(handler -> this.subscribe(channel, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction subscribeMany(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.subscribeMany(channels, handler);
        return this;
    }

    public Single<String> rxSubscribeMany(List<String> channels) {
        return AsyncResultSingle.toSingle(handler -> this.subscribeMany(channels, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sunion(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sunion(keys, handler);
        return this;
    }

    public Single<String> rxSunion(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.sunion(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sunionstore(String destkey, List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.sunionstore(destkey, keys, handler);
        return this;
    }

    public Single<String> rxSunionstore(String destkey, List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.sunionstore(destkey, keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sync(Handler<AsyncResult<String>> handler) {
        this.delegate.sync(handler);
        return this;
    }

    public Single<String> rxSync() {
        return AsyncResultSingle.toSingle(handler -> this.sync((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction time(Handler<AsyncResult<String>> handler) {
        this.delegate.time(handler);
        return this;
    }

    public Single<String> rxTime() {
        return AsyncResultSingle.toSingle(handler -> this.time((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction ttl(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.ttl(key, handler);
        return this;
    }

    public Single<String> rxTtl(String key) {
        return AsyncResultSingle.toSingle(handler -> this.ttl(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction type(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.type(key, handler);
        return this;
    }

    public Single<String> rxType(String key) {
        return AsyncResultSingle.toSingle(handler -> this.type(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction unsubscribe(List<String> channels, Handler<AsyncResult<String>> handler) {
        this.delegate.unsubscribe(channels, handler);
        return this;
    }

    public Single<String> rxUnsubscribe(List<String> channels) {
        return AsyncResultSingle.toSingle(handler -> this.unsubscribe(channels, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction unwatch(Handler<AsyncResult<String>> handler) {
        this.delegate.unwatch(handler);
        return this;
    }

    public Single<String> rxUnwatch() {
        return AsyncResultSingle.toSingle(handler -> this.unwatch((Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction wait(long numSlaves, long timeout, Handler<AsyncResult<String>> handler) {
        this.delegate.wait(numSlaves, timeout, handler);
        return this;
    }

    public Single<String> rxWait(long numSlaves, long timeout) {
        return AsyncResultSingle.toSingle(handler -> this.wait(numSlaves, timeout, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction watch(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.watch(key, handler);
        return this;
    }

    public Single<String> rxWatch(String key) {
        return AsyncResultSingle.toSingle(handler -> this.watch(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction watchMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.watchMany(keys, handler);
        return this;
    }

    public Single<String> rxWatchMany(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.watchMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zadd(String key, double score, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zadd(key, score, member, handler);
        return this;
    }

    public Single<String> rxZadd(String key, double score, String member) {
        return AsyncResultSingle.toSingle(handler -> this.zadd(key, score, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zaddMany(String key, Map<String, Double> members, Handler<AsyncResult<String>> handler) {
        this.delegate.zaddMany(key, members, handler);
        return this;
    }

    public Single<String> rxZaddMany(String key, Map<String, Double> members) {
        return AsyncResultSingle.toSingle(handler -> this.zaddMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zcard(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.zcard(key, handler);
        return this;
    }

    public Single<String> rxZcard(String key) {
        return AsyncResultSingle.toSingle(handler -> this.zcard(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zcount(String key, double min, double max, Handler<AsyncResult<String>> handler) {
        this.delegate.zcount(key, min, max, handler);
        return this;
    }

    public Single<String> rxZcount(String key, double min, double max) {
        return AsyncResultSingle.toSingle(handler -> this.zcount(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zincrby(String key, double increment, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zincrby(key, increment, member, handler);
        return this;
    }

    public Single<String> rxZincrby(String key, double increment, String member) {
        return AsyncResultSingle.toSingle(handler -> this.zincrby(key, increment, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zinterstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zinterstore(destkey, sets, options, handler);
        return this;
    }

    public Single<String> rxZinterstore(String destkey, List<String> sets, AggregateOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zinterstore(destkey, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zinterstoreWeighed(destkey, sets, options, handler);
        return this;
    }

    public Single<String> rxZinterstoreWeighed(String destkey, Map<String, Double> sets, AggregateOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zinterstoreWeighed(destkey, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zlexcount(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zlexcount(key, min, max, handler);
        return this;
    }

    public Single<String> rxZlexcount(String key, String min, String max) {
        return AsyncResultSingle.toSingle(handler -> this.zlexcount(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrange(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
        this.delegate.zrange(key, start, stop, handler);
        return this;
    }

    public Single<String> rxZrange(String key, long start, long stop) {
        return AsyncResultSingle.toSingle(handler -> this.zrange(key, start, stop, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrangeWithOptions(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangeWithOptions(key, start, stop, options, handler);
        return this;
    }

    public Single<String> rxZrangeWithOptions(String key, long start, long stop, RangeOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zrangeWithOptions(key, start, stop, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrangebylex(String key, String min, String max, LimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangebylex(key, min, max, options, handler);
        return this;
    }

    public Single<String> rxZrangebylex(String key, String min, String max, LimitOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zrangebylex(key, min, max, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrangebyscore(String key, String min, String max, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrangebyscore(key, min, max, options, handler);
        return this;
    }

    public Single<String> rxZrangebyscore(String key, String min, String max, RangeLimitOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zrangebyscore(key, min, max, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrank(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrank(key, member, handler);
        return this;
    }

    public Single<String> rxZrank(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.zrank(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrem(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrem(key, member, handler);
        return this;
    }

    public Single<String> rxZrem(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.zrem(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zremMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.zremMany(key, members, handler);
        return this;
    }

    public Single<String> rxZremMany(String key, List<String> members) {
        return AsyncResultSingle.toSingle(handler -> this.zremMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zremrangebylex(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebylex(key, min, max, handler);
        return this;
    }

    public Single<String> rxZremrangebylex(String key, String min, String max) {
        return AsyncResultSingle.toSingle(handler -> this.zremrangebylex(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zremrangebyrank(String key, long start, long stop, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebyrank(key, start, stop, handler);
        return this;
    }

    public Single<String> rxZremrangebyrank(String key, long start, long stop) {
        return AsyncResultSingle.toSingle(handler -> this.zremrangebyrank(key, start, stop, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zremrangebyscore(String key, String min, String max, Handler<AsyncResult<String>> handler) {
        this.delegate.zremrangebyscore(key, min, max, handler);
        return this;
    }

    public Single<String> rxZremrangebyscore(String key, String min, String max) {
        return AsyncResultSingle.toSingle(handler -> this.zremrangebyscore(key, min, max, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrevrange(String key, long start, long stop, RangeOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrange(key, start, stop, options, handler);
        return this;
    }

    public Single<String> rxZrevrange(String key, long start, long stop, RangeOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zrevrange(key, start, stop, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrevrangebylex(String key, String max, String min, LimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrangebylex(key, max, min, options, handler);
        return this;
    }

    public Single<String> rxZrevrangebylex(String key, String max, String min, LimitOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zrevrangebylex(key, max, min, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrevrangebyscore(String key, String max, String min, RangeLimitOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrangebyscore(key, max, min, options, handler);
        return this;
    }

    public Single<String> rxZrevrangebyscore(String key, String max, String min, RangeLimitOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zrevrangebyscore(key, max, min, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zrevrank(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zrevrank(key, member, handler);
        return this;
    }

    public Single<String> rxZrevrank(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.zrevrank(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zscore(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.zscore(key, member, handler);
        return this;
    }

    public Single<String> rxZscore(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.zscore(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zunionstore(String destkey, List<String> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zunionstore(destkey, sets, options, handler);
        return this;
    }

    public Single<String> rxZunionstore(String destkey, List<String> sets, AggregateOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zunionstore(destkey, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zunionstoreWeighed(key, sets, options, handler);
        return this;
    }

    public Single<String> rxZunionstoreWeighed(String key, Map<String, Double> sets, AggregateOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zunionstoreWeighed(key, sets, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction scan(String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.scan(cursor, options, handler);
        return this;
    }

    public Single<String> rxScan(String cursor, ScanOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.scan(cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction sscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.sscan(key, cursor, options, handler);
        return this;
    }

    public Single<String> rxSscan(String key, String cursor, ScanOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.sscan(key, cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction hscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.hscan(key, cursor, options, handler);
        return this;
    }

    public Single<String> rxHscan(String key, String cursor, ScanOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.hscan(key, cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction zscan(String key, String cursor, ScanOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.zscan(key, cursor, options, handler);
        return this;
    }

    public Single<String> rxZscan(String key, String cursor, ScanOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.zscan(key, cursor, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geoadd(String key, double longitude, double latitude, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geoadd(key, longitude, latitude, member, handler);
        return this;
    }

    public Single<String> rxGeoadd(String key, double longitude, double latitude, String member) {
        return AsyncResultSingle.toSingle(handler -> this.geoadd(key, longitude, latitude, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geoaddMany(String key, List<GeoMember> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geoaddMany(key, members, handler);
        return this;
    }

    public Single<String> rxGeoaddMany(String key, List<GeoMember> members) {
        return AsyncResultSingle.toSingle(handler -> this.geoaddMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geohash(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geohash(key, member, handler);
        return this;
    }

    public Single<String> rxGeohash(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.geohash(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geohashMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geohashMany(key, members, handler);
        return this;
    }

    public Single<String> rxGeohashMany(String key, List<String> members) {
        return AsyncResultSingle.toSingle(handler -> this.geohashMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geopos(String key, String member, Handler<AsyncResult<String>> handler) {
        this.delegate.geopos(key, member, handler);
        return this;
    }

    public Single<String> rxGeopos(String key, String member) {
        return AsyncResultSingle.toSingle(handler -> this.geopos(key, member, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geoposMany(String key, List<String> members, Handler<AsyncResult<String>> handler) {
        this.delegate.geoposMany(key, members, handler);
        return this;
    }

    public Single<String> rxGeoposMany(String key, List<String> members) {
        return AsyncResultSingle.toSingle(handler -> this.geoposMany(key, members, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geodist(String key, String member1, String member2, Handler<AsyncResult<String>> handler) {
        this.delegate.geodist(key, member1, member2, handler);
        return this;
    }

    public Single<String> rxGeodist(String key, String member1, String member2) {
        return AsyncResultSingle.toSingle(handler -> this.geodist(key, member1, member2, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction geodistWithUnit(String key, String member1, String member2, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.geodistWithUnit(key, member1, member2, unit, handler);
        return this;
    }

    public Single<String> rxGeodistWithUnit(String key, String member1, String member2, GeoUnit unit) {
        return AsyncResultSingle.toSingle(handler -> this.geodistWithUnit(key, member1, member2, unit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.georadius(key, longitude, latitude, radius, unit, handler);
        return this;
    }

    public Single<String> rxGeoradius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return AsyncResultSingle.toSingle(handler -> this.georadius(key, longitude, latitude, radius, unit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction georadiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusWithOptions(key, longitude, latitude, radius, unit, options, handler);
        return this;
    }

    public Single<String> rxGeoradiusWithOptions(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.georadiusWithOptions(key, longitude, latitude, radius, unit, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction georadiusbymember(String key, String member, double radius, GeoUnit unit, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusbymember(key, member, radius, unit, handler);
        return this;
    }

    public Single<String> rxGeoradiusbymember(String key, String member, double radius, GeoUnit unit) {
        return AsyncResultSingle.toSingle(handler -> this.georadiusbymember(key, member, radius, unit, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction georadiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options, Handler<AsyncResult<String>> handler) {
        this.delegate.georadiusbymemberWithOptions(key, member, radius, unit, options, handler);
        return this;
    }

    public Single<String> rxGeoradiusbymemberWithOptions(String key, String member, double radius, GeoUnit unit, GeoRadiusOptions options) {
        return AsyncResultSingle.toSingle(handler -> this.georadiusbymemberWithOptions(key, member, radius, unit, options, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction unlink(String key, Handler<AsyncResult<String>> handler) {
        this.delegate.unlink(key, handler);
        return this;
    }

    public Single<String> rxUnlink(String key) {
        return AsyncResultSingle.toSingle(handler -> this.unlink(key, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction unlinkMany(List<String> keys, Handler<AsyncResult<String>> handler) {
        this.delegate.unlinkMany(keys, handler);
        return this;
    }

    public Single<String> rxUnlinkMany(List<String> keys) {
        return AsyncResultSingle.toSingle(handler -> this.unlinkMany(keys, (Handler<AsyncResult<String>>)handler));
    }

    public RedisTransaction swapdb(int index1, int index2, Handler<AsyncResult<String>> handler) {
        this.delegate.swapdb(index1, index2, handler);
        return this;
    }

    public Single<String> rxSwapdb(int index1, int index2) {
        return AsyncResultSingle.toSingle(handler -> this.swapdb(index1, index2, (Handler<AsyncResult<String>>)handler));
    }

    public static RedisTransaction newInstance(io.vertx.redis.RedisTransaction arg) {
        return arg != null ? new RedisTransaction(arg) : null;
    }
}

