/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlClientBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.pool.SqlConnectionPool;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;

public abstract class PoolBase<P extends Pool>
extends SqlClientBase<P>
implements Pool,
Closeable {
    private final VertxInternal vertx;
    private final SqlConnectionPool pool;
    private final CloseFuture closeFuture;
    private final long idleTimeout;
    private final long connectionTimeout;
    private final long cleanerPeriod;
    private volatile Handler<SqlConnectionPool.PooledConnection> connectionInitializer;
    private long timerID;
    private volatile Function<Context, Future<SqlConnection>> connectionProvider;

    public PoolBase(VertxInternal vertx, SqlConnectOptions baseConnectOptions, Supplier<Future<SqlConnectOptions>> connectOptionsProvider, QueryTracer tracer, ClientMetrics metrics, int pipeliningLimit, PoolOptions poolOptions) {
        super(tracer, metrics);
        this.idleTimeout = TimeUnit.MILLISECONDS.convert(poolOptions.getIdleTimeout(), poolOptions.getIdleTimeoutUnit());
        this.connectionTimeout = TimeUnit.MILLISECONDS.convert(poolOptions.getConnectionTimeout(), poolOptions.getConnectionTimeoutUnit());
        this.cleanerPeriod = poolOptions.getPoolCleanerPeriod();
        this.timerID = -1L;
        this.vertx = vertx;
        this.pool = new SqlConnectionPool(baseConnectOptions, connectOptionsProvider, ctx -> this.connectionProvider.apply((Context)ctx), () -> this.connectionInitializer, vertx, this.idleTimeout, poolOptions.getMaxSize(), pipeliningLimit, poolOptions.getMaxWaitQueueSize());
        this.closeFuture = new CloseFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public P init() {
        this.closeFuture.add((Closeable)this);
        if (this.idleTimeout > 0L && this.cleanerPeriod > 0L) {
            PoolBase poolBase = this;
            synchronized (poolBase) {
                this.timerID = this.vertx.setTimer(this.cleanerPeriod, id -> this.checkExpired());
            }
        }
        return (P)this;
    }

    public P connectionProvider(Function<Context, Future<SqlConnection>> connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.connectionProvider = connectionProvider;
        return (P)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExpired() {
        PoolBase poolBase = this;
        synchronized (poolBase) {
            if (this.timerID == -1L) {
                return;
            }
            this.timerID = this.vertx.setTimer(this.cleanerPeriod, id -> this.checkExpired());
        }
        this.pool.checkExpired();
    }

    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    protected <T> PromiseInternal<T> promise() {
        return this.vertx.promise();
    }

    @Override
    protected ContextInternal context() {
        return this.vertx.getOrCreateContext();
    }

    @Override
    protected <T> PromiseInternal<T> promise(Handler<AsyncResult<T>> handler) {
        return this.vertx.promise(handler);
    }

    @Override
    public void getConnection(Handler<AsyncResult<SqlConnection>> handler) {
        Future<SqlConnection> fut = this.getConnection();
        if (handler != null) {
            fut.onComplete(handler);
        }
    }

    @Override
    public Future<SqlConnection> getConnection() {
        ContextInternal current = this.vertx.getOrCreateContext();
        Object metric = this.metrics != null ? this.metrics.enqueueRequest() : null;
        PromiseInternal promise = current.promise();
        this.acquire(current, this.connectionTimeout, (Handler<AsyncResult<SqlConnectionPool.PooledConnection>>)promise);
        if (this.metrics != null) {
            promise.future().onComplete(ar -> this.metrics.dequeueRequest(metric));
        }
        return promise.future().map(conn -> {
            SqlConnectionImpl wrapper = this.wrap(current, conn.factory(), (Connection)conn);
            conn.init(wrapper);
            return wrapper;
        });
    }

    @Override
    public <R> Future<R> schedule(ContextInternal context, CommandBase<R> cmd) {
        Object metric = this.metrics != null ? this.metrics.enqueueRequest() : null;
        Future<R> fut = this.pool.execute(context, cmd);
        if (this.metrics != null) {
            fut.onComplete(ar -> {
                if (this.metrics != null) {
                    this.metrics.dequeueRequest(metric);
                }
            });
        }
        return fut;
    }

    private void acquire(ContextInternal context, long timeout, Handler<AsyncResult<SqlConnectionPool.PooledConnection>> completionHandler) {
        this.pool.acquire(context, timeout, completionHandler);
    }

    protected abstract SqlConnectionImpl wrap(ContextInternal var1, ConnectionFactory var2, Connection var3);

    public void close(Promise<Void> completion) {
        this.doClose().onComplete(completion);
    }

    @Override
    public Future<Void> close() {
        PromiseInternal promise = this.vertx.promise();
        this.closeFuture.close((Promise)promise);
        return promise.future();
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.closeFuture.close((Promise)this.vertx.promise(handler));
    }

    @Override
    public Pool connectHandler(Handler<SqlConnection> handler) {
        this.connectionInitializer = handler != null ? conn -> {
            ContextInternal current = this.vertx.getContext();
            SqlConnectionImpl wrapper = this.wrap(current, conn.factory(), (Connection)conn);
            conn.init(wrapper);
            current.dispatch((Object)wrapper, handler);
        } : null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> doClose() {
        PoolBase poolBase = this;
        synchronized (poolBase) {
            if (this.timerID >= 0L) {
                this.vertx.cancelTimer(this.timerID);
                this.timerID = -1L;
            }
        }
        return this.pool.close().onComplete(v -> {
            if (this.metrics != null) {
                this.metrics.close();
            }
        });
    }

    @Override
    public int size() {
        return this.pool.size();
    }

    public void check(Handler<AsyncResult<List<Integer>>> handler) {
        this.pool.check(handler);
    }
}

