/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.accumulator.ArrayListRowAccumulator;
import io.vertx.sqlclient.impl.accumulator.RowAccumulator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.stream.Collector;

class RowSetImpl<R>
extends SqlResultBase<RowSet<R>>
implements RowSet<R> {
    static Collector<Row, RowSetImpl<Row>, RowSet<Row>> COLLECTOR = Collector.of(RowSetImpl::new, RowSetImpl::add, (set1, set2) -> null, set -> set, new Collector.Characteristics[0]);
    static Function<RowSet<Row>, RowSetImpl<Row>> FACTORY = rs -> (RowSetImpl)rs;
    private R firstRow;
    private RowAccumulator<R> rowAccumulator;

    RowSetImpl() {
    }

    static <U> Collector<Row, RowSetImpl<U>, RowSet<U>> collector(Function<Row, U> mapper) {
        return Collector.of(RowSetImpl::new, (set, row) -> set.add(mapper.apply((Row)row)), (set1, set2) -> null, set -> set, new Collector.Characteristics[0]);
    }

    static <U> Function<RowSet<U>, RowSetImpl<U>> factory() {
        return rs -> (RowSetImpl)rs;
    }

    @Override
    public RowSet<R> value() {
        return this;
    }

    private void add(R row) {
        if (this.rowAccumulator != null) {
            this.rowAccumulator.accept(row);
        } else if (this.firstRow != null) {
            this.rowAccumulator = new ArrayListRowAccumulator<R>();
            this.rowAccumulator.accept(this.firstRow);
            this.rowAccumulator.accept(row);
            this.firstRow = null;
        } else {
            this.firstRow = row;
        }
    }

    @Override
    public RowIterator<R> iterator() {
        return this.rowAccumulator != null ? this.rowAccumulator.iterator() : SingletonRowIterator.createFor(this.firstRow);
    }

    @Override
    public RowSetImpl<R> next() {
        return (RowSetImpl)super.next();
    }

    private static final class SingletonRowIterator<ROW>
    implements RowIterator<ROW> {
        static final SingletonRowIterator<Object> EMPTY_INSTANCE = new SingletonRowIterator<Object>(null);
        ROW row;

        SingletonRowIterator(ROW row) {
            this.row = row;
        }

        static <X> SingletonRowIterator<X> createFor(X row) {
            return row != null ? new SingletonRowIterator<X>(row) : EMPTY_INSTANCE;
        }

        @Override
        public boolean hasNext() {
            return this.row != null;
        }

        @Override
        public ROW next() {
            if (this.row != null) {
                ROW res = this.row;
                this.row = null;
                return res;
            }
            throw new NoSuchElementException();
        }
    }
}

