/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.PropertyKind;
import java.util.Arrays;
import java.util.Objects;

public final class PropertyKindMap {
    private static final Object[] EMPTY_ELEMENTS = new Object[0];
    private Object[] elements = EMPTY_ELEMENTS;

    public Object get(PropertyKind<?> property) {
        for (int i = 0; i < this.elements.length; i += 2) {
            Object key = this.elements[i];
            if (key != property && !key.equals(property)) continue;
            return this.elements[i + 1];
        }
        return null;
    }

    public void put(PropertyKind<?> property, Object value) {
        Objects.requireNonNull(property, "property is null");
        Objects.requireNonNull(value, "value is null");
        for (int i = 0; i < this.elements.length; i += 2) {
            Object key = this.elements[i];
            if (key != property && !key.equals(property)) continue;
            this.elements[i + 1] = value;
            return;
        }
        this.elements = this.elements == EMPTY_ELEMENTS ? new Object[2] : Arrays.copyOf(this.elements, this.elements.length + 2);
        this.elements[this.elements.length - 2] = property;
        this.elements[this.elements.length - 1] = value;
    }

    int count() {
        return this.elements.length >> 1;
    }
}

