/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.QueryResultBuilder;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CommandScheduler;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collector;

class QueryExecutor<T, R extends SqlResultBase<T>, L extends SqlResult<T>> {
    private final Function<T, R> factory;
    private final Collector<Row, ?, T> collector;

    public QueryExecutor(Function<T, R> factory, Collector<Row, ?, T> collector) {
        this.factory = factory;
        this.collector = collector;
    }

    private QueryResultBuilder<T, R, L> createHandler(PromiseInternal<L> promise) {
        return new QueryResultBuilder<T, R, L>(this.factory, promise);
    }

    void executeSimpleQuery(CommandScheduler scheduler, String sql, boolean autoCommit, boolean singleton, PromiseInternal<L> promise) {
        ContextInternal context = promise.context();
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise);
        scheduler.schedule(context, new SimpleQueryCommand<T>(sql, singleton, autoCommit, this.collector, handler)).onComplete(handler);
    }

    QueryResultBuilder<T, R, L> executeExtendedQuery(CommandScheduler scheduler, PreparedStatement preparedStatement, PrepareOptions options, boolean autoCommit, Tuple arguments, int fetch, String cursorId, boolean suspended, PromiseInternal<L> promise) {
        ContextInternal context = promise.context();
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise);
        String msg = preparedStatement.prepare((TupleInternal)arguments);
        if (msg != null) {
            handler.fail(msg);
            return null;
        }
        ExtendedQueryCommand<T> cmd = ExtendedQueryCommand.createQuery(preparedStatement.sql(), options, preparedStatement, arguments, fetch, cursorId, suspended, autoCommit, this.collector, handler);
        scheduler.schedule(context, cmd).onComplete(handler);
        return handler;
    }

    void executeExtendedQuery(CommandScheduler scheduler, String sql, PrepareOptions options, boolean autoCommit, Tuple arguments, PromiseInternal<L> promise) {
        ContextInternal context = promise.context();
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise);
        ExtendedQueryCommand<T> cmd = this.createExtendedQueryCommand(sql, options, autoCommit, arguments, handler);
        scheduler.schedule(context, cmd).onComplete(handler);
    }

    private ExtendedQueryCommand<T> createExtendedQueryCommand(String sql, PrepareOptions options, boolean autoCommit, Tuple tuple, QueryResultBuilder<T, R, L> handler) {
        return ExtendedQueryCommand.createQuery(sql, options, null, tuple, autoCommit, this.collector, handler);
    }

    void executeBatchQuery(CommandScheduler scheduler, PrepareOptions options, PreparedStatement preparedStatement, boolean autoCommit, List<Tuple> batch, PromiseInternal<L> promise) {
        ContextInternal context = promise.context();
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise);
        for (Tuple args : batch) {
            String msg = preparedStatement.prepare((TupleInternal)args);
            if (msg == null) continue;
            handler.fail(msg);
            return;
        }
        ExtendedQueryCommand<T> cmd = ExtendedQueryCommand.createBatch(preparedStatement.sql(), options, preparedStatement, batch, autoCommit, this.collector, handler);
        scheduler.schedule(context, cmd).onComplete(handler);
    }

    void executeBatchQuery(CommandScheduler scheduler, String sql, PrepareOptions options, boolean autoCommit, List<Tuple> batch, PromiseInternal<L> promise) {
        ContextInternal context = promise.context();
        QueryResultBuilder<T, R, L> handler = this.createHandler(promise);
        ExtendedQueryCommand<T> cmd = this.createBatchQueryCommand(sql, options, autoCommit, batch, handler);
        scheduler.schedule(context, cmd).onComplete(handler);
    }

    private ExtendedQueryCommand<T> createBatchQueryCommand(String sql, PrepareOptions options, boolean autoCommit, List<Tuple> argsList, QueryResultBuilder<T, R, L> handler) {
        return ExtendedQueryCommand.createBatch(sql, options, null, argsList, autoCommit, this.collector, handler);
    }
}

