/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.impl.PropertyKindMap;
import java.util.List;

public abstract class SqlResultBase<T>
implements SqlResult<T> {
    int updated;
    List<String> columnNames;
    List<ColumnDescriptor> columnDescriptors;
    int size;
    SqlResult<T> next;
    PropertyKindMap properties;

    @Override
    public List<String> columnsNames() {
        return this.columnNames;
    }

    @Override
    public List<ColumnDescriptor> columnDescriptors() {
        return this.columnDescriptors;
    }

    @Override
    public int rowCount() {
        return this.updated;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public <V> V property(PropertyKind<V> property) {
        if (property == null) {
            throw new IllegalArgumentException("Property can not be null");
        }
        if (this.properties == null) {
            return null;
        }
        Object value = this.properties.get(property);
        if (value == null) {
            return null;
        }
        Class<V> type = property.type();
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        throw new IllegalArgumentException("Invalid property kind: " + value.getClass().getName() + " is not an instance of " + type.getName());
    }

    @Override
    public SqlResult<T> next() {
        return this.next;
    }
}

