/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class LruCache<K, V>
extends LinkedHashMap<K, V> {
    List<V> removed;
    private final int capacity;

    public LruCache(int capacity) {
        super(capacity, 0.75f, true);
        this.capacity = capacity;
    }

    public V evict() {
        Iterator it = this.values().iterator();
        if (it.hasNext()) {
            Object value = it.next();
            it.remove();
            return value;
        }
        return null;
    }

    public List<V> cache(K key, V value) {
        this.put(key, value);
        if (this.removed != null) {
            List<V> evicted = this.removed;
            this.removed = null;
            return evicted;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        boolean evict;
        boolean bl = evict = this.size() > this.capacity;
        if (evict) {
            if (this.removed == null) {
                this.removed = new ArrayList<V>();
            }
            this.removed.add(eldest.getValue());
            return true;
        }
        return false;
    }
}

