/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.QueryStringEncoder;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.ReadStream;
import io.vertx.ext.auth.authentication.Credentials;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.ext.web.client.impl.ClientUri;
import io.vertx.ext.web.client.impl.HttpContext;
import io.vertx.ext.web.client.impl.WebClientBase;
import io.vertx.ext.web.client.predicate.ResponsePredicate;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.multipart.MultipartForm;
import io.vertx.uritemplate.UriTemplate;
import io.vertx.uritemplate.Variables;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HttpRequestImpl<T>
implements HttpRequest<T> {
    final WebClientBase client;
    ProxyOptions proxyOptions;
    SocketAddress serverAddress;
    MultiMap queryParams;
    Variables templateParams;
    HttpMethod method;
    UriTemplate absoluteUri;
    private Integer port;
    private String host;
    String virtualHost;
    Object uri;
    MultiMap headers;
    long timeout = -1L;
    BodyCodec<T> codec;
    boolean followRedirects;
    Boolean ssl;
    boolean multipartMixed = true;
    public List<ResponsePredicate> expectations;

    private HttpRequestImpl(WebClientBase client, HttpMethod method, SocketAddress serverAddress, BodyCodec<T> codec, WebClientOptions options, ProxyOptions proxyOptions) {
        this.client = client;
        this.method = method;
        this.codec = codec;
        this.serverAddress = serverAddress;
        this.followRedirects = options.isFollowRedirects();
        this.proxyOptions = proxyOptions != null ? new ProxyOptions(proxyOptions) : null;
        this.headers = options.isUserAgentEnabled() ? HttpHeaders.set((CharSequence)HttpHeaders.USER_AGENT, (CharSequence)options.getUserAgent()) : HttpHeaders.headers();
    }

    HttpRequestImpl(WebClientBase client, HttpMethod method, SocketAddress serverAddress, UriTemplate absoluteUri, BodyCodec<T> codec, WebClientOptions options, ProxyOptions proxyOptions) {
        this(client, method, serverAddress, codec, options, proxyOptions);
        Objects.requireNonNull(absoluteUri, "absoluteUri cannot be null");
        this.absoluteUri = absoluteUri;
    }

    HttpRequestImpl(WebClientBase client, HttpMethod method, SocketAddress serverAddress, Boolean ssl, int port, String host, Object uri, BodyCodec<T> codec, WebClientOptions options, ProxyOptions proxyOptions) {
        this(client, method, serverAddress, codec, options, proxyOptions);
        Objects.requireNonNull(host, "Host cannot be null");
        this.codec = codec;
        this.port = port;
        this.host = host;
        this.uri = uri;
        this.ssl = ssl;
    }

    private HttpRequestImpl(HttpRequestImpl<T> other) {
        this.client = other.client;
        this.serverAddress = other.serverAddress;
        this.proxyOptions = other.proxyOptions != null ? new ProxyOptions(other.proxyOptions) : null;
        this.method = other.method;
        this.absoluteUri = other.absoluteUri;
        this.port = other.port;
        this.host = other.host;
        this.timeout = other.timeout;
        this.uri = other.uri;
        this.headers = other.headers != null ? HttpHeaders.headers().addAll(other.headers) : HttpHeaders.headers();
        this.queryParams = other.queryParams != null ? MultiMap.caseInsensitiveMultiMap().addAll(other.queryParams) : null;
        this.codec = other.codec;
        this.followRedirects = other.followRedirects;
        this.ssl = other.ssl;
        this.multipartMixed = other.multipartMixed;
        this.virtualHost = other.virtualHost;
        this.expectations = other.expectations != null ? new ArrayList<ResponsePredicate>(other.expectations) : null;
    }

    @Override
    public <U> HttpRequest<U> as(BodyCodec<U> responseCodec) {
        this.codec = responseCodec;
        return this;
    }

    @Override
    public HttpRequest<T> method(HttpMethod value) {
        this.method = value;
        return this;
    }

    @Override
    public HttpRequest<T> port(int value) {
        this.port = value;
        return this;
    }

    private static String buildUri(String uri, MultiMap queryParams) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri);
        QueryStringEncoder encoder = new QueryStringEncoder(decoder.rawPath());
        decoder.parameters().forEach((name, values) -> {
            for (String value : values) {
                encoder.addParam(name, value);
            }
        });
        queryParams.forEach(param -> encoder.addParam((String)param.getKey(), (String)param.getValue()));
        uri = encoder.toString();
        return uri;
    }

    RequestOptions buildRequestOptions() throws URISyntaxException, MalformedURLException {
        Boolean ssl;
        String protocol;
        int port;
        String host;
        String uri;
        if (this.absoluteUri != null) {
            uri = this.absoluteUri.expandToString(this.templateParams(), this.client.options.getTemplateExpandOptions());
            ClientUri curi = ClientUri.parse(uri);
            uri = curi.uri;
            host = curi.host;
            port = curi.port;
            protocol = curi.protocol;
            ssl = curi.ssl;
        } else {
            port = this.port;
            host = this.host;
            ssl = this.ssl;
            uri = this.uri instanceof String ? (String)this.uri : ((UriTemplate)this.uri).expandToString(this.templateParams(), this.client.options.getTemplateExpandOptions());
            protocol = null;
        }
        if (this.queryParams != null) {
            uri = HttpRequestImpl.buildUri(uri, this.queryParams);
        }
        RequestOptions requestOptions = new RequestOptions();
        if (protocol != null && !protocol.equals("http") && !protocol.equals("https")) {
            URI tmp = new URI(protocol, null, host, port, uri, null, null);
            requestOptions.setServer(this.serverAddress).setMethod(this.method).setAbsoluteURI(tmp.toString());
        } else {
            requestOptions.setServer(this.serverAddress).setMethod(this.method).setHost(host).setPort(Integer.valueOf(port)).setURI(uri);
            if (ssl != null) {
                requestOptions.setSsl(ssl);
            }
        }
        if (this.virtualHost != null) {
            if (requestOptions.getServer() == null) {
                requestOptions.setServer(SocketAddress.inetSocketAddress((int)requestOptions.getPort(), (String)requestOptions.getHost()));
            }
            requestOptions.setHost(this.virtualHost);
        }
        this.mergeHeaders(requestOptions);
        requestOptions.setTimeout(this.timeout);
        requestOptions.setProxyOptions(this.proxyOptions);
        return requestOptions;
    }

    @Override
    public HttpRequest<T> host(String value) {
        Objects.requireNonNull(this.host, "Host cannot be null");
        this.host = value;
        return this;
    }

    @Override
    public HttpRequest<T> virtualHost(String value) {
        this.virtualHost = value;
        return this;
    }

    @Override
    public HttpRequest<T> uri(String value) {
        this.queryParams = null;
        this.uri = value;
        return this;
    }

    public String uri() {
        return this.uri.toString();
    }

    @Override
    public HttpRequest<T> putHeaders(MultiMap headers) {
        this.headers().addAll(headers);
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpRequest<T> putHeader(String name, Iterable<String> value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = HttpHeaders.headers();
        }
        return this.headers;
    }

    @Override
    public HttpRequest<T> authentication(Credentials credentials) {
        this.putHeader(HttpHeaders.AUTHORIZATION.toString(), credentials.toHttpAuthorization());
        return this;
    }

    @Override
    public HttpRequest<T> ssl(Boolean value) {
        this.ssl = value;
        return this;
    }

    @Override
    public HttpRequest<T> timeout(long value) {
        this.timeout = value;
        return this;
    }

    @Override
    public HttpRequest<T> addQueryParam(String paramName, String paramValue) {
        this.queryParams().add(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setQueryParam(String paramName, String paramValue) {
        this.queryParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setTemplateParam(String paramName, String paramValue) {
        this.templateParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setTemplateParam(String paramName, List<String> paramValue) {
        this.templateParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> setTemplateParam(String paramName, Map<String, String> paramValue) {
        this.templateParams().set(paramName, paramValue);
        return this;
    }

    @Override
    public HttpRequest<T> followRedirects(boolean value) {
        this.followRedirects = value;
        return this;
    }

    @Override
    public HttpRequest<T> proxy(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    @Override
    public HttpRequest<T> expect(ResponsePredicate expectation) {
        if (this.expectations == null) {
            this.expectations = new ArrayList<ResponsePredicate>();
        }
        this.expectations.add(expectation);
        return this;
    }

    @Override
    public MultiMap queryParams() {
        if (this.queryParams == null) {
            int idx;
            this.queryParams = MultiMap.caseInsensitiveMultiMap();
            if (this.uri instanceof String && (idx = ((String)this.uri).indexOf(63)) >= 0) {
                QueryStringDecoder dec = new QueryStringDecoder((String)this.uri);
                dec.parameters().forEach((name, value) -> this.queryParams.add(name, (Iterable)value));
                this.uri = ((String)this.uri).substring(0, idx);
            }
        }
        return this.queryParams;
    }

    @Override
    public Variables templateParams() {
        if (!(this.uri instanceof UriTemplate) && !(this.absoluteUri instanceof UriTemplate)) {
            throw new IllegalStateException();
        }
        if (this.templateParams == null) {
            this.templateParams = Variables.variables();
        }
        return this.templateParams;
    }

    @Override
    public HttpRequest<T> copy() {
        return new HttpRequestImpl<T>(this);
    }

    @Override
    public HttpRequest<T> multipartMixed(boolean allow) {
        this.multipartMixed = allow;
        return this;
    }

    @Override
    public void sendStream(ReadStream<Buffer> body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, body, handler);
    }

    @Override
    public void send(Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, null, handler);
    }

    @Override
    public void sendBuffer(Buffer body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send(null, body, handler);
    }

    @Override
    public void sendJsonObject(JsonObject body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/json", body, handler);
    }

    @Override
    public void sendJson(Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("application/json", body, handler);
    }

    @Override
    public void sendForm(MultiMap body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.sendForm(body, "UTF-8", handler);
    }

    @Override
    public void sendForm(MultiMap body, String charset, Handler<AsyncResult<HttpResponse<T>>> handler) {
        MultipartForm parts = MultipartForm.create();
        for (Map.Entry attribute : body) {
            parts.attribute((String)attribute.getKey(), (String)attribute.getValue());
        }
        parts.setCharset(charset);
        this.send("application/x-www-form-urlencoded", parts, handler);
    }

    @Override
    public void sendMultipartForm(MultipartForm body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        this.send("multipart/form-data", body, handler);
    }

    void send(String contentType, Object body, Handler<AsyncResult<HttpResponse<T>>> handler) {
        HttpContext<T> ctx = this.client.createContext(handler);
        ctx.prepareRequest(this, contentType, body);
    }

    void mergeHeaders(RequestOptions options) {
        if (this.headers != null) {
            MultiMap tmp = options.getHeaders();
            if (tmp == null) {
                tmp = MultiMap.caseInsensitiveMultiMap();
                options.setHeaders(tmp);
            }
            tmp.addAll(this.headers);
        }
    }
}

