/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.impl;

import io.vertx.core.Handler;
import io.vertx.ext.web.AllowForwardHeaders;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.impl.RouteImpl;
import io.vertx.ext.web.impl.RouterImpl;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

final class RouterState {
    private static final Comparator<RouteImpl> routeComparator = (o1, o2) -> {
        int compare = Integer.compare(o1.order(), o2.order());
        if (compare == 0) {
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
        return compare;
    };
    private final RouterImpl router;
    private final TreeSet<RouteImpl> routes;
    private final int orderSequence;
    private final Map<Integer, Handler<RoutingContext>> errorHandlers;
    private final Handler<Router> modifiedHandler;
    private final AllowForwardHeaders allowForward;
    private final Map<String, Object> metadata;

    public RouterState(RouterImpl router, TreeSet<RouteImpl> routes, int orderSequence, Map<Integer, Handler<RoutingContext>> errorHandlers, Handler<Router> modifiedHandler, AllowForwardHeaders allowForward, Map<String, Object> metadata) {
        this.router = router;
        this.routes = routes;
        this.orderSequence = orderSequence;
        this.errorHandlers = errorHandlers;
        this.modifiedHandler = modifiedHandler;
        this.allowForward = allowForward;
        this.metadata = metadata;
    }

    public RouterState(RouterImpl router) {
        this(router, null, 0, null, null, AllowForwardHeaders.NONE, null);
    }

    public RouterImpl router() {
        return this.router;
    }

    public Set<RouteImpl> getRoutes() {
        if (this.routes == null) {
            return Collections.emptySet();
        }
        return this.routes;
    }

    RouterState setRoutes(Set<RouteImpl> routes) {
        RouterState newState = new RouterState(this.router, new TreeSet<RouteImpl>(routeComparator), this.orderSequence, this.errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
        newState.routes.addAll(routes);
        return newState;
    }

    RouterState addRoute(RouteImpl route) {
        TreeSet<RouteImpl> routes = new TreeSet<RouteImpl>(routeComparator);
        if (this.routes != null) {
            routes.addAll(this.routes);
        }
        routes.add(route);
        return new RouterState(this.router, routes, this.orderSequence, this.errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
    }

    RouterState clearRoutes() {
        return new RouterState(this.router, new TreeSet<RouteImpl>(routeComparator), this.orderSequence, this.errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
    }

    RouterState removeRoute(RouteImpl route) {
        TreeSet<RouteImpl> routes = new TreeSet<RouteImpl>(routeComparator);
        if (this.routes != null) {
            routes.addAll(this.routes);
        }
        routes.remove(route);
        return new RouterState(this.router, routes, this.orderSequence, this.errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
    }

    public int getOrderSequence() {
        return this.orderSequence;
    }

    RouterState incrementOrderSequence() {
        return new RouterState(this.router, this.routes, this.orderSequence + 1, this.errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
    }

    RouterState setOrderSequence(int orderSequence) {
        return new RouterState(this.router, this.routes, orderSequence, this.errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
    }

    public Map<Integer, Handler<RoutingContext>> getErrorHandlers() {
        return this.errorHandlers;
    }

    RouterState setErrorHandlers(Map<Integer, Handler<RoutingContext>> errorHandlers) {
        return new RouterState(this.router, this.routes, this.orderSequence, errorHandlers, this.modifiedHandler, this.allowForward, this.metadata);
    }

    Handler<RoutingContext> getErrorHandler(int errorCode) {
        if (this.errorHandlers != null) {
            return this.errorHandlers.get(errorCode);
        }
        return null;
    }

    RouterState putErrorHandler(int errorCode, Handler<RoutingContext> errorHandler) {
        RouterState newState = new RouterState(this.router, this.routes, this.orderSequence, this.errorHandlers == null ? new HashMap<Integer, Handler<RoutingContext>>() : new HashMap<Integer, Handler<RoutingContext>>(this.errorHandlers), this.modifiedHandler, this.allowForward, this.metadata);
        newState.errorHandlers.put(errorCode, errorHandler);
        return newState;
    }

    public Handler<Router> getModifiedHandler() {
        return this.modifiedHandler;
    }

    public RouterState setModifiedHandler(Handler<Router> modifiedHandler) {
        return new RouterState(this.router, this.routes, this.orderSequence, this.errorHandlers, modifiedHandler, this.allowForward, this.metadata);
    }

    public RouterState setAllowForward(AllowForwardHeaders allow) {
        return new RouterState(this.router, this.routes, this.orderSequence, this.errorHandlers, this.modifiedHandler, allow, this.metadata);
    }

    public AllowForwardHeaders getAllowForward() {
        return this.allowForward;
    }

    public RouterState putMetadata(String key, Object value) {
        HashMap<String, Object> metadata;
        HashMap<String, Object> hashMap = metadata = this.metadata == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.metadata);
        if (value == null) {
            metadata.remove(key);
        } else {
            metadata.put(key, value);
        }
        return new RouterState(this.router, this.routes, this.orderSequence, this.errorHandlers, this.modifiedHandler, this.allowForward, Collections.unmodifiableMap(metadata));
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "RouterState{routes=" + this.routes + ", orderSequence=" + this.orderSequence + ", errorHandlers=" + this.errorHandlers + ", modifiedHandler=" + this.modifiedHandler + ", this.allowForward=" + (Object)((Object)this.allowForward) + ", metadata=" + this.metadata + '}';
    }
}

