/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.fields;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Field
implements Argument {
    private final String name;
    private final Field[] fields;

    @Override
    public String build() {
        StringBuilder s = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            s.append(this.name);
        }
        if (ArrayUtils.isNotEmpty((Object[])this.fields)) {
            s.append(String.format("{%s}", Arrays.stream(this.fields).map(Field::build).collect(Collectors.joining(" "))));
        }
        return s.toString();
    }

    Field(String name, Field[] fields) {
        this.name = name;
        this.fields = fields;
    }

    public static FieldBuilder builder() {
        return new FieldBuilder();
    }

    public String getName() {
        return this.name;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public String toString() {
        return "Field(name=" + this.getName() + ", fields=" + Arrays.deepToString(this.getFields()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Field)) {
            return false;
        }
        Field other = (Field)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        return Arrays.deepEquals(this.getFields(), other.getFields());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Field;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getFields());
        return result;
    }

    public static class FieldBuilder {
        private String name;
        private Field[] fields;

        public FieldBuilder fields(Field ... fields) {
            this.fields = fields;
            return this;
        }

        FieldBuilder() {
        }

        public FieldBuilder name(String name) {
            this.name = name;
            return this;
        }

        public Field build() {
            return new Field(this.name, this.fields);
        }

        public String toString() {
            return "Field.FieldBuilder(name=" + this.name + ", fields=" + Arrays.deepToString(this.fields) + ")";
        }
    }
}

