/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.builder;

import com.google.protobuf.GeneratedMessageV3;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBase;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBaseSearch;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoSearchGet;
import io.weaviate.client.v1.filters.WhereFilter;
import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.Bm25Argument;
import io.weaviate.client.v1.graphql.query.argument.GroupArgument;
import io.weaviate.client.v1.graphql.query.argument.GroupByArgument;
import io.weaviate.client.v1.graphql.query.argument.HybridArgument;
import io.weaviate.client.v1.graphql.query.argument.NearAudioArgument;
import io.weaviate.client.v1.graphql.query.argument.NearDepthArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImuArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearThermalArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVideoArgument;
import io.weaviate.client.v1.graphql.query.argument.SortArguments;
import io.weaviate.client.v1.graphql.query.argument.WhereArgument;
import io.weaviate.client.v1.graphql.query.builder.Query;
import io.weaviate.client.v1.graphql.query.fields.Field;
import io.weaviate.client.v1.graphql.query.fields.Fields;
import io.weaviate.client.v1.graphql.query.fields.GenerativeSearchBuilder;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import io.weaviate.client.v1.grpc.GRPC;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GetBuilder
implements Query {
    private final String className;
    private final Fields fields;
    private final Integer offset;
    private final Integer limit;
    private final String after;
    private final Integer autocut;
    private final String withConsistencyLevel;
    private final WhereArgument withWhereFilter;
    private final Bm25Argument withBm25Filter;
    private final HybridArgument withHybridFilter;
    private final AskArgument withAskArgument;
    private final NearTextArgument withNearTextFilter;
    private final NearObjectArgument withNearObjectFilter;
    private final NearVectorArgument withNearVectorFilter;
    private final NearImageArgument withNearImageFilter;
    private final NearAudioArgument withNearAudioFilter;
    private final NearVideoArgument withNearVideoFilter;
    private final NearDepthArgument withNearDepthFilter;
    private final NearThermalArgument withNearThermalFilter;
    private final NearImuArgument withNearImuFilter;
    private final GroupArgument withGroupArgument;
    private final SortArguments withSortArguments;
    private final GenerativeSearchBuilder withGenerativeSearch;
    private final GroupByArgument withGroupByArgument;
    private final String tenant;

    private Stream<Argument> buildableArguments() {
        return Stream.of(this.withWhereFilter, this.withAskArgument, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withGroupArgument, this.withBm25Filter, this.withHybridFilter, this.withSortArguments, this.withGroupByArgument, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter);
    }

    private Stream<Object> nonStringArguments() {
        return Stream.of(this.limit, this.offset, this.autocut);
    }

    private Stream<String> stringArguments() {
        return Stream.of(this.withConsistencyLevel, this.after, this.tenant);
    }

    private boolean includesFilterClause() {
        return this.buildableArguments().anyMatch(Objects::nonNull) || this.nonStringArguments().anyMatch(Objects::nonNull) || this.stringArguments().anyMatch(StringUtils::isNotBlank);
    }

    private String createFilterClause() {
        if (this.includesFilterClause()) {
            LinkedHashSet<String> filters = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.tenant)) {
                filters.add(String.format("tenant:%s", Serializer.quote(this.tenant)));
            }
            this.buildableArguments().filter(Objects::nonNull).map(Argument::build).forEach(filters::add);
            if (this.limit != null) {
                filters.add(String.format("limit:%s", this.limit));
            }
            if (this.offset != null) {
                filters.add(String.format("offset:%s", this.offset));
            }
            if (StringUtils.isNotBlank((CharSequence)this.after)) {
                filters.add(String.format("after:%s", Serializer.quote(this.after)));
            }
            if (StringUtils.isNotBlank((CharSequence)this.withConsistencyLevel)) {
                filters.add(String.format("consistencyLevel:%s", Serializer.escape(this.withConsistencyLevel)));
            }
            if (this.autocut != null) {
                filters.add(String.format("autocut:%s", this.autocut));
            }
            return String.format("(%s)", String.join((CharSequence)" ", filters));
        }
        return "";
    }

    private String createFields() {
        if (ObjectUtils.allNull((Object[])new Object[]{this.fields, this.withGenerativeSearch})) {
            return "";
        }
        if (this.withGenerativeSearch == null) {
            return this.fields.build();
        }
        Field generate = this.withGenerativeSearch.build();
        Field generateAdditional = Field.builder().name("_additional").fields(generate).build();
        if (this.fields == null) {
            return generateAdditional.build();
        }
        Map<Boolean, List<Field>> grouped = Arrays.stream(this.fields.getFields()).collect(Collectors.groupingBy(f -> "_additional".equals(f.getName())));
        List additionals = grouped.getOrDefault(true, new ArrayList());
        if (additionals.isEmpty()) {
            additionals.add(generateAdditional);
        } else {
            Field[] mergedInternalFields = (Field[])Stream.concat(Arrays.stream(((Field)additionals.get(0)).getFields()), Stream.of(generate)).toArray(Field[]::new);
            additionals.set(0, Field.builder().name("_additional").fields(mergedInternalFields).build());
        }
        Field[] allFields = (Field[])Stream.concat(((List)grouped.getOrDefault(false, new ArrayList())).stream(), additionals.stream()).toArray(Field[]::new);
        return Fields.builder().fields(allFields).build().build();
    }

    @Override
    public String buildQuery() {
        return String.format("{Get{%s%s{%s}}}", Serializer.escape(this.className), this.createFilterClause(), this.createFields());
    }

    public WeaviateProtoSearchGet.SearchRequest buildSearchRequest() {
        WeaviateProtoSearchGet.SearchRequest.Builder search = WeaviateProtoSearchGet.SearchRequest.newBuilder();
        search.setCollection(this.className);
        if (StringUtils.isNotBlank((CharSequence)this.tenant)) {
            search.setTenant(this.tenant);
        }
        if (this.withWhereFilter != null) {
            WeaviateProtoBase.Filters.Builder filters = WeaviateProtoBase.Filters.newBuilder();
            this.addWhereFilters(filters, this.withWhereFilter.getFilter());
            search.setFilters(filters.build());
        }
        if (this.withNearVectorFilter != null) {
            WeaviateProtoBaseSearch.NearVector.Builder nearVector = WeaviateProtoBaseSearch.NearVector.newBuilder();
            NearVectorArgument f2 = this.withNearVectorFilter;
            Object[] vector = f2.getVector();
            if (vector != null) {
                nearVector.setVectorBytes(GRPC.toByteString(f2.getVector()));
            }
            if (f2.getCertainty() != null) {
                nearVector.setCertainty(f2.getCertainty().floatValue());
            } else if (f2.getDistance() != null) {
                nearVector.setDistance(f2.getDistance().floatValue());
            }
            search.setNearVector(nearVector.build());
        }
        if (this.limit != null) {
            search.setLimit(this.limit);
        }
        if (this.offset != null) {
            search.setOffset(this.offset);
        }
        if (StringUtils.isNotBlank((CharSequence)this.after)) {
            search.setAfter(this.after);
        }
        if (StringUtils.isNotBlank((CharSequence)this.withConsistencyLevel)) {
            search.setConsistencyLevelValue(Integer.valueOf(this.withConsistencyLevel));
        }
        if (this.autocut != null) {
            search.setAutocut(this.autocut);
        }
        if (this.fields != null) {
            List props;
            Optional<Field> _additional = Arrays.stream(this.fields.getFields()).filter(f -> "_additional".equals(f.getName())).findFirst();
            if (_additional.isPresent()) {
                WeaviateProtoSearchGet.MetadataRequest.Builder metadata = WeaviateProtoSearchGet.MetadataRequest.newBuilder();
                block10: for (Field f3 : _additional.get().getFields()) {
                    switch (f3.getName()) {
                        case "id": {
                            metadata.setUuid(true);
                            continue block10;
                        }
                        case "vector": {
                            metadata.setVector(true);
                            continue block10;
                        }
                        case "distance": {
                            metadata.setDistance(true);
                        }
                    }
                }
                search.setMetadata(metadata.build());
            }
            if (!(props = Arrays.stream(this.fields.getFields()).filter(f -> !"_additional".equals(f.getName())).collect(Collectors.toList())).isEmpty()) {
                WeaviateProtoSearchGet.PropertiesRequest.Builder properties = WeaviateProtoSearchGet.PropertiesRequest.newBuilder();
                for (Field f4 : props) {
                    properties.addNonRefProperties(f4.getName());
                }
                search.setProperties(properties.build());
            }
        }
        search.setUses123Api(true);
        search.setUses125Api(true);
        search.setUses127Api(true);
        return search.build();
    }

    private void addWhereFilters(WeaviateProtoBase.Filters.Builder where, WhereFilter f) {
        Object[] operands = f.getOperands();
        if (ArrayUtils.isNotEmpty((Object[])operands)) {
            for (Object op : operands) {
                WeaviateProtoBase.Filters.Builder nested = WeaviateProtoBase.Filters.newBuilder();
                this.addWhereFilters(nested, (WhereFilter)op);
                where.addFilters(nested);
            }
        } else {
            if (ArrayUtils.isNotEmpty((Object[])f.getPath())) {
                where.addOn(f.getPath()[0]);
            }
            if (f.getValueBoolean() == null) {
                GeneratedMessageV3.Builder arr;
                if (f.getValueBooleanArray() != null) {
                    arr = WeaviateProtoBase.BooleanArray.newBuilder();
                    Arrays.stream(f.getValueBooleanArray()).forEach(arg_0 -> GetBuilder.lambda$addWhereFilters$5((WeaviateProtoBase.BooleanArray.Builder)arr, arg_0));
                    where.setValueBooleanArray(arr.build());
                } else if (f.getValueInt() != null) {
                    where.setValueInt(f.getValueInt().intValue());
                } else if (f.getValueIntArray() != null) {
                    arr = WeaviateProtoBase.IntArray.newBuilder();
                    Arrays.stream(f.getValueIntArray()).forEach(arg_0 -> GetBuilder.lambda$addWhereFilters$6((WeaviateProtoBase.IntArray.Builder)arr, arg_0));
                    where.setValueIntArray((WeaviateProtoBase.IntArray.Builder)arr);
                } else if (f.getValueNumber() != null) {
                    where.setValueNumber(f.getValueNumber());
                } else if (f.getValueNumberArray() != null) {
                    arr = WeaviateProtoBase.NumberArray.newBuilder();
                    Arrays.stream(f.getValueNumberArray()).forEach(arg_0 -> GetBuilder.lambda$addWhereFilters$7((WeaviateProtoBase.NumberArray.Builder)arr, arg_0));
                    where.setValueNumberArray((WeaviateProtoBase.NumberArray.Builder)arr);
                } else if (f.getValueText() != null) {
                    where.setValueText(f.getValueText());
                } else if (f.getValueTextArray() != null) {
                    arr = WeaviateProtoBase.TextArray.newBuilder();
                    Arrays.stream(f.getValueTextArray()).forEach(arg_0 -> GetBuilder.lambda$addWhereFilters$8((WeaviateProtoBase.TextArray.Builder)arr, arg_0));
                    where.setValueTextArray((WeaviateProtoBase.TextArray.Builder)arr);
                } else if (f.getValueString() != null) {
                    where.setValueText(f.getValueString());
                } else if (f.getValueStringArray() != null) {
                    arr = WeaviateProtoBase.TextArray.newBuilder();
                    Arrays.stream(f.getValueStringArray()).forEach(arg_0 -> GetBuilder.lambda$addWhereFilters$9((WeaviateProtoBase.TextArray.Builder)arr, arg_0));
                    where.setValueTextArray((WeaviateProtoBase.TextArray.Builder)arr);
                } else assert (false) : "unexpected WhereFilter value";
            }
        }
        switch (f.getOperator()) {
            case "And": {
                where.setOperator(WeaviateProtoBase.Filters.Operator.OPERATOR_AND);
                break;
            }
            case "Or": {
                where.setOperator(WeaviateProtoBase.Filters.Operator.OPERATOR_OR);
                break;
            }
            case "Equal": {
                where.setOperator(WeaviateProtoBase.Filters.Operator.OPERATOR_EQUAL);
                break;
            }
            case "NotEqual": {
                where.setOperator(WeaviateProtoBase.Filters.Operator.OPERATOR_NOT_EQUAL);
                break;
            }
            default: {
                assert (false) : "unexpected operator: " + f.getOperator();
                break;
            }
        }
    }

    @Generated
    GetBuilder(String className, Fields fields, Integer offset, Integer limit, String after, Integer autocut, String withConsistencyLevel, WhereArgument withWhereFilter, Bm25Argument withBm25Filter, HybridArgument withHybridFilter, AskArgument withAskArgument, NearTextArgument withNearTextFilter, NearObjectArgument withNearObjectFilter, NearVectorArgument withNearVectorFilter, NearImageArgument withNearImageFilter, NearAudioArgument withNearAudioFilter, NearVideoArgument withNearVideoFilter, NearDepthArgument withNearDepthFilter, NearThermalArgument withNearThermalFilter, NearImuArgument withNearImuFilter, GroupArgument withGroupArgument, SortArguments withSortArguments, GenerativeSearchBuilder withGenerativeSearch, GroupByArgument withGroupByArgument, String tenant) {
        this.className = className;
        this.fields = fields;
        this.offset = offset;
        this.limit = limit;
        this.after = after;
        this.autocut = autocut;
        this.withConsistencyLevel = withConsistencyLevel;
        this.withWhereFilter = withWhereFilter;
        this.withBm25Filter = withBm25Filter;
        this.withHybridFilter = withHybridFilter;
        this.withAskArgument = withAskArgument;
        this.withNearTextFilter = withNearTextFilter;
        this.withNearObjectFilter = withNearObjectFilter;
        this.withNearVectorFilter = withNearVectorFilter;
        this.withNearImageFilter = withNearImageFilter;
        this.withNearAudioFilter = withNearAudioFilter;
        this.withNearVideoFilter = withNearVideoFilter;
        this.withNearDepthFilter = withNearDepthFilter;
        this.withNearThermalFilter = withNearThermalFilter;
        this.withNearImuFilter = withNearImuFilter;
        this.withGroupArgument = withGroupArgument;
        this.withSortArguments = withSortArguments;
        this.withGenerativeSearch = withGenerativeSearch;
        this.withGroupByArgument = withGroupByArgument;
        this.tenant = tenant;
    }

    @Generated
    public static GetBuilderBuilder builder() {
        return new GetBuilderBuilder();
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public Fields getFields() {
        return this.fields;
    }

    @Generated
    public Integer getOffset() {
        return this.offset;
    }

    @Generated
    public Integer getLimit() {
        return this.limit;
    }

    @Generated
    public String getAfter() {
        return this.after;
    }

    @Generated
    public Integer getAutocut() {
        return this.autocut;
    }

    @Generated
    public String getWithConsistencyLevel() {
        return this.withConsistencyLevel;
    }

    @Generated
    public WhereArgument getWithWhereFilter() {
        return this.withWhereFilter;
    }

    @Generated
    public Bm25Argument getWithBm25Filter() {
        return this.withBm25Filter;
    }

    @Generated
    public HybridArgument getWithHybridFilter() {
        return this.withHybridFilter;
    }

    @Generated
    public AskArgument getWithAskArgument() {
        return this.withAskArgument;
    }

    @Generated
    public NearTextArgument getWithNearTextFilter() {
        return this.withNearTextFilter;
    }

    @Generated
    public NearObjectArgument getWithNearObjectFilter() {
        return this.withNearObjectFilter;
    }

    @Generated
    public NearVectorArgument getWithNearVectorFilter() {
        return this.withNearVectorFilter;
    }

    @Generated
    public NearImageArgument getWithNearImageFilter() {
        return this.withNearImageFilter;
    }

    @Generated
    public NearAudioArgument getWithNearAudioFilter() {
        return this.withNearAudioFilter;
    }

    @Generated
    public NearVideoArgument getWithNearVideoFilter() {
        return this.withNearVideoFilter;
    }

    @Generated
    public NearDepthArgument getWithNearDepthFilter() {
        return this.withNearDepthFilter;
    }

    @Generated
    public NearThermalArgument getWithNearThermalFilter() {
        return this.withNearThermalFilter;
    }

    @Generated
    public NearImuArgument getWithNearImuFilter() {
        return this.withNearImuFilter;
    }

    @Generated
    public GroupArgument getWithGroupArgument() {
        return this.withGroupArgument;
    }

    @Generated
    public SortArguments getWithSortArguments() {
        return this.withSortArguments;
    }

    @Generated
    public GenerativeSearchBuilder getWithGenerativeSearch() {
        return this.withGenerativeSearch;
    }

    @Generated
    public GroupByArgument getWithGroupByArgument() {
        return this.withGroupByArgument;
    }

    @Generated
    public String getTenant() {
        return this.tenant;
    }

    @Generated
    public String toString() {
        return "GetBuilder(className=" + this.getClassName() + ", fields=" + this.getFields() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ", after=" + this.getAfter() + ", autocut=" + this.getAutocut() + ", withConsistencyLevel=" + this.getWithConsistencyLevel() + ", withWhereFilter=" + this.getWithWhereFilter() + ", withBm25Filter=" + this.getWithBm25Filter() + ", withHybridFilter=" + this.getWithHybridFilter() + ", withAskArgument=" + this.getWithAskArgument() + ", withNearTextFilter=" + this.getWithNearTextFilter() + ", withNearObjectFilter=" + this.getWithNearObjectFilter() + ", withNearVectorFilter=" + this.getWithNearVectorFilter() + ", withNearImageFilter=" + this.getWithNearImageFilter() + ", withNearAudioFilter=" + this.getWithNearAudioFilter() + ", withNearVideoFilter=" + this.getWithNearVideoFilter() + ", withNearDepthFilter=" + this.getWithNearDepthFilter() + ", withNearThermalFilter=" + this.getWithNearThermalFilter() + ", withNearImuFilter=" + this.getWithNearImuFilter() + ", withGroupArgument=" + this.getWithGroupArgument() + ", withSortArguments=" + this.getWithSortArguments() + ", withGenerativeSearch=" + this.getWithGenerativeSearch() + ", withGroupByArgument=" + this.getWithGroupByArgument() + ", tenant=" + this.getTenant() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetBuilder)) {
            return false;
        }
        GetBuilder other = (GetBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$autocut = this.getAutocut();
        Integer other$autocut = other.getAutocut();
        if (this$autocut == null ? other$autocut != null : !((Object)this$autocut).equals(other$autocut)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Fields this$fields = this.getFields();
        Fields other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$after = this.getAfter();
        String other$after = other.getAfter();
        if (this$after == null ? other$after != null : !this$after.equals(other$after)) {
            return false;
        }
        String this$withConsistencyLevel = this.getWithConsistencyLevel();
        String other$withConsistencyLevel = other.getWithConsistencyLevel();
        if (this$withConsistencyLevel == null ? other$withConsistencyLevel != null : !this$withConsistencyLevel.equals(other$withConsistencyLevel)) {
            return false;
        }
        WhereArgument this$withWhereFilter = this.getWithWhereFilter();
        WhereArgument other$withWhereFilter = other.getWithWhereFilter();
        if (this$withWhereFilter == null ? other$withWhereFilter != null : !((Object)this$withWhereFilter).equals(other$withWhereFilter)) {
            return false;
        }
        Bm25Argument this$withBm25Filter = this.getWithBm25Filter();
        Bm25Argument other$withBm25Filter = other.getWithBm25Filter();
        if (this$withBm25Filter == null ? other$withBm25Filter != null : !((Object)this$withBm25Filter).equals(other$withBm25Filter)) {
            return false;
        }
        HybridArgument this$withHybridFilter = this.getWithHybridFilter();
        HybridArgument other$withHybridFilter = other.getWithHybridFilter();
        if (this$withHybridFilter == null ? other$withHybridFilter != null : !((Object)this$withHybridFilter).equals(other$withHybridFilter)) {
            return false;
        }
        AskArgument this$withAskArgument = this.getWithAskArgument();
        AskArgument other$withAskArgument = other.getWithAskArgument();
        if (this$withAskArgument == null ? other$withAskArgument != null : !((Object)this$withAskArgument).equals(other$withAskArgument)) {
            return false;
        }
        NearTextArgument this$withNearTextFilter = this.getWithNearTextFilter();
        NearTextArgument other$withNearTextFilter = other.getWithNearTextFilter();
        if (this$withNearTextFilter == null ? other$withNearTextFilter != null : !((Object)this$withNearTextFilter).equals(other$withNearTextFilter)) {
            return false;
        }
        NearObjectArgument this$withNearObjectFilter = this.getWithNearObjectFilter();
        NearObjectArgument other$withNearObjectFilter = other.getWithNearObjectFilter();
        if (this$withNearObjectFilter == null ? other$withNearObjectFilter != null : !((Object)this$withNearObjectFilter).equals(other$withNearObjectFilter)) {
            return false;
        }
        NearVectorArgument this$withNearVectorFilter = this.getWithNearVectorFilter();
        NearVectorArgument other$withNearVectorFilter = other.getWithNearVectorFilter();
        if (this$withNearVectorFilter == null ? other$withNearVectorFilter != null : !((Object)this$withNearVectorFilter).equals(other$withNearVectorFilter)) {
            return false;
        }
        NearImageArgument this$withNearImageFilter = this.getWithNearImageFilter();
        NearImageArgument other$withNearImageFilter = other.getWithNearImageFilter();
        if (this$withNearImageFilter == null ? other$withNearImageFilter != null : !((Object)this$withNearImageFilter).equals(other$withNearImageFilter)) {
            return false;
        }
        NearAudioArgument this$withNearAudioFilter = this.getWithNearAudioFilter();
        NearAudioArgument other$withNearAudioFilter = other.getWithNearAudioFilter();
        if (this$withNearAudioFilter == null ? other$withNearAudioFilter != null : !((Object)this$withNearAudioFilter).equals(other$withNearAudioFilter)) {
            return false;
        }
        NearVideoArgument this$withNearVideoFilter = this.getWithNearVideoFilter();
        NearVideoArgument other$withNearVideoFilter = other.getWithNearVideoFilter();
        if (this$withNearVideoFilter == null ? other$withNearVideoFilter != null : !((Object)this$withNearVideoFilter).equals(other$withNearVideoFilter)) {
            return false;
        }
        NearDepthArgument this$withNearDepthFilter = this.getWithNearDepthFilter();
        NearDepthArgument other$withNearDepthFilter = other.getWithNearDepthFilter();
        if (this$withNearDepthFilter == null ? other$withNearDepthFilter != null : !((Object)this$withNearDepthFilter).equals(other$withNearDepthFilter)) {
            return false;
        }
        NearThermalArgument this$withNearThermalFilter = this.getWithNearThermalFilter();
        NearThermalArgument other$withNearThermalFilter = other.getWithNearThermalFilter();
        if (this$withNearThermalFilter == null ? other$withNearThermalFilter != null : !((Object)this$withNearThermalFilter).equals(other$withNearThermalFilter)) {
            return false;
        }
        NearImuArgument this$withNearImuFilter = this.getWithNearImuFilter();
        NearImuArgument other$withNearImuFilter = other.getWithNearImuFilter();
        if (this$withNearImuFilter == null ? other$withNearImuFilter != null : !((Object)this$withNearImuFilter).equals(other$withNearImuFilter)) {
            return false;
        }
        GroupArgument this$withGroupArgument = this.getWithGroupArgument();
        GroupArgument other$withGroupArgument = other.getWithGroupArgument();
        if (this$withGroupArgument == null ? other$withGroupArgument != null : !((Object)this$withGroupArgument).equals(other$withGroupArgument)) {
            return false;
        }
        SortArguments this$withSortArguments = this.getWithSortArguments();
        SortArguments other$withSortArguments = other.getWithSortArguments();
        if (this$withSortArguments == null ? other$withSortArguments != null : !((Object)this$withSortArguments).equals(other$withSortArguments)) {
            return false;
        }
        GenerativeSearchBuilder this$withGenerativeSearch = this.getWithGenerativeSearch();
        GenerativeSearchBuilder other$withGenerativeSearch = other.getWithGenerativeSearch();
        if (this$withGenerativeSearch == null ? other$withGenerativeSearch != null : !((Object)this$withGenerativeSearch).equals(other$withGenerativeSearch)) {
            return false;
        }
        GroupByArgument this$withGroupByArgument = this.getWithGroupByArgument();
        GroupByArgument other$withGroupByArgument = other.getWithGroupByArgument();
        if (this$withGroupByArgument == null ? other$withGroupByArgument != null : !((Object)this$withGroupByArgument).equals(other$withGroupByArgument)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        return !(this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GetBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $autocut = this.getAutocut();
        result = result * 59 + ($autocut == null ? 43 : ((Object)$autocut).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Fields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $after = this.getAfter();
        result = result * 59 + ($after == null ? 43 : $after.hashCode());
        String $withConsistencyLevel = this.getWithConsistencyLevel();
        result = result * 59 + ($withConsistencyLevel == null ? 43 : $withConsistencyLevel.hashCode());
        WhereArgument $withWhereFilter = this.getWithWhereFilter();
        result = result * 59 + ($withWhereFilter == null ? 43 : ((Object)$withWhereFilter).hashCode());
        Bm25Argument $withBm25Filter = this.getWithBm25Filter();
        result = result * 59 + ($withBm25Filter == null ? 43 : ((Object)$withBm25Filter).hashCode());
        HybridArgument $withHybridFilter = this.getWithHybridFilter();
        result = result * 59 + ($withHybridFilter == null ? 43 : ((Object)$withHybridFilter).hashCode());
        AskArgument $withAskArgument = this.getWithAskArgument();
        result = result * 59 + ($withAskArgument == null ? 43 : ((Object)$withAskArgument).hashCode());
        NearTextArgument $withNearTextFilter = this.getWithNearTextFilter();
        result = result * 59 + ($withNearTextFilter == null ? 43 : ((Object)$withNearTextFilter).hashCode());
        NearObjectArgument $withNearObjectFilter = this.getWithNearObjectFilter();
        result = result * 59 + ($withNearObjectFilter == null ? 43 : ((Object)$withNearObjectFilter).hashCode());
        NearVectorArgument $withNearVectorFilter = this.getWithNearVectorFilter();
        result = result * 59 + ($withNearVectorFilter == null ? 43 : ((Object)$withNearVectorFilter).hashCode());
        NearImageArgument $withNearImageFilter = this.getWithNearImageFilter();
        result = result * 59 + ($withNearImageFilter == null ? 43 : ((Object)$withNearImageFilter).hashCode());
        NearAudioArgument $withNearAudioFilter = this.getWithNearAudioFilter();
        result = result * 59 + ($withNearAudioFilter == null ? 43 : ((Object)$withNearAudioFilter).hashCode());
        NearVideoArgument $withNearVideoFilter = this.getWithNearVideoFilter();
        result = result * 59 + ($withNearVideoFilter == null ? 43 : ((Object)$withNearVideoFilter).hashCode());
        NearDepthArgument $withNearDepthFilter = this.getWithNearDepthFilter();
        result = result * 59 + ($withNearDepthFilter == null ? 43 : ((Object)$withNearDepthFilter).hashCode());
        NearThermalArgument $withNearThermalFilter = this.getWithNearThermalFilter();
        result = result * 59 + ($withNearThermalFilter == null ? 43 : ((Object)$withNearThermalFilter).hashCode());
        NearImuArgument $withNearImuFilter = this.getWithNearImuFilter();
        result = result * 59 + ($withNearImuFilter == null ? 43 : ((Object)$withNearImuFilter).hashCode());
        GroupArgument $withGroupArgument = this.getWithGroupArgument();
        result = result * 59 + ($withGroupArgument == null ? 43 : ((Object)$withGroupArgument).hashCode());
        SortArguments $withSortArguments = this.getWithSortArguments();
        result = result * 59 + ($withSortArguments == null ? 43 : ((Object)$withSortArguments).hashCode());
        GenerativeSearchBuilder $withGenerativeSearch = this.getWithGenerativeSearch();
        result = result * 59 + ($withGenerativeSearch == null ? 43 : ((Object)$withGenerativeSearch).hashCode());
        GroupByArgument $withGroupByArgument = this.getWithGroupByArgument();
        result = result * 59 + ($withGroupByArgument == null ? 43 : ((Object)$withGroupByArgument).hashCode());
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        return result;
    }

    private static /* synthetic */ void lambda$addWhereFilters$9(WeaviateProtoBase.TextArray.Builder arr, String v) {
        arr.addValues(v);
    }

    private static /* synthetic */ void lambda$addWhereFilters$8(WeaviateProtoBase.TextArray.Builder arr, String v) {
        arr.addValues(v);
    }

    private static /* synthetic */ void lambda$addWhereFilters$7(WeaviateProtoBase.NumberArray.Builder arr, Double v) {
        arr.addValues(v);
    }

    private static /* synthetic */ void lambda$addWhereFilters$6(WeaviateProtoBase.IntArray.Builder arr, Integer v) {
        arr.addValues(v.intValue());
    }

    private static /* synthetic */ void lambda$addWhereFilters$5(WeaviateProtoBase.BooleanArray.Builder arr, Boolean v) {
        arr.addValues(v);
    }

    public static class GetBuilderBuilder {
        @Generated
        private String className;
        @Generated
        private Fields fields;
        @Generated
        private Integer offset;
        @Generated
        private Integer limit;
        @Generated
        private String after;
        @Generated
        private Integer autocut;
        @Generated
        private String withConsistencyLevel;
        @Generated
        private Bm25Argument withBm25Filter;
        @Generated
        private HybridArgument withHybridFilter;
        @Generated
        private AskArgument withAskArgument;
        @Generated
        private NearTextArgument withNearTextFilter;
        @Generated
        private NearObjectArgument withNearObjectFilter;
        @Generated
        private NearVectorArgument withNearVectorFilter;
        @Generated
        private NearImageArgument withNearImageFilter;
        @Generated
        private NearAudioArgument withNearAudioFilter;
        @Generated
        private NearVideoArgument withNearVideoFilter;
        @Generated
        private NearDepthArgument withNearDepthFilter;
        @Generated
        private NearThermalArgument withNearThermalFilter;
        @Generated
        private NearImuArgument withNearImuFilter;
        @Generated
        private GroupArgument withGroupArgument;
        @Generated
        private SortArguments withSortArguments;
        @Generated
        private GenerativeSearchBuilder withGenerativeSearch;
        @Generated
        private GroupByArgument withGroupByArgument;
        @Generated
        private String tenant;
        private WhereArgument withWhereFilter;

        @Deprecated
        public GetBuilderBuilder withWhereFilter(WhereFilter whereFilter) {
            this.withWhereFilter = WhereArgument.builder().filter(whereFilter).build();
            return this;
        }

        public GetBuilderBuilder withWhereFilter(WhereArgument whereArgument) {
            this.withWhereFilter = whereArgument;
            return this;
        }

        @Generated
        GetBuilderBuilder() {
        }

        @Generated
        public GetBuilderBuilder className(String className) {
            this.className = className;
            return this;
        }

        @Generated
        public GetBuilderBuilder fields(Fields fields) {
            this.fields = fields;
            return this;
        }

        @Generated
        public GetBuilderBuilder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        @Generated
        public GetBuilderBuilder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Generated
        public GetBuilderBuilder after(String after) {
            this.after = after;
            return this;
        }

        @Generated
        public GetBuilderBuilder autocut(Integer autocut) {
            this.autocut = autocut;
            return this;
        }

        @Generated
        public GetBuilderBuilder withConsistencyLevel(String withConsistencyLevel) {
            this.withConsistencyLevel = withConsistencyLevel;
            return this;
        }

        @Generated
        public GetBuilderBuilder withBm25Filter(Bm25Argument withBm25Filter) {
            this.withBm25Filter = withBm25Filter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withHybridFilter(HybridArgument withHybridFilter) {
            this.withHybridFilter = withHybridFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withAskArgument(AskArgument withAskArgument) {
            this.withAskArgument = withAskArgument;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearTextFilter(NearTextArgument withNearTextFilter) {
            this.withNearTextFilter = withNearTextFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearObjectFilter(NearObjectArgument withNearObjectFilter) {
            this.withNearObjectFilter = withNearObjectFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearVectorFilter(NearVectorArgument withNearVectorFilter) {
            this.withNearVectorFilter = withNearVectorFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearImageFilter(NearImageArgument withNearImageFilter) {
            this.withNearImageFilter = withNearImageFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearAudioFilter(NearAudioArgument withNearAudioFilter) {
            this.withNearAudioFilter = withNearAudioFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearVideoFilter(NearVideoArgument withNearVideoFilter) {
            this.withNearVideoFilter = withNearVideoFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearDepthFilter(NearDepthArgument withNearDepthFilter) {
            this.withNearDepthFilter = withNearDepthFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearThermalFilter(NearThermalArgument withNearThermalFilter) {
            this.withNearThermalFilter = withNearThermalFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withNearImuFilter(NearImuArgument withNearImuFilter) {
            this.withNearImuFilter = withNearImuFilter;
            return this;
        }

        @Generated
        public GetBuilderBuilder withGroupArgument(GroupArgument withGroupArgument) {
            this.withGroupArgument = withGroupArgument;
            return this;
        }

        @Generated
        public GetBuilderBuilder withSortArguments(SortArguments withSortArguments) {
            this.withSortArguments = withSortArguments;
            return this;
        }

        @Generated
        public GetBuilderBuilder withGenerativeSearch(GenerativeSearchBuilder withGenerativeSearch) {
            this.withGenerativeSearch = withGenerativeSearch;
            return this;
        }

        @Generated
        public GetBuilderBuilder withGroupByArgument(GroupByArgument withGroupByArgument) {
            this.withGroupByArgument = withGroupByArgument;
            return this;
        }

        @Generated
        public GetBuilderBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        @Generated
        public GetBuilder build() {
            return new GetBuilder(this.className, this.fields, this.offset, this.limit, this.after, this.autocut, this.withConsistencyLevel, this.withWhereFilter, this.withBm25Filter, this.withHybridFilter, this.withAskArgument, this.withNearTextFilter, this.withNearObjectFilter, this.withNearVectorFilter, this.withNearImageFilter, this.withNearAudioFilter, this.withNearVideoFilter, this.withNearDepthFilter, this.withNearThermalFilter, this.withNearImuFilter, this.withGroupArgument, this.withSortArguments, this.withGenerativeSearch, this.withGroupByArgument, this.tenant);
        }

        @Generated
        public String toString() {
            return "GetBuilder.GetBuilderBuilder(className=" + this.className + ", fields=" + this.fields + ", offset=" + this.offset + ", limit=" + this.limit + ", after=" + this.after + ", autocut=" + this.autocut + ", withConsistencyLevel=" + this.withConsistencyLevel + ", withWhereFilter=" + this.withWhereFilter + ", withBm25Filter=" + this.withBm25Filter + ", withHybridFilter=" + this.withHybridFilter + ", withAskArgument=" + this.withAskArgument + ", withNearTextFilter=" + this.withNearTextFilter + ", withNearObjectFilter=" + this.withNearObjectFilter + ", withNearVectorFilter=" + this.withNearVectorFilter + ", withNearImageFilter=" + this.withNearImageFilter + ", withNearAudioFilter=" + this.withNearAudioFilter + ", withNearVideoFilter=" + this.withNearVideoFilter + ", withNearDepthFilter=" + this.withNearDepthFilter + ", withNearThermalFilter=" + this.withNearThermalFilter + ", withNearImuFilter=" + this.withNearImuFilter + ", withGroupArgument=" + this.withGroupArgument + ", withSortArguments=" + this.withSortArguments + ", withGenerativeSearch=" + this.withGenerativeSearch + ", withGroupByArgument=" + this.withGroupByArgument + ", tenant=" + this.tenant + ")";
        }
    }
}

